Program scn2asc;
{ Filter to convert screen captured by TEXTCAP to plain ASCII file           }
{ I.e., throw out display attribute bytes, reformat in lines of 80 columns   }
{ (or whatever is specified on the command line).                            }
{ Free Software by TapirSoft Gisbert W.Selke, Dec 1991                       }

  Const progname = 'Scn2Asc';
        version  = '1.0';
        copyright= 'Free Software by TapirSoft Gisbert W.Selke, Dec 1991';

        bufsize  = 30000; { must be even! }

  Type iobuffer  = Array [0..bufsize-1] Of char;

  Var  inf : File;
       outf : text;
       inbuf, outbuf : iobuffer;
       n : longint;
       i, iread : word;
       ires : integer;
       k, len : byte;

Begin
  len := 80;
  For i := 1 To ParamCount Do
  Begin
    Val(ParamStr(i),n,ires);
    If (ires <> 0) Or (n <= 0) Or (n > 255) Then
    Begin
      writeln(progname,' ',version,' - ',copyright);
      writeln('Illegal command line argument - must be between 1 and 255');
      Halt(1);
    End;
    len := n;
  End;
  i := FileMode;
  FileMode := 0;
  Assign(inf,'');
  Reset(inf,1);
  FileMode := i;
  Assign(outf,'');
  Rewrite(outf);
  SetTextBuf(outf,outbuf);
  k := 0;
  While Not EoF(inf) Do
  Begin
    BlockRead(inf,inbuf,SizeOf(inbuf),iread);
    For i := 0 To Pred(iread) Div 2 Do
    Begin
      write(outf,inbuf[2*i]);
      Inc(k);
      If k = len Then
      Begin
        writeln(outf);
        k := 0;
      End;
    End;
  End;
  Close(inf);
  Flush(outf);
  Close(outf);
End.
