TITLE  'Orthographic projection'
NAME   PROJORTHO
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      Project 3D points to 2D via orthographic projection    |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call PROJORTH(vseg,voff)                               |
;    stack:     +06 = offset of 3D data pack                            |
;                08 = segment                                           |
;  returns:      none                                                   |
;------------------------------------------------------------------------

PARMS           = 2
ARGpackoff      EQU [bp+06]
ARGpackseg      EQU [bp+08]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

PROJORTHO_TEXT  SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:PROJORTHO_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  PROJORTHO
PROJORTHO       PROC    FAR

                push    bp
                mov     bp,sp
                push    bp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGpackoff
                mov     si,[bx]
                mov     bx,ARGpackseg
                mov     es,[bx]
                mov     di,offset dgroup:xtype3
                mov     cx,21           ;packet is 21 words
                push    ds
                mov     ax,es
                mov     bx,ds           ;es:di->dgroup:xtype3
                mov     es,bx
                mov     ds,ax           ;ds:si->passed seg:off
                rep     movsw           ;copy xform pack to dgroup
                pop     ds

                mov     cx,points3
                or      cx,cx
                jnz     DoOrtho         ;got some points to work on
                jmp     short PROJORTHObad

DoOrtho:        push    ds
                mov     di,offXYj3
                mov     es,segXYj3      ;es:di->ortho points
                mov     si,offXYp3
                mov     ds,segXYp3      ;ds:si->prime pts
                ASSUME ds:nothing
OrthoL1:        lodsw                   ;get Xprime
                stosw                   ;store Xortho
                lodsw                   ;get Yp
                stosw                   ;store Yo
                inc     si
                inc     si              ;skip Zprime
                loop    OrthoL1
                pop     ds
                ASSUME ds:dgroup
                xor     ax,ax
                jmp     short PROJORTHOxit

PROJORTHObad:   mov     ax,-1

PROJORTHOxit:   pop     di
                pop     si
                pop     ds
                ASSUME ds:dgroup
                pop     bp
                mov     sp,bp
                pop     bp
                RET     PARMS*2
PROJORTHO       ENDP
PROJORTHO_TEXT  ENDS
                END

