TITLE  'Set extended video mode'
NAME   SETMODEX
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      set an extended video mode                             |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call SETMODEX(ax,bx)                                   |
;    stack:     +06 = bx                                                |
;                08 = ax                                                |
;  returns:      none                                                   |
;-----------------------------------------------------------------------|

PARMS           = 2
ARGbx           EQU [bp+06]
ARGax           EQU [bp+08]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

SetModeX_TEXT   SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:SetModeX_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  SetModeX
SetModeX        PROC    FAR

                push    bp
                mov     bp,sp
                mov     bx,ARGax
                mov     ax,[bx]
                sub     ah,ah
                mov     bx,ARGbx
                mov     bx,[bx]
                int 10h
                pop     bp
                RET     PARMS*2
SetModeX        ENDP

SetModeX_TEXT   ENDS
                END

