Program tiff2chr;
{ liest eine TIFF-Datei ein, gibt das Bild mit '*' fr gesetzte Pixel als    }
{ Textdatei aus. Simple Form: versteht nur wenige Tags, 1 Bild je Datei,     }
{ 1 Bit/Sample, 1 Sample/Pixel. Versteht Run-Length-Encoded TIFF.            }
{ TapirSoft Gisbert W.Selke, 13 Jan 1991                                     }

{$A+,B-,D+,E+,F-,I-,L+,N-,O-,R+,S+,V- }
{$M 65520,0,480000 }

  Uses Crt;

  Const progname     = 'TIFF2CHR';
        version      = '1.0';
        copyright    = 'Freeware by TapirSoft Gisbert W.Selke, Jan 1991';
        bufsize      = 30000;
        NoCompressed = 1;
        RLE          = 32773;
        Return : char= #13;

  Type iobuf = Array [1..bufsize] Of byte;
       tiffheader = Record
                      format  : word;
                      version : word;
                      ifdoffset : longint;
                    End;
       ifdentry   = Record
                      tag : word;
                      typ : word;
                      length : longint;
                      Case boolean Of
                        True:  (longdata : longint);
                        False: (shortdata : word;
                                filler    : word;);
                    End;

  Var inf : File;
      outf : text;
      inbuf, outbuf : iobuf;
      header : tiffheader;
      ifd : ifdentry;
      ifdentries : word;
      byteptr, inct, i, outinrow, rowct, comprtype : word;
      b, k, run, ncopy, lastbyte : byte;
      black, white : char;
      totpxl, totct, height, width, stripoff, striplen : longint;

  Procedure abort(msg : string; icode : byte);
  { gibt Fehlermeldung aus und stirbt dahin                                  }
  Begin                                                              { abort }
    writeln(progname,': ',msg);
    Halt(icode);
  End;                                                               { abort }

  Procedure readhdr;
  { liest TIFF-Header und wichtige Tags ein                                  }

    Var longval : longint;
        iread : word;
        i : byte;

    Function word2str(w : word) : string;
    { wandelt Word in String um                                              }
      Var stemp : string;
    Begin                                                         { word2str }
      Str(w,stemp);
      word2str := stemp;
    End;                                                          { word2str }

  Begin                                                            { readhdr }
    width  := 0;
    height := 0;
    stripoff := 0;
    striplen := 0;
    black := ' ';
    white := '*';
    BlockRead(inf,header,SizeOf(header),iread);
    If (iread <> SizeOf(header)) Or (header.format <> $4949) Or
       (header.version <> 42) Then abort('Falscher Header',2);
    Seek(inf,header.ifdoffset);
    BlockRead(inf,ifdentries,SizeOf(ifdentries),iread);
    If iread <> SizeOf(ifdentries) Then abort('Falscher Header',2);
    For i := 1 To ifdentries Do
    Begin
      BlockRead(inf,ifd,SizeOf(ifd),iread);
      If iread <> SizeOf(ifd) Then abort('Falscher Tag-Eintrag',3);
      Case ifd.typ Of
        2 : longval := ifd.longdata;
        3 : longval := ifd.shortdata;
        4 : longval := ifd.longdata;
        Else Begin
               writeln('Unbekannter Tag-Typ "',ifd.typ,'" fr Tag "',
                       ifd.tag,'"');
               longval := 0;
             End;
      End;
      Case ifd.tag Of
        $FF  : ; { subfile at full resolution }
        $100 : width  := longval;
        $101 : height := longval;
        $102 : If longval <> 1 Then
                         abort('Nur 1 Bit/Sample wird untersttzt',5);
        $103 : Begin
                 If (longval <> NoCompressed) And (longval <> RLE) Then abort(
            'Nur un- und lauflngenkomprimierte Dateien werden untersttzt',5);
                 comprtype := longval;
               End;
        $106 : Begin  { Photometric Interpretation }
                 If longval <> 1 Then
                 Begin
                   black := '*';
                   white := ' ';
                 End;
               End;
        $111 : Begin
                 If Not (ifd.typ In [3,4]) Then abort('Z.Zt. nur 1 Strip!',4);
                 stripoff := longval;
               End;
        $115 : If longval <> 1 Then
                         abort('Nur 1 Sample/Pixel wird untersttzt',5);
        $117 : striplen := longval;
        $11C : If longval <> 1 Then
                         abort('Nur planare Konfiguration wird untersttzt',5);
        $10E, $10F, $131, $132, $13B, $13C : ; { ignore informational tags }
        Else writeln('Unbekannte Tag-Kennung ',ifd.tag);
      End;
    End;
  End;                                                             { readhdr }

  Function getbyte : byte;
  { gets one byte from input stream, possibly compressed                     }
  Begin                                                            { getbyte }
    If run > 0 Then
    Begin
      getbyte := lastbyte;
      Dec(run);
    End
    Else
    Begin
      If byteptr >= inct Then
      Begin
        BlockRead(inf,inbuf,bufsize,inct);
        byteptr := 0;
      End;
      Inc(byteptr);
      If comprtype = NoCompressed Then getbyte := inbuf[byteptr]
      Else
      Begin
        If ncopy > 0 Then
        Begin
          getbyte := inbuf[byteptr];
          Dec(ncopy);
        End
        Else
        Begin
          lastbyte := inbuf[byteptr];
          If lastbyte > 127 Then
          Begin
            ncopy := 1;
            getbyte := getbyte;
            run := -lastbyte + 256;
            lastbyte := inbuf[byteptr];
          End
          Else
          Begin
            If lastbyte = 128 Then getbyte := getbyte
            Else
            Begin
              ncopy   := Succ(lastbyte);
              getbyte := getbyte;
            End
          End
        End
      End
    End
  End;                                                             { getbyte }

Begin
  writeln(progname,' ',version,' ',copyright);
  writeln('Einfacher TIFF-nach-Textdatei-Konverter');
  Assign(inf,'');
  Reset(inf,1);
  Assign(outf,'');
  Rewrite(outf);
  SetTextBuf(outf,outbuf);
  readhdr;
  Seek(inf,stripoff);
  outinrow := 0;
  rowct := 0;
  totpxl := height*width;
  inct := 0;
  byteptr := 1;
  run := 0;
  ncopy := 0;
  totct := 0;
  writeln(outf,width,' ',height);
  write('1     von ',height,' Zeilen');
  While totct < totpxl Do
  Begin
    b := getbyte;
    For k := 1 To 8 Do
    Begin
      If (b And $80) = 0 Then write(outf,black)
                         Else write(outf,white);
      b := (b And $7F) ShL 1;
    End;
    totct := totct + 8;
    outinrow := outinrow + 8;
    If outinrow >= width Then
    Begin
      writeln(outf);
      outinrow := 0;
      Inc(rowct);
      If (rowct And $F) = 0 Then write(Return,rowct);
    End;
    If IOResult <> 0 Then abort('Fehler beim Schreiben der Ausgabedatei',6);
  End;
  write(Return,rowct);
  Flush(outf);
  Close(inf);
  Close(outf);
  If IOResult <> 0 Then abort('Fehler beim Schreiben der Ausgabedatei',6);
  If rowct <> height Then writeln('Falsche Anzahl von Zeilen gelesen');
End.
