/*
   grabasc.c by Bill Buckels January 25, 1992

   An trivial tsr ascii screen capture utility
   for 80-column text mode 3 or 7 written in MIX POWER C

   grab the print screen key and save ascii to disk

   compile and link with a 2K stack and a 2K heap using the
   following sequence...

   pc grabasc.c
   pcl [2K,2K] grabasc.mix

   In case anyone thinks that this code is something special...
   It ain't and is hereby by placed by me into the public domain
   where it can be used and copied freely.

   This TSR has been used safely by me and works well on a clean
   system. Reboot after use as with any screen capture utility.

   I will not be held responsible for self-inflicted wounds.

*/

#include <bios.h>
#include <stdio.h>
#include <dos.h>

unsigned SCREENSEG = 0xb800; /* default to the CGA */
                             /* adjust for people with mono */

/* the current video mode */
/* we don't want to grab squinty modes or graphics */
char far *vmodeptr = (char far *)(unsigned long)0x0400049;

void interrupt grabasc(void)
{

    FILE *fp;
    static char far *crtptr;
    unsigned char temp;
    unsigned row,col,target;

    char *filename="HANDFULL.TXT";

    disable();

    /* make sure we are in a legal text mode */
    temp=vmodeptr[0];
    if(temp == 2|| temp ==3 || temp==7)
    {
      /* open HANDFULL.TXT for append and write screen bytes  */
      /* without attributes. put a carriage return- line feed */
      /* at the end of each row... */

      fp=fopen(filename,"ab");
      for(row=0;row<25;row++)
        {
        /* point to the start of each line of text */
        crtptr=MK_FP(SCREENSEG,row*160);

        /* skip the attributes and save the ascii to disk */
        /* trim the white space while we are at it...     */
        /* we need to check first then write...           */
        for(col=0;col<160;col+=2)if(crtptr[col]!='\x20')target=col;
        for(col=0;col<=target;col+=2)fputc(crtptr[col],fp);
        /* append the line with a cr-lf combination */
        fputc('\x0d',fp);
        fputc('\x0a',fp);
        }

        fclose(fp);
    }
    enable();
}

main()
{
    unsigned programsize;

    puts("Grabasc is now resident.");
    puts("Use the Shift-Print-Screen Key Comination \
to Capture Text Screens.");
    puts("The Ascii Capture Buffer will be appended \
to \"HANDFULL.TXT\".");
    puts("Have a Nice Dos!");

    if ((biosequip() & 0x30) == 0x30)SCREENSEG=0xb000;
    setvect(5,grabasc);
    programsize=farsetsize(0);

    keep(0, programsize);

}
