;RM82TS8,16,24,32,40,48,56,64
; updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.MODEL MEDIUM

	Public  RESTSCRN, SAVESCRN

.data
	;external data so all video routines can access
	EVEN
	EXTRN  B$DVIDEOSEG:WORD
	EXTRN  B$DVIDEOPORT:WORD
	EXTRN  B$DVIDEOINSTL:BYTE

.CODE
INCLUDE  NOWAIT.INC           ;add all the video macros
EXTRN	Get_Adapter:FAR

;========================================================================
;RESTSCRN.ASM - restores 80 * 25 page text screen in QuickBASIC array
;Parameters:
; DECLARE SUB RESTSCRN (BYVAL Segment%, BYVAL Offset%)
; DIM ARRAY%(2000)
; CALL RESTSCRN(VARSEG(ARRAY%(0)), VARPTR(ARRAY%(0)))
;========================================================================

EVEN
RESTSCRN    Proc   FAR

	Push    BP            ;save registers for BASIC
	Mov     BP,SP         ;locate stack to get variable addresses later
	Push    DS
	Push    SI
	Push    DI

	Assume	DS:@data

	Cmp     B$DVIDEOINSTL,1 ;skip ahead if we have done this before
	JE      Didit          ;if 1 then initialized, so skip ahead
	Call    Get_Adapter    ;use find display routine

Didit:
	Mov     DX,B$DVIDEOPORT  ;load retrace port if CGA, else 0
	Mov     ES,B$DVIDEOSEG   ;set ES to the appropriate screen segment
	Mov     SI,[BP+6]     ;get location of array, offset in SI
	Mov     BX,[BP+8]     ;    segment in BX
	Mov     DS,BX         ;MUST set DS _after_ addressing stack
		     	      ;once adjust DS lose access to stack &
			      ;DGROUP
	Xor     DI,DI         ;Clear DI
	Mov     CX,2000       ;Move 2000 words or 4000 bytes
	Cld                   ;all data moves below will be forward
	OR      DL,DL         ;monochrome/EGA (is DL=0)?
	JZ      Mono          ;yes, skip over the retrace stuff

EVEN
CGA:
	CLI                   ;prevent interrupts
	Wait_CGA_Retrace      ;wait for retrace on CGA
	Movsw                 ;move the data source DS:SI, destination ES:DI
	STI                   ;allow interrupts again
	Loop    CGA           ;loop until done
	Jmp     Short Exit    ;skip over the mono routine and exit

Mono:
	Rep     Movsw         ;move the data in one operation
Exit:                         ;source DS:SI, destination ES:DI

	Pop     DI
	Pop     SI
	Pop     DS            ;restore registers for BASIC

        Assume	DS:@data

	Pop     BP
	Ret     4             ;return skipping 2 passed parameters
RESTSCRN        Endp

;========================================================================
;SAVESCRN.ASM - saves 80 * 25 text screen page in QuickBASIC array
;Parameters:
; DECLARE SUB SAVESCRN (BYVAL Segment%, BYVAL Offset%)
; DIM ARRAY%(2000)
; CALL SAVESCRN( VARSEG(ARRAY%(0)), VARPTR(ARRAY%(0)))
;========================================================================

EVEN
SAVESCRN    Proc   FAR
	Push    BP            ;save registers for BASIC
	Mov     BP,SP         ;locate stack to get variable addresses later
	Push    DS
	Push    SI
	Push    DI

        Assume	DS:@data

	Cmp     B$DVIDEOINSTL,1 ;skip ahead if we have done this before
	JE      Didit1
	Call	Get_Adapter     ;use find display routine
Didit1:
	Mov     DX,B$DVIDEOPORT ;load retrace port if CGA, else 0
	Mov     BX,B$DVIDEOSEG  ;get appropriate screen segment
			       ;for storage later in DS
Get_Param1:
	Mov     SI,[BP+8]     ;get location of array
	Mov     ES,SI         ;    segment in ES
	Mov     SI,[BP+6]     ;
	Mov     DI,SI         ;    offset in DI
	Mov     DS,BX         ;store screen segment in DS
		     	      ;once adjust DS lose access to stack &
			      ;DGROUP
        Xor     SI,SI	      ;DS:SI, so start at page 0
	Cld                   ;all data moves below will be forward
	Mov     CX,2000       ;load up CX for 2000 words, 4000 bytes
	Or      DL,DL         ;monochrome /EGA (is DL =0)?
	JZ      Mono          ;yes, skip over the retrace stuff

EVEN
CGA1:
	CLI                   ;prevent interrupts
	Wait_CGA_Retrace      ;wait for retrace on CGA
	Movsw                 ;move the data source DS:SI, destination ES:DI
	STI                   ;allow interrupts again
	Loop    CGA1          ;loop until done
	Jmp     Short Exit1   ;skip over the mono routine and exit

Mono1:
	Rep     Movsw         ;move the data in one operation
Exit1:                        ;source DS:SI, destination ES:DI
	Pop     DI
	Pop     SI
	Pop     DS            ;restore registers for BASIC

        Assume	DS:@data

	Pop     BP
	Ret     4             ;return skipping 2 passed parameters
SAVESCRN        Endp
END

