;RM82TS8,16,24,32,40,48,56,64
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.MODEL MEDIUM
	PUBLIC  SNOWCHECK, TOGGLESNOW
.data
	;external data so all video routines can access
	EVEN
	EXTRN  B$DVIDEOSEG:WORD     ;inside VDATA
	EXTRN  B$DVIDEOPORT:WORD    ;inside VDATA
	EXTRN  B$DVIDEOINSTL:BYTE   ;inside VDATA
.code

EXTRN	Get_Adapter:FAR              ;inside VDATA

COMPAQ          DB      'COMPAQ'     ; BIOS ID string in COMPAQ's
COMPAQ_LEN      Equ     $-COMPAQ     ; length of string
ZDS		DB	'ZDS CORP'   ; BIOS ID string for Zenith CGA
ZDS_LEN		Equ	$-ZDS        ; length of string

EVEN
SNOWCHECK PROC	FAR

;===========================================================================
; DECLARE SUB SNOWCHECK ()
; CALL SNOWCHECK
; Purpose:
;        Clears the snowcheck variable if find a CGA display by
;        OLIVETTI (AT&T), COMPAQ, or ZENITH
;
; Returns:
;	 Nothing Above Data Area Filed
;===========================================================================

	Push	Bp            ;save everthing we use
        Push	DS
	Push	DI
	Push	SI

	Cmp   	B$DVIDEOINSTL,1   ;have we done this before?
	JE    	Didit             ;yep, so skip ahead
	Call  	Get_Adapter       ;determine the display type

Didit:
	Cmp   	B$DVIDEOPORT,0    ;snowcheck is already set to off
	JE      All_Done          ;so skip ahead
	;------------------------------------------------
	;Look for CGA's that do not need snowcheck
	;------------------------------------------------

ATT_test:
     	Mov     AX,0F000h     ; Get ROM ID segment
     	Mov     ES,AX         ; Store segment in ES
     	CLD                   ; clear the direction flag
     	Push    DS            ; Save DS
     	Mov     AX,CS
     	Mov     DS,AX         ; set DS = to CS

     	Assume  DS:@code

     			       ; faster version
     			       ; Source:  XMS.SYS version 2.06 MASM source
     	Cmp     ES:[0C05h],'LO' ; look for byte reversed 'OL' at FC00:0050h
     			       ; in memory letters are reversed
    	Jne     Compaq_test    ; AT&T not found, test COMPAQ

ATT_found:
     	; program assumes that if a CGA is active on an AT&T
    	; that built-in adapter is in use.

     	Pop     DS             ; restore DS
        Assume  DS:@data

	Mov     B$DVIDEOPORT,0
     	Jmp     Short All_Done

Compaq_test:
     	; Purpose of this test is to allow other routines to know if
     	; "snow" testing is necessary.

     	Mov     DI,0FFEAh       ; Get ID offset & store in DI
     	Mov     SI,OFFSET COMPAQ ; DS:SI points to  "COMPAQ".
     	Mov     CX,COMPAQ_LEN   ; CX has length of "COMPAQ".
     	REP     CMPSB           ; ES:DI destination, DS:SI source
        JNE 	Test_ZDS

Compaq_found:
	Pop	DS
        Assume  DS:@data

        Mov     B$DVIDEOPORT,0
        Jmp     Short All_Done

Test_ZDS:
	Mov     DI, 800Ch
	Mov	SI, OFFSET ZDS
	Mov	CX, ZDS_LEN
	Rep	CMPSB

	Pop	DS
        Assume  DS:@data      ;restore DS

	Jne	All_Done      ;report ZDS not found

ZDS_Found:
        Mov     B$DVIDEOPORT,0

All_Done:
	Pop	SI
	Pop	DI
	Pop	DS
        Pop	BP
	Ret
SNOWCHECK ENDP

;===========================================================================
; DECLARE SUB TOGGLESNOW (Mode%)
; CALL TOGGLESNOW(Mode%)
;Input: If Mode% =  0, clears SNOWCHECK
;       If Mode% <> 0, leaves SNOWCHECK set
;Purpose:
;        Clears the snowcheck variable if find a CGA display
;	 Also reinitializes Video Data Area
;
;Returns:  Nothing
;	   Video Data Area Filed
;===========================================================================

EVEN
TOGGLESNOW	PROC	FAR
	Push	BP
	Mov	BP,SP
	Call  	Get_Adapter       ;determine the display type
				  ;reinitialize each time
	Cmp   	B$DVIDEOPORT,0    ;snowcheck is already set to off
				  ;don't want to tinker with this
				  ;if have a MONO, EGA or VGA display
	JE      Finis             ;so skip ahead
	Mov	BX,[BP+6]
	Mov	BX,[BX]		  ;get value of toggle
	Or	BX,BX             ;is it zero?, then
	JNZ	Finis		  ;nothing to do so skip ahead
	Mov     B$DVIDEOPORT,0	  ;else, clear snowcheck variable & quit
Finis:
        Pop	BP
	Ret  	2                 ;remove parameters pushed on stack
TOGGLESNOW	ENDP
END
