' ͻ
'  TOOLBOX DEMONSTRATION  By Christy Gemmell    Version 3 | January 1990  
' Ķ
'  This program illustrates some of the ways that the routines provided   
'  in the Libraries on this disk, can enhance your QuickBASIC programs.   
' ͼ
'
'   Written for the MicroSoft Extended QuickBASIC and BASIC 7.
'   Assembler routines created with MicroSoft Macro Assembler 5.1
'
'   The program was compiled using the command line statement:
'
'   BC /E/Fs/O/S/W/X DEMON;
'
' Ŀ
'  External Functions and Procedures.                                     
' 
'
'   These routines are contained in an external library which is linked
'   to the object file with the command:
'
'   LINK /E/F DEMON,,,TOOLBOX.LIB;
'
'   To run the program in the QuickBASIC environment, start up with
'   the command:
'
'   QBX DEMON.BAS /L TOOLBOX.QLB
'
'   Declare external functions and procedures.
'
    DECLARE FUNCTION CapsLock% (BYVAL Switch%)
    DECLARE FUNCTION Cpu% ()
    DECLARE FUNCTION DosVersion$ ()
    DECLARE FUNCTION FindFile$ (FileSpec$)
    DECLARE FUNCTION GetFlag% (Flag%)
    DECLARE FUNCTION KeyFlags% ()
    DECLARE FUNCTION KeyIn% ()
    DECLARE FUNCTION LongDate$ (Day%, Month%, Year%)
    DECLARE FUNCTION NumLock% (BYVAL Switch%)
    DECLARE FUNCTION PrinTest% (Printer%)
    DECLARE FUNCTION ScrLock% (BYVAL Switch%)
    DECLARE FUNCTION SizeOf& (FileSpec$)
    DECLARE FUNCTION StatusLine% (Message$)
    DECLARE FUNCTION Verify% (Row%, Message$)
    DECLARE SUB BackFill (Row%, Col%, Rows%, Cols%, Attribute%)
    DECLARE SUB Cipher (Text$, KeyWord$)
    DECLARE SUB ClearEnd (BYVAL Switch%, BYVAL Attribute%)
    DECLARE SUB Delay (Interval!)
    DECLARE SUB FastPrint (Row%, Col%, Message$, Attrib%)
    DECLARE SUB HelpMate (Context%, Topic$)
    DECLARE SUB KeyFlush ()
    DECLARE SUB Panel (Row%, Col%, Rows%, Cols%, Border%, Attrib%)
    DECLARE SUB PopUp (Y%, X%, H%, W%, C%, B%, S%, Z%)
    DECLARE SUB PrintEps (BYVAL Attrib%, BYVAL Printer%)
    DECLARE SUB Scroll (D%, Y%, X%, R%, C%, L%, A%)
    DECLARE SUB SetFlag (Flag%, Setting%)
    DECLARE SUB ShutUp ()
    DECLARE SUB VideoMode (Colour%, MaxRes%, VideoRam%)

'   Declare local functions and procedures.
'
    DECLARE FUNCTION Attribute% (Fore%, Back%)
    DECLARE FUNCTION Centre$ (Text$, MaxWidth%)
    DECLARE FUNCTION DateInput$ (D$)
    DECLARE FUNCTION RevInput$ (MaxLen%, A$)
    DECLARE FUNCTION ValBinStr% (Bin$)
    DECLARE SUB BarMenu (Row%, Attrib%, Options%, Menu$())
    DECLARE SUB CheckPrinter (Printer%)
    DECLARE SUB DiskSort (PathName$, OffSet%, FieldLen%, Done%)
    DECLARE SUB Display (Title$, Switch%)
    DECLARE SUB MemSort (PathName$, OffSet%, FieldLen%, Done%)
    DECLARE SUB PopUpMenu (R%, C%, A%, B%, Options%, Title$, Menu$())
    DECLARE SUB SortFile (PathName$, OffSet%, FieldLen%, Done%)

    ON ERROR GOTO Trap

' Ŀ
'  Initialisation.                                                        
' 
'
'   $DYNAMIC
'
    CONST FALSE = 0, TRUE = NOT FALSE

'   Test a specified bit in the integer number supplied.
'
    DEF FNBitTest% (Number%, Bit%) = -SGN(Number% AND 2 ^ Bit%)

    DIM SHARED Menu$(0 TO 10), Abort%
    DIM SHARED Records&, FileLen&, RecordLen%

    TYPE Element
        SortKey AS STRING * 10
        RecNum AS INTEGER
    END TYPE

'   Check video capabilities of the host system
'
    Colour% = FALSE: MaxRes% = FALSE: VideoRam% = 4      ' Default to MDA
    VideoMode Colour%, MaxRes%, VideoRam%                ' Call ROM-BIOS

    IF Colour% AND MaxRes% > 2 THEN PALETTE 6, 30        ' Fix EGA Bug

'   Set display colours
'
    IF Colour% THEN
       BarColour% = 48         ' Black on Cyan
       HeadColour% = 31        ' Bright White on Blue
       StatColour% = 48        ' Black on Cyan
       TextColour% = 112       ' Black on White
    ELSE
       BarColour% = 112        ' Reverse video
       HeadColour% = 15        ' Intense White on Black
       StatColour% = 112       ' Reverse video
       TextColour% = 7         ' White on Black
    END IF

    SELECT CASE MaxRes%
        CASE 13
             IF VideoRam% = 64 THEN
                Adaptor$ = "Multi-Colour Graphics Array"
             ELSE
                Adaptor$ = "Video Graphics Array"
             END IF
        CASE 7 TO 10
             Adaptor$ = "Enhanced Graphics Adaptor"
        CASE 3
             Adaptor$ = "Hercules Graphics Card"
        CASE 2
             Adaptor$ = "Colour Graphics Adaptor"
        CASE ELSE
             Adaptor$ = "Monochrome Display Adaptor"
    END SELECT

    Printer% = 1: DOS$ = "DOS " + DosVersion$
    DY$ = MID$(DATE$, 4, 2): DY% = VAL(DY$): MO$ = LEFT$(DATE$, 2)
    MO% = VAL(MO$): YR$ = RIGHT$(DATE$, 2): YR% = VAL(YR$)
    Now$ = DY$ + "/" + MO$ + "/" + YR$: ToDay$ = LongDate$(DY%, MO%, YR%)

' Ŀ
'      Main Menu.                                                         
' 
'
D001:
    Context% = FALSE: Topic$ = ""
    Head$ = "ASSEMBLY-LANGUAGE TOOLBOX FOR QuickBASIC"
    LOCATE , , 0: Display Head$, 1: BarChoice% = 1
D002:
    Options% = 6: Menu$(0) = "WSFKEX"
    Menu$(1) = "Windows": Menu$(2) = "Screen"
    Menu$(3) = "Files": Menu$(4) = "Keyboard"
    Menu$(5) = "Examples": Menu$(6) = "Exit"
    IF NxtPop% THEN
       IF BarChoice% = 1 THEN BarChoice% = 6
       IF BarChoice% = 7 THEN BarChoice% = 2
    END IF
    BarMenu 3, BarColour%, Options%, Menu$()
    IF Abort% THEN
       OK% = Verify%(18, "Exit program, are you sure")
       IF OK% THEN GOTO Egress
    ELSE
       SELECT CASE BarChoice%
           CASE 1
                GOTO D100
           CASE 2
                GOTO D200
           CASE 3
                GOTO D300
           CASE 4
                GOTO D400
           CASE 5
                GOTO D500
           CASE 6
                GOTO D600
           CASE ELSE
       END SELECT
    END IF
GOTO D002

' Ŀ
'      Popup Window Demonstration.                                        
' 
'
D100:
    ShiftStatus% = KeyFlags%: KEY 15, CHR$(ShiftStatus%) + CHR$(&H01) 
    RANDOMIZE TIMER: KEY (15) ON: ON KEY (15) GOSUB D110
    A$ = STRING$(1680, ""): FastPrint 4, 1, A$, 30
    FastPrint 25, 1, SPACE$(80), StatColour%: A$ = ""
    FastPrint 25, 2, Adaptor$, StatColour%
    FastPrint 25, 71, DOS$, StatColour%
    KEY (15) STOP
    FOR M% = 1 TO 3
        FOR I% = 1 TO 40
            J% = INT(RND * 66): K% = INT(RND * 19)
            F% = INT(RND * 15) + 1: B% = INT(RND * 7) + 1
            IF NOT Colour% THEN
               IF F% = 1 OR F% = 9 THEN F% = 0: B% = 7
            END IF
            Attrib% = Attribute%(F%, B%)
            PopUp K% + 1, J% + 1, 5, 12, Attrib%, 2, 0, 0
            FastPrint K% + 2, J% + 4, "WINDOW", Attrib%
            IF INKEY$ = CHR$(27) THEN EXIT FOR
         NEXT I%
         IF I% > 40 THEN
            IF (M% = 3) THEN Delay 3 ELSE Delay 1
            FOR I% = 40 TO 1 STEP -1
                CALL ShutUp
            NEXT I%
         ELSE
            EXIT FOR
         END IF
    NEXT M%
    KEY (15) ON
    PopUp 4, 15, 10, 30, 52, 4, 1, 1: PopUp 3, 36, 13, 40, 47, 3, 1, 1
    PopUp 9, 10, 13, 40, 31, 2, 1, 1: PopUp 12, 42, 11, 36, 67, 1, 1, 1
    PopUp 2, 31, 5, 20, 78, 2, 1, 1: FastPrint 4, 34, "Presenting ...", 78
    Delay 3: Attrib% = Attribute%(0, 7)
    PopUp 8, 20, 7, 40, Attrib%, 2, 1, 1
    FastPrint 8, 31, "[ QUICK  WINDOWS ]", Attrib%
    FastPrint 11, 29, "Windowing Routines for", Attrib%
    FastPrint 12, 29, " Extended  QuickBASIC ", Attrib%
    Delay 3: Attrib% = Attribute%(0, 3)
    PopUp 17, 55, 7, 24, Attrib%, 1, 2, 1
    FastPrint 19, 66, "By", Attrib%
    FastPrint 20, 59, "Christy  Gemmell", Attrib%
    FastPrint 21, 57, "with acknowledgement", Attrib%
    FastPrint 22, 58, "to Rick Fothergill", Attrib%
    Delay 3: Attrib% = Attribute%(14, 1)
    PopUp 13, 2, 10, 23, Attrib%, 2, 1, 0
    FastPrint 15, 4, "A Library of screen", Attrib%
    FastPrint 16, 4, "handling procedures", Attrib%
    FastPrint 17, 4, "and functions which", Attrib%
    FastPrint 18, 4, "can be incorporated", Attrib%
    FastPrint 19, 4, "in your QuickBASIC ", Attrib%
    FastPrint 20, 9, "programs.", Attrib%
    Delay 4: Attrib% = Attribute%(15, 1)
    PopUp 16, 27, 5, 26, Attrib%, 2, 1, 0
    FastPrint 18, 30, "HOLD ONTO YOUR HATS", Attrib%
    Delay 2: FOR I% = 1 TO 9: ShutUp: NEXT
    PopUp 9, 16, 8, 50, 112, 2, 2, 0: RESTORE Blurb
    FOR I% = 10 TO 15: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    Delay 6: Scroll 1, 10, 17, 15, 64, 0, 112
    FOR I% = 12 TO 13: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    Delay 5: Attrib% = Attribute%(1, 2)
    IF NOT Colour% THEN Attrib% = 112
    PopUp 3, 3, 7, 35, Attrib%, 0, 2, 1
    Delay 3: ShutUp: Scroll 1, 10, 17, 15, 64, 0, 112
    FOR I% = 12 TO 13: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    Delay 6: Attrib% = Attribute%(0, 6)
    IF NOT Colour% THEN Attrib% = 112
    PopUp 6, 5, 8, 35, Attrib%, 0, 2, 0
    FastPrint 6, 15, "[  No  Frame  ]", Attrib%
    Delay 1: Attrib% = Attribute%(0, 2)
    PopUp 8, 8, 8, 35, Attrib%, 1, 2, 0
    FastPrint 8, 17, "[ Frame Style 1 ]", Attrib%
    Delay 1: Attrib% = Attribute%(14, 4)
    IF NOT Colour% THEN Attrib% = 112
    PopUp 10, 11, 8, 35, Attrib%, 2, 2, 0
    FastPrint 10, 20, "[ Frame Style 2 ]", Attrib%
    Delay 1: Attrib% = Attribute%(0, 3)
    PopUp 12, 14, 8, 35, Attrib%, 3, 2, 0
    FastPrint 12, 23, "[ Frame Style 3 ]", Attrib%
    Delay 1: Attrib% = Attribute%(14, 5)
    IF NOT Colour% THEN Attrib% = 112
    PopUp 14, 17, 8, 35, Attrib%, 4, 2, 0
    FastPrint 14, 26, "[ Frame Style 4 ]", Attrib%
    Delay 4: FOR I% = 1 TO 5: ShutUp: NEXT
    Scroll 1, 10, 17, 15, 64, 0, 112
    FOR I% = 11 TO 13: READ Me$: FastPrint I%, 20, Me$, 112: NEXT
    Delay 6: KEY (15) STOP
    FOR I% = 0 TO 15
        Label$ = "[ Colour:" + STR$(I%) + " ]"
        J% = INT(RND * 50) + 1: K% = INT(RND * 12) + 1
        Attrib% = Attribute%(I%, 3)
        IF NOT Colour% AND (I% = 0 OR I% = 8) THEN Attrib% = 112
        PopUp K% + 1, J% + 1, 7, 24, Attrib%, 4, 2, 0
        FastPrint K% + 1, J% + 6, Label$, Attrib%
        IF INKEY$ = CHR$(27) THEN EXIT FOR
        Delay .5
    NEXT I%
    KEY (15) ON: Attrib% = Attribute%(31, 4)
    PopUp 7, 20, 7, 24, Attrib%, 4, 2, 0
    FastPrint 7, 25, "[ Colour: 31 ]", Attrib%
    Delay 4: FOR I% = 1 TO 17: ShutUp: NEXT
    Scroll 1, 10, 17, 15, 64, 0, 112
    FOR I% = 12 TO 13: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    Delay 6: Attrib% = Attribute%(15, 1)
    PopUp 2, 2, 11, 30, Attrib%, 7, 0, 0
    Delay 3: ShutUp: Scroll 1, 10, 17, 15, 64, 0, 112
    FOR I% = 12 TO 13: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    Delay 6: Attrib% = Attribute%(14, 5)
    PopUp 5, 5, 10, 30, Attrib%, 2, 1, 0
    FastPrint 9, 14, "Left Shadow", Attrib%
    Delay 2: Attrib% = Attribute%(0, 2)
    PopUp 5, 45, 10, 30, Attrib%, 2, 2, 0
    FastPrint 9, 54, "Right Shadow", Attrib%
    Delay 2: ShutUp: ShutUp
    Scroll 1, 10, 17, 15, 64, 0, 112
    FastPrint 12, 31, "Windows can be zoomed", 112
    FastPrint 13, 33, "onto the screen.", 112
    Delay 3: Attrib% = Attribute%(0, 2)
    PopUp 2, 2, 15, 60, Attrib%, 2, 0, 1
    Delay 2: Attrib% = Attribute%(0, 3)
    PopUp 13, 10, 10, 60, Attrib%, 3, 0, 1
    Delay 2: Attrib% = Attribute%(14, 5)
    PopUp 7, 33, 10, 45, Attrib%, 1, 0, 1
    Delay 2: Attrib% = Attribute%(15, 4)
    IF NOT Colour% THEN Attrib% = 112
    PopUp 7, 10, 12, 63, Attrib%, 2, 1, 1
    FastPrint 12, 32, "<<< W O W >>>", Attrib%
    Delay 3: FOR I% = 1 TO 4: ShutUp: NEXT
    Scroll 1, 10, 17, 15, 64, 0, 112
    FOR I% = 10 TO 14: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    Delay 6: Scroll 1, 10, 17, 15, 64, 0, 112
    FOR I% = 10 TO 15: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    Delay 6: Scroll 1, 10, 17, 15, 64, 0, 112
    FOR I% = 10 TO 15: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    Delay 6: Attrib% = Attribute%(0, 2)
    PopUp 3, 5, 15, 45, Attrib%, 4, 1, 1
    FastPrint 9, 14, "This is the first level ...", Attrib%
    Delay 2: Attrib% = Attribute%(15, 4)
    PopUp 6, 29, 17, 50, Attrib%, 4, 1, 1
    FastPrint 12, 40, "This is the second level ...", Attrib%
    Delay 2: Attrib% = Attribute%(0, 3)
    PopUp 9, 22, 15, 35, Attrib%, 4, 1, 1
    FastPrint 16, 26, "This is the third level ...", Attrib%
    Delay 2: FastPrint 16, 26, "Now to go back ...         ", Attrib%
    Delay 1: ShutUp: Delay 1: ShutUp: Delay 1: ShutUp: Delay 2
    Scroll 1, 10, 17, 15, 64, 0, 112
    FOR I% = 10 TO 15: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    OK% = Verify%(20, "Are you enjoying this program")
    Scroll 1, 10, 17, 15, 64, 0, 112
    IF OK% THEN
       FastPrint 11, 28, "You sound very positive!", 112
    ELSE
       FastPrint 11, 28, "You sound very negative!", 112
    END IF
    Delay 2: Scroll 1, 10, 17, 15, 64, 0, 112
    FOR I% = 10 TO 15: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    KEY (15) OFF: Delay 3: SL% = StatusLine%("Want to carry on?")
    IF SL% = 78 OR SL% = 110 OR SL% = 27 THEN
       CALL ShutUp
    ELSE
       A$ = STRING$(44, SL%)
       FOR I% = 10 TO 15: FastPrint I%, 19, A$, 112: NEXT
       Delay 6: Scroll 1, 10, 17, 15, 64, 0, 112
       FOR I% = 10 TO 15: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
       Delay 6: Scroll 1, 10, 17, 15, 64, 0, 112
       Ready% = PrinTest%(Printer%)
       IF Ready% = 144 OR Ready% = 208 THEN
          Ready% = TRUE
       ELSE
          Ready% = FALSE
       END IF
       IF Ready% THEN
          FastPrint 11, 29, "PRINTER CONTROL WINDOW", 112
          FastPrint 13, 24, "The Toolbox contains versions for", 112
          FastPrint 14, 27, "two other popular printers.", 112
          FastPrint 25, 2, "Press <ESC> to Abort       ", StatColour%
          IF Colour% THEN
             PAttrib% = BarColour%
             IF MaxRes% > 2 THEN
                Adaptor$ = "Enhanced Graphics Adaptor"
             ELSE
                Adaptor$ = "Colour Graphics Adaptor"
             END IF
          ELSE
             Adaptor$ = "Monochrome Display Adaptor": PAttrib% = 112
          END IF
          PrintEps PAttrib%, Printer%
          FastPrint 25, 1, SPACE$(80), StatColour%
          FastPrint 25, 2, Adaptor$, StatColour%
          FastPrint 25, 71, DOS$, StatColour%
          Delay 5
       END IF
       CALL ShutUp
       PopUp 4, 15, 10, 30, 52, 4, 1, 1: PopUp 3, 36, 13, 40, 47, 3, 1, 1
       PopUp 9, 10, 13, 40, 78, 2, 1, 1: PopUp 12, 42, 11, 36, 67, 1, 1, 1
       PopUp 9, 16, 8, 52, 112, 2, 1, 1
       FastPrint 11, 20, "The modules in the Quick WINDOWS Library", 112
       FastPrint 12, 20, "give you all you need to create powerful", 112
       FastPrint 13, 20, "and professional screen displays in your", 112
       FastPrint 14, 20, "QuickBASIC programs.", 112: Delay 9
       FOR I% = 1 TO 5: ShutUp: Delay 1: NEXT
       IF NOT Ready% THEN
          PopUp 10, 18, 5, 44, 96, 1, 2, 0
          Me$ = "Pity you didn't have a printer connected"
          FastPrint 12, 20, Me$, 96: Delay 5: ShutUp
       END IF
    END IF
GOTO D001

D110:
    FOR I% = 1 TO 40: ShutUp: NEXT  
    KEY (15) OFF
RETURN D001

' Ŀ
'      Screen control functions.                                          
' 
'
D200:
    Options% = 4: Menu$(0) = "FSCB"
    Menu$(1) = "Fast screen printing"
    Menu$(2) = "Selective scrolling"
    Menu$(3) = "Clear to the end"
    Menu$(4) = "Background colours"
    PopUpMenu 4, 3, BarColour%, 1, Options%, "SCREEN CONTROL", Menu$()
    IF Abort% OR NxtPop% THEN
       GOTO D002
    ELSE
       SELECT CASE Choice%
           CASE 1
                GOTO D210
           CASE 2
                GOTO D220
           CASE 3
                GOTO D230
           CASE 4
                GOTO D240
           CASE ELSE
       END SELECT
    END IF
GOTO D200

'   Screen print demonstration
'
D210:
    A$ = STRING$(1680, ""): B$ = STRING$(1680, "")
    FOR I% = 1 TO 255
        FastPrint 4, 1, A$, I%: FastPrint 4, 1, B$, I%
        IF INKEY$ = CHR$(27) THEN EXIT FOR
    NEXT I%
    IF I% = 256 THEN
       A$ = "": B$ = "": C$ = STRING$(1680, ""): Attrib% = 30
       FastPrint 4, 1, C$, Attrib%: C$ = ""
       IF Colour% THEN Attrib% = 48 ELSE Attrib% = 112
       PopUp 12, 21, 7, 40, Attrib%, 3, 2, 1
       FastPrint 15, 33, "<<< W O W >>>", Attrib%
       Delay 5: ShutUp
    END IF
GOTO D200

'   Selective scrolling demonstration
'
D220:
    Panel 4, 1, 21, 80, 1, TextColour%
    Clr% = 1: Dly% = 1
    DO
        IF Dly% MOD 2 = 1 THEN
           Scroll 0, 4, 21, 7, 60, 1, Attribute%(0, Clr%)
           Scroll 0, 9, 6, 19, 20, 1, Attribute%(0, Clr%)
           Scroll 1, 9, 61, 19, 75, 1, Attribute%(0, Clr%)
           Scroll 1, 21, 21, 24, 60, 1, Attribute%(0, Clr%)
           IF Dly% = 1 THEN
              COLOR Clr%, 0
              LOCATE 19, 25: PRINT "SCROLLING UP";
              Scroll 0, 9, 23, 19, 38, 1, 0
              LOCATE 9, 43: PRINT "SCROLLING DOWN";
              Scroll 1, 9, 41, 19, 58, 1, 0
           END IF
        END IF
        Clr% = Clr% + 1: IF Clr% = 8 THEN Clr% = 1
        Dly% = Dly% + 1: IF Dly% = 14 THEN Dly% = 1
    LOOP UNTIL INKEY$ = CHR$(27)
GOTO D200

'   Clear to end of line or screen
'
D230:
    Panel 4, 1, 24, 80, 1, TextColour%
    IF Colour% THEN Attrib% = 15 ELSE Attrib% = 112
    FastPrint 22, 30, "Press a key to do it", TextColour%
    FastPrint 10, 3, "Clear end of line >", TextColour%
    LOCATE 10, 22, 1: R$ = INPUT$(1): ClearEnd 0, Attrib%
    FastPrint 15, 3, "Clear end of screen >", TextColour%
    LOCATE 15, 24, 1: R$ = INPUT$(1): ClearEnd 1, Attrib%
    LOCATE , , 0: Display Head$, 0
GOTO D200

D240:
    FastPrint 25, 1, SPACE$(80), StatColour%
    FastPrint 25, 3, "Press any key, <Esc> to abort", StatColour%
    RANDOMIZE TIMER
    DO
        Row% = INT(RND * 15) + 5: Col% = INT(RND * 60) + 2
        Rows% = INT(RND * 15) + 1
        IF Row% + Rows% > 23 THEN Rows% = 24 - Row%
        Cols% = INT(RND * 60) + 1
        IF Col% + Cols% > 78 THEN Cols% = 79 - Col%
        Attrib% = INT(RND * 255)
        BackFill Row%, Col%, Rows%, Cols%, Attrib%
        Character% = KeyIn%
    LOOP UNTIL Character% = 27
    Display Head$, 0
GOTO D200

' Ŀ
'      File Functions.                                                    
' 
'
D300:
    Options% = 3: Menu$(0) = "WHS"
    Menu$(1) = "Where's that file?"
    Menu$(2) = "How big is that file?"
    Menu$(3) = "Sort that file"
    PopUpMenu 4, 11, BarColour%, 1, Options%, "FILE FUNCTIONS", Menu$()
    IF Abort% OR NxtPop% THEN
       GOTO D002
    ELSE
       SELECT CASE Choice%
           CASE 1
                GOTO D310
           CASE 2
                GOTO D320
           CASE 3
                GOTO D330
           CASE ELSE
       END SELECT
    END IF
GOTO D300

'   File Finder
'
D310:
    Panel 4, 1, 21, 80, 1, TextColour%
    RESTORE Finder
    FOR I% = 1 TO 13
        READ Me$: FastPrint 5 + I%, 14, Me$, TextColour%
    NEXT I%
    Scroll 1, 19, 2, 21, 79, 0, TextColour%
    PopUp 19, 19, 4, 44, 96, 2, 0, 1
    FastPrint 20, 28, "Enter name of file to find", 96
    LOCATE 21, 21: PathName$ = RevInput$(40, ""): ShutUp
    IF NOT Abort% THEN
       PathName$ = RTRIM$(LTRIM$(PathName$))
       Found$ = FindFile$(PathName$)
       IF Found$ <> "" THEN
          Found$ = LTRIM$(RTRIM$(Found$))
          OT% = 40 - (LEN(Found$) \ 2)
          FastPrint 20, OT%, Found$, TextColour%
       END IF
    END IF
GOTO D300

D320:
    Panel 4, 1, 21, 80, 1, TextColour%
    RESTORE Size
    FOR I% = 1 TO 12
        READ Me$: FastPrint 5 + I%, 8, Me$, TextColour%
    NEXT I%
    Scroll 1, 18, 3, 23, 78, 0, TextColour%
    LOCATE 20, 8: PathName$ = RevInput$(64, "")
    IF Abort% OR PathName$ = SPACE$(64) THEN PathName$ = ""
    IF LEN(PathName$) > 1 AND LEN(PathName$) < 65 THEN
       Bytes& = SizeOf&(PathName$)
       IF Bytes& > 0 THEN
          Me$ = "Size = " + LTRIM$(RTRIM$(STR$(Bytes&))) + " bytes"
          FastPrint 22, 40 - (LEN(Me$) \ 2), Me$, TextColour%
       ELSE
          SL% = StatusLine%("No match found!")
       END IF
    END IF
GOTO D300

'   File sorter.
'
D330:
    Panel 4, 1, 21, 80, 1, TextColour%
    RESTORE Sorts
    FOR I% = 1 TO 10
        READ Me$: FastPrint 4 + I%, 8, Me$, TextColour%
    NEXT I%
    IF SizeOf&("SAMPLE.DAT") < 1 THEN
       SL% = StatusLine%("Can't find SAMPLE data file to sort!")
    ELSE
       IF Colour% THEN Attrib% = 32 ELSE Attrib% = 112
       PopUp 16, 3, 8, 74, Attrib%, 1, 2, 1
       FastPrint 16, 36, " SAMPLE.DAT ", Attrib%
       OPEN "SAMPLE.DAT" FOR INPUT AS #1
       FOR I% = 1 TO 6
           LINE INPUT #1, A$: OL% = LEN(A$)
           Me$ = LEFT$(A$, OL% - 2)
           FastPrint 16 + I%, 40 - (OL% \ 2) + 1, Me$, Attrib%
       NEXT I%
       CLOSE 1
       SortFile "SAMPLE.DAT", 1, 10, Done%
       IF Done% THEN
          OPEN "SAMPLE.DAT" FOR INPUT AS #1
          FOR I% = 1 TO 6
              LINE INPUT #1, A$: OL% = LEN(A$)
              Me$ = LEFT$(A$, OL% - 2)
              FastPrint 16 + I%, 40 - (OL% \ 2) + 1, Me$, Attrib%
          NEXT I%
          CLOSE 1
          SL% = StatusLine%(""): ShutUp
          FastPrint 21, 28, "File successfully sorted", TextColour%
       ELSE
          CALL ShutUp
          FastPrint 21, 30, "Unable to sort file", TextColour%
       END IF
    END IF
GOTO D300

' Ŀ
'      Keyboard functions and procedures.                                 
' 
'
D400:
    Options% = 3: Menu$(0) = "AKT"
    Menu$(1) = "ASCII and Scan Codes"
    Menu$(2) = "Keyboard Shift Flags"
    Menu$(3) = "Typeahead Buffer"
    PopUpMenu 4, 19, BarColour%, 1, Options%, "KEYBOARD", Menu$()
    IF Abort% OR NxtPop% THEN
       GOTO D002
    ELSE
       SELECT CASE Choice%
           CASE 1
                GOTO D410
           CASE 2
                GOTO D420
           CASE 3
                GOTO D430
           CASE ELSE
       END SELECT
    END IF
GOTO D400

'   Indexes to the font table in ROM-BIOS, then translates the pixel
'   values of the character specified by a keypress, into a large-
'   scale representation of that character.
'
D410:
    Panel 4, 1, 21, 80, 1, TextColour%
    Fore$ = STRING$(2, ""): Back$ = STRING$(2, "")
    FastPrint 6, 31, "Ŀ", TextColour%
    FOR Row% = 7 TO 14
        FastPrint Row%, 31, "" + STRING$(16, "") + "", TextColour%
    NEXT Row%
    FastPrint 15, 31, "", TextColour%
    FastPrint 25, 1, SPACE$(80), StatColour%
    FastPrint 25, 3, "Press any key, or <Esc> to abort", StatColour%
    LOCATE 21, 40, 1: DEF SEG = &HF000: Abort% = FALSE: KeyFlush
    DO
        Character% = KeyIn%: IF Character% = 27 THEN EXIT DO
        FastPrint 21, 40, " ", TextColour%
        FastPrint 16, 10, SPACE$(60), TextColour%
        SELECT CASE Character%
            CASE 0 TO 127
                 FOR Row% = 1 TO 8
                     Pixel% = PEEK(&HFA6D + (Character% * 8) + Row%)
                     IF Pixel% = 0 THEN
                        FastPrint Row% + 6, 32, STRING$(16, ""), TextColour%
                     ELSE
                        Col% = 32
                        FOR Column% = 7 TO 0 STEP -1
                            IF Pixel% < 2 ^ Column% THEN
                               FastPrint Row% + 6, Col%, Back$, TextColour%
                            ELSE
                               FastPrint Row% + 6, Col%, Fore$, TextColour%
                               Pixel% = Pixel% - 2 ^ Column%
                            END IF
                            Col% = Col% + 2
                        NEXT Column%
                     END IF
                 NEXT Row%
            CASE ELSE
                 IF Character% < 0 THEN
                    Me$ = SPACE$(16)
                 ELSE
                    Me$ = STRING$(16, Character%)
                 END IF
                 FOR Row% = 1 TO 8
                     FastPrint Row% + 6, 32, Me$, TextColour%
                 NEXT Row%
        END SELECT
        IF Character% < 0 THEN
           Me$ = "Scan Code " + LTRIM$(RTRIM$(STR$(ABS(Character%))))
        ELSE
           Me$ = "ASCII Code " + LTRIM$(RTRIM$(STR$(Character%)))
        END IF
        FastPrint 16, 40 - (LEN(Me$) \ 2), Me$, TextColour%
    LOOP WHILE 1
    DEF SEG : LOCATE , , 0: Display Head$, 0
GOTO D400

'   Keyboard shift flags.
'
D420:
    Panel 4, 1, 21, 80, 1, TextColour%
    ShiftFlags% = KeyFlags%: Flag$ = STRING$(16, "0")
    FOR I% = 15 TO 0 STEP -1
        IF FNBitTest%(ShiftFlags%, I%) THEN
           MID$(Flag$, 16 - I%, 1) = "1"
        END IF
    NEXT I%
    FastPrint  5, 40, "Keyboard Status Word at 0040:0017", TextColour%
    FastPrint  7, 40, "Bit settings (1 = set)", TextColour%
    FastPrint  5, 3, " F E D C B A 9 8 7 6 5 4 3 2 1 0", TextColour%
    FastPrint  6, 3, "Ŀ", TextColour%
    FastPrint  7, 3, "", TextColour%: Col% = 4
    FOR I% = 1 TO 16
        FastPrint 7, Col%, MID$(Flag$, I%, 1) + "", TextColour%
        Col% = Col% + 2
    NEXT I%
    FastPrint  8, 3, "", TextColour%
    FastPrint  9, 3, "               ", TextColour%
    FastPrint 10, 3, "              ", TextColour%
    FastPrint 11, 3, "             ", TextColour%
    FastPrint 12, 3, "            ", TextColour%
    FastPrint 13, 3, "           ", TextColour%
    FastPrint 14, 3, "          ", TextColour%
    FastPrint 15, 3, "         ", TextColour%
    FastPrint 16, 3, "        ", TextColour%
    FastPrint 17, 3, "       ", TextColour%
    FastPrint 18, 3, "      ", TextColour%
    FastPrint 19, 3, "     ", TextColour%
    FastPrint 20, 3, "    ", TextColour%
    FastPrint 21, 3, "   ", TextColour%
    FastPrint 22, 3, "  ", TextColour%
    FastPrint 23, 3, " ", TextColour%
    FastPrint 25, 1, SPACE$(80), StatColour%
    FastPrint 25, 3, "Press <Esc> to abort", StatColour%
    RESTORE Shift
    FOR I% = 1 TO 15
        READ Me$: FastPrint I% + 8, 40, Me$, TextColour%
    NEXT I%
    DO
        ShiftFlags% = KeyFlags%
        FOR I% = 15 TO 0 STEP -1
            IF FNBitTest%(ShiftFlags%, I%) THEN
               MID$(Flag$, 16 - I%, 1) = "1"
            END IF
        NEXT I%
        Col% = 4
        FOR I% = 1 TO 16
            FastPrint 7, Col%, MID$(Flag$, I%, 1) + "", TextColour%
            Col% = Col% + 2
        NEXT I%
        CL% = CapsLock%(2)
        IF CL% THEN
           FastPrint 25, 65, "CAPS", 14
        ELSE
           FastPrint 25, 65, "    ", StatColour%
        END IF
        NL% = NumLock%(2)
        IF NL% THEN
           FastPrint 25, 70, "NUM", 14
        ELSE
           FastPrint 25, 70, "   ", StatColour%
        END IF
        SL% = ScrLock%(2)
        IF SL% THEN
           FastPrint 25, 74, "SCRL", 14
        ELSE
           FastPrint 25, 74, "    ", StatColour%
        END IF
    LOOP UNTIL INKEY$ = CHR$(27)
    Display Head$, 0
GOTO D400

'   Keyboard typeahead buffer.
'
D430:
    COLOR 7, 0: Panel 4, 1, 21, 80, 1, 14
    RESTORE KeyBuff: READ Items%
    FOR I% = 1 TO Items%
        READ Row%, Col%, Me$: LOCATE Row%, Col%, 0: PRINT Me$;
    NEXT I%
    LOCATE 11, 68: COLOR 11: DEF SEG = &H40
    Start% = &H400 + PEEK(&H80): Finish% = &H400 + PEEK(&H82)
    PRINT RIGHT$("0000" + HEX$(Start%), 4); " ";
    PRINT RIGHT$("0000" + HEX$(Finish%), 4);
    DO
        Hd% = &H400 + PEEK(&H1A): Tl% = &H400 + PEEK(&H1C)
        LOCATE 11, 4: COLOR 11
        PRINT RIGHT$("0000" + HEX$(Hd%), 4); " ";
        PRINT RIGHT$("0000" + HEX$(Tl%), 4);
        COLOR 13: LOCATE 9, 17: PRINT SPACE$(48);
        LOCATE 9, 17 + ((Hd% - &H41E) \ 2) * 3: PRINT CHR$(25);
        COLOR 12: LOCATE 13, 17: PRINT SPACE$(48);
        LOCATE 13, 17 + ((Tl% - &H41E) \ 2) * 3: PRINT CHR$(24);
        FOR I% = 0 TO 15
            C% = PEEK(&H1E + (I% * 2))
            S% = PEEK(&H1E + (I% * 2) + 1)
            IF C% < 32 THEN Ky$ = "  " ELSE Ky$ = CHR$(C%) + " "
            LOCATE 11, 17 + (I% * 3): COLOR 14: PRINT Ky$;
            LOCATE 14, 17 + (I% * 3): COLOR 9
            PRINT RIGHT$("0" + HEX$(C%), 2);
            LOCATE 15, 17 + (I% * 3): COLOR 10
            PRINT RIGHT$("0" + HEX$(S%), 2);
        NEXT I%
        IF Hd% >= Tl% THEN
           Kys% = 16 - ((Hd% - Tl%) \ 2)
        ELSE
           Kys% = (Tl% - Hd%) \ 2
        END IF
        LOCATE 14, 76: IF Kys% = 16 THEN Kys% = 0
        PRINT RIGHT$(" " + LTRIM$(RTRIM$(STR$(Kys%))), 2);
        IF Kys% = 15 THEN
           LOCATE 15, 67: COLOR 28: PRINT "BUFFER FULL";
           Delay 2: KeyFlush: LOCATE , 67: PRINT SPACE$(11);
        END IF
    LOOP UNTIL PEEK((Tl% - &H400) - 2) = 27
    DEF SEG : COLOR 7, 0: LOCATE 20, 1, 0
    Dummy$ = INPUT$(Kys%)
GOTO D400

' Ŀ
'      Miscellaneous functions and procedures.                            
' 
'
D500:
    Options% = 4: Menu$(0) = "ODHE"
    Menu$(1) = "Operating System Flags"
    Menu$(2) = "Date entry and validation"
    Menu$(3) = "Hardware Equipment List"
    Menu$(4) = "Encryption of Text"
    PopUpMenu 4, 27, BarColour%, 1, Options%, "EXAMPLES", Menu$()
    IF Abort% OR NxtPop% THEN
       GOTO D002
    ELSE
       SELECT CASE Choice%
           CASE 1
                GOTO D510
           CASE 2
                GOTO D520
           CASE 3
                GOTO D530
           CASE 4
                GOTO D540
           CASE ELSE
       END SELECT
    END IF
GOTO D500

' Ŀ
'      System Flags.                                                      
' 
'
D510:
    DIM CoOrd%(16, 2): Context% = 1: Topic$ = "FLAGS"
    Panel 4, 1, 21, 80, 1, TextColour%: RESTORE Flags
    FOR I% = 6 TO 21
        READ Me$: FastPrint I%, 6, Me$, TextColour%
    NEXT I%
    Panel 6, 50, 16, 27, 2, 48
    FastPrint 7, 53, "CURRENT FLAG SETTINGS", 48
    FastPrint 8, 50, "" + STRING$(25, "") + "", 48
    FOR I% = 10 TO 17
        READ Me$: FastPrint I%, 52, Me$, 48
    NEXT I%
    FOR I% = 1 TO 16
        READ CoOrd%(I%, 1), CoOrd%(I%, 2): F% = GetFlag%(I%)
        F$ = LTRIM$(RTRIM$(STR$(F%))): F$ = RIGHT$("   " + F$, 3)
        FastPrint CoOrd%(I%, 1), CoOrd%(I%, 2), F$, 48
    NEXT I%
    FastPrint 19, 52, "Enter Flag Number:", 48
    FastPrint 25, 3, SPACE$(78), StatColour%
    FastPrint 25, 3, "Press <ESC> to Abort", StatColour%
    DO
        LOCATE 19, 73: Number$ = RevInput$(2, Number$)
        IF Abort% THEN EXIT DO
        Number% = VAL(Number$)
        IF Number% < 1 OR Number% > 16 THEN
           BEEP
        ELSE
           Number$ = LTRIM$(RTRIM$(STR$(Number%)))
           Number$ = RIGHT$("  " + Number$, 2)
           FastPrint 19, 73, Number$, 48
           Setting% = GetFlag%(Number%)
           Setting$ = RIGHT$("   " + LTRIM$(RTRIM$(STR$(Setting%))), 3)
           LOCATE CoOrd%(Number%, 1), CoOrd%(Number%, 2)
           Setting$ = RevInput$(3, Setting$): IF Abort% THEN EXIT DO
           Setting% = VAL(Setting$)
           IF Setting% < 0 OR Setting% > 255 THEN
              BEEP
           ELSE
              SetFlag Number%, Setting%
           END IF
           Setting% = GetFlag%(Number%)
           Setting$ = RIGHT$("   " + LTRIM$(RTRIM$(STR$(Setting%))), 3)
           FastPrint CoOrd%(Number%, 1), CoOrd%(Number%, 2), Setting$, 48
        END IF
    LOOP WHILE NOT Abort%
    ERASE CoOrd%: Display Head$, 0
GOTO D500

' Ŀ
'      Long Date Routine.                                                 
' 
'
D520:
    IF Colour% THEN Attrib% = 48 ELSE Attrib% = 112
    IF ToDay$ = "" THEN ToDay$ = SPACE$(20)
    Context% = 1: Topic$ = "LONGDATE": WW% = LEN(ToDay$)
    WT% = 41 - (WW% \ 2): PopUp 13, 24, 8, 34, Attrib%, 3, 2, 1
    FastPrint 14, 33, "Today's date is:", Attrib%
    FastPrint 15, WT%, ToDay$, Attrib%
    OK% = Verify%(19, "Is this correct")
    IF NOT OK% THEN
       FastPrint 17, 32, "Enter correct date", Attrib%
       Temp$ = "": LOCATE 19, 37: Temp$ = DateInput$(Temp$)
       IF NOT Abort% THEN
          Now$ = Temp$: MO% = VAL(MID$(Temp$, 4, 2))
          DY% = VAL(LEFT$(Temp$, 2)): YR% = VAL(RIGHT$(Temp$, 2))
          ToDay$ = LongDate$(DY%, MO%, YR%): OL% = LEN(ToDay$)
          IF OL% > 0 THEN
             FastPrint 25, 41, SPACE$(40), StatColour%
             FastPrint 25, 79 - OL%, ToDay$, StatColour%
          END IF
       END IF
    END IF
    CALL ShutUp
GOTO D500

' Ŀ
'      Equipment List.                                                    
' 
'
D530:
    Panel 4, 1, 21, 80, 1, TextColour%
    Cols$ = "80": Video$ = "color": DIM Model(0 TO 8) AS STRING
    RESTORE HWare: FOR I% = 0 TO 8: READ Model(I%): NEXT
    DEF SEG = &H40: Equipment% = PEEK(&H10) + (PEEK(&H11) * 256)
    DEF SEG = &HF000: Computer% = PEEK(&HFFFE)
    DEF SEG : Flag$ = STRING$(16, "0")
    Computer% = Computer% - &HF8: IF Computer% < 0 THEN Computer% = 0
    FastPrint 8, 38, "IBM " + Model(Computer%) + " or compatible", TextColour%
    Chip% = Cpu%
    SELECT CASE Chip%
        CASE IS < 0
             Me$ = " an Intel 80C" + LTRIM$(RTRIM$(STR$(ABS(Chip%))))
        CASE 20, 30
             Me$ = " a NEC V" + LTRIM$(RTRIM$(STR$(Chip%)))
        CASE 88 TO 486
             Me$ = " an Intel 80" + LTRIM$(RTRIM$(STR$(Chip%)))
        CASE ELSE
             Me$ = " an unknown"
    END SELECT
    Me$ = "with" + Me$ + " microprocessor"
    FastPrint 9, 38, Me$, TextColour%
    FOR I% = 15 TO 0 STEP -1
        IF FNBitTest%(Equipment%, I%) THEN
           MID$(Flag$, 16 - I%, 1) = "1"
        END IF
    NEXT I%
    FastPrint 8, 3, " F E D C B A 9 8 7 6 5 4 3 2 1 0", TextColour%
    FastPrint 9, 3, "Ŀ", TextColour%
    FastPrint 10, 3, "", TextColour%: Col% = 4
    FOR I% = 1 TO 16
        FastPrint 10, Col%, MID$(Flag$, I%, 1) + "", TextColour%
        Col% = Col% + 2
    NEXT I%
    FastPrint 10, 38, "ROM BIOS Equipment Flag at 0040:0010", TextColour%
    FastPrint 11, 3, "", TextColour%
    FastPrint 12, 3, "                  ", TextColour%
    FastPrint 13, 3, "                  ", TextColour%
    FastPrint 14, 3, "                 ", TextColour%
    FastPrint 15, 3, "               ", TextColour%
    FastPrint 16, 3, "             ", TextColour%
    FastPrint 17, 3, "           ", TextColour%
    FastPrint 18, 3, "      ", TextColour%
    FastPrint 19, 3, "     ", TextColour%
    FastPrint 20, 3, " ", TextColour%
    FastPrint 13, 38, "Floppy drives installed?", TextColour%
    IF MID$(Flag$, 16, 1) = "1" THEN Me$ = "Yes" ELSE Me$ = "No"
    FastPrint 13, 68, Me$, TextColour%
    FastPrint 14, 38, "Maths coprocessor installed?", TextColour%
    IF MID$(Flag$, 15, 1) = "1" THEN Me$ = "Yes" ELSE Me$ = "No"
    FastPrint 14, 68, Me$, TextColour%
    FastPrint 15, 38, "Original PC motherboard RAM", TextColour%
    IF Computer% = 1 THEN
       Ram% = (ValBinStr%(MID$(Flag$, 13, 2)) + 1) * 16
       Me$ = RIGHT$("  " + LTRIM$(RTRIM$(STR$(Ram%))), 2) + "KB"
    ELSE
       Me$ = "n/a"
    END IF
    FastPrint 15, 68, Me$, TextColour%
    FastPrint 16, 38, "Initial Video mode", TextColour%
    Mode% = ValBinStr%(MID$(Flag$, 11, 2))
    IF Mode% = 1 THEN Cols$ = "40"
    IF Mode% = 7 THEN Video$ = "mono"
    FastPrint 16, 58, Cols$ + " column " + Video$, TextColour%
    FastPrint 17, 38, "Number of floppy drives", TextColour%
    Mode% = ValBinStr%(MID$(Flag$, 9, 2)) + 1
    Me$ = LTRIM$(RTRIM$(STR$(Mode%))): FastPrint 17, 68, Me$, TextColour%
    FastPrint 18, 38, "Number of serial ports", TextColour%
    Mode% = ValBinStr%(MID$(Flag$, 5, 3)) + 1
    Me$ = LTRIM$(RTRIM$(STR$(Mode%))): FastPrint 18, 68, Me$, TextColour%
    FastPrint 19, 38, "Games adaptor installed?", TextColour%
    IF MID$(Flag$, 3, 1) = "1" THEN Me$ = "Yes" ELSE Me$ = "No"
    FastPrint 19, 68, Me$, TextColour%
    FastPrint 20, 38, "Number of parallel printers", TextColour%
    Mode% = ValBinStr%(LEFT$(Flag$, 2))
    Me$ = LTRIM$(RTRIM$(STR$(Mode%))): FastPrint 20, 68, Me$, TextColour%
    FastPrint 25, 1, SPACE$(80), StatColour%
    FastPrint 25, 3, "Press a key to continue", StatColour%
    Character% = KeyIn%: Display Head$, 0
    ERASE Model
GOTO D500

'   Text Encryption.
'
D540:
    Panel 4, 1, 21, 80, 1, TextColour%
    Done% = FALSE: RESTORE Crypt
    FOR I% = 1 TO 5
        READ Me$: FastPrint 6 + I%, 11, Me$, TextColour%
    NEXT I%
    IF Colour% THEN Attrib% = 32 ELSE Attrib% = 112
    DO
        PopUp 17, 19, 4, 44, Attrib%, 2, 2, 1
        FastPrint 18, 27, "Enter string to be encrypted", Attrib%
        LOCATE 19, 21: Text$ = RevInput$(40, "")
        CALL ShutUp: IF Abort% THEN EXIT DO
        Text$ = LTRIM$(RTRIM$(Text$))
        IF Text$ = "" THEN
           SL% = StatusLine%("You can't encrypt an empty string!")
        END IF
    LOOP WHILE Text$ = ""
    IF NOT Abort% THEN
       IF Colour% THEN Attrib% = 78 ELSE Attrib% = 112
       DO
           PopUp 17, 19, 4, 44, Attrib%, 2, 2, 1
           FastPrint 18, 25, "Enter string to encrypt it with", Attrib%
           LOCATE 19, 21: Code$ = RevInput$(40, "")
           CALL ShutUp: IF Abort% THEN EXIT DO
           Code$ = LTRIM$(RTRIM$(Code$))
           IF Code$ = "" THEN
              SL% = StatusLine%("An empty string is no use!")
           END IF
       LOOP WHILE Code$ = ""
       IF NOT Abort% THEN
          Cipher Text$, Code$: Me$ = "Encrypted string >  " + Text$
          FastPrint 14, 11, Me$, TextColour%
          IF Colour% THEN Attrib% = 48 ELSE Attrib% = 112
          DO
              DO
                  PopUp 19, 19, 4, 44, Attrib%, 2, 2, 1
                  FastPrint 20, 27, "Enter key string once again", Attrib%
                  LOCATE 21, 21: DeCode$ = RevInput$(40, DeCode$)
                  CALL ShutUp: IF Abort% THEN EXIT DO
                  DeCode$ = LTRIM$(RTRIM$(DeCode$))
                  IF DeCode$ = "" THEN
                     SL% = StatusLine%("An empty string is no use!")
                  END IF
              LOOP WHILE DeCode$ = ""
              IF Abort% THEN
                 Done% = TRUE
              ELSE
                 Me$ = Text$: Cipher Me$, DeCode$
                 Me$ = "Decrypted string >  " + Me$
                 FastPrint 16, 11, Me$, TextColour%
                 IF Code$ = DeCode$ THEN
                    FastPrint 19, 33, "That's the one!", TextColour%
                    Done% = TRUE
                 ELSE
                    Me$ = "Whoops, that's not right"
                    IF MisMatch% THEN
                       Me$ = Me$ + " either"
                    END IF
                    SL% = StatusLine%(Me$ + "!"): MisMatch% = TRUE
                 END IF
              END IF
          LOOP UNTIL Done%
       END IF
    END IF
GOTO D500

' Ŀ
'      Program Exit.                                                      
' 
'
D600:
    Options% = 2: Menu$(0) = "ED"
    Menu$(1) = "Exit program"
    Menu$(2) = "DOS shell"
    PopUpMenu 4, 40, BarColour%, 1, Options%, "EXIT", Menu$()
    IF Abort% OR NxtPop% THEN
       GOTO D002
    ELSE
       SELECT CASE Choice%
           CASE 1
                GOTO D610
           CASE 2
                GOTO D620
           CASE ELSE
       END SELECT
    END IF
GOTO D600

'   Program Exit
'
D610:
    IF Colour% THEN
       Scroll 1, 1, 1, 25, 80, 0, Attribute%(15, 1)
       COLOR , , 1: Attrib% = 32
    ELSE
       FOR I% = 1 TO 24
           FastPrint I%, 1, STRING$(80, ""), 7
       NEXT I%
       Attrib% = 112
    END IF
    PopUp 3, 2, 11, 44, Attrib%, 3, 2, 1: RESTORE Credits
    READ Me$: FastPrint 4, 4, Me$, Attrib%
    READ Me$: FastPrint 5, 4, Me$, Attrib%
    READ Me$: FastPrint 6, 4, Me$, Attrib%
    READ Me$: FastPrint 8, 4, Me$, Attrib%
    READ Me$: FastPrint 9, 4, Me$, Attrib%
    READ Me$: FastPrint 10, 4, Me$, Attrib%
    Delay 5
    IF Colour% THEN Attrib% = 48 ELSE Attrib% = 112
    PopUp 11, 29, 11, 50, Attrib%, 2, 1, 1
    FOR I% = 12 TO 14
        READ Me$: FastPrint I%, 31, Me$, Attrib%
    NEXT I%
    FOR I% = 16 TO 20
        READ Me$: FastPrint I%, 31, Me$, Attrib%
    NEXT I%
    Delay 2: FastPrint 24, 1, SPACE$(160), 27
    Me$ = "A donation of 25.00 towards development costs "
    Me$ = Me$ + "would warm my heart.": FastPrint 24, 7, Me$, 30
    Me$ = "(and put your name at the top of my mailing list)"
    FastPrint 25, 15, Me$, 31: Delay 20: ShutUp
    Delay 1: ShutUp: Delay 1: CLS
GOTO Egress

' Ŀ
'      Operating System Shell.                                            
' 
'
D620:
    Scroll 1, 3, 1, 25, 80, 0, 7
    Me$ = "Enter the command 'EXIT' when you are ready to return."
    FastPrint 10, 40 - (LEN(Me$) \ 2), Me$, 14
    LOCATE 13, 1, 1: ON ERROR GOTO D621
    SHELL
    ON ERROR GOTO Trap
    GOTO D001
D621:
    ON ERROR GOTO Trap
    IF ERR = 5 THEN
       Me$ = "Cannot load secondary Command Processor"
       SL% = StatusLine%(Me$)
       RESUME D600
    END IF

' Ŀ
'      Error Trap.                                                        
' 
'
Trap:
    Fatal% = TRUE
    SELECT CASE ERR
        CASE 7, 14
             Me$ = "Out of memory"
        CASE 27
             Me$ = "PRINTER NOT READY": Fatal% = 0
        CASE 61, 67
             Me$ = "Out of disk space"
        CASE 71
             Me$ = "DISK DRIVE NOT READY": Fatal% = 0
        CASE 72
             Me$ = "Disk media error"
        CASE ELSE
             A$ = STR$(ERR): Me$ = "A type" + A$ + " Error has just occurred"
    END SELECT
    IF Fatal% THEN
       Me$ = Me$ + ", aborting to DOS ...."
       SL% = StatusLine%(Me$)
       RESUME Egress
    ELSE
       ML% = LEN(Me$): MT% = 40 - (ML% \ 2)
       IF Colour% THEN Attrib% = 78 ELSE Attrib% = 112
       PopUp 9, 20, 7, 42, Attrib%, 3, 2, 1
       FastPrint 10, MT%, Me$, Attrib% + 128: BEEP
       Me$ = "Please correct this error if possible"
       FastPrint 12, 22, Me$, Attrib%
       FastPrint 13, 30, "Press a key when ready", Attrib%
       FastPrint 14, 32, "or <ESC> to Abort.", Attrib%
       Character% = KeyIn%: ShutUp
       IF Character% = 27 THEN RESUME Egress
       RESUME
    END IF
Egress:
    LOCATE 20, 1, 1: ClearEnd 1, 7
END


' Ŀ
'      Calculate Colour Attribute.                                        
' 
'
'   Supply the Foreground and Background colours required.
'
FUNCTION Attribute% (Fore%, Back%) STATIC
    Blink% = 0
    IF Fore% < 0 OR Fore% > 31 THEN Fore% = 7
    IF Back% < 0 OR Back% > 7 THEN Back% = 0
    IF Fore% > 15 THEN Fore% = Fore% - 16: Blink% = -1
    Temp% = (Back% * 16) + Fore%
    IF Blink% THEN Temp% = Temp% + 128
    Attribute% = Temp%
END FUNCTION

' Ŀ
'    Horizontal Bar Menu.                           CJG | January 1989    
' 
'
'   Creates and operates a menu orientated horizontally on the screen
'   row specified. The calling program must supply :
'
'   Menu$()     String array containing selection list. Menu$(0)
'               should be set to a string of ASCII characters,
'               corresponding to the initial or key letter of each
'               option in the list.
'   Options%    Number of options available for selection
'   Row%        The screen row on which the menu will appear
'   Attrib%     The display attribute code for the menu
'
SUB BarMenu (Row%, Attrib%, Options%, Menu$()) STATIC
    SHARED BarChoice%, Mouse%, NxtPop%
    DIM xLoc%(Options% + 1): X% = 3: Abort% = FALSE:
    FastPrint Row%, 1, SPACE$(80), Attrib%
    IF BarChoice% < 1 OR BarChoice% > Options% THEN BarChoice% = 1
    FOR I% = 1 TO Options%
        xLoc%(I%) = X%: FastPrint Row%, xLoc%(I%), Menu$(I%), Attrib%
        X% = X% + LEN(Menu$(I%)) + 2
    NEXT I%
    IF X% < 74 THEN
       Options% = Options% + 1: xLoc%(Options%) = 75
       Menu$(Options%) = "Help": Menu$(0) = Menu$(0) + "H"
       FastPrint Row%, xLoc%(Options%), Menu$(Options%), Attrib%
       HelpOption% = TRUE
    END IF
    DO
        FastPrint Row%, xLoc%(BarChoice%), Menu$(BarChoice%), 14
        IF NxtPop% THEN EXIT DO
        Character% = KeyIn%: LastChoice% = BarChoice%
        IF Character% < 0 THEN
           ScanCode% = ABS(Character%)
           IF ScanCode% = 59 THEN
              IF HelpOption% AND BarChoice% = Options% THEN
                 Context% = 0: Topic$ = ""
              ELSE
                 Context% = 1
                 Topic$ = "DEMON" + LTRIM$(RTRIM$(STR$(BarChoice%))) + "0"
              END IF 
              HelpMate Context%, Topic$
           END IF
           IF ScanCode% = 75 THEN BarChoice% = BarChoice% - 1
           IF ScanCode% = 77 THEN BarChoice% = BarChoice% + 1
           IF ScanCode% = 80 THEN Character% = 13
        ELSE
           IF Character% = 27 THEN Abort% = TRUE: EXIT DO
           Ky$ = UCASE$(CHR$(Character%)): M% = INSTR(Menu$(0), Ky$)
           IF M% > 0 THEN BarChoice% = M%
        END IF
        IF BarChoice% > Options% THEN BarChoice% = 1
        IF BarChoice% < 1 THEN BarChoice% = Options%
        IF BarChoice% <> LastChoice% THEN
           FastPrint Row%, xLoc%(LastChoice%), Menu$(LastChoice%), Attrib%
        END IF
        IF Character% = 13 AND HelpOption% THEN
           IF BarChoice% = Options% THEN
              HelpMate 0, "": Character% = 0
           END IF
        END IF
    LOOP UNTIL Character% = 13
    ERASE xLoc%
END SUB

' Ŀ
'   CENTRE TEXT  By Christy Gemmell                          August 1989  
' 
'
'   Centre a string within an empty string of specified width.
'
FUNCTION Centre$ (Text$, MaxWidth%) STATIC
    Text$ = LTRIM$(RTRIM$(Text$))
    Extra% = MaxWidth% - LEN(Text$)
    IF Extra% > 0 THEN
       Centre$ = SPACE$(Extra% \ 2) + Text$ + SPACE$(Extra% - Extra% \ 2)
    ELSE
       Centre$ = Text$
    END IF
END FUNCTION

' Ŀ
'      Check Printer status.                                              
' 
'
SUB CheckPrinter (Printer%) STATIC
    Abort% = FALSE: Ready% = FALSE
    DO
        Status% = PrinTest%(Printer%)
        IF Status% = 144 OR Status% = 208 THEN
           Ready% = TRUE
        ELSE
           SL% = StatusLine%("Printer NOT Ready")
           IF SL% = 27 THEN Abort% = TRUE
        END IF
    LOOP UNTIL Ready% OR Abort%
END SUB

' Ŀ
'    DATINPUT.INC | Date Input                   CJG | 13th October, 1988   
' 
'
'       This version written for MicroSoft Quick BASIC version 4.5
'
'       Accepts and verifies date input in a Reverse Video entry panel, all
'       the usual editing keys are supported and entry is terminated by
'       either a Carriage Return or the Escape character.
'
'       Requires the LONGDATE$ Library function to be declared in the
'       Module-Level code and WEEKDAY.OBJ to be linked at runtime.
'
'       Includes support for HELPMATE on-line help system (if required)
'
'       Revised USER-FRIENDLY version by CJG, 23rd May 1989
'
FUNCTION DateInput$ (D$) STATIC
    SHARED Now$, Abort%
    CursLeft$ = CHR$(29): CursRight$ = CHR$(28): Col% = POS(0)
    IF D$ = "" OR D$ = SPACE$(8) THEN
       Buffer$ = "DD/MM/YY"
    ELSE
       Buffer$ = LEFT$(D$ + SPACE$(8), 8)
    END IF
    DO
        Pointer% = 1: MaxLen% = 8: Abort% = FALSE
        COLOR 0, 7: LOCATE , Col%: PRINT Buffer$;
        LOCATE , Col%, 1: KeyCode% = 0
        DO WHILE KeyCode% <> 13
           KeyCode% = KeyIn%
           SELECT CASE KeyCode%
               CASE -59        ' <F1> key
                    HelpMate Context%, Topic$
               CASE -77        ' Right Arrow
                    IF Pointer% < MaxLen% THEN
                       Pointer% = Pointer% + 1
                       PRINT CursRight$;
                    END IF
               CASE -75        ' Left Arrow
                    IF Pointer% > 1 THEN
                       Pointer% = Pointer% - 1
                       PRINT CursLeft$;
                    END IF
               CASE 27         ' Escape key
                    KeyCode% = 13: Abort% = TRUE
               CASE 32, 45, 47 TO 57           ' Numeric keys
                    Z$ = CHR$(KeyCode%)
                    MID$(Buffer$, Pointer%, 1) = Z$
                    PRINT Z$; : Pointer% = Pointer% + 1
                    IF Pointer% > MaxLen% THEN
                       PRINT CursLeft$; : Pointer% = Pointer% - 1
                    END IF
               CASE ELSE
           END SELECT
        LOOP
        IF Buffer$ = SPACE$(8) OR Buffer$ = "DD/MM/YY" THEN
           Valid% = TRUE: Buffer$ = SPACE$(8)
        ELSE
           I% = 1: Part% = 1: Digit% = 0: Numeric% = FALSE
           DIM Temp(1 TO 3) AS STRING
           DO
               A% = ASC(MID$(Buffer$, I%, 1))
               IF A% > 47 AND A% < 58 THEN
                  Numeric% = TRUE: Digit% = Digit% + 1
                  IF Digit% > 2 THEN Part% = Part% + 1: Digit% = 1
                  IF Part% > 3 THEN EXIT DO
                  Temp(Part%) = Temp(Part%) + CHR$(A%)
               ELSE
                  IF Numeric% THEN Part% = Part% + 1: Digit% = 0
                  IF Part% > 3 THEN EXIT DO
                  Numeric% = FALSE
               END IF
               I% = I% + 1
           LOOP UNTIL I% = 9
           D% = VAL(Temp(1)): M% = VAL(Temp(2)): Y% = VAL(Temp(3))
           Buffer$ = RIGHT$("00" + Temp(1), 2) + "/"_
                   + RIGHT$("00" + Temp(2), 2) + "/"_
                   + RIGHT$("00" + Temp(3), 2)
           T$ = LongDate$(D%, M%, Y%): ERASE Temp
           IF T$ = "" THEN
              Valid% = FALSE: BEEP
           ELSE
              Valid% = TRUE
           END IF
        END IF
    LOOP UNTIL Valid%
    COLOR 7, 0: LOCATE , Col%, 0: PRINT Buffer$;
    DateInput$ = Buffer$
END FUNCTION

'   Sort file in place on disk
'
SUB DiskSort (PathName$, OffSet%, FieldLen%, Done%) STATIC
    OPEN PathName$ FOR RANDOM AS #1 LEN = RecordLen%
    FIELD 1, OffSet% - 1 AS Dummy1$, FieldLen% AS Key1$
    OPEN PathName$ FOR RANDOM AS #2 LEN = RecordLen%
    FIELD 2, OffSet% - 1 AS Dummy2$, FieldLen% AS Key2$
    Split% = Records& \ 2
    DO WHILE Split% > 0
       Limit% = Records& - Split%
       DO
           Switch% = FALSE
           FOR I% = 1 TO Limit%
               GET 1, I%: A$ = Key1$
               GET 2, I% + Split%: B$ = Key2$
               IF A$ > B$ THEN
                  LSET Full1$ = Y$: LSET Full2$ = X$
                  PUT 1, I% + Split%: PUT 2, I%
                  Switch% = I%
               END IF
           NEXT I%
           Limit% = Switch%
       LOOP WHILE Switch%
       Split% = Split% \ 2
    LOOP
    CLOSE : Done% = TRUE
END SUB

' Ŀ
'   SCREEN DISPLAY                                                        
' 
'
'   Draws or refreshes the main display screen. If switch is zero, only the
'   status line is refreshed.
'
SUB Display (Title$, Switch%) STATIC
    SHARED Colour%, ToDay$, Mouse%, NetWork%
    SHARED StatColour%, HeadColour%, TextColour%
    IF Switch% THEN
       Scroll 1, 1, 1, 3, 80, 0, HeadColour%
       IF Title$ <> "" THEN
          FastPrint 1, 40 - (LEN(Title$) \ 2), Title$, HeadColour%
       END IF
       FastPrint 2, 1, STRING$(80, ""), HeadColour%
       Panel 4, 1, 21, 80, 1, TextColour%
    END IF
    FastPrint 25, 1, SPACE$(80), StatColour%
    FastPrint 25, 4, "Press <F1> for Help, <ESC> to Abort", StatColour%
    IF ToDay$ <> "" THEN
       FastPrint 25, 78 - LEN(ToDay$), ToDay$, StatColour%
    END IF
END SUB

'   Sort file in memory
'
SUB MemSort (PathName$, OffSet%, FieldLen%, Done%) STATIC
    TempFile$ = UCASE$(PathName$)
    DotPosition% = INSTR(TempFile$, ".")
    IF DotPosition% > 0 THEN
       TempFile$ = LEFT$(TempFile$, DotPosition%) + "TMP"
    ELSE
       TempFile$ = TempFile$ + ".TMP"
    END IF
    Cmd$ = "COPY " + PathName$ + " " + TempFile$ + " > nul"
    SHELL Cmd$: DIM MemArray(1 TO Records&) AS Element
    OPEN PathName$ FOR RANDOM AS #1 LEN = RecordLen%
    IF OffSet% > 1 THEN
       FIELD 1, OffSet% - 1 AS Dummy1$, FieldLen% AS Key1$
    ELSE
       FIELD 1, FieldLen% AS Key1$
    END IF
    FIELD 1, RecordLen% AS A$
    I% = 1: CtrlZ$ = CHR$(26)
    DO
        GET 1, I%
        IF INSTR(A$, CtrlZ$) > 0 THEN
           Records& = I% - 1
        END IF
        LSET MemArray(I%).SortKey = Key1$
        MemArray(I%).RecNum = I%
        I% = I% + 1
    LOOP UNTIL I% > Records&
    Split% = Records& \ 2
    DO WHILE Split% > 0
       Limit% = Records& - Split%
       DO
          Switch% = FALSE
          FOR I% = 1 TO Limit%
              IF MemArray(I%).SortKey > MemArray(I% + Split%).SortKey THEN
                 SWAP MemArray(I%), MemArray(I% + Split%)
                 Switch% = I%
              END IF
          NEXT I%
          Limit% = Switch%
       LOOP WHILE Switch%
       Split% = Split% \ 2
    LOOP
    OPEN TempFile$ FOR RANDOM AS #2 LEN = RecordLen%
    FIELD 2, RecordLen% AS B$
    FOR I% = 1 TO Records&
        GET 2, MemArray(I%).RecNum
        C$ = B$: LSET A$ = C$
        PUT 1, I%
    NEXT I%
    CLOSE : KILL TempFile$: ERASE MemArray: Done% = TRUE
END SUB

' Ŀ
'   POPUP MENU  By Christy Gemmell                           August 1989  
' 
'
'   Displays and operates a popup menu, allowing the user to select from
'   the list of options displayed in the menu window. Now includes support
'   for a Microsoft compatible mouse.
'
'   This procedure calls the following assembly-language procedures.
'
'             FASTPRINT, HELPMATE, POPUP, SHUTUP
'
'   it also uses the function CENTRE$() listed, seperately, above.
'
'   Expects:  ROW%, COL%     screen co-ordinates of top-left corner of the
'                            window containing the menu.
'             ATTRIBUTE%     display attribute given to menu window.
'             BORDER%        Border style (1 - 8, 0 = no border). see the
'                            WINDOWS documentation for a list of styles.
'             OPTIONS%       Number of options provided by menu.
'             TITLE$         Title for the menu, if null string then no
'                            title is displayed.
'             MENU$()        Text for options list. MENU$(0) should contain
'                            a list of key characters, one for each option.
'
'   Shared:   COLOUR%        Set TRUE if system has a colour monitor fitted,
'                            otherwise defaults to monochrome.
'             CONTEXT%       Set TRUE if context-sensitive help is provided
'             TOPIC$         Name of HELP Topic to display if CONTEXT% is set.
'
'   Returns:  CHOICE%        Number of selection made by user.
'             ABORT%         Set TRUE if user pressed <ESC> without making
'                            a selection.
'
SUB PopUpMenu (Row%, Col%, Attr%, Border%, Options%, Title$, Menu$()) STATIC
    SHARED Abort%, Choice%, Colour%, Context%, Topic$
    SHARED BarChoice%, NxtPop%
    Abort% = FALSE: Choice% = 1: NxtPop% = FALSE
    IF UBOUND(Menu$) < Options% THEN Options% = UBOUND(Menu$)
    MaxWidth% = LEN(Title$): IF MaxWidth% > 0 THEN Title% = TRUE
    Rows% = Options% + 2: IF Title% THEN Rows% = Rows% + 2
    FOR I% = 1 TO Options%
        ThisWidth% = LEN(Menu$(I%))
        IF ThisWidth% > MaxWidth% THEN MaxWidth% = ThisWidth%
    NEXT I%
    IF Col% < 1 THEN Col% = INT((80 - MaxWidth%) / 2) - 2
    PopUp Row%, Col%, Rows%, MaxWidth% + 4, Attr%, Border%, 2, 0
    Row% = Row% + 1: Col% = Col% + 2
    IF Title% THEN
       IF LEN(Title$) < MaxWidth% THEN Title$ = Centre$(Title$, MaxWidth%)
       FastPrint Row%, Col%, Title$, Attr%
       Me$ = "" + STRING$(MaxWidth% + 2, "") + ""
       FastPrint Row% + 1, Col% - 2, Me$, Attr%
       Row% = Row% + 1
    ELSE
       Row% = Row% - 1
    END IF
    FOR I% = 1 TO Options%
        FastPrint Row% + I%, Col%, Menu$(I%), Attr%
    NEXT I%
    DO
        Me$ = LEFT$(Menu$(Choice%) + SPACE$(MaxWidth%), MaxWidth%)
        FastPrint Row% + Choice%, Col%, Me$, 14
        Character% = KeyIn%: LastChoice% = Choice%
        IF Character% < 0 THEN
           ScanCode% = ABS(Character%)
           IF ScanCode% = 59 THEN
              Topic$ = "DEMON" + LTRIM$(RTRIM$(STR$(BarChoice%)))_
                     + LTRIM$(RTRIM$(STR$(Choice%)))
              HelpMate 1, Topic$
           END IF
           IF ScanCode% = 72 THEN Choice% = Choice% - 1
           IF ScanCode% = 75 THEN
              BarChoice% = BarChoice% - 1: NxtPop% = TRUE
           END IF
           IF ScanCode% = 77 THEN
              BarChoice% = BarChoice% + 1: NxtPop% = TRUE
           END IF
           IF ScanCode% = 80 THEN Choice% = Choice% + 1
           IF NxtPop% THEN EXIT DO
        ELSE
           IF Character% = 27 THEN Abort% = TRUE: EXIT DO
           Ky$ = UCASE$(CHR$(Character%)): M% = INSTR(Menu$(0), Ky$)
           IF M% > 0 THEN Choice% = M%
        END IF
        IF Choice% > Options% THEN Choice% = 1
        IF Choice% < 1 THEN
           Abort% = TRUE: EXIT DO
        END IF
        IF Choice% <> LastChoice% THEN
           Me$ = LEFT$(Menu$(LastChoice%) + SPACE$(MaxWidth%), MaxWidth%)
           FastPrint Row% + LastChoice%, Col%, Me$, Attr%
        END IF
    LOOP UNTIL Character% = 13
    CALL ShutUp
END SUB

' Ŀ
'   REVINPUT.INC | Reverse Video Input              CJG | 9th March 1988    
' 
'
'   Accepts user input in a Reverse Video entry panel, all the usual
'   editing keys are supported and entry is terminated by either a
'   Carriage Return or the Escape character. Quick BASIC version.
'
FUNCTION RevInput$ (MX%, A$) STATIC
    SHARED Abort%, TextColour%
    CL$ = CHR$(29): CR$ = CHR$(28)
    IF A$ = "" THEN
       Bf$ = SPACE$(MX%)
    ELSE
       Bf$ = LEFT$(A$ + SPACE$(MX%), MX%)
    END IF
    PR% = 1: EN% = 0: Abort% = FALSE: KeyCode% = 0: It% = FALSE
    IF TextColour% = 112 THEN COLOR 7, 0 ELSE COLOR 0, 7
    Col% = POS(0): PRINT Bf$; : LOCATE , Col%, 1
    DO WHILE KeyCode% <> 13
       KeyCode% = KeyIn%
       SELECT CASE KeyCode%
           CASE -59              ' <F1> key
                HelpMate Context%, Topic$
           CASE -75              ' Left Arrow
                IF PR% > 1 THEN PR% = PR% - 1: PRINT CL$;
           CASE -77              ' Right Arrow
                IF PR% < MX% THEN PR% = PR% + 1: PRINT CR$;
           CASE -82              ' Insert Key
                IF NOT It% THEN
                   It% = TRUE: LOCATE , , 1, 1, 7
                ELSE
                   It% = FALSE: LOCATE , , 1, 6, 7
                END IF
           CASE -83              ' Delete Key
                Bf$ = LEFT$(Bf$, PR% - 1) + RIGHT$(Bf$, MX% - PR%) + " "
                LOCATE , Col%: PRINT Bf$; : LOCATE , (Col% - 1) + PR%
           CASE -117             ' <CTRL> <END>
                Bf$ = LEFT$(Bf$, PR% - 1) + SPACE$(MX% - PR%) + " "
                LOCATE , Col%: PRINT Bf$; : LOCATE , (Col% - 1) + PR%
           CASE 8                ' BackSpace key
                IF PR% > 1 THEN
                   MID$(Bf$, PR%, 1) = " ": PR% = PR% - 1
                   PRINT CL$; " "; CL$;
                ELSE
                   BEEP
                END IF
           CASE 27               ' Escape key
                KeyCode% = 13: Abort% = TRUE
           CASE IS > 31          ' Printable characters
                Z$ = CHR$(KeyCode%)
                IF NOT It% THEN
                   MID$(Bf$, PR%, 1) = Z$: PRINT Z$; : PR% = PR% + 1
                   IF PR% > MX% THEN
                      PRINT CL$; : PR% = PR% - 1
                   END IF
                ELSE
                   IF PR% < MX% THEN
                      Bf$ = LEFT$(Bf$, PR% - 1) + Z$_
                          + RIGHT$(Bf$, MX% - (PR% - 1))
                      Bf$ = LEFT$(Bf$, MX%)
                      LOCATE , Col%: PRINT Bf$;
                      LOCATE , Col% + PR%: PR% = PR% + 1
                   ELSE
                      BEEP
                   END IF
                END IF
           CASE ELSE
       END SELECT
    LOOP
    IF Abort% THEN Bf$ = SPACE$(MX%)
    IF TextColour% = 112 THEN COLOR 0, 7 ELSE COLOR 7, 0
    LOCATE , Col%, 0, 6, 7: PRINT Bf$;
    RevInput$ = Bf$
END FUNCTION

'   Root module - selects which kind of sort is required.
'
SUB SortFile (PathName$, OffSet%, FieldLen%, Done%) STATIC
    Memory% = TRUE: Done% = FALSE
    FileLen& = SizeOf&(PathName$)
    IF FileLen& = 0 THEN
       SL% = StatusLine%("File not found!")
       EXIT SUB
    END IF
    OPEN PathName$ FOR INPUT AS #1
    LINE INPUT #1, Temp$: CLOSE #1
    RecordLen% = LEN(Temp$) + 2: Records& = FileLen& \ RecordLen%
    IF (FieldLen% + OffSet%) > RecordLen% THEN
       SL% = StatusLine%("Bad record length!"): EXIT SUB
    END IF
    FreeRam& = FRE(-1): Wanted& = Records& * 12
    IF FieldLen% > 10 OR Records& > 32767 OR Wanted& > FreeRam& THEN
       Memory% = FALSE
       Me$ = "File too big for memory sort, use disk"
       OK% = Verify(16, Me$): IF OK% THEN Disk% = TRUE
    END IF
    IF Memory% THEN MemSort PathName$, OffSet%, FieldLen%, Done%
    IF Disk% THEN DiskSort PathName$, OffSet%, FieldLen%, Done%
END SUB

'   Evaluate a string of binary digits.
'
FUNCTION ValBinStr% (Bin$) STATIC
    Mask% = &H4000: Work$ = RIGHT$(STRING$(16, "0") + Bin$, 16)
    IF LEFT$(Work$, 1) = "1" THEN W% = &H8000 ELSE W% = 0
    FOR I% = 2 TO 16
        IF MID$(Work$, I%, 1) = "1" THEN W% = W% OR Mask%
        Mask% = Mask% \ 2
    NEXT I%
    ValBinStr% = W%
END FUNCTION

' Ŀ
'      Data Division.                                                     
' 
'
Blurb:
    DATA "The Library modules on this disk provide you"
    DATA "with all the facilities necessary for you to"
    DATA "implement a full range of window features in"
    DATA "your programs.  With just one statement, for"
    DATA "instance, you can 'Pop-up' a window onto the"
    DATA "screen."
    DATA "The window can be a simple rectangle, in any"
    DATA "the QuickBASIC background colors, such as .."
    DATA "Alternatively it may have a border in one of"
    DATA "four styles..."
    DATA "The border itself may be in any one of the"
    DATA "QuickBASIC foreground colors. It can blink"
    DATA "if you want it to ..."
    DATA "The window, too, can be presented in several"
    DATA "different ways. It can be flat..."
    DATA "or it can have a black shadow underneath, to"
    DATA "give a three-dimensional effect..."
    DATA "Once you have a window on the screen, simply"
    DATA "use FASTPRINT, also in the TOOLBOX Library, "
    DATA "to put text into it, in any colour you like."
    DATA "You can also use the SCROLL routine from the"
    DATA "same source, to clear the window's contents."
    DATA "All the functions in the Library are written"
    DATA "in fast assembly language, but this does not"
    DATA "prevent them from being very easy to use."
    DATA "This for instance, is the call to create the"
    DATA "present window ....."
    DATA "   PopUp 8, 14, 8, 52, 112, 2, 0, 1"
    DATA "Before opening a window, the function stores"
    DATA "the screen beneath it in an internal buffer."
    DATA "When you close a window, the screen contents"
    DATA "are restored to their original location. Use"
    DATA "the statement 'CALL ShutUp'to close the last"
    DATA "window opened.  For example ...."
    DATA "The Library includes several functions which"
    DATA "apply windowing techniques. The HELP screen,"
    DATA "which is available at the front menu, is one"
    DATA "example. Another is the VERIFY BOX which you"
    DATA "can use to collect a Yes/No response from an"
    DATA "operator, without redrawing the display."
    DATA "Another utility is the STATUS LINE MESSAGE,"
    DATA "which can be used to pause execution of the"
    DATA "program until the operator presses a key."
    DATA "You can display any prompt message you like"
    DATA "and the function will return the ASCII code"
    DATA "of the key which was pressed."
    DATA "I often use StatusLine in conjunction with a"
    DATA "routine which checks if the printer is ready"
    DATA "or not.  This gives the user a chance to fix"
    DATA "the printer,  if it is just out of paper, or"
    DATA "to abandon printing, if it is a more serious"
    DATA "problem. PrinterStat is included here too."

Flags:
    DATA "The ASSEMBLY LANGUAGE TOOLBOX includes a"
    DATA "pair  of functions which give you access"
    DATA "to  the  INTRA-APPLICATION COMMUNICATION"
    DATA "AREA (IAC),  an area of memory which has"
    DATA "been reserved,  by DOS, so that programs"
    DATA "can communicate with each other. The IAC"
    DATA "is 16 bytes long and is located,  in low"
    DATA "RAM at addresses 0000:04F0 - 04FF (Hex)."
    DATA "Once set, an IAC flag retains it's value"
    DATA "until  you reset it,  or the computer is"
    DATA "rebooted."
    DATA "Since QuickBASIC programs, compiled with"
    DATA "the /O switch to run stand-alone, cannot"
    DATA "pass variables to chain modules, you can"
    DATA "use  this feature to implement a limited"
    DATA "form of parameter passing."
    DATA "1.4F0h       9.4F8h", "2.4F1h      10.4F9h"
    DATA "3.4F2h      11.4FAh", "4.4F3h      12.4FBh"
    DATA "5.4F4h      13.4FCh", "6.4F5h      14.4FDh"
    DATA "7.4F6h      15.4FEh", "8.4F7h      16.4FFh"
    DATA 10, 59, 11, 59, 12, 59, 13, 59, 14, 59, 15, 59
    DATA 16, 59, 17, 59, 10, 72, 11, 72, 12, 72, 13, 72
    DATA 14, 72, 15, 72, 16, 72, 17, 72

Finder:
    DATA "This function allows you to find out if a particular"
    DATA "file is present on any disk drive in the system."," "
    DATA "Enter the name of the file which you want to locate,"
    DATA "including the drive letter and directory pathname if"
    DATA "required.  You can use an ambiguous name,  including"
    DATA "the wildcard characters (* and ?).  In this case the"
    DATA "function will pop up a directory window containing a"
    DATA "list of all files that match. You can select the one"
    DATA "you are interested in,  by high-lighting it with the"
    DATA "cursor arrow keys and pressing <RETURN>. The routine"
    DATA "returns a string containing the full pathname of the"
    DATA "file which you have selected."

Sorts:
    DATA "SORTFILE sorts ASCII text files. You supply the name, which may"
    DATA "include a directory pathname, and the start position and length"
    DATA "of the field which the file is to be sorted on.", " "
    DATA "The program first checks the size of the file and the amount of"
    DATA "free disk space to see if the it can be sorted in memory, this"
    DATA "requires space for two copies of the file on disk. If it is too"
    DATA "large, the file is sorted in place so that no extra disk space"
    DATA "is required. Using this method, which is far slower, the file"
    DATA "may be of any size up to 4 Gigabytes."

Size:
    DATA "THIS PROGRAM REPORTS THE SIZE OF FILES WHICH YOU SPECIFY"
    DATA "--------------------------------------------------------", " "
    DATA "The filename can include a directory path and may be ambiguous,"
    DATA "using the wildcard characters '*' and '?'. The program will"
    DATA "return the size of the file, in bytes, or, if more than one"
    DATA "match is found, the total size of all the files. If a size of"
    DATA "zero is returned, the file does not exist (at least not in the"
    DATA "directory specified).", " "
    DATA "Type in the pathname required (no more than 64 characters) or"
    DATA "Enter an empty string to quit."

KeyBuff:
    DATA 19, 6, 4, "Head Tail", 6, 33, "Keyboard Buffer"
    DATA 6, 67, "Buffer Area", 8, 4, "041A 041C"
    DATA 8, 17, "1E 20 22 24 26 28 2A 2C 2E 30 32 34 36 38 3A 3C"
    DATA 8, 68, "0480 0482", 10, 3, "Ŀ"
    DATA 10, 16, "Ŀ"
    DATA 10, 67, "Ŀ",11, 3,"         ", 11, 16, ""
    DATA 11, 64, "", 11, 67, "         ", 12, 3, ""
    DATA 12, 16, ""
    DATA 12, 67, "", 14, 3, "ASCII Codes"
    DATA 14, 67, "Waiting", 15, 3, "Scan Codes"

HWare:
    DATA "Unknown computer type", "PC", "PC/XT", "PCjr"
    DATA "PC/AT, PS/2 Model 50/60", "PC/XT", "PS/2 Model 30"
    DATA "PC Convertible", "PS/2 Model 80"

Shift:
    DATA "Left & Right SHIFT keys pressed", "CTRL key pressed"
    DATA "ALT key pressed", "SCROLL LOCK active"
    DATA "NUM LOCK active", "CAPS LOCK active"
    DATA "INSERT key status", "Left CTRL key pressed"
    DATA "Left ALT key pressed", "SYS REQ key pressed"
    DATA "PAUSE (or CTRL-NUM LOCK) active", "SCROLL LOCK pressed"
    DATA "NUM LOCK pressed", "CAPS LOCK pressed"
    DATA "INSERT key pressed"

Crypt:
    DATA "This routine requires that you supply two strings of
    DATA "characters. The first is the text to be encrypted, and"
    DATA "the second is one or more keywords which are used to"
    DATA "encipher the text. Thereafter, the text cannot be"
    DATA "decrypted until you supply the same key string again."

Credits:
    DATA "Licensed for distribution as ShareWare."
    DATA "You may copy this program or distribute"
    DATA "it to others on a non-commercial basis."
    DATA "You may also use or adapt these routines"
    DATA "in your own programs without charge, but"
    DATA "please give me the appropriate credit."
    DATA "If you find these programs useful and would"
    DATA "like to receive future additions and upgrades,"
    DATA "please contact the author:"
    DATA "Christy Gemmell            Singular SoftWare"
    DATA "                           22 Peake Road,"
    DATA "                           Northfields"
    DATA "                           Leicester, LE4 7DN"
    DATA "                           England"

' Ŀ
'   (c) 1988,1990 By Christy Gemmell and Singular Software.               
' 
