    DEFINT A-Z

    REM $INCLUDE: 'MOUSE.BI'  

    CLS
    PRINT "A Microsoft compatible mouse driver ";
    IF MouseInstalled% THEN
        PRINT "IS installed."
    ELSE
        PRINT "IS NOT installed."
        END
    END IF

    PRINT "It is ";
    IF NOT MouseAlreadyReset% THEN
        PRINT "NOT ";
    END IF
    PRINT "already reset."

    'The following routine resets the mouse and returns the number of buttons.
    Buttons% = MouseReset%
    
    'Get current mouse sensitivity settings
    CALL MouseGetSensitivity(VertRatio%, HorizRatio%, DblSpd%)
    
    'Get mouse hardware and software information
    CALL MouseGetInfo(MajorV%, MinorV%, MouseType%, Irq%)

    PRINT "The mouse has been initialized."
    PRINT
    PRINT "Mouse information:"
    PRINT
    PRINT "       Mouse Driver Version:";
    PRINT USING "##.##"; MajorV% + MinorV% / 100
    PRINT "                 Mouse Type: ";
    SELECT CASE MouseType%
        CASE 1
            PRINT "Bus Mouse"
        CASE 2
            PRINT "Serial Mouse"
        CASE 3
            PRINT "InPort Mouse"
        CASE 4
            PRINT "PS/2 Mouse"
        CASE 5
            PRINT "HP Mouse"
        CASE ELSE
            PRINT "Beats the heck outta me!"
    END SELECT
    PRINT "          Number of Buttons:"; Buttons%
    PRINT "                   IRQ Line:"; Irq%
    PRINT
    PRINT "Current mouse settings:"
    PRINT
    PRINT "           Horizontal Ratio:"; HorizRatio%; "mickeys per 8 pixels"
    PRINT "             Vertical Ratio:"; VertRatio%; "mickeys per 8 pixels"
    PRINT "     Double-speed Threshold:"; DblSpd%; "mickeys per second"
    PRINT
    PRINT "Press <Enter> to proceed to the next part of the demo or <Esc> to quit."

    CALL MousePointerOn                 'Makes the mouse pointer visible

    GOSUB WaitForEscOrEnter

    GOSUB ClearScreen
    
    PRINT
    PRINT "You may now move the mouse around the screen. Press <P> to toggle"
    PRINT "between Pixel and Row/Column coordinates. Press <Enter> to proceed"
    PRINT "to the next part of the demo or press <Esc> to quit."
    PRINT
    
    StartRow% = CSRLIN
    PRINT "Mouse location (Vert/Horiz):"
    PRINT "                Left Button:"
    PRINT "               Right Button:"
    IF Buttons% > 2 THEN
        PRINT "              Center button:"
    END IF

    CALL MousePointerOn                 'Makes the mouse pointer visible
    
    DO
        A$ = INKEY$
        SELECT CASE A$
            CASE CHR$(27)                   'Esc
                GOTO MouseTestExit
            CASE CHR$(13)                   'Enter
                EXIT DO
            CASE "P", "p"
                Pixels% = Pixels% XOR -1
                IF Pixels% THEN
                    CALL MousePixelsOn
                ELSE
                    CALL MousePixelsOff
                END IF
            CASE ELSE
        END SELECT
        CALL MouseGetStatus(Lb%, Rb%, Cb%, Row%, Column%)
        LOCATE StartRow%, 29
        PRINT STR$(Row%); ","; STR$(Column%); " (";
        IF Pixels% THEN
            PRINT "Pixels)      "
        ELSE
            PRINT "Row/Columns) "
        END IF
        LOCATE , 30
        IF Lb% THEN
            PRINT "Pressed    "
        ELSE
            PRINT "Not Pressed"
        END IF
        LOCATE , 30
        IF Rb% THEN
            PRINT "Pressed    "
        ELSE
            PRINT "Not Pressed"
        END IF
        IF Buttons% = 3 THEN
            LOCATE , 30
            IF Cb% THEN
                PRINT "Pressed    "
            ELSE
                PRINT "Not Pressed"
            END IF
        END IF
    LOOP
    CALL MousePixelsOff                 'Back to row/column coordinates

    DEF SEG = 0
    ScreenRows% = PEEK(&H484) + 1       'Get rows from EGA/VGA data area
    IF ScreenRows% = 1 THEN             'If it was zero (we added one)
        ScreenRows% = 25                'Then it must be a CGA/Mono - Only
    END IF                              ' 25 rows are supported.
    ScreenCols% = PEEK(&H44A)           'Get Screen columns from BIOS data area
    DEF SEG

    GOSUB ClearScreen
    
    PRINT "You can now use the arrow keys position the mouse pointer. The"
    PRINT "MouseSetPointer routine is being utilized for this purpose. Press"
    PRINT "<Enter> when you are ready to proceed to the next part of the demo"
    PRINT "or press <Esc> to quit."
    CALL MousePointerOn
    DO
        DO
            A$ = INKEY$
        LOOP UNTIL LEN(A$)
        
        'In case you moved the mouse between key presses, Row% and Column%
        CALL MouseGetStatus(Lb%, Rb%, Cb%, Row%, Column%)
        
        SELECT CASE A$
            CASE CHR$(27)                   'Esc
                GOTO MouseTestExit
            CASE CHR$(13)                   'Enter
                EXIT DO
            CASE CHR$(0) + CHR$(72)         'Up arrow
                IF Row% > 1 THEN
                    Row% = Row% - 1
                END IF
            CASE CHR$(0) + CHR$(80)         'Down arrow
                IF Row% < ScreenRows% THEN
                    Row% = Row% + 1
                END IF
            CASE CHR$(0) + CHR$(75)         'Left arrow
                IF Column% > 1 THEN
                    Column% = Column% - 1
                END IF
            CASE CHR$(0) + CHR$(77)         'Right arrow
                IF Column% < ScreenCols% THEN
                    Column% = Column% + 1
                END IF
            CASE ELSE
                BEEP
        END SELECT
        CALL MouseSetPointer(Row%, Column%)
    LOOP

    GOSUB ClearScreen

    PRINT "We can even tell you where a specific mouse button was pressed or"
    PRINT "released, and how many times. For the next 10 seconds, move the"
    PRINT "mouse around pressing and releasing the left button. At the end of"
    PRINT "that time, we'll tell you how many times it was pressed and released,"
    PRINT "and where the mouse pointer was located at the time of the last"
    PRINT "press and release. Press <Enter> if you don't wish to wait a full 10 seconds."
    PRINT

    Presses% = MousePressInfo(0, Row%, Column%)         'Resets the internal
    Releases% = MouseReleaseInfo(0, Row%, Column%)      'counters.

    PRINT "Time left:";
    CALL MousePointerOn
    StartTime& = TIMER                          'Starting TIMER value
    DO
        TimeLeft% = 10& - (TIMER - StartTime&)  'Calculate time left
        LOCATE , 11                             'Position cursor for display
        PRINT TimeLeft%;                        'Print TimeLeft value
        A$ = INKEY$                             'Check for a keypress
    LOOP UNTIL TimeLeft% = 0 OR A$ = CHR$(13)   'Loop until Esc or out of time
    PRINT
    PRINT
    PRINT "The left button was pressed"; MousePressInfo(0, Row%, Column%);
    PRINT "times and was located at"; Row%; ","; Column%; "when it"
    PRINT "was last pressed."
    PRINT
    PRINT "The left button was released"; MouseReleaseInfo(0, Row%, Column%);
    PRINT "times and was located at"; Row%; ","; Column%; "when it"
    PRINT "was last released."
    PRINT
    PRINT "Press <Enter> to proceed to the next part of the demo or press <Esc> to quit."
    GOSUB WaitForEscOrEnter

    GOSUB ClearScreen
    
    PRINT "We'll now the use MouseSetWindow routine to restrict the movement of the"
    PRINT "mouse pointer to a rectangular area of the screen. Press <Enter> to"
    PRINT "proceed to the next part of the demo or press <Esc> to quit."
    
    LOCATE 5, 1
    PRINT STRING$(1440, 219)            'Create a "blocked" area of the
    FOR Row% = 8 TO 19                  ' screen. This helps to demonstrate
        LOCATE Row%, 10                 ' the routine more effectively.
        PRINT STRING$(60, " ");
    NEXT

    CALL MousePointerOn                 'Pointer back on
    CALL MouseSetWindow(8, 10, 19, 69)  'Define our window

    GOSUB WaitForEscOrEnter             'Hmm. What does this do?

    CALL MouseSetWindow(1, 1, ScreenRows%, ScreenCols%) 'Restore to whole scrn
    
    GOSUB ClearScreen
    
    PRINT "The MouseMovement routine can tell you how far the mouse has moved"
    PRINT "between calls. The results are returned in "; mickeys; ". There are"
    PRINT "about 200 mickeys per inch."
    PRINT
    PRINT "Each time you press the left mouse button, we'll show you how far the"
    PRINT "mouse has moved since the last time the left button was pressed."
    PRINT
    PRINT "Press <Enter> when you are ready to proceed to the next part of the"
    PRINT "demo or press <Esc> to quit."
    PRINT
    PRINT "Mouse movement since last left button click:"
    PRINT
    PRINT "     Horizontal Mickeys: 0"
    PRINT "       Vertical Mickeys: 0"

    CALL MouseMovement(Rows%, Columns%)     'Reset the internal counters

    CALL MousePointerOn                     'So we can see it

    Rows% = 0                               'Zero our variables
    Columns% = 0

    DO
        
        DO
            CALL MouseGetStatus(Lb%, Rb%, Cb%, Row%, Column%)
            A$ = INKEY$
        LOOP UNTIL Lb% OR LEN(A$)
        
        IF Lb% THEN                                 'If left button pressed
            CALL MouseMovement(Rows%, Columns%)     'How much has it moved?
            LOCATE 13, 25
            PRINT Rows%; "    "                     'Display the net changes
            LOCATE , 25
            PRINT Columns%; "    "
            CALL MouseWaitForRelease                'Wait for button release
        ELSE
            SELECT CASE A$                          'A key was pressed
                CASE CHR$(27)                       'Esc
                    GOTO MouseTestExit
                CASE CHR$(13)                       'Enter
                    EXIT DO
                CASE ELSE                           'Whoops
                    BEEP
            END SELECT
        END IF
    LOOP

    GOSUB ClearScreen
    
    PRINT "Using the MouseSetRatio routine, you can control the sensitivity of the"
    PRINT "mouse. It is used to adjust the ratio between the physical movement"
    PRINT "of the mouse and the amount of movement reflected by the mouse pointer"
    PRINT "on the screen."
    PRINT
    PRINT "The default setting is 8 mickeys per 8 pixels of horizontal movement"
    PRINT "(1 mickey per pixel) and 16 mickeys per 8 pixels of vertical movement"
    PRINT "(2 mickeys per pixel). In other words, the mouse is twice as sensitive to"
    PRINT "horizontal movement than to vertical. This is necessary to more closely"
    PRINT "match the proportions of your display."
    PRINT
    PRINT "We'll not make the mouse half as sensitive as it normally is. This means"
    PRINT "that you'll have to move the mouse twice as far in order to move the"
    PRINT "pointer the same distance. Try it now. Press <Enter> to proceed or press"
    PRINT "<Esc> to quit."

    CALL MousePointerOn
    CALL MouseSetRatio(32, 16)              'Make half as sensitive

    GOSUB WaitForEscOrEnter

    PRINT
    PRINT "We'll now make the mouse twice as sensitive as it normally is. Try it now."
    PRINT "Press <Enter> to proceed or <Esc> to quit."

    CALL MouseSetRatio(8, 4)                'Make twice as sensitive

    GOSUB WaitForEscOrEnter

    CALL MouseSetRatio(16, 8)               'Back to normal
    
    GOSUB ClearScreen
    
    PRINT "Using the MouseSetExclusionArea routine, you can define an area of the screen"
    PRINT "that the mouse pointer will made invisible if moved into."
    PRINT
    PRINT "We've move the mouse cursor to the upper-left corner of the screen and"
    PRINT "drawn a block below. If you move the mouse pointer into the block, the"
    PRINT "pointer will disappear until you turn it back on again with the"
    PRINT "MousePointerOn routine."
    PRINT
    PRINT "Press <Enter> to proceed to the next part of the demo or press <Esc> to quit."

    CALL MousePointerOn

    CALL MouseSetPointer(1, 1)

    CALL MouseSetExclusionArea(11, 10, 20, 70)

    FOR Row% = 11 TO 20
        LOCATE Row%, 10
        PRINT STRING$(61, 219)
    NEXT
    GOSUB WaitForEscOrEnter

    CALL MousePointerOn                 'Mouse exclusion turns it off
    
    GOSUB ClearScreen
    
    PRINT "MouseSaveState can be used to save the current mouse characteristics such"
    PRINT "as locate, pointer definitions, visibility, etc., so it can be restored"
    PRINT "at a later time with the MouseRestoreState routine."
    PRINT
    PRINT "The current mouse state has just been saved. Move the mouse around the"
    PRINT "screen. When you press <Enter>, the mouse state will be restored. You can"
    PRINT "tell it worked correctly if the mouse pointer is returned to its current"
    PRINT "locate. Press <Esc> to quit."

    CALL MousePointerOn

    Success% = MouseSaveState%
    IF NOT Success% THEN
        PRINT
        PRINT "Insufficient memory to save mouse state ... Press a key"
    ELSE
        GOSUB WaitForEscOrEnter

        CALL MouseRestoreState
        PRINT
        PRINT "The mouse state has been restored. Press <Enter> to proceed to the next"
        PRINT "part of the demo or press <Esc> to quit."
    END IF

    GOSUB WaitForEscOrEnter
    
    GOSUB ClearScreen

    PRINT "Using the MouseSetEvent routine in conjunction with BASIC's built-in"
    PRINT "'ON UEVENT' function, we can build a mouse oriented event trap. BASIC"
    PRINT "already has one for a joystick, the timer, the keyboard, etc., so why not"
    PRINT "a mouse?? Only Microsoft knows for sure."
    PRINT
    PRINT "A mouse event has been set up. It will be triggered when the left button"
    PRINT "is pressed, the right button is released, or when there is ANY mouse movement."
    PRINT "Other options are available, but these are the only ones we'll demonstrate at"
    PRINT "this time"
    PRINT
    PRINT "You'll see a message at the bottom of the screen each time an event occurs."
    PRINT "You can try it now by moving the mouse around and pressing/releasing the"
    PRINT "left and right mouse buttons."
    PRINT
    PRINT "Press any key when you've seen enough."
    PRINT STRING$(79, "=")
    VIEW PRINT 17 TO 25
    
    CALL MousePointerOn                     'Turn on mouse pointer
    
    CALL MouseSetEvent(19)                  '2 + 16

    ON UEVENT GOSUB MouseEventHandler       'Point to an event hander
    UEVENT ON                               'Turn on event trapping.
    
    DO
        A$ = INKEY$                         'Wait for a key
EventCheckLabel:                            '/W will cause check for events here
    LOOP UNTIL LEN(A$)

    UEVENT OFF                              'Turn off event trapping

    CALL MouseCancelEvent                   'Turn our handler off.
    
    VIEW PRINT                              'Back to normal
    GOSUB ClearScreen
    
    PRINT "There are also some miscellaneous routines that do things like:"
    PRINT
    PRINT "  *  Change the mouse pointer's active display page"
    PRINT "  *  Change the pointer's display characteristics"
    PRINT "  *  Halt program execution until all buttons have been released"
    PRINT "  *  Switch easily between row/column and pixel based coordinates"
    PRINT
    PRINT "The routines are extremely easy to use and 'forgiving'. For example: If you"
    PRINT "save the current mouse state, memory is allocated to hold the data. If you"
    PRINT "forget to call the MouseRestoreState routine, the memory will be released"
    PRINT "automatically when your program terminates! Also, if you used the"
    PRINT "MouseSetEvent routine and forget to call the MouseCancelEvent routine to"
    PRINT "'unhook' your program from the mouse event chain, it'll be taken care of"
    PRINT "for you automatically when you program ends."
    PRINT
    PRINT "If you have any additional ideas, comments, criticisms or suggestions,"
    PRINT "please leave me a note on Compuserve - 76220,2575."
    PRINT
    PRINT "Thanks!   ----- Tony Elliott"
    
MouseTestExit:
    CALL MousePointerOff
    END

ClearScreen:
    CALL MousePointerOff                'The cls overwrites the mouse pointer.
    CLS                                 'So we have to turn it off, and CLS.
RETURN                                  'We'll turn it back on again above

WaitForEscOrEnter:
    DO
        A$ = INKEY$
    LOOP UNTIL A$ = CHR$(13) OR A$ = CHR$(27)
    IF A$ = CHR$(27) THEN
        RETURN MouseTestExit
    END IF
RETURN

MouseEventHandler:
    'This subroutine used in conjunction with the MouseSetEvent and UEVENT
    'demonstration.
    
    CALL MouseGetEventInfo(EventFlag%, Lb%, Rb%, Cb%, Row%, Column%)
    CALL MousePointerOff                'To prevent mouse droppings
    PRINT "Mouse Event - ";
    IF EventFlag% AND 1 THEN            'We have to use multiple IF..THEN
        PRINT "Mouse Motion - ";        ' blocks here instead of a SELECT CASE
    END IF                              ' because it is possible for more than
    IF EventFlag% AND 2 THEN            ' one type of event to occur
        PRINT "Lb Pressed - ";          ' simultaneously.
    END IF
    IF EventFlag% AND 16 THEN           'If you are interested only in one
        PRINT "Rb Released -";          ' type of event at a time, then a
    END IF                              ' SELECT CASE structure would be more
    PRINT Row%; ","; Column%            ' appropriate.
    CALL MousePointerOn                 'Back on
RETURN


