; EXAMPLE.asm
; sample code fragment showing runtime dynamic linking
;
; By Ray Duncan
; 


objbuf  db      64 dup (0)      ; receives failing module
                                ; or entry point name

objbuf_len equ  $-objbuf

mname   db      'VIOCALLS',0    ; module name

mhandle dw      0               ; receives module handle

ename   db      'VIOGETANSI',0  ; entry point name

eptr    dd      0               ; receives far pointer
                                ; to entry point

        .
        .
        .
                                ; attach to DLL...
        push    ds              ; receives failing dynlink
        push    offset DGROUP:objbuf
        push    objbuf_len      ; length of buffer
        push    ds              ; address of module name
        push    offset DGROUP:mname
        push    ds              ; receives module handle
        push    offset DGROUP:mhandle
        call    DosLoadModule   ; transfer to OS/2
        or      ax,ax           ; module found?
        jnz     error           ; jump if no such module

                                ; get entry point...
        push    mhandle         ; module handle
        push    ds              ; address of entry name
        push    offset DGROUP:ename
        push    ds              ; receives entry pointer
        push    offset DGROUP:eptr
        call    DosGetProcAddr  ; transfer to OS/2
        or      ax,ax           ; entry point found?
        jnz     error           ; jump if no entry point

        .
        .                       ; other processing here...
        .

        call    eptr            ; indirect call to
                                ; dynlink library routine

        .
        .                       ; other processing here...
        .

                                ; module no longer
                                ; needed, release it...
        push    mhandle         ; module handle
        call    DosFreeModule   ; transfer to OS/2        or      ax,ax           ; should never fail
        jnz     error           ; but check anyway
        .
        .
        .



