ķ
PCPS(V7.50)                                                        PCPS(V7.50)
Ľ

NAME
        PCPS.EXE - convert text to postscript

SYNOPSIS
        PCPS [-arg1 -arg2 -arg3 ... -argn] [filename(s)]

DESCRIPTION
        PCPS reads in text files (now including support of the full IBM/PC
        character set), converts them to POSTSCRIPT and outputs them to a
        POSTSCRIPT printer, a file or stdout.  If no input files are
        specified, PCPS will take its input from stdin.  Many attributes
        such as fonts, headings, orientation, various formatting options
        etc. may be specified.

        The various arguments are detailed below.  Any field enclosed in <>
        is mandatory for that argument but those enclosed in [] are
        optional:

        -? or ? or (no arguments AND no stdin pipe)
                This will give you a multiple page help screen.

        -l      List available font codes.  ALL other arguments are ignored
                when -l is used.

        -#[n]   Print line numbers.  The default is for the line numbers to
                be shown with 4 digits but should an optional number also
                be specified, the line numbers will start with "n" digits
                where "n" can be a maximum of 6.  The number of digits is
                automatically increased should the line numbers exceed the
                number able to be specified by the current number of
                digits.

                EXAMPLE: -#     print line numbers and start with 4 digits.
                         -#3    print line numbers and start with 3 digits.

*       -#-     Do NOT print line numbers.

        -a<o|e> Print alternate pages where o = ODD and e = even.  This is
                useful when double sided printing is required.  For further
                double sided support, see "-z" below.

                EXAMPLE: -ao    print only odd pages.

*       -a-     Turn OFF alternate page printing - print both odd and even.

        -b      Disable banner printing.

*       -b-     Enable banner printing.

        -c      Truncate (Cut) lines longer than the maximum number of
                characters allowed in the current mode.

*       -c-     Disable truncation of lines - wrap them instead.

        -db     Debug - download the extended postscript error handler to
                the printer before the print job.  This error handler causes
                the printer to output any errors on paper as well as back
                along its comms line.

                Use this option carefully as, on many printers, this causes
                a permanent change to its error handling routine.

                This option should only be used as a last resort if, for
                any reason, your printer refuses to print the output from
                PCPS and you are unable to monitor your printers errors;
                E.g. Most spoolers have a log file and any errors output by
                the printer are normally placed into this file, but access
                to this file may be impractical.

*       -db-    Disable debug mode.

        -dl     Delete the input file(s) after successful processing.
                **************** USE WITH CAUTION *******************
                PCPS will consider the file processed successfully if it
                receives no errors during the processing and will delete
                the input file.  Be aware that print jobs can sometimes get
                lost, especially on networks.

*       -dl-    Do NOT delete the input file.

        -dr     Enable draft print mode where the word "DRAFT" is printed
                in light grey on the background of each page behind the
                text.  This is functionally equivalent to the argument
                "-kDRAFT".

*       -dr-    Disable all background printing including any text
                specified with the "-k" argument.

        -dt     Add timing code to the postscript to cause the printer to
                dump timing information back out its comms line so that it
                may be captured (to a log file for instance).  This
                information can be useful when analysing printer performance.

*       -dt-    Disable postscript timing code.

        -e<l|r|t|b><n>
                Set the specified margin (Edge) to be "n" points (1/72
                inch) where l = Left, r = Right, t = Top and b = Bottom.

                EXAMPLE: -el72  set the left margin to 1 inch.

                The default margins are as follows:

                ͻ
                           Left      Right     Top       Bottom    
                ͹
                Portrait   36p(.50") 18p(.25") 36p(.50") 36p(.50") 
                Landscape  18p(.25") 18p(.25") 36p(.50") 18p(.25") 
                ͼ

*       -e-     Set the margins back to their defaults.

        -f<[font code][size]>
                This argument is used to set the font type and/or the font
                size.  The "font code" is the abbreviated code for the font
                which is listed by the "-l" option.  The size is in points.
                See SUPPORTED FONTS.

                EXAMPLE: -fc12 set font to Courier at size 12 point.

*       -f-     Set the font and size to the default IBMPCFont at 10 point.

        -g or -gonewordcomment or "-gmultiple word comment"
                Print a gaudy banner at the top of the page containing the
                files last modification date, the current page number, the
                file name and an optional comment.  Please note that the
                -g and the comment must be enclosed in quotes if there is
                more than one word in the comment.

                EXAMPLE: -g             print a gaudy banner at the top of
                                        each page.
                         "-gMy file"    print the gaudy banner but add a
                                        comment inside the banner.

*       -g-     Disable the gaudy banner.

        -h<t|b>[n]
                Specify the paper tray (Hopper) to start with where t = Top
                and b = Bottom.  This may be followed by an optional number
                which specifies the number of pages to print from this tray
                before switching to the other.

                EXAMPLE: -ht1   print the first page from the top paper
                                tray, then switch to the bottom one.

*       -h-     Do NOT specify any trays - use the printers default.

        -i[f|o] Inverse page order (ie. Output the last page first).

                "-i" uses the default mode and is the fastest.  The pages
                will be sorted in memory if there is sufficient memory
                to do so.  If there is insufficient memory then the "-if"
                mode is automatically selected.

                "-if" is the default temporary file method and is the new
                "fast" mode which, although slower than memory sorting, is
                far more efficient than the old temporary file sorting
                method, especially with large files.

                "-io" may be specified if either of the above arguments are
                giving you trouble - this mode requires no additional
                memory but is verrrrrry slooooooow.

*       -i-     Normal page order.

        -k<text>
                Print "text" (K)omment in grey on the background of each
                page where "text" may be up to 40 characters.

*       -k-     Disable background printing including any previously
                specified "-dr" argument.

        -m      Enable manual paper feed - useful if you wish to use
                different paper than that loaded into the paper tray(s).

        -m1     Enable manual paper feed on the first page printed only -
                useful if the first page needs to be printed on letter head
                and you are not fortunate enough to have two paper trays.

*       -m-     Disable all manual paper feeding.

        -n<n>   Set lines per page to "n" lines.

                EXAMPLE: -n66   set the pages to 66 lines.

        -n-     Set lines per page to the default which is to print
                whatever will fit on the page or until Form Feed characters
                are encountered.

        -o<path>
                Output postscript to <path> instead of the default LPT2
                where <path> may be a filename (Eg. c:\doc\example.ps) or
                the name of another device (Eg. LPT1 or COM1).

                EXAMPLE: -oC:\TEMP\EXAMPLE.PS   output the POSTSCRIPT to
                                                the specified file.

                ĴPLEASE NOTEĿ
                If PCPS detects that its output is being piped to another  
                program it will automatically send the postscript to stdout
                and totally ignore any output file specified with this     
                argument.  In this mode, PCPS sends the screen information 
                to stderr.                                                 
                

*       -o-     Use the default output file LPT2.

        -p<dir path>
                Get printer preparation data from the file PCPS.PPF under
                the directory <dir path>.  The contents of this file are
                sent to the printer prior to any other output from PCPS.
                See SUPPORT FILES.

                EXAMPLE: -pC:\UTILS     Use the file PCPS.PPF under the
                                        directory C:\UTILS

        -p-     Do not use any printer preparation file.

        -q      Quiet mode - no fancy information is displayed.  For each
                file processed, only the number of pages printed is
                displayed.

*       -q-     Noisy :-) mode with lots of information displayed.

        -r      Rotate the print 90 degrees to Landscape orientation.

*       -r-     Use portrait orientation.

        -2      Rotate to Landscape orientation and print in 2 columns.
                This allows two normal pages to fit on one.

*       -2-     Use single column Portrait orientation.

        -s<a|u> Use paper size where a = A4 and u = US letter.

                EXAMPLE: -su    set the paper size to US letter (11" x 8.5")

*       -s-     Use default paper size (A4).

        -t[n]   Expand tab characters to spaces.  If "n" is specified, tabs
                will be expanded to "n" spaces, otherwise they will be
                expanded to 8 spaces.

                EXAMPLE: -t     expand all tab characters to 8 spaces.
                         -t4    expand all tab characters to 4 spaces.

*       -t-     Do NOT expand tab characters; pass them through untouched.

        -u[n]   Unlimited line length (well almost...65535 chars).  If "n"
                is specified, set line length to "n" characters.  Normally
                PCPS calculates the maximum line length using the font size
                and the available printing area but this calculation is
                made assuming the non-proportional default IBMPCFont font and
                is not necessarily accurate for other fonts other than
                Courier.  This argument allows the user to over-ride the
                calculated maximum.

                EXAMPLE: -u     set maximum char per line to 65,535
                         -u60   set maximum char per line to 60

*       -u-     Use the default calculated maximum line length.

        -v<n[-|,|$>
                Specify page ranges to print where a range may be a single
                page (n), a range of pages (n1-n2) or from a page to the
                end of the document (n-$).  Each separate range
                specification should be separated by a comma.

                EXAMPLE: -v1-12,35,50-$ print pages 1 through 12, 35 and 50
                                        through to the end of the document.

*       -v-     Print all pages.

        -x      The first and last characters output by PCPS will be ^D
                (0x04) characters.  This is required by some printers to
                signify end of job.

*       -x-     Do not output ^D (0x04) characters.

        -z<o|e> Enable margin swapping for double sided printing on (O)dd
                or (E)ven pages.

                In Portrait mode the Left and Right margins will be swapped
                on the specified pages as well as the Page-number and File-
                -time boxes in the Gaudy header if gaudy mode is enabled.

                In Landscape mode the Top and Bottom margins are swapped on
                the specified pages.  No change is performed on the Gaudy
                banner.

*       -z-     Disable margin swapping.


        All arguments preceded by * reflect the default conditions for PCPS.

        Normal DOS style wildcards (* and ?) are allowed when specifying
        the input files.

ENVIRONMENT
        PCPSCFG
                Points to a directory containing a PCPS configuration file
                (See SUPPORT FILES).

        PCPSPPF
                Points to a directory containing a PCPS printer prep file
                (See SUPPORT FILES).


SUPPORT FILES
        PCPS can have two support files:  PCPS.CFG and PCPS.PPF
        The Printer Preparation file (PPF) may be explicitly specified by
        the -p argument or explicitly disabled by -p- but if not, the method
        for locating both files is identical:

        The current directory is first searched for the file and if it is not
        found there, the directory that PCPS.EXE was executed from is then
        searched.  If this also fails, PCPS checks the environment for a
        variable PCPS<ext> where <ext> is either CFG or PPF and checks for
        the existance of the file in the directory pointed to by this
        variable.

        PCPS.CFG
                This file can contain arguments in the same way that the
                command line can have arguments.  The arguments may be
                spread over several lines and will be processed
                sequentially.

                PCPS processes arguments from this file first, should it
                exist, and then from the command line, so the command line
                arguments may over-ride the arguments in this file or even
                negate them.

        PCPS.PPF
                Some POSTSCRIPT printers require some setup or preparation
                information sent to them before the output of PCPS.  This
                support file is provided for such purposes.

                Any characters contained in this file will sent to the
                output file before any POSTSCRIPT output from PCPS.


SCREEN SUPPORT
        PCPS can support differing numbers of lines per screen and provides
        a "more" feature when listing font codes or showing usage.  At the
        [more] prompt you may view the next screen by pressing any key
        other than the "q" key which will quit the output.

SUPPORTED FONTS
        PCPS currently supports the default fonts built into an Apple
        Laserwriter and assumes that the target printer will "know" these
        fonts.  PCPS additionally supports its own font named IBMPCFont.
        Listed below are the fonts and the code for each that may be used
        with the -f argument:

               ͻ
               FontCode  Font                           
               ͹
               AGB       AvantGarde-Book                
               AGBO      AvantGarde-BookOblique         
               AGD       AvanteGarde-Demi               
               AGDO      AvantGarde-DemiOblique         
               BD        Bookman-Demi                   
               BDI       Bookman-DemiItalic             
               BL        Bookman-Light                  
               BLI       Bookman-LightItalic            
               C         Courier                        
               CB        Courier-Bold                   
               CBO       Courier-BoldOblique            
               CO        Courier-Oblique                
               H         Helvetica                      
               HB        Helvetica-Bold                 
               HBO       Helvetica-BoldOblique          
               HN        Helvetica-Narrow               
               HNB       Helvetica-Narrow-Bold          
               HNBO      Helvetica-Narrow-BoldOblique   
               HNO       Helvetica-Narrow-Oblique       
               HO        Helvetica-Oblique              
               IBM       IBMPCFont (default)
               NCSB      NewCenturySchlbk-Bold          
               NCSBI     NewCenturySchlbk-BoldItalic    
               NCSI      NewCenturySchlbk-Italic        
               NCSR      NewCenturySchlbk-Roman         
               PB        Palatino-Bold                  
               PBI       Palatino-BoldItalic            
               PI        Palatino-Italic                
               PR        Palatino-Roman                 
               S         Symbol                         
               TB        Times-Bold                     
               TBI       Times-BoldItalic               
               TI        Times-Italic                   
               TR        Times-Roman                    
               ZCMI      ZapfChancery-MediumItalic      
               ZD        ZapfDingbats                   
               ͼ

        PCPS now supports most european characters in all text fonts and
        the full IBM/PC character set with its own default font IBMPCFont.

REQUIREMENTS
        DOS ONLY VERSION
                MS/PC DOS V2.1 is the minimum required version, though for
                full compatibility, DOS3.0 or greater is recommended.

        FAMILY MODE VERSION
                For running under DOS, the above requirements are true.
                For running under OS2 the user should require OS2 1.0 or
                higher though the author has only run it under OS2 2.0 and
                2.1beta and would appreciate confirmation that it runs
                under any other version.

DIAGNOSTICS
        These should be fairly self-explanatory.

AUTHOR
        Paul Carapetis
        Internet: pjc@melb.bull.oz.au

BUGS
        Far too many argument letters which are far from intuitive.  The
        author proposes to change the arguments to short words (Eg. -out,
        -tab etc.) where the user may specify the full word or enough
        letters to render it unique.  The author is interested in the
        user's opinions on this and any other matters relating to PCPS so
        feel free to contact him.

        Hopefully there are no others but sometimes they manage to sneak
        their ugly little heads through so the author would be extremely
        grateful to hear from anyone encountering any of these little
        beasties!

NOTES
        POSTSCRIPT is a trademark of Adobe Systems Incorporated.

