/* Copyright (c) xTech 1991-1993 */

#ifndef X2C_H_
#define X2C_H_

/* ----------------------- Check configuration ------------------------ */
/*                         -------------------                          */

#if defined(__EMX__) && !defined(__GNUC__)
#define __GNUC__
#endif

#if defined(__GNUC__) && !defined(X2C_values)
#define X2C_values
#endif

/* ------------------- Include standard libraries --------------------- */
/*                     --------------------------                       */

#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#ifndef X2C_values
#include <float.h>
#else
#include <values.h>
#ifndef FLT_MAX
#define FLT_MAX MAXFLOAT
#endif
#ifndef DBL_MAX
#define DBL_MAX MAXDOUBLE
#endif
#endif

/* ------------------------- Basic types ----------------------- */
/*                           -----------                         */

#define X2C_INT8 signed char
#define X2C_CARD8 unsigned char
#define X2C_INT16 short
#define X2C_CARD16 unsigned short
#define X2C_INT32 long
#define X2C_CARD32 unsigned long

#define X2C_INDEX unsigned
#define X2C_REAL float
#define X2C_LONGREAL double
#define X2C_CHAR char
#define X2C_BOOLEAN unsigned char
#define X2C_BITSET unsigned long
#define X2C_WORD unsigned long
#define X2C_BYTE unsigned char
typedef void *X2C_ADDRESS;
typedef void (*X2C_PROC) (void);

/* --------------------- MIN(type) and MAX(type) --------------------- */
/*                       -----------------------                       */

/* AC: some compilers feel lucky if ((void *)0), but ANSI said 0 is better */
#define NIL 0

/* AC: OK for Alpha as well */
#define X2C_max_longint 0x7FFFFFFFL
#define X2C_min_longint (-0x80000000L)
#define X2C_max_integer 0x7FFFL
#define X2C_min_integer (-0x8000L)
#define X2C_max_longcard 0xFFFFFFFFUL
#define X2C_max_cardinal 0xFFFFUL
#define X2C_max_real ((X2C_REAL)FLT_MAX)
#define X2C_min_real ((X2C_REAL)-FLT_MAX)
#define X2C_max_longreal ((X2C_LONGREAL)DBL_MAX)
#define X2C_min_longreal ((X2C_LONGREAL)-DBL_MAX)

/* ------------------------- TRAP codes --------------------------- */
/*                           ----------                             */

#define X2C_INDEX_TRAP          1
#define X2C_RETURN_TRAP         2
#define X2C_CASE_TRAP           3
#define X2C_ASSERT_TRAP         4
#define X2C_NO_MEMORY_TRAP      5
#define X2C_GUARD_TRAP          6
#define X2C_RANGE_TRAP          7
#define X2C_NIL_TRAP            8
#define X2C_DIV_0_TRAP          9
#define X2C_DIV_N_TRAP		10
#define X2C_NOT_IMP_TRAP        11
#define X2C_FATAL_ERROR         35

/* --------------------------- Arguments ------------------------- */
/*                             ---------                           */

extern int    X2C_argc;
extern char **X2C_argv;

/* ------------------------- Miscellaneous ----------------------- */
/*                           -------------                         */

#define X2C_ODD(x)    ((x)&1)
extern X2C_CHAR X2C_CAP(X2C_CHAR x);
extern void X2C_strUPR(X2C_CHAR *s);
extern int X2C_STRCMP (X2C_CHAR *a, X2C_INDEX alen, X2C_CHAR *b, X2C_INDEX blen);
extern void X2C_BEGIN (int argc, char **argv);

/* --------------------------- CHECKs ---------------------------- */
/*                             ------                              */

extern X2C_INDEX X2C_CHKINX (X2C_CARD32 i, X2C_INDEX len);

extern X2C_INT32 X2C_CHKS(X2C_INT32 i);
/* IF i<0 THEN trap() END */

extern X2C_INT16 X2C_CHK (X2C_INT16 a, X2C_INT16 min, X2C_INT16 max);
extern X2C_INT32 X2C_CHKL(X2C_INT32 a, X2C_INT32 min, X2C_INT32 max);
/* IF (a<min) OR (a>max) THEN trap() END; RETURN a */

extern X2C_CARD16 X2C_CHKU (X2C_CARD16 a, X2C_CARD16 min, X2C_CARD16 max);
extern X2C_CARD32 X2C_CHKUL(X2C_CARD32 a, X2C_CARD32 min, X2C_CARD32 max);
/* IF (a<min) OR (a>max) THEN trap() END; RETURN a */

#define X2C_CHKNIL(_T_,_p_)         ( (_T_) X2C_CHKPTR((void *) _p_) )

extern void *X2C_CHKPTR(void *p);

/* ---------------------------- SYSTEM -------------------------- */
/*                              ------                            */

extern X2C_BOOLEAN X2C_BIT(X2C_ADDRESS a, X2C_CARD32 n);
extern X2C_INT32  X2C_ASH (X2C_INT32  a,X2C_INT32 b);
extern X2C_CARD16 X2C_ROT (X2C_CARD16 a,X2C_INT32 n);
extern X2C_CARD8  X2C_ROTB(X2C_CARD8  a,X2C_INT32 n);
extern X2C_CARD32 X2C_ROTL(X2C_CARD32 a,X2C_INT32 n);
extern X2C_CARD16 X2C_LSH (X2C_CARD16 a,X2C_INT32 n);
extern X2C_CARD8  X2C_LSHB(X2C_CARD8  a,X2C_INT32 n);
extern X2C_CARD32 X2C_LSHL(X2C_CARD32 a,X2C_INT32 n);

extern X2C_ADDRESS  X2C_ADDADR(X2C_ADDRESS a,X2C_INDEX n);
extern X2C_ADDRESS  X2C_SUBADR(X2C_ADDRESS a,X2C_INDEX n);
extern int      X2C_DIFADR(X2C_ADDRESS a,X2C_ADDRESS b);

/* ---------------------- Qoutient and modulo --------------------- */
/*                        -------------------                       */

#define X2C_REM(a,b) ((a)%(b))
#define X2C_QUO(a,b) ((a)/(b))
extern X2C_INT32 X2C_MOD (X2C_INT32 a, X2C_INT32 b);
extern X2C_INT32 X2C_DIV (X2C_INT32 a, X2C_INT32 b);

/* ----------------------------- TRAPs -------------------------- */
/*                               -----                            */

extern void X2C_FTRAP(X2C_INT16 trap_no, X2C_INT32 text_pos, char *module_name);
extern void X2C_TRAP (X2C_INT16 trap_no);
extern void X2C_HALT (X2C_INT16 x);

/* --------------------- SETs and LONGSETs --------------------- */
/*                       -----------------                       */

extern X2C_BOOLEAN X2C_IN (X2C_INT16 i,X2C_INT16 bits,X2C_BITSET set);
/* i IN set */

extern X2C_BITSET X2C_SET(X2C_INT32 a,X2C_INT32 b,X2C_INT16 bits);
/* RETURN {a..b} */

extern X2C_BOOLEAN X2C_INLONGSET(X2C_INT32 i,X2C_INT16 bits, X2C_BITSET *set);
/* (i MOD set_size) IN set[i DIV set_size] */

extern void X2C_INCL(X2C_BITSET *set, X2C_INT32 i, X2C_INT16 bits);
extern void X2C_EXCL(X2C_BITSET *set, X2C_INT32 i, X2C_INT16 bits);

extern X2C_BOOLEAN X2C_SET_EQU(X2C_BITSET *a, X2C_BITSET *b, X2C_INT16 bits);
extern X2C_BOOLEAN X2C_SET_LEQ(X2C_BITSET *a, X2C_BITSET *b, X2C_INT16 bits);

extern void X2C_LONGSET(X2C_BITSET *set, X2C_INT32 a,X2C_INT32 b,X2C_INT16 bits);
/* set:=set+{a..b} */

extern X2C_BITSET * X2C_AND(X2C_BITSET *res, X2C_BITSET *a, X2C_BITSET *b, X2C_INT16 len);
/* FOR i:=0 TO len-1 DO res[i] := a[i]*b[i] END */

extern X2C_BITSET * X2C_OR (X2C_BITSET *res, X2C_BITSET *a, X2C_BITSET *b, X2C_INT16 len);
/* FOR i:=0 TO len-1 DO res[i] := a[i]+b[i] END */

extern X2C_BITSET * X2C_XOR(X2C_BITSET *res, X2C_BITSET *a, X2C_BITSET *b, X2C_INT16 len);
/* FOR i:=0 TO len-1 DO res[i] := a[i]/b[i] END */

extern X2C_BITSET * X2C_BIC(X2C_BITSET *res, X2C_BITSET *a, X2C_BITSET *b, X2C_INT16 len);
/* FOR i:=0 TO len-1 DO res[i] := a[i]-b[i] END */

extern X2C_BITSET * X2C_COMPLEMENT(X2C_BITSET *res, X2C_BITSET *a, X2C_INT16 len);
/* FOR i:=0 TO len-1 DO res[i] := -a[i] END */

/* ------------------------ TRUNC & ENTIER ----------------------- */
/*                          --------------                         */

extern X2C_INT32  X2C_ENTIER(X2C_LONGREAL x);

extern X2C_INT32  X2C_TRUNCI(X2C_LONGREAL x,X2C_INT32  min,X2C_INT32  max);
extern X2C_CARD32 X2C_TRUNCC(X2C_LONGREAL x,X2C_CARD32 min,X2C_CARD32 max);

/* ---------------------------- SHORT ----------------------------- */
/*                              -----                               */

extern X2C_INT8  X2C_VAL_INT8 (X2C_INT16 x);
extern X2C_CARD8 X2C_VAL_CARD8(X2C_CARD16 x);
extern X2C_REAL  X2C_VAL_REAL (X2C_LONGREAL x);

extern X2C_INT16   X2C_VAL_INT16(X2C_INT32 x);
extern X2C_CARD16  X2C_VAL_CARD16(X2C_CARD32 x);

/* ----------------------------- ABS ------------------------------ */
/*                               ---                                */

#define X2C_ABS_INT8(x) ((X2C_INT8) abs(x))
#define X2C_ABS_INT16(x) ((X2C_INT16)abs(x))
#if defined(X2C_index16) && !defined(X2C_nolabs)
#define X2C_ABS_INT32(x) labs(x)
#else
#define X2C_ABS_INT32(x) abs(x)
#endif

extern double fabs (double x);
#define X2C_ABS_LONGREAL(x) fabs(x)
#define X2C_ABS_REAL(x) ((X2C_REAL)fabs(x))

/* ---------------------------- COPY & LENGTH -------------------------- */
/*                              -------------                            */

extern void X2C_COPY(X2C_CHAR *s,X2C_INDEX s_len,X2C_CHAR *d,X2C_INDEX d_len);
extern X2C_INDEX X2C_LENGTH(X2C_CHAR *s,X2C_INDEX s_len);

/* ---------------------- Copy ARRAY OF parameters --------------------- */
/*                        ------------------------                       */

extern void X2C_PCOPY(X2C_ADDRESS *p,X2C_INDEX size);
extern void X2C_PFREE(X2C_ADDRESS  p,X2C_INDEX size);

/* ------------------------------- MEMORY ------------------------------ */
/*                                 ------                                */

extern void X2C_ALLOCATE  (X2C_ADDRESS *a,X2C_INDEX size);
extern void X2C_DEALLOCATE(X2C_ADDRESS *a,X2C_INDEX size);

extern void X2C_DYNALLOCATE
  (X2C_ADDRESS *a, X2C_INDEX size, X2C_CARD32 *lens, X2C_INDEX dim);
extern void X2C_DYNDEALLOCATE(X2C_ADDRESS *a,X2C_INDEX size,X2C_INDEX dim);

/* -------------------------- OBERON support ------------------------ */
/*                            --------------                          */

#define X2C_EXT 25

typedef struct X2C_TD_STR *X2C_TD;
typedef struct X2C_TD_STR
{
  X2C_INDEX size;
  X2C_TD base[X2C_EXT];
  X2C_INDEX  procno;
}
X2C_TD_REC;

typedef struct
{
  X2C_INDEX  size;
  X2C_TD base[X2C_EXT];
  X2C_INDEX  procno;
  void  *proc[256];
}
*X2C_TDM;

#define X2C_CALL(MT,TD,N) (*((MT)((X2C_TDM)(TD))->proc[N]))

/* ------------------------- Type guards ----------------------- */
/*                           -----------                         */

extern void  X2C_GUARD0(X2C_BOOLEAN b);
extern void *X2C_GUARD (void *p,int ofs,int n,X2C_TD td);
extern void *X2C_VGUARD(void *p,int ofs,int n,X2C_TD td);
extern void *X2C_EGUARD(void *p,int ofs,X2C_TD td);

extern void *X2C_SET_TD(void *p,int ofs,X2C_TD td);

extern void X2C_RECCPY(void *d,void *s,int ofs,int size);
/* Oberon record copy */

extern X2C_TD X2C_INIT(X2C_INDEX size,X2C_TD base,X2C_INT16 procno);
/* initialization of type descriptor */

#define X2C_METHOD(T,N,P) ((X2C_TDM)(T))->proc[N] = (void *)(P)

/* -------------------------- OBERON NEW ----------------------- */
/*                            ----------                         */

extern void X2C_NEW_REC (X2C_TD td, X2C_ADDRESS *a, X2C_INDEX ofs);
extern void X2C_NEW_ARR (X2C_TD td, X2C_ADDRESS *a, X2C_INDEX size);
extern void X2C_NEW_OPEN(X2C_TD td, X2C_ADDRESS *a, X2C_INDEX size,
                                X2C_CARD32 *lens, X2C_INDEX dim);

#endif

