/* Copyright (c) xTech 1991,1993 */
/* "@(#)X2C.c 1.30.6 X2C" */

#include "X2C.h"

#include <stdio.h>

/*#define X2C_CHECK_ALLOC*/ /* HALT if no enough memory */

#ifdef __ZTC__
extern long _stack = 0; /* AC: disable some bloody Zortech C/C++ features */
#endif

/* ---------------- memory allocation library ---------------- */
/*                  -------------------------                  */

void X2C_ALLOCATE (X2C_ADDRESS * a, X2C_INDEX size)
{
#ifndef X2C_CHECK_ALLOC
  *a = (X2C_ADDRESS) malloc ((int)size);
#else
  if ((*a = (X2C_ADDRESS) malloc ((int)size)) == 0) X2C_TRAP (X2C_NO_MEMORY_TRAP);
#endif
}

void X2C_DEALLOCATE (X2C_ADDRESS * a, X2C_INDEX size)
{
  free ((void *)(*a));
  *a = 0;
}

/* -------------- value array parameter copy and free --------------- */
/*                -----------------------------------                 */

void X2C_PCOPY (X2C_ADDRESS * p, X2C_INDEX size)
{
  void *a;
  if ((a = malloc ((int)size)) == 0) X2C_TRAP (X2C_NO_MEMORY_TRAP);
  memcpy (a, (void *)*p, size);
  *p = (X2C_ADDRESS)a;
}

void X2C_PFREE (X2C_ADDRESS p, X2C_INDEX size)
{
  free ((void *)p);
}

/* ------------------ string COPY & LENGTH ------------------- */
/*                    --------------------                     */

void X2C_COPY (X2C_CHAR * s, X2C_INDEX s_len, X2C_CHAR * d, X2C_INDEX d_len)
{
  X2C_INDEX i;
  if (s_len >= d_len) s_len = d_len;
  for (i = 0; i < s_len && (d[i] = s[i]) != 0; ++i);
  if (i < d_len) d[i] = 0;
}

X2C_INDEX X2C_LENGTH (X2C_CHAR * s, X2C_INDEX s_len)
{
  X2C_INDEX i;
  for (i = 0; i < s_len && s[i] != 0; ++i);
  return (i);
}

/* ----------------- Oberon specific procedures ----------------- */
/*                   --------------------------                   */

typedef struct
{
  X2C_TD TYPE;
} *PTR;

void X2C_GUARD0 (X2C_BOOLEAN b)
{
  if (b) X2C_TRAP (X2C_GUARD_TRAP);
}

void *X2C_GUARD (void *p, int ofs, int n, X2C_TD td)
{
  if (p == NULL) X2C_TRAP (X2C_NIL_TRAP);
  if (((PTR)((char *) p + ofs))->TYPE->base[n] != td)
    X2C_TRAP (X2C_GUARD_TRAP);
  return (p);
}

void *X2C_VGUARD (void *p, int ofs, int n, X2C_TD td)
{
  char *s;
  if ((s = *(char **)p) == NULL) X2C_TRAP (X2C_NIL_TRAP);
  if (((PTR) (s + ofs))->TYPE->base[n] != td) X2C_TRAP (X2C_GUARD_TRAP);
  return (p);
}

void *X2C_EGUARD (void *p, int ofs, X2C_TD td)
{
  if (p == NULL) X2C_TRAP (X2C_NIL_TRAP);
  if (((PTR) (((char *) p) + ofs))->TYPE != td) X2C_TRAP (X2C_GUARD_TRAP);
  return p;
}

void X2C_RECCPY (void *d, void *s, int ofs, int size)
{
  X2C_TD *x = &((PTR)((char *) d + ofs))->TYPE;
  X2C_TD td = *x; memcpy (d, s, size); *x = td;
}

void *X2C_SET_TD (void *p, int ofs, X2C_TD td)
{
  ((PTR) (((char *) p) + ofs))->TYPE = td;
  return (p);
}

X2C_TD X2C_INIT (X2C_INDEX size, X2C_TD td, X2C_INT16 procno)
{
  X2C_TD x;
  int i = sizeof (*x) + sizeof (void *) * procno;
  if ((x = (X2C_ADDRESS) malloc ((int)i)) == 0) X2C_TRAP (X2C_NO_MEMORY_TRAP);
  memset ((void *)x, 0, i);
  if (td != 0)
  {
    memcpy (x, td, sizeof (*td) + sizeof (void *) * td->procno);
    for (i = 0; i < X2C_EXT && x->base[i] != NIL; ++i);
    x->base[i] = x;
  }
  x->size = size; x->procno = procno;
  return (x);
}

/* -------------------- NEW for Oberon -------------------- */
/*                      --------------                      */

void X2C_NEW_REC (X2C_TD td, X2C_ADDRESS * p, X2C_INDEX ofs)
{
  void *a;
  if ((a = (X2C_ADDRESS) malloc (td->size)) == 0) X2C_TRAP (X2C_NO_MEMORY_TRAP);
  memset (*p = a, 0, td->size);
  ((PTR) ((char *)a + ofs))->TYPE = td;
}

void X2C_NEW_ARR (X2C_TD td, X2C_ADDRESS * p, X2C_INDEX size)
{
  if ((*p = (X2C_ADDRESS) malloc (td->size)) == 0) X2C_TRAP (X2C_NO_MEMORY_TRAP);
}

/* ------------------ dynamic arrays support ------------------ */
/*                    ----------------------                    */

typedef struct {
  void *a;
  X2C_INDEX n[1];
} X2C_D;

static X2C_ADDRESS *dyn_alloc(X2C_INDEX size, X2C_INDEX dim, X2C_CARD32 *lens)
{
  int i;
  X2C_CARD32 n;
  X2C_D *d;

  if ((d = (X2C_D *) malloc (sizeof (*d) + 2*sizeof (d->n) * (dim-1))) == 0)
    return (0);

  n = size;
  for (i = 1; i < dim; ++i) d->n[i*2-1] = (X2C_INDEX)(n *= lens[dim-i]);
  for (i = 0; i < dim; ++i) d->n[i*2] = (X2C_INDEX) lens[i];
  n *= lens[0];

  if (n >= 0x8000UL) X2C_TRAP (X2C_RANGE_TRAP);

  if ((d->a = malloc ((int)n)) == 0) return (0);
  memset (d->a, 0, (int)n);

  return ((X2C_ADDRESS)d);
}

void X2C_DYNDEALLOCATE(X2C_ADDRESS *a, X2C_INDEX size, X2C_INDEX dim)
{
  X2C_D *d = (X2C_D *) *a;
  free ((void *)(d->a));
  free ((void *)d);
  *a = 0;
}

void X2C_DYNALLOCATE (X2C_ADDRESS * a, X2C_INDEX size, X2C_CARD32 * lens, X2C_INDEX dim)
{
  *a = dyn_alloc (size, dim, lens);
#ifdef X2C_CHECK_ALLOC
  if (*a == 0) X2C_TRAP (X2C_NO_MEMORY_TRAP);
#endif
}

void X2C_NEW_OPEN (X2C_TD td, X2C_ADDRESS * a, X2C_INDEX size,
                   X2C_CARD32 * lens, X2C_INDEX dim)
{
  *a = dyn_alloc (size, dim, lens);
  if (*a == 0) X2C_TRAP (X2C_NO_MEMORY_TRAP);
}

/* ------------------ convert to upper case ------------------- */
/*                    ---------------------                     */

X2C_CHAR X2C_CAP (X2C_CHAR x)
{
  if ((x >= 'a') && (x <= 'z')) x += 'A' - 'a';
  return (x);
}

void X2C_strUPR (X2C_CHAR * s)
{
  while (*s)
  {
    *s = X2C_CAP (*s);
    ++s;
  }
}

int X2C_STRCMP (X2C_CHAR *a, X2C_INDEX alen, X2C_CHAR *b, X2C_INDEX blen)
{
  X2C_INDEX i, m;
  i = 0; m = alen; if (m > blen) m = blen;
  for (;;)
  {
    if (a[i] != b[i] || a[i] == 0)
      return ((unsigned)a[i] - (unsigned)b[i]);
    if (++i > m)
    {
      if (alen != blen)
        if (alen > blen) return ((unsigned)a[i]);
        else return ((unsigned)b[i]);
      return (0);
    }
  }
}

/* ----------------- run-time checks and casts ----------------- */
/*                   -------------------------                   */

/* AC: please notice we operate in unsigned arithmetics therefore */
/* you can eliminate i<0 check... */

X2C_INDEX X2C_CHKINX (X2C_CARD32 i, X2C_INDEX len)
{
  if (i >= (X2C_CARD32)len) X2C_TRAP (X2C_INDEX_TRAP);
  return (X2C_INDEX)i;
}

X2C_INT32 X2C_CHKS (X2C_INT32 i)
{
  if (i < 0) X2C_TRAP (X2C_INDEX_TRAP); return (X2C_INDEX) i;
}

X2C_INT32 X2C_CHKL (X2C_INT32 a, X2C_INT32 min, X2C_INT32 max)
{
  if ((a < min) || (a > max)) X2C_TRAP (X2C_RANGE_TRAP); return (a);
}

X2C_INT16 X2C_CHK (X2C_INT16 a, X2C_INT16 min, X2C_INT16 max)
{
  if ((a < min) || (a > max)) X2C_TRAP (X2C_RANGE_TRAP); return (a);
}

X2C_CARD16 X2C_CHKU (X2C_CARD16 a, X2C_CARD16 min, X2C_CARD16 max)
{
  if ((a < min) || (a > max)) X2C_TRAP (X2C_RANGE_TRAP); return (a);
}

X2C_CARD32 X2C_CHKUL (X2C_CARD32 a, X2C_CARD32 min, X2C_CARD32 max)
{
  if ((a < min) || (a > max)) X2C_TRAP (X2C_RANGE_TRAP); return (a);
}

void *X2C_CHKPTR (void *p)
{
  if (p == NULL) X2C_TRAP (X2C_NIL_TRAP); return p;
}

/* ------------------- SYSTEM module implementation ------------------- */
/*                     ----------------------------                     */

X2C_BOOLEAN X2C_BIT (X2C_ADDRESS a, X2C_CARD32 n)
{
  /* AC: how do you like it? - it is real art! */
  return (((((char *)a)[((int)n)>>3])&(1<<(((int)n)&7))) != 0);
}

X2C_INT32 X2C_ASH (X2C_INT32 a, X2C_INT32 b)
{
  if (b >= 0) return (a << b);
  return (a >> (-b));
}

X2C_CARD16 X2C_ROT (X2C_CARD16 a, X2C_INT32 n)
{
  if (n > 0) return ((a << n) | (a >> (sizeof (a) * 8 - n)));
  return ((a >> (-n)) | (a << (sizeof (a) * 8 + n)));
}

X2C_CARD8 X2C_ROTB (X2C_CARD8 a, X2C_INT32 n)
{
  if (n > 0) return ((a << n) | (a >> (sizeof (a) * 8 - n)));
  return ((a >> (-n)) | (a << (sizeof (a) * 8 + n)));
}

X2C_CARD32 X2C_ROTL (X2C_CARD32 a, X2C_INT32 n)
{
  if (n > 0) return ((a << n) | (a >> (sizeof (a) * 8 - n)));
  return ((a >> (-n)) | (a << (sizeof (a) * 8 + n)));
}

X2C_CARD16 X2C_LSH (X2C_CARD16 a, X2C_INT32 n)
{
  if (n > 0) return (a << n);
  return (a >> (-n));
}

X2C_CARD8 X2C_LSHB (X2C_CARD8 a, X2C_INT32 n)
{
  if (n > 0) return (a << n);
  return (a >> (-n));
}

X2C_CARD32 X2C_LSHL (X2C_CARD32 a, X2C_INT32 n)
{
  if (n > 0) return (a << n);
  return (a >> (-n));
}

X2C_ADDRESS X2C_ADDADR (X2C_ADDRESS a, X2C_INDEX n)
{
  return ((char *) a + n);
}

X2C_ADDRESS X2C_SUBADR (X2C_ADDRESS a, X2C_INDEX n)
{
  return ((char *) a - n);
}

int X2C_DIFADR (X2C_ADDRESS a, X2C_ADDRESS b)
{
  return ((int) a - (int) b);
}

/* ----------------- quotinent and modulo ----------------- */
/*                   --------------------                   */

X2C_INT32 X2C_MOD (X2C_INT32 a, X2C_INT32 b)
{
  if (a >= 0) return (a % b);
  if ((a = b - (-a%b)) != b) return (a);
  return (0);
}

X2C_INT32 X2C_DIV (X2C_INT32 a, X2C_INT32 b)
{
  if (a >= 0) return (a/b);
  return -((b-1-a)/b);
}

/* ----------------------- traps ---------------------- */
/*                         -----                        */

void X2C_HALT (X2C_INT16 x)
{
  exit (x);
}

static void message (unsigned no)
{
static char *text[] =
{
  0,
  "invalid index",
  "function/procedure without RETURN statement",
  "invalid case in CASE statement",
  "ASSERT",
  "out of heap space",
  "type guard check",
  "expression out of bounds",
  "NIL reference",
  "division by zero",
  "negative divisor in DIV/MOD",
  "function not implemented"
};
  if (no < sizeof (text) / sizeof (text[0])) printf ("%s", text[no]);
  else printf ("TRAP(%d)", no);
}

void X2C_TRAP (X2C_INT16 no)
{
  if (no == 0) exit (0);
  message (no);
  printf ("\n");
  exit (X2C_FATAL_ERROR);
}

void X2C_FTRAP (X2C_INT16 no, X2C_INT32 pos, char *name)
{
  if (no == 0) exit (0);
  message (no);
  printf (" in module '%s' at line %d, column %d\n",name,
    (int) (pos>>16) + 1, (int) (pos & 0xFFFFUL) + 1);
  exit (X2C_FATAL_ERROR);
}

/* ---------------------- SETs and LONGSETs ----------------------- */
/*                        -----------------                         */

#define SET_SIZE (sizeof (X2C_BITSET) * 8)

X2C_BOOLEAN X2C_IN (X2C_INT16 i, X2C_INT16 bits, X2C_BITSET set)
{
  return ((X2C_CARD16)i >= (X2C_CARD16)bits) ? 0 : ((1L << i) & set) != 0;
}

X2C_BITSET X2C_SET (X2C_INT32 a, X2C_INT32 b, X2C_INT16 bits)
{
  if ((X2C_CARD32)a > (X2C_CARD32)b || b >= bits) return (0);
  return ((X2C_BITSET) ((2L<<(int)b) - (1L<<(int)a)));
/* AC: really it is OK code even with b = 31! */
}

X2C_BOOLEAN X2C_INLONGSET (X2C_INT32 i, X2C_INT16 bits, X2C_BITSET * set)
{
  if ((X2C_CARD16)i >= (X2C_CARD16)bits) return (0);
  return (set[(int)i/SET_SIZE] & (1L << ((int)i%SET_SIZE))) != 0;
}

void X2C_INCL (X2C_BITSET * set, X2C_INT32 i, X2C_INT16 bits)
{
  if ((X2C_CARD32)i >= (X2C_CARD32)bits) X2C_TRAP (X2C_RANGE_TRAP);
  set[(int)i/SET_SIZE] |= 1L << ((int)i%SET_SIZE);
}

void X2C_EXCL (X2C_BITSET * set, X2C_INT32 i, X2C_INT16 bits)
{
  if ((X2C_CARD32)i >= (X2C_CARD32)bits) X2C_TRAP (X2C_RANGE_TRAP);
  set[(int)i/SET_SIZE] &= ~(1L << ((int)i%SET_SIZE));
}

X2C_BOOLEAN X2C_SET_EQU (X2C_BITSET * a, X2C_BITSET * b, X2C_INT16 bits)
{
  X2C_BITSET mask;
  while (bits >= SET_SIZE)
  {
    if (*a++ != *b++) return (0);
    bits -= SET_SIZE;
  }
  if (bits == 0) return (1);
  mask = (2L<<bits) - 1;
  return (*a&mask) == (*b&mask);
}

X2C_BOOLEAN X2C_SET_LEQ (X2C_BITSET * a, X2C_BITSET * b, X2C_INT16 bits)
{
  X2C_BITSET mask;
  while (bits >= SET_SIZE)
  {
    if ((*a++ & ~*b++) != 0) return (0);
    bits -= 32;
  }
  if (bits == 0) return 1;
  mask = (2L << bits) - 1;
  return (((*a&mask) & (~(*b&mask))) != 0);
}

void X2C_LONGSET (X2C_BITSET * set, X2C_INT32 a, X2C_INT32 b, X2C_INT16 bits)
{
  if ((X2C_CARD32)a > (X2C_CARD32)b || b >= bits) X2C_TRAP (X2C_RANGE_TRAP);
  while (a <= b)
  {
    set[(int)a/SET_SIZE] |= 1L << ((int)a%SET_SIZE); ++a;
  }
}

X2C_BITSET *X2C_AND (X2C_BITSET * res, X2C_BITSET * a, X2C_BITSET * b, X2C_INT16 len)
{
  while (--len >= 0) res[len] = a[len] & b[len]; return (res);
}

X2C_BITSET *X2C_OR (X2C_BITSET * res, X2C_BITSET * a, X2C_BITSET * b, X2C_INT16 len)
{
  while (--len >= 0) res[len] = a[len] | b[len]; return (res);
}

X2C_BITSET *X2C_XOR (X2C_BITSET * res, X2C_BITSET * a, X2C_BITSET * b, X2C_INT16 len)
{
  while (--len >= 0) res[len] = a[len] ^ b[len]; return (res);
}

X2C_BITSET *X2C_BIC (X2C_BITSET * res, X2C_BITSET * a, X2C_BITSET * b, X2C_INT16 len)
{
  while (--len >= 0) res[len] = a[len] & (~b[len]); return (res);
}

X2C_BITSET *X2C_COMPLEMENT (X2C_BITSET * res, X2C_BITSET * a, X2C_INT16 len)
{
  while (--len >= 0) res[len] = ~a[len]; return res;
}

/* ---------------------- TRUNC & ENTIER -------------------- */
/*                        --------------                      */

X2C_INT32 X2C_ENTIER (X2C_LONGREAL x)
{
  X2C_INT32 i;
  if (x < (X2C_LONGREAL) X2C_min_longint || x > (X2C_LONGREAL) X2C_max_longint)
    X2C_TRAP (X2C_RANGE_TRAP);
  i = (X2C_INT32) x; if (i > x) --i;
  return (i);
}

X2C_INT32 X2C_TRUNCI (X2C_LONGREAL x, X2C_INT32 min, X2C_INT32 max)
{
  if (x < (X2C_LONGREAL) min || x > (X2C_LONGREAL) max)
    X2C_TRAP (X2C_RANGE_TRAP);
  return ((X2C_INT32) x);
}

X2C_CARD32 X2C_TRUNCC (X2C_LONGREAL x, X2C_CARD32 min, X2C_CARD32 max)
{
  if (x < (X2C_LONGREAL) min || x > (X2C_LONGREAL) max)
    X2C_TRAP (X2C_RANGE_TRAP);
  return ((X2C_CARD32) x);
}

/* -------------------------- SHORT -------------------------- */
/*                            -----                            */

X2C_INT8 X2C_VAL_INT8 (X2C_INT16 x)
{
  if (((X2C_CARD16) x + 0x80) & ~0xff) X2C_TRAP (X2C_RANGE_TRAP);
  return ((X2C_INT8) x);
}

X2C_CARD16 X2C_VAL_CARD16 (X2C_CARD32 x)
{
  if (x & ~0xFFFFUL) X2C_TRAP (X2C_RANGE_TRAP);
  return ((X2C_CARD16) x);
}

X2C_INT16 X2C_VAL_INT16 (X2C_INT32 x)
{
  if (((X2C_CARD32) x + 0x8000UL) & ~0xffffUL) X2C_TRAP (X2C_RANGE_TRAP);
  return ((X2C_INT16) x);
}

X2C_CARD8 X2C_VAL_CARD8 (X2C_CARD16 x)
{
  if (x > 255) X2C_TRAP (X2C_RANGE_TRAP);
  return ((X2C_CARD8) x);
}

X2C_CARD8 X2C_SHORTC (X2C_INT32 x)
{
  if ((X2C_CARD32) x > 255) X2C_TRAP (X2C_RANGE_TRAP);
  return ((X2C_CARD8) x);
}

X2C_REAL X2C_VAL_REAL (X2C_LONGREAL x)
{
  if (x < X2C_min_real || x > X2C_max_real) X2C_TRAP (X2C_RANGE_TRAP);
  return ((X2C_REAL) x);
}

/* --------------------- constants and variables ---------------------- */
/*                       -----------------------                        */

int    X2C_argc = 0;
char **X2C_argv = 0;

void X2C_BEGIN (int argc, char **argv)
{
  X2C_argc = argc;
  X2C_argv = argv;
}