/************************************************************************/
/*					  				*/
/*	File PC-IPC.H			  				*/
/*									*/
/*	Copyright (c) 1989 Donnelly Software Engineering		*/
/*									*/
/*  This file contains the definitions for the default IPC interrupt	*/
/*  vector, return status masks, IPC commands, IPC error codes, the	*/
/*  type definition of IPC_PARAM_BLOCK, and the function prototypes	*/
/*  for the modules in IPCLIB.LIB.					*/
/*							  		*/
/************************************************************************/

#ifndef	PC_IPC_DEF
#define	PC_IPC_DEF	1

#define		IPC_TRUE	1
#define		IPC_FALSE	0
#define		IPC_VECTOR	0x60

/* ipc status flags */
#define		IPC_STAT_ENABLED	2
#define		IPC_STAT_INSTALLED	4
#define		IPC_STAT_ERROR		8
#define		IPC_STAT_AVDATA		16

/* ipc commands */
#define		IPC_CMND_INQUIRE	1
#define		IPC_CMND_ENABLE		2
#define		IPC_CMND_DISABLE	3
#define		IPC_CMND_INSTALL	4
#define		IPC_CMND_RDATA		6
#define		IPC_CMND_SDATA		7
#define		IPC_CMND_REQID		8
#define		IPC_CMND_DELID		9
#define		IPC_CMND_RDATAW		10
#define		IPC_CMND_VERS		11

/* ipc error codes */
#define		IPC_ERR_NOERR		0
#define		IPC_ERR_BADCMND		1
#define		IPC_ERR_INST0		2
#define		IPC_ERR_CANTENAB	3
#define		IPC_ERR_NOTENAB		4
#define		IPC_ERR_CANTDISAB	5
#define		IPC_ERR_BADTOID		6
#define		IPC_ERR_BADFMID		7
#define		IPC_ERR_NOADDR		8
#define		IPC_ERR_MAXIDS		9
#define		IPC_ERR_CANTRELI	10
#define		IPC_ERR_NOMEM		11
#define		IPC_ERR_NOTINST		12

/* parameter block used to interface with IPC */
typedef	struct	ipc_param_block
	{
	unsigned	int	my_id;
	unsigned	int	to_id;
	unsigned	int	command;
	unsigned	int	status;
	unsigned	int	error;
	unsigned	int	size;
	void		far	*data_ptr;
	} IPC_PARAM_BLOCK;

/* procedure declarations */

void far pc_ipc(unsigned int vector,
			IPC_PARAM_BLOCK far *param_ptr);

void far ipc_error(unsigned int index);

void far init_param_block(IPC_PARAM_BLOCK far *param,
			unsigned int my_id,
			unsigned int to_id,
			unsigned int command,
			unsigned int size,
			void far *data_ptr);

int far pc_ipc_installed(unsigned int vector);

void far get_ipc_version(unsigned int vector,
			char far *version);

	/* ipc_getvect() and ipc_print() enable functions within	*/
	/* IPCLIB.LIB to be independant of any run-time library		*/
	/* routines. The are not intended for general use.		*/

void far ipc_getvect(unsigned int vector,
			unsigned long far *int_ptr);

void far ipc_print(char far *data);

#endif
