{
 
                                                                          
         TITLE :      DGPARAM.TPU                                         
       PURPOSE :      Parameter and Command Line handling.                
        AUTHOR :      David Gerrold, CompuServe ID:  70307,544            
  ______________________________________________________________________  
                                                                          
    Written in Turbo Pascal, Version 5.5,                                 
    with routines from TurboPower, Object Professional.                   
                                                                          
    Turbo Pascal is a product of Borland International.                   
    Object Professional is a product of TurboPower Software.              
  ______________________________________________________________________  
                                                                          
    This is not public domain software.                                   
    This software is copyright 1990, by David Gerrold.                    
    Permission is hereby granted for personal use.                        
                                                                          
         The Brass Cannon Corporation                                     
         9420 Reseda Blvd., #804                                          
         Northridge, CA  91324-2932.                                      
                                                                          
 
                                                                            }
{ Compiler Directives ===================================================== }

{$A-}    {Switch word alignment off, necessary for cloning}
{$R-}    {Range checking off}
{$B-}    {Boolean complete evaluation off}
{$S-}    {Stack checking off}
{$I-}    {I/O checking off}
{$N+,E+} {Simulate numeric coprocessor}
{$M 16384,0,327680} {stack and heap}
{$V-}    {Variable range checking off}

{ Name ==================================================================== }

UNIT DgParam;
{
  The purpose of DgParam is to provide routines for parsing and handling
  command line parameters and parameter strings passed to a program.
}

{ Interface =============================================================== }

INTERFACE

USES
{ Object Professional Units }
  OpCrt,
  OpString,

{ Dg Units }
  DgStr;

{ Declarations ============================================================ }
{ Constants --------------------------------------------------------------- }

CONST
  ParamString    : string = '';                  { for stashing parameters }

{ Functions and Procedures ================================================ }

FUNCTION GetSwitchPos (Ch : char;  S : string12) : byte;
{ returns pos of command line switch char in ParamString }

FUNCTION GetCommandLineSwitch (S : string12;  VAR Loop : byte) : boolean;
{
  reads ParamString, looks for switch S;
  returns succeeding string if found, returns '' if not found.
}

{ ========================================================================= }
{ IMPLEMENTATION ========================================================== }

IMPLEMENTATION

{ ========================================================================= }
{ GetSwitchPos ============================================================ }

FUNCTION GetSwitchPos (Ch : char;  S : string12) : byte;
{ returns pos of command line switch char in ParamString }

VAR
  ParamUpStr : string;

BEGIN
  S := StUpCase (S);
  ParamUpStr := StUpCase (ParamString);
  GetSwitchPos := pos (Ch + S, ParamUpStr);
END;

{ GetCommandLineSwitch ==================================================== }

FUNCTION GetCommandLineSwitch (S : string12;  VAR Loop : byte) : boolean;
{
  reads ParamString, looks for switch S;
  returns succeeding string if found, returns '' if not found.
}

BEGIN
  GetCommandLineSwitch := false;
  Loop := GetSwitchPos ('-', S);
  if Loop = 0 then
    Loop := GetSwitchPos ('/', S);
  if Loop > 0 then
    GetCommandLineSwitch := true;
END;

{ ========================================================================= }
{ Initialization ========================================================== }

VAR
  Loop : byte;

BEGIN
  { stuff ParamString }
  For Loop := 1 to ParamCount do
    ParamString := ParamString + trim (ParamStr (Loop)) + ' ';
  ParamString := SpaceFix (ParamString);

{
  There is no way that a program can tell if a user has a color card
  connected to a bw monitor.  To force a bw display, let the user
  call the program with the command line option of '-bw' or '/bw'.
  The program will look through the ParamStrs and set DefColorChoice
  to ForceMono.

  For this to work, however, EVERY color choice called must be mapped
  with OpCrt's ColorMono (color, mono) function.
}
  { look for mono switch }
  If GetCommandLineSwitch ('BW', Loop) then begin
    DefColorChoice := ForceMono;
    TextAttr := MapColor (TextAttr);
    delete (ParamString, Loop, 3);
    end;
END.

{ ========================================================================= }
{ DgParam History ========================================================= }

VERSION HISTORY:
  9005.05
    Totally restructured for consistency with Object Professional.

{ DgParam Needs =========================================================== }

NEED TO ADD:
  Nothing right now.

{ Bug Reports ============================================================= }

BUGS:
  No known bugs.

{ ========================================================================= }
