{
 
                                                                          
         TITLE :      DGBIT.TPU                                           
       PURPOSE :      Bit handing routines.                               
        AUTHOR :      David Gerrold, CompuServe ID:  70307,544            
  ______________________________________________________________________  
                                                                          
    Written in Turbo Pascal, Version 5.5,                                 
    with routines from TurboPower, Object Professional.                   
                                                                          
    Turbo Pascal is a product of Borland International.                   
    Object Professional is a product of TurboPower Software.              
  ______________________________________________________________________  
                                                                          
    This is not public domain software.                                   
    This software is copyright 1990, by David Gerrold.                    
    Permission is hereby granted for personal use.                        
                                                                          
         The Brass Cannon Corporation                                     
         9420 Reseda Blvd., #804                                          
         Northridge, CA  91324-2932.                                      
                                                                          
 
                                                                            }
{ Compiler Directives ===================================================== }

{$A-}    {Switch word alignment off, necessary for cloning}
{$R-}    {Range checking off}
{$B-}    {Boolean complete evaluation off}
{$S-}    {Stack checking off}
{$I-}    {I/O checking off}
{$N+,E+} {Simulate numeric coprocessor}
{$M 16384,0,327680} {stack and heap}
{$V-}    {Variable range checking off}

{ Name ==================================================================== }

UNIT DgBit;
{
  The purpose of DgBit is to provide useful bit-handling routines.
}

{ Interface =============================================================== }

INTERFACE

{ Functions and Procedures ================================================ }

FUNCTION SetBitOff (B : word;  Bit: word) : word;

FUNCTION SetBitOn (B : word;  Bit: word) : word;

FUNCTION ToggleBit (B : word;  Bit : word) : word;
{ Flipflops target bit, leaving other bits unchanged. }

FUNCTION ToggleBitMask (B : word;  BitMask : word) : word;
{ Flipflops target bit value, leaving other bits unchanged. }

FUNCTION AndBit (Source, Target : longint) : boolean;
{ Returns true if Source contains Target. }

{ ========================================================================= }
{ Implementation ========================================================== }

IMPLEMENTATION

{ ========================================================================= }
{ SetBitOff =============================================================== }

FUNCTION SetBitOff (B : word;  Bit: word) : word;
BEGIN
  SetBitOff := B and not (1 shl Bit);
END;

{ SetBitOn ================================================================ }

FUNCTION SetBitOn (B : word;  Bit: word) : word;
BEGIN
  SetBitOn := B or (1 shl Bit);
END;

{ ToggleBit =============================================================== }

FUNCTION ToggleBit (B : word;  Bit : word) : word;
{ Flipflops target bit, leaving other bits unchanged. }

BEGIN
  ToggleBit := ToggleBitMask (B, SetBitOn (0, Bit));
END;

{ ToggleBitMask =========================================================== }

FUNCTION ToggleBitMask (B : word;  BitMask : word) : word;
{ Flipflops target bit value, leaving other bits unchanged. }

BEGIN
  ToggleBitMask := B xor BitMask;
END;

{ AndBit ================================================================== }

FUNCTION AndBit (Source, Target : longint) : boolean;
{ Returns true if Source contains Target. }
BEGIN
  AndBit := Source and Target = Target;
END;

{ ========================================================================= }
{ Initialization ========================================================== }

{ no initialization needed }
END.

{ ========================================================================= }
{ DgMath History ========================================================== }

VERSION HISTORY:
  9005.05
    Totally restructured for consistency with Object Professional.

{ DgMath Needs ============================================================ }

NEED TO ADD:
  Nothing right now.

{ Bug Reports ============================================================= }

BUGS:
  Don't be silly.

{ ========================================================================= }
