/*----------------------------------------------------------------
   METACLIP.C -- Replacement ClientWndProc for METAFILE.C.
                 Demonstrates using the clipboard with metafiles.
                 (Remember to define INCL_WIN in METAFILE.C!)

                 (c) Ziff Communications Co, 1990
                 PC Magazine * Charles Petzold, 6/90
  ----------------------------------------------------------------*/

MRESULT EXPENTRY ClientWndProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
     {
     HMF hmf ;
     HPS hps ;

     switch (msg)
          {
          case WM_CREATE:
               hmf = CreateMetaFile () ;

               WinOpenClipbrd (hab) ;
               WinEmptyClipbrd (hab) ;  
               WinSetClipbrdData (hab, (ULONG) hmf, CF_METAFILE, CFI_HANDLE) ;
               WinCloseClipbrd (hab) ;

               return 0 ;

          case WM_PAINT:
               hps = WinBeginPaint (hwnd, NULL, NULL) ;
               GpiErase (hps) ;

               WinOpenClipbrd (hab) ;
               hmf = (HMF) WinQueryClipbrdData (hab, CF_METAFILE) ;

               if (hmf != NULL)
                    GpiPlayMetaFile (hps, hmf, 0L, NULL, NULL, 0L, NULL) ;

               WinCloseClipbrd (hab) ;

               WinEndPaint (hps) ;
               return 0 ;
          }
     return WinDefWindowProc (hwnd, msg, mp1, mp2) ;
     }
