
program HeapBug;
CONST AllocSize : Word = $8000;
VAR
  P         : ARRAY[0..1] OF Pointer;
  flip      : byte;
  PrevAlloc : Word;
BEGIN
  flip := 0;
  REPEAT
    PrevAlloc := AllocSize;
    WHILE MaxAvail < AllocSize DO
      AllocSize := AllocSize DIV 2;
    GetMem(P[flip], AllocSize);
    Write('Allocated ', AllocSize:6 ,' bytes ');
    Write('to pointer #', flip);
    WriteLn(' -- MaxAvail is ',MaxAvail:8);
    flip := succ(flip) MOD 2;
  UNTIL MaxAvail <= 16;
  Write('Deallocating ', PrevAlloc ,' bytes ');
  WriteLn('from pointer #', flip);
  FreeMem(P[flip], PrevAlloc);
  WriteLn('NO crash -- FreeMin = ',FreeMin);
END.

