
'The ComInput Function

DEFINT A-Z

DECLARE FUNCTION ComInput% (Handle%, TimeOut, Buffer$, Term$, ErrCode%)

OPEN "COM1:1200, N, 8, 1, BIN" FOR RANDOM AS #1         'Open the COM port

Handle = 1                              'Specify the file handle
TimeOut = 5                             'Set time-out to 5 seconds
Buffer$ = SPACE$(256)                   'Make a 256 character buffer
Term$ = CHR$(13) + CHR$(10)             'Specify the line terminator string

DO                                      'Read a line of data
   Pointer = ComInput(Handle, TimeOut, Buffer$, Term$, ErrCode)
   PRINT LEFT$(Buffer$, Pointer);       'Print the part of buffer filled
   IF ErrCode <> 69 THEN PRINT          'If the buffer didn't overflow
                                        '  print a CR,LF
LOOP UNTIL ErrCode = 24                 'Get another line unless we timed out

CLOSE #1                                'Close the port

'***************************************************************************
'Function ComInput
'    Reads characters from a COM port until a terminating string is read
'    or the length of the buffer is exceded or a time-out occurs.  Replaces
'    BASIC's "LINE INPUT #" routine.
'Inputs:
'    Handle   - The file handle used to refer to the COM port
'    TimeOut  - Number of seconds to wait for each character
'    Buffer$  - Padded string which will hold characters read from the port
'    Term$    - String used to detect the end of a line
'Returns:
'    FUNCTION - returns a pointer into the buffer where the line ends
'    ErrCode  - Flags the success or failure of the function
'               0 = No error, 24 = "Device Timeout", 69 = "Buffer Overflow"
'***************************************************************************
'
FUNCTION ComInput (Handle, TimeOut, Buffer$, Term$, ErrCode) STATIC
   
    ErrCode = 0                         'No errors yet
    TermLen = LEN(Term$)                'Save length of terminator string
    BufLen = LEN(Buffer$)               'Save length of buffer
    T& = TIMER + TimeOut                'Set the value for time-out

    FOR Ptr = 1 TO BufLen               'Assume we will fill the whole buffer
       DO UNTIL LOC(Handle)             'Wait for a character to come in port
          IF TIMER > T& THEN            'Have we waited too long?
             ErrCode = 24               'Set BASIC's "Device timeout" error
             EXIT FOR                   'Bail out of loops
          END IF
       LOOP
                                        'Read the character into the buffer
       MID$(Buffer$, Ptr) = INPUT$(1, Handle)
                                        'If looking for a terminating string,
       IF TermLen > 0 AND Ptr >= TermLen THEN
          IF MID$(Buffer$, Ptr - TermLen + 1, TermLen) = Term$ THEN EXIT FOR
       END IF

    NEXT

    IF Ptr > BufLen THEN                'Did we go off the end of the buffer?
       Ptr = Ptr - 1                    'Fix the pointer
       ErrCode = 69                     'Set BASIC's "Com Buffer Overflow"
    ELSE                                '  error
       IF Ptr > TermLen THEN
          Ptr = Ptr - TermLen           'Set pointer to before terminator
       END IF
    END IF

    ComInput = Ptr                      'Assign the function

END FUNCTION


