/*-------------------------------------------------------------------
   TIMELINE.C -- Time and Date Display for OS/2 Presentation Manager
                 (c) 1989, Ziff Communications Co.
                 PC Magazine * Charles Petzold, November 1988
  -------------------------------------------------------------------*/

#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <string.h>
#include <time.h>

#define ID_TIMER 1

MRESULT EXPENTRY ClientWndProc (HWND, USHORT, MPARAM, MPARAM) ;

HAB  hab ;

int main (void)
     {
     static CHAR  szClientClass[] = "TimeLine" ;
     static ULONG flFrameFlags = FCF_BORDER | FCF_TASKLIST ;
     HMQ          hmq ;
     HWND         hwndFrame, hwndClient ;
     QMSG         qmsg ;

     hab = WinInitialize (0) ;
     hmq = WinCreateMsgQueue (hab, 0) ;

     WinRegisterClass (hab, szClientClass, ClientWndProc, 0L, 0) ;

     hwndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
                                     &flFrameFlags, szClientClass, NULL,
				     0L, NULL, 0, &hwndClient) ;

     while (WinGetMsg (hab, &qmsg, NULL, 0, 0))
          WinDispatchMsg (hab, &qmsg) ;

     WinDestroyWindow (hwndFrame) ;
     WinDestroyMsgQueue (hmq) ;
     WinTerminate (hab) ;
     return 0 ;
     }

VOID SizeWindow (HWND hwnd)
     {
     static CHAR szDummyTime[] = " Wed May 00 00:00:00 0000 " ;
     HPS         hps ;
     HWND        hwndFrame ;
     POINTL      aptl[TXTBOX_COUNT] ;
     RECTL       rcl ;

                    // Find width and height of text string

     hps = WinGetPS (hwnd) ;
     GpiQueryTextBox (hps, (LONG) strlen (szDummyTime), szDummyTime,
                           TXTBOX_COUNT, aptl) ;
     WinReleasePS (hps) ;

                    // Set up rectangle structure based on text dimensions

     rcl.xLeft   = 0 ;
     rcl.yBottom = 0 ;
     rcl.xRight  = aptl[TXTBOX_BOTTOMRIGHT].x - aptl[TXTBOX_BOTTOMLEFT].x ;
     rcl.yTop    = aptl[TXTBOX_TOPLEFT].y     - aptl[TXTBOX_BOTTOMLEFT].y ;

                    // Set frame window position and size

     hwndFrame = WinQueryWindow (hwnd, QW_PARENT, FALSE) ;

     WinCalcFrameRect (hwndFrame, &rcl, FALSE) ;
     WinSetWindowPos  (hwndFrame, NULL,
                       (SHORT) rcl.xLeft,  (SHORT) rcl.yBottom,
                       (SHORT) rcl.xRight, (SHORT) rcl.yTop,
                       SWP_MOVE | SWP_SIZE) ;
     }

VOID UpdateTime (HWND hwnd, HPS hps)
     {
     CHAR   *szTime ;
     CHAR   szFormattedTime[40] ;
     RECTL  rcl ;
     time_t lTime ;

                    // Get ASCII time and date string and format it

     time (&lTime) ;
     szTime = ctime (&lTime) ;
     strcpy (szFormattedTime, "   ") ;
     strcat (szFormattedTime, szTime) ;
     szFormattedTime[strlen (szFormattedTime) - 1] = '\0' ;
     strcat (szFormattedTime, "   ") ;

                    // Display string in client window

     WinQueryWindowRect (hwnd, &rcl) ;
     GpiSetBackMix (hps, BM_OVERPAINT) ;
     WinDrawText (hps, -1, szFormattedTime, &rcl,
                  CLR_NEUTRAL, CLR_BACKGROUND, DT_CENTER | DT_VCENTER) ;
     }

MRESULT EXPENTRY ClientWndProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
     {
     HPS hps;

     switch (msg)
          {
          case WM_CREATE:
               SizeWindow (hwnd) ;
               WinStartTimer (hab, hwnd, ID_TIMER, 1000) ;
               return 0 ;

          case WM_TIMER:
               hps = WinGetPS (hwnd) ;

               UpdateTime (hwnd, hps) ;

               WinReleasePS (hps) ;
               return 0 ;

          case WM_PAINT:
               hps = WinBeginPaint (hwnd, NULL, NULL) ;
               GpiErase (hps) ;

               UpdateTime (hwnd, hps) ;

               WinEndPaint (hps) ;
               return 0 ;

          case WM_DESTROY:
               WinStopTimer (hab, hwnd, ID_TIMER) ;
               return 0 ;
          }
     return WinDefWindowProc (hwnd, msg, mp1, mp2) ;
     }
