/* TSO.C: This program is a very simple example of how to log on to
 * a TSO session using the HLLAPI programming interface. This
 * program does no checking for any error conditions which
 * might occur during the signon process. */

/* EXTERNAL DECLARATIONS SECTION */
/* Entry point for the Language Interface Module
   (LIM) where the HLLAPI commands are processed */

externapilim();

/* GLOBAL DATA SECTION */
charbuf[BUFSIZE];
intlen, ps_rc, func;

main() {
    doconps('A');	/* Connect Presentation Space on session 'A' */
    doskey("1 TSOID@E");/* Enter TSO Logon ID */
    dopause(40);	/* Wait for 20 secs for host to BIND session */
    doskey("PASSWORD@E"); /* Enter Password */
    dopause(30);	/* Wait 15 secs for host to display READY prompt */
    doskey("LOGOFF@E");	/* Logoff of TSO Session */
    dopause(30);	/* Wait for 15 secs for host to UNBIND session */
    dodconps();		/* Disconnect Presentation Space */
}

/***Connect Presentation Space  (Function 1)***/
doconps(session)
  charsession;
{
    func = ACONNECT;
    len = 1;
    buf = session;
    buf[len] = '\0';
    invoke();
}

/***Disconnect Presentation Space (Function 2)***/
dodconps() {
    func = ADISCONN;
    invoke();
}

/***Send Key (Function 3)***/doskey(strg)
  char *strg;
{
    len = strlen(strg);
    strcpy(buf, strg);
    buf[len] = '\0';
    func = ASENDKEY;
    invoke();
}

/***Pause (Function 18)***/
dopause(time)
  inttime;
{
    len = time;
    func = APAUSE;
    invoke();
}

/***Invoke:Calls the Language Interface Module (LIM)'s main routine.**/
invoke() {
    return( apilim(&func, buf, &len, &ps_rc) );
}
