'********** READ123.BAS
'Copyright (c) 1988, Ziff Communications Co.
'PC Magazine * Ethan Winer * Martin Valley 
'Reads a file written by Lotus 123

DEFINT A-Z
DECLARE SUB GetFormat (Format, Row, Column)

DIM SHARED FileNum                      'the file number to use
DIM SHARED CellFmt AS STRING * 1        'allows reading one byte

CLS
DO
   INPUT "Enter name of Lotus file to read: ", FileName$
   IF FileName$ = "" THEN FILES "*.WK?"
LOOP UNTIL LEN(FileName$)

FileNum = FREEFILE                      'obtain the next available file handle
OPEN FileName$ FOR BINARY AS #FileNum   'open the file for Binary access

DO UNTIL Opcode = 1                     'until the Lotus "End of File" Opcode

   GET FileNum, , Opcode        'get the next opcode
   GET FileNum, , Length        'and the length of the data that follows

   SELECT CASE Opcode           'handle the data according to its type

      CASE 0                    'Beginning of file record (and version)
	 GET FileNum, , Integ   'Integ holds the version number

	 IF Integ < 1028 OR Integ > 1030 THEN   'test this if you want
	    PRINT "NOT a Lotus File !"
	    END
	 END IF

	 PRINT "BOF:  Lotus ";          'Version number is the only
	 SELECT CASE Integ              '  information in this record
	     CASE 1028
		PRINT "123 version 1.0 or 1A"
	     CASE 1029
		PRINT "Symphony version 1.0"
	     CASE 1030
		PRINT "123 version 2.0, 2.1, or Symphony version 1.1"
	 END SELECT

      CASE 12                   'Blank - NOTE: Lotus saves blank cells only
				'  if they are formatted or protected
	 GetFormat Format, Row, Column
	 PRINT "Blank:  "; Format, "Row ="; Row, "Col ="; Column

      CASE 13                   'Integer
	 GetFormat Format, Row, Column
	 GET FileNum, , Integ
	 PRINT "Integer:"; Format, "Row ="; Row, "Col ="; Column, Integ

      CASE 14                   'Real number (BASIC double precision type)
	 GetFormat Format, Row, Column
	 GET FileNum, , Number#
	 PRINT "Number: "; Format, "Row ="; Row, "Col ="; Column, Number#
     
      CASE 15                   'Label
	 GetFormat Format, Row, Column
	 Info$ = SPACE$(Length - 6)     'create a string to hold the label
					'6 is subtracted to exclude the
					'  Format, Column, Row, and 0 bytes
					'  that were included in the original
					'  length byte (already gotten by the
					'  GetFormat routine)
	 GET FileNum, , Info$           'get the label text
	 GET FileNum, , CellFmt$        'gobble up the trailing CHR$(0) byte
	 PRINT "Label:  "; Format, "Row ="; Row, "Col ="; Column, Info$


      CASE 16                   'Formula
	 GetFormat Format, Row, Column
	 GET FileNum, , Number#         'get the cell's value
	 GET FileNum, , Length          'get length of formula "text"
	 SEEK FileNum, SEEK(FileNum) + Length   'skip over the formula
					'the formula is "tokenized" in reverse
					'Polish notation - not a pretty story
	 PRINT "Formula:"; Format, "Row ="; Row, "Col ="; Column, Number#

      CASE ELSE                 'anything else merely relates to the way the
				'  spreadsheet operates (recalc order, print
				'  ranges, and so forth)
	 Dummy$ = SPACE$(Length)        'skip over the unwanted record
	 GET FileNum, , Dummy$
	 PRINT "Opcode: "; Opcode       'show its Opcode just for fun

   END SELECT

   IF CSRLIN > 21 THEN
      PRINT : PRINT "Press <ESC> to end or any other key for more . . ."
      DO: K$ = INKEY$: LOOP UNTIL LEN(K$)
      IF K$ = CHR$(27) THEN EXIT DO
      CLS
   END IF

   Cntr = Cntr + 1

LOOP

   PRINT "Number of Records Processed ="; Cntr

CLOSE

SUB GetFormat (Format, Row, Column)
     
      GET FileNum, , CellFmt$: Format = ASC(CellFmt$)
      GET FileNum, , Column
      GET FileNum, , Row

END SUB
