{$R+}
PROGRAM Cursor;
VAR
  I, J, X : Integer;
  Equipment_Flag : Integer ABSOLUTE $40:$10;

  PROCEDURE Set_Cursor(Top, Bottom : Byte);
  TYPE
    Registers  = Record
      CASE Integer Of
        1 : ( AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags : Integer );
        2 : ( AL,AH,BL,BH,CL,CH,DL,DH : Byte );
      END;
  VAR
    recpack : Registers;
  BEGIN
    Recpack.AH := 1;
    RecPack.CH := Top;
    RecPack.CL := Bottom;
    Intr($10, recpack);       {call interrupt}
  END;                        { Set_Cursor }

BEGIN
  CASE ParamCount OF
    0 : IF Equipment_Flag AND $30 = $30 THEN { Monochrome board? }
          Set_Cursor(11, 12)
        ELSE
          BEGIN
            WriteLn('Auto-reset is for MONO system only.');
            WriteLn('Use 2 numeric parameters (to set ',
            'cursor top and bottom, e.g. "Cursor 2 10").');
          END;
    2 : BEGIN
          Val(ParamStr(1), I, X);
          IF X <> 0 THEN
            BEGIN
              Write('Parameters must be numeric!  "');
              WriteLn(ParamStr(1),'" is not.');
              Halt;
            END;
          Val(ParamStr(2), J, X);
          IF X <> 0 THEN
            BEGIN
              Write('Parameters must be numeric!  "');
              WriteLn(ParamStr(2),'" is not.');
              Halt;
            END;
          Set_Cursor(I, J);
        END;
  ELSE
    BEGIN
      WriteLn('Call program either with no ',
      'parameters (for reset to MONO startup cursor)');
      WriteLn('or with 2 numeric parameters (to set ',
      'cursor top and bottom, e.g. "Cursor 2 10").');
    END;
  END; {CASE}
END.