;----------------------------------------------------------------------
;  NewNode.ASM -- Node finder for NetWare
;  Syntax: NEWNODE
;  Results:
;  If the NetWare shell is loaded, display the 12 byte station address
;  in hexadecimal and  display the last two bytes in decimal.
;
;  Return <= 255 with physical node address (normally set on the card)
;  Return 1 if NetWare shell is not active or if the logical connection
;  is 0 (means you're running on a Non-Dedicated server)
;----------------------------------------------------------------------
CSEG          Segment
              Assume  CS:CSEG,DS:CSEG
              Org     100h

Entry:		JMP     Begin
		DB      " NewNode (c) 1987 Jeffrey Diehl "
		DB      "Released to the Public Domain"
		DB      "Syntax: NewNode  "
		DB      "Output: Prints the 12-digit Hexadecimal"
		DB      " address of the workstation, then"
		DB      " converts the last two digits to"
		DB      " decimal."
		DB      "   The DOS IF ERRORLEVEL batch command"
		DB      " can use the return to branch."
CX4		DW      ?
BX4		DW      ?
AX4		DW      ?
PNODE		DB      "The Node Address of this workstation"
		DB      " is",0Dh,0Ah,"$"
HEXA		DB      " Hexadecimal, or $"
DECI		DB      " Decimal.  $"
OOPS		DB      "OOPS! The NetWare shell returned a 0,"
		DB      " so you either don't have the shell loaded"
		DB      " or you are at a non-dedicated server,"
		DB      " or you don't have a network card!"
CRLF		DB      0Dh,0Ah,"$"
GETSTN		EQU     0DCh	;represents get station call to Novell
GETNWAD		EQU     0EEh	;represents get node address call to Novell

PRTCHR		EQU     02h      ;print character dos call
PRTSTR		EQU     09h      ;print string dos call
DOS		EQU     21h

;  Set up a CRLF to the CRT
BEGIN:
		MOV     DX,OFFSET CRLF
		MOV     AH,PRTSTR
		INT     DOS

;  Send the first line to the CRT

		MOV     DX,OFFSET PNODE
		MOV     AH,PRTSTR
		INT     DOS

;  See if the NetWare shell is active

		MOV     AH,GETSTN        ;call to Novell shell for status
                                         ;put return code into AL
		INT     DOS

		CMP     AL,0             ;compare return code
		JA      GET_ADDR         ;jump above to get_addr
No_NET:
		MOV     DX,Offset OOPS ;display error message
		MOV     AX4,1
		MOV     AH,PRTSTR
		INT     DOS
		JMP     XOUT             ;get out of program

;  Get the Address from the NetWare Shell

GET_ADDR:
		MOV     AH,GETNWAD       ;call to Novell shell for address
		INT     DOS

;  Now store off the address before messing with it

		MOV     AX4,AX
		MOV     BX4,BX
		MOV     CX4,CX

;  But First check if NetWare returned ok address.  If last two chars are 0,
;  then check if last 8 chars are 0, just to be certain.

		CMP     AX,0
		JA      NET_OK
		MOV     AX,BX
		CMP     AX,0
		JA      NET_OK
No_ADDR:
		MOV     DX,Offset OOPS   ;display error message
		MOV     AX4,1
		MOV     AH,PRTSTR
		INT     DOS
		JMP     XOUT             ;get out of program

;  Send the hex chars to the CRT four at a time.
NET_OK:
		MOV     AX,CX4
		CALL    HEX4PRN

		MOV     AX,BX4
		CALL    HEX4PRN

		MOV     AX,AX4
		CALL    HEX4PRN

;  Send the Hexa message to the CRT

		MOV     DX,OFFSET HEXA
		MOV     AH,PRTSTR
		INT     DOS

;  Convert the last two digits to decimal for message

		SUB     AX,AX   ;Clear the accumulator
		MOV     AX,AX4  ;Put the last four hex into AL
		AND     AX,0FFh ; but only keep last two
		MOV     BL,100  ;Byte divisor
		DIV     BL
		MOV     CH,AH   ;Keep remainder from AH
		ADD     AL,'0'  ; convert to ASCII
		CALL    PRINTIT ;quotient in AL

		MOV     AL,CH   ;Get remainder back
		AND     AX,0FFh
		MOV     BL,10
		DIV     BL
		MOV     CH,AH   ;Keep remainder from AH
		ADD     AL,"0"
		CALL    PRINTIT

		MOV     AL,CH   ;Get remainder back
		ADD     AL,"0"
		CALL    PRINTIT ; and print it

;  Send the Decimal message to the CRT

		MOV     DX,OFFSET DECI
		MOV     AH,PRTSTR
		INT     DOS

;  Set up a CRLF to the CRT

		MOV     DX,OFFSET CRLF
		MOV     AH,PRTSTR
		INT     DOS

;  Now get out!  Leave the DOS IF ERRORLEVEL value intact

XOUT:
		MOV     AX,AX4
		MOV     AH,4Ch
		INT     DOS

;  Sub-Routines
;  Convert Hex character in AX to ASCII

HEX4PRN:
		MOV     BX,AX
		MOV     CL,04
		MOV     CH,04
XLOOP:
		ROL     BX,CL            ;rotate left 4 bits
		MOV     AL,BL
		AND     AL,0Fh           ;mask upper 4 bits
		ADD     AL,90h
		DAA                      ;decimal adjust for addition
		ADC     AL,40h
		DAA
		CALL PRINTIT
		DEC     CH
		JNZ     XLOOP
		RET

;  Single Character print AL=Char

PRINTIT:
		MOV     DL,AL
		MOV     AH,PRTCHR
		INT     DOS
		RET

CSEG		ENDS
		END     Entry
