'FileCopy.Bas - demonstration of the FileCopy.Asm routine

On Error Goto DiskErr                   'MUST handle critical errors and
                                        '  re-call FileCopy to close source

Input "Enter the source file: ", InFile$
Input "Enter the target file: ", OutFile$

Free = Fre("")                          'see how big a buffer we can make
If Free > 32849 Then                    'reserve 2 * 64 bytes for file names
   Buffer$ = Space$(32767)
Else
   Buffer$ = Space$(Free - 82)
End If

Call FileCopy(InFile$, OutFile$, Buffer$, ErrCode%)

Print
If ErrCode% Then                        'did FileCopy detect any errors?
   Print "ERROR: ";
   Select Case ErrCode%
   Case 1
      Msg$ = "Source path cannot be found."
   Case 2
      Msg$ = "Source file does not exist."
   Case 4
      Msg$ = "Source file is a directory."
   Case 5

 Msg$ = "Source file cannot be accessed."
   Case 6
      Msg$ = "Target path cannot be found."
   Case 7
      Msg$ = "Target filename is invalid."
   Case 8
      Msg$ = "Target directory is full."
   Case 9
      Msg$ = "Target file is a directory."
   Case 10
      Msg$ = "Target file is read-only."
   Case 11
      Msg$ = "Target file cannot be accessed."
   Case 12
      Msg$ = "Target disk is full."
   Case 13
      Msg$ = "Not enough string space for copy buffer."
   End Select
   Print Msg$
Else
   Print "Successful completion."
End If


Done:
Buffer$ = ""            'free up the memory used by Buffer$
End


DiskErr:                'program will arrive here if a critical error occurred
                        'call FileCopy again to close any open files

Print "A DOS critical error occured - check the disk and disk drive."
Call FileCopy(InFile$, OutFile$, Buffer$, -1%)
Resume Done

