/* PUTCLIP.C -- put text from file onto Windows clipboard */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include "winclip.h"

void fail(char *s) { puts(s); exit(1); }

int main(int argc, char *argv[])
{
    unsigned len;
    char *p;
    
    if (argc < 2)
    	fail(
	"usage: PUTCLIP text        puts text into clipboard\n"
	"       PUTCLIP @filename   puts file contents into clipboard\n"
	"       PUTCLIP -           copies standard input into clipboard\n");

    if (! WindowsClipboard())
         fail("This program must run in a DOS box "
	      "under Enhanced mode Windows");

      if (! (argv[1][0] == '-' || argv[1][0] == '@'))
      {
            static char buf[128];
			char far *cmdline = MK_FP(_psp, 0x82);
			int len = *((unsigned char far *) MK_FP(_psp, 0x80)) - 1;
			_fmemcpy(buf, cmdline, len);
            p=buf;
      }
      else
      {
            int f;
            unsigned rc;    /* count of bytes read */
            if (argv[1][0] == '-' && argv[1][1] == '\0')  // - on cmdline
                 f = 0;      // STDIN
            else if (argv[1][0] == '@')       // filename on cmdline
                 if ((f = open(&argv[1][1], O_RDONLY)) == -1)
                       fail("can't open file");
            if ((len = filelength(f)) > (32 * 1024))// 32k max
                 fail("file too big");
            if ((p = malloc(len+1)) == 0)
                 fail("insufficient memory");
            if ((rc = read(f, p, len)) < 1) // means 32k max!
                 fail("can't read file");
            close(f);
            p[rc] = '\0';   /* must be NULL terminated */
            len = rc;
      }

    if (PutClipStrLen(p, len+1))   // +1 for NULL
        puts("putclip successful");
    else
        puts("putclip failed");
    
    return 0;
}

