// arraymgr.h

#if !defined(ARRAYMGR_H)
#define ARRAYMGR_H

#include<windows.h>
#include<memory.h>

typedef struct _clipelement
    {
    DWORD offset;
    WORD format;
    DWORD size;
    WORD usage;
    } CLIPELEMENT;

class ArrayMgr
    {
    int numElements;
    int maxElements;
    CLIPELEMENT *array;
    LONG lastoffset;

    void DecrementUsage(DWORD offset);
    void SetUsage(DWORD offset, WORD usage);

public:
    void Init(int Els)
        {
        maxElements = Els;
        array = (CLIPELEMENT *)new char[Size()];
        memset(array,0,Size());
        numElements = 0;
        lastoffset = 0L;
        }
    ArrayMgr(void)
        {
        numElements = maxElements = 0;
        array = NULL;
        }

    ArrayMgr(int Els)
        {
        Init(Els);
        }
    ~ArrayMgr(void)
        {
        delete array;
        }
    BOOL IsValid(int index)
        {
        if(index >= 0 && index < numElements)
            return TRUE;
        return FALSE;
        }
    CLIPELEMENT *operator[](int index)
        {                    
        if(index >= 0 && index < maxElements)   // use maxElements not IsValid
            return (CLIPELEMENT *)&array[index];
        return (CLIPELEMENT *)NULL;
        }
    int NumElements(void)       {   return numElements; }
    int MaxElements(void)       {   return maxElements; }
    int Size(void)              {   return maxElements*sizeof(CLIPELEMENT); }
    void SetNumElements(int n)  {   numElements = n;    }
    void SetMaxElements(int n)  {   maxElements = n;    }
    void *Array(void)           {   return (void *)array;   }
    BOOL ReSize(int newMaxEls)
        {
        if(newMaxEls == maxElements)
            return TRUE;
        if(newMaxEls < maxElements)
            {
            maxElements = newMaxEls;
            if(maxElements < numElements)
                numElements = maxElements;
            return TRUE;
            }

        int size;
        CLIPELEMENT *temp = 
            (CLIPELEMENT *)new char[size = (newMaxEls*sizeof(CLIPELEMENT))];
        if(!temp)
            return FALSE;
        memset(temp,0,size);
        memcpy(temp,array,Size());
        delete array;
        array = temp;
        maxElements = newMaxEls;
        return TRUE;
        }

    void Add(int index, DWORD off, WORD fmt, DWORD sz, WORD us = 0)
        {
        array[index].offset = off;
        array[index].format = fmt;
        array[index].size = sz;
        array[index].usage = us;
        numElements++;
        }
    void Insert(DWORD off, WORD fmt, DWORD sz, WORD us = 0)
        {                       // shift array down
        if(numElements > 0)     // if nothing there, don't bother
            memmove(&array[1],&array[0],Size()-sizeof(CLIPELEMENT));
        if((numElements == maxElements) && (numElements > 0))
             numElements--;     // decrement numElements 
        Add(0,off,fmt,sz);      // add new element
        if(us)                  // if usage > 0, update all owners' usage
            SetUsage(off,us);
        }
    void Delete(int index)
        {
        if(numElements > 0)
            {
            if(array[index].usage)          // if block in use elsewhere
                DecrementUsage(array[index].offset);    // usage-- for owners
                // close array up over deleted one
            memmove(&array[index],&array[index+1],
                (maxElements-(index+1))*sizeof(CLIPELEMENT));
                // reduce number of elements
            numElements--;
            }
        }
    DWORD LastOffset(LONG lo = 0L)
        {
        if(!numElements)
            return 0L;
        if(lo > 0L)
            lastoffset = lo;
        return lastoffset;
    //    return (array[0].offset+array[0].size +
    //        (array[0].format == CF_BITMAP ? sizeof(BITMAP) : 0L));
        }

    BOOL IsDupe(int index);
    void UpdateOffsets(DWORD offset);
    void UpdateDupes(int index, DWORD newoffset);
    BOOL IsFirstDupe(int index);
    };

#endif

