{$X+}
UNIT FileSrch;
(**) INTERFACE (**)
USES WinDos, Strings;
TYPE
    {-SearchProc must return 0 if Ok, > 127 if error-}
  SearchProc = FUNCTION(VAR S : TSearchRec; P : Pchar) : Byte;

  FUNCTION Searcher(Mask : PChar;
                    Attr : Byte;
                    SP   : SearchProc) : Byte;
  FUNCTION AllSearcher(Mask : PChar;
                       Attr : Byte;
                       SP   : SearchProc) : Byte;

(**) IMPLEMENTATION (**)

  FUNCTION Searcher(Mask : PChar;
                    Attr : Byte;
                    SP   : SearchProc) : Byte;
  VAR
    SR  : TSearchRec;
    Ds  : ARRAY[0..65] OF Char;
    Ns  : ARRAY[0..8] OF Char;
    Es  : ARRAY[0..3] OF Char;
    Err : Byte;
  BEGIN
    FindFirst(Mask, Attr, SR);
    IF DosError <> 0 THEN Searcher := DosError
    ELSE
      BEGIN
        Err := 0;
        FileSplit(Mask, Ds, Ns, Es);
        WHILE (DosError = 0) AND (Err = 0) DO
          BEGIN
            Err := SP(SR, Ds);
            FindNext(SR);
          END;
        IF Err <> 0 THEN Searcher := Err
        ELSE IF DosError = 18 THEN Searcher := 0
        ELSE Searcher := DosError;
      END;
  END;

VAR
  GlobalSearchDirMask : Array[0..12] OF Char;
  GlobalSearchDirAttr : Byte;
  GlobalSearchDirProc : SearchProc;

  FUNCTION SearchDir(VAR S:TSearchRec; P:PChar) : Byte; FAR;
  VAR
    NuP : ARRAY[0..79] OF Char;
    Err : Byte;
  BEGIN
    Err := 0;
    IF (S.name[0] <> '.') AND
       (S.Attr AND faDirectory > 0) THEN
      BEGIN
        StrCopy(NuP, P);
        StrCat(NuP, S.Name);
        {- handle individual files -}
        StrCat(NuP, '\');
        StrCat(NuP, GlobalSearchDirMask);
        Err := Searcher(NuP,
                        GlobalSearchDirAttr,
                        GlobalSearchDirProc);
        IF Err = 0 THEN
          BEGIN
            {- handle any subdirectories -}
            StrCopy(NuP, P);
            StrCat(NuP, S.Name);
            StrCat(NuP, '\*.*');
            Err := Searcher(NuP,
                            faDirectory OR faArchive,
                            SearchDir)
          END;
      END;
    SearchDir := Err;
  END;

  FUNCTION AllSearcher(Mask : PChar;
                       Attr : Byte;
                       SP   : SearchProc) : Byte;
  VAR
    Ds  : ARRAY[0..65] OF Char;
    Ns  : ARRAY[0..8] OF Char;
    Es  : ARRAY[0..3] OF Char;
    Err : Byte;
  BEGIN
    FileSplit(Mask, Ds, Ns, Es);
    StrCopy(GlobalSearchDirMask, Ns);
    StrCat(GlobalSearchDirmask, Es);
    GlobalSearchDirAttr := Attr;
    GlobalSearchDirProc := SP;
    {- handle individual files -}
    Err := Searcher(Mask, Attr, SP);
    StrCat(Ds, '*.*');
    IF (Err = 0) OR (Err = 18) THEN
      {- handle any subdirectories -}
      AllSearcher := Searcher(Ds,
                              faDirectory OR faArchive,
                              SearchDir)
    ELSE AllSearcher := Err;
  END;
END.