// scroller.cpp RHS 10/15/91

#include"scroller.h"

Scroller::Scroller(char *title, DWORD position, BYTE colors, 
        int num, int size)  
        : Window(title, position, colors)
    {
    bufsize = size;
    startBuf = curBuf = 0;
    endBuf = numbuffers-1;
    buffer_changed = FALSE;
    }

Scroller::Scroller(char *title, DWORD position, BYTE colors)
        : Window(title, position, colors)
    {
    numbuffers = bufsize = 0;
    startBuf = endBuf = curBuf = 0;
    buffer_changed = FALSE;
    }

int Scroller::Init(int num, int size)
    {
    bufsize = size;
    SetColors();
    endBuf = numbuffers-1;
    return numbuffers;
    }

void Scroller::Open(void)
    {
    Window::Open();
    startBuf = curBuf = 0;
//    endBuf = MaxBufs();
    Paint();
    }

void Scroller::Paint(void)
    {
    int i;
    for(i = startBuf; (i < endBuf+1) && (i-startBuf < clientheight); i++)
        DispBuffer(i-startBuf,i);
                                            // display current
    DispBuffer(curBuf-startBuf,curBuf,SCROLLER_CURRENT);
    buffer_changed = FALSE;
    }

void Scroller::Home(void)
    {
    BufMgt(SCROLL_HOME);

    if(startBuf == 0 && !buffer_changed)
        {
        if(curBuf == 0)
            return;
        DispBuffer(curBuf,curBuf);          // no longer current
        curBuf = 0;
                                            // top one now current
        DispBuffer(curBuf,curBuf,SCROLLER_CURRENT);
        return;
        }
    curBuf = startBuf = 0;
    endBuf = Lines()-1;
    Paint();
    }

void Scroller::End(void)
    {
    BufMgt(SCROLL_END);
//    if(endBuf == MaxBufs())
//        return;

//    if(endBuf == (numbuffers-1) && !buffer_changed)
      if((endBuf == MaxBufs()) && !buffer_changed)
        {
        DispBuffer(curBuf-startBuf,curBuf); // no longer current
        curBuf = endBuf;
                                            // top one now current
        DispBuffer(curBuf-startBuf,curBuf,SCROLLER_CURRENT);
        return;
        }

//    curBuf = endBuf = numbuffers-1;
    curBuf = endBuf = MaxBufs();
    startBuf = endBuf-(int)(Lines()-1);
    Paint();
    }

void Scroller::PgUp(void)
    {
    BufMgt(SCROLL_PGUP);

    if(startBuf == 0 && !buffer_changed)
        {
        Home();
        return;
        }

    curBuf -= startBuf;
    endBuf -= startBuf;

    if((startBuf -= (int)Lines()) < 0)
        startBuf = 0;

    curBuf += startBuf;
    endBuf += startBuf;
    Paint();
    }

void Scroller::PgDn(void)
    {
    BufMgt(SCROLL_PGDN);

    if(!buffer_changed)
        if((endBuf == MaxBufs()) || (endBuf+Lines() > MaxBufs()))
            {
            End();
            return;
            }

    curBuf = endBuf-curBuf;
    startBuf = endBuf-startBuf;

    if((endBuf += Lines()) >= numbuffers)
        endBuf = numbuffers-1;
    curBuf = endBuf-curBuf;
    startBuf = endBuf-startBuf;

    Paint();
    }

// Down and Up are dedicated to 'Mobimientos Del Alma' by Earl Klugh
void Scroller::Down(void)
    {
    BufMgt(SCROLL_DN);
    if(curBuf == endBuf)                    // if on last displayed buffer
        {
        if(endBuf == numbuffers-1)          // if no more buffers, out
            return;
        if(endBuf == MaxBufs())
            return;
                                            // no longer current
        DispBuffer(curBuf-startBuf,curBuf);
        curBuf++;                           // move to next line
        startBuf++;
        endBuf++;
        Scroll(WIN_SCROLLUP,1);             // scroll window up
                                            // new buffer now current
        DispBuffer(Lines()-1,curBuf,SCROLLER_CURRENT);
        return;
        }
                                            // else not on bottom line
    DispBuffer(curBuf-startBuf,curBuf);     // this buffer no longer current
    curBuf++;                               // next buffer
                                            // and make it current
    DispBuffer(curBuf-startBuf,curBuf,SCROLLER_CURRENT);
    if(buffer_changed)
        Paint();
    }

void Scroller::Up(void)
    {
    BufMgt(SCROLL_UP);

    if(!curBuf)                             // if on first buffer
        return;                             // fuh-gi-da-bou-dit!

    if(curBuf == startBuf)                  // else on first line
        {
        DispBuffer(0,curBuf); // no longer current line
        curBuf--;                           // m'on back!
        startBuf--;
        endBuf--;
        Scroll(WIN_SCROLLDN,1);             // scroll window down
        DispBuffer(0,curBuf,SCROLLER_CURRENT);  // this line current
        return;
        }
    DispBuffer(curBuf-startBuf,curBuf);     // else not on first line
                                            // no longer current line
    curBuf--;                               // back up
                                            // this line current
    DispBuffer(curBuf-startBuf,curBuf,SCROLLER_CURRENT);
    if(buffer_changed)
        Paint();
    }

void Scroller::DispBuffer(int line, int bufnum, BYTE attribute)
    {
    BYTE attrib = GetAttribute(bufnum);    // retrieve attribute byte
    switch(attribute)                           // check this operation:
        {
        case SCROLLER_NORMAL:                   // turn off CURRENT bit
            attrib &= 0xfe;
            break;
        case SCROLLER_CURRENT:                  // turn on CURRENT bit
            attrib |= 0x01;
            break;
        default:
            attrib = attribute;
        }
    SetAttribute(bufnum,attrib);         // store attribute byte
    BYTE color = Colors(attrib);            // get color value
//    strcpy(workbuffer,GetBuffer(bufnum));
    char buffer[80];
    strcpy(buffer,GetBuffer(bufnum));
    AtSay(line,0,buffer,color);
    }

BYTE Scroller::Select(void)
    {
    BYTE attrib = GetAttribute(curBuf);

    if(attrib & SCROLLER_DELETED)
        return attrib;
    if(attrib & SCROLLER_SELECTED_NORMAL)       // if selected
        attrib &= 0xfd;                         // de-select
    else                                        // if not selected
        attrib |= SCROLLER_SELECTED_NORMAL;     // select it
    SetAttribute(curBuf,attrib);
    DispBuffer(curBuf-startBuf,curBuf,attrib);
    return attrib;
    }

void Scroller::SetColors(BYTE cur, BYTE sel_cur, 
    BYTE sel_norm, BYTE norm, BYTE sel_del, BYTE del_cur)
    {
    ScrColors[SCROLLER_NORMAL] = norm;
    ScrColors[SCROLLER_CURRENT] = cur;
    ScrColors[SCROLLER_SELECTED_NORMAL] = sel_norm;
    ScrColors[SCROLLER_SELECTED_CURRENT] = sel_cur;
    ScrColors[SCROLLER_DELETED] = sel_del;
    ScrColors[SCROLLER_DELETED_CURRENT] = del_cur;
    }

//#define MAIN
#if defined(MAIN)
#include<stdio.h>
#include"stdapp.h"

class TestScroller : public StandardApplication
    {
public:
    TestScroller(void);
    };

TestScroller::TestScroller(void)
    {
    Scroller scroller("Test Scroller!",MakePosition(6,20,
        (screen.Lines() > 25 ? 42 : 18), 26));

    scroller.Init(100,50);
    int i;
    char buf[50];

    for(i = 0; i < 100; i++)
        {
        sprintf(buf,"This is buffer number %02d!",i);
        scroller.Change(i,buf,0,i*1L);
        }
#ifdef JUNK
    for(i = 0; i < 100; i++)
        printf("%s  Attribute=%02d  Recno=%02ld\n",
            scroller[i]->buffer,
            scroller[i]->attribute,
            scroller[i]->recno);
#endif

    scroller.Open();
    while(TRUE)
        {
        switch(keyboard.Get())
            {
            case UP:
                scroller.Up();
                break;
            case DOWN:
                scroller.Down();
                break;
            case HOME:
                scroller.Home();
                break;
            case END:
                scroller.End();
                break;
            case PGDN:
                scroller.PgDn();
                break;
            case PGUP:
                scroller.PgUp();
                break;
            case SPACE:
                scroller.Select();
                break;
            case ESC:
                return;
            }
        }
    }

void main(void)
    {
    TestScroller testscroller;
    }

#endif


