// dupes.h RHS 8/5/91

#if !defined(DUPES_H)
#define DUPES_H

#include"file.h"

typedef struct
    {
    unsigned dirnamelen;
    char dirname[80];
    } DIRNAME;

typedef struct
    {
    unsigned time;
    unsigned date;
    long size;
    long dirnameoffset;
    } DATABUF;
 
typedef struct
    {
    char buf[13];
    BYTE status;
    long offset;
    } OUTBUF;

class Dupes
    {
protected:
    OUTBUF OutBuf;
    DATABUF DataBuf;
    DIRNAME DirName;
    File TempIndex;
    File TempData;
    File IndexFile;
    File DataFile;

public:
    Dupes(void)
        {
        TempIndex.SetName("DUPE_IDX.TMP");
        TempData.SetName("DUPE_DAT.TMP");
        IndexFile.SetName("DUPES.IDX");
        DataFile.SetName("DUPES.DAT");
        }

    BOOL PutDirectory(File *f, char *dirspec, BOOL init = FALSE);
    void GetData(File *d, long offset);
    int GetRecord(void);
    void PutData(File *d, void *data);
    void PutIndex(File *i, char *name, long offset, BYTE status = 0);
    BOOL PutDirectoryToTemp(char *dirspec)
        {
        return PutDirectory(&TempData,dirspec);
        }
    BOOL PutDirectoryToData(BOOL init)
        {
        return PutDirectory(&DataFile,DirName.dirname,init);
        }
    void PutIndexToTemp(char *name)
        {
        PutIndex(&TempIndex,name,TempData.CurPosition());
        }
    void PutDataToTemp(void *data)
        {
        PutData(&TempData,data);
        }
    void PutDataFile(void)
        {
        DataFile.Write(sizeof(DATABUF),&DataBuf);
        }
    ~Dupes(void)
        {
        }
    };
#endif

