// app.h RHS 6/7/91

#if !defined(APP_H)
#define APP_H

#include"stddefs.h"

const MAXSWITCHES = 2;

class Application
    {
    int argcount;
    char **arglist;
    char switches[MAXSWITCHES];
    int nextarg;
    char oldc;

    void SetDefaults(void)
        {
        nextarg = 0;
        oldc = 0;
        SetSwitchChar();
        AddSwitchChar();
        }
    char *_GetSwitchArg(char *buf); // search engine

public:
    Application(int argc, char **argv);
    Application(void);

    char *GetAppName(void);         // return application name,
    void GetAppName(char *);        // argv[0]
    
    BOOL GetSwitchArg(char c);      // returns TRUE if switch is set
    char *GetSwitchArg(char c, char *buf); // returns the arg following the switch
    char *GetNextSwitchArg(char *buf);

    char *GetArg(void);             // returns arg (no switch)
    char *GetNextArg(void);         // returns next arg with no switch
    char *Arg(void);                // returns first and following args

    void SetSwitchChar(char c = '-');   // sets the switch character
    void AddSwitchChar(char c = '/');   // adds an additional switch char

    char *GetArg(int argno);        // returns argv[argno+1]

    int  GetArgCount(void);         // returns argc-1
    int  GetParamCount(void);       // returns argc

    char *operator[](int argno);    // returns argv[argno]
    };

#if defined(APP_NOMAIN)
void main(void)
    {
    }
#endif



#endif

