// makepath.cpp RHS 2/5/92

#include<dir.h>
#include<string.h>
#include<ctype.h>
#include<stdio.h>

#include"makepath.h"

char *makepath(char *buf, char *spec)
    {
    char drivelet;

    if(spec[1] != ':')                  // no drive letter
        drivelet = (getdisk()+'A');     // get one
    else                                // drive letter specified
        {
        drivelet = toupper(*spec);      // get it
        spec = &spec[2];
        }

        // spec now points to path portion (after drivelet+colon)

    if(spec[strlen(spec)-1] == '\\')    // if trailing backslash
        spec[strlen(spec)-1] = '\0';    // remove it

    buf[0] = drivelet;                  // add drive letter
    strcpy(&buf[1],":\\");              // add colon and backslash

    if(*spec == '\\')                   // if starts with backslash,
        strcat(buf,&spec[1]);           // add it after that point
    else                                // otherwise, it's a relative dir
        {
        getcurdir(drivelet-'A'+1,&buf[3]);  // add cwd
        if(buf[strlen(buf)-1] != '\\')  // if no backslash, 
            strcat(buf,"\\");           // add one
        strcat(buf,spec);               // add dirspec
        }

    char *p,*q;
    while(p = strstr(buf,"\\.."))       // weed out ..
        {
        q = &p[3];
        for( p-- ; p > &buf[2] && *p != '\\'; p--);
        if(*p == '\\')
            strcpy(p,q);
        }

    if(p = strstr(buf,"\\."))           // weed out .
        strcpy(p,&p[2]);

    strupr(buf);
    return buf;
    }

#if defined(MAIN)
void main(int argc, char **argv)
    {
    if(argc == 2)
        {
        char buffer[80];

        makepath(buffer, argv[1]);
        printf("%s\n", buffer);
        }
    }
#endif


