// window.cpp RHS 11/1/91

#include<stdio.h>
#include<string.h>
#include<stdarg.h>
#include<malloc.h>
#include"window.h"

const BYTE  WIN_ACTIVE_VERT     = 186;
const BYTE  WIN_ACTIVE_HORZ     = 205;
const BYTE  WIN_ACTIVE_ULEFT    = 201;
const BYTE  WIN_ACTIVE_URIGHT   = 187;
const BYTE  WIN_ACTIVE_LLEFT    = 200;
const BYTE  WIN_ACTIVE_LRIGHT   = 188;

const BYTE  WIN_INACTIVE_VERT   = 179;
const BYTE  WIN_INACTIVE_HORZ   = 196;
const BYTE  WIN_INACTIVE_ULEFT  = 218;
const BYTE  WIN_INACTIVE_URIGHT = 191;
const BYTE  WIN_INACTIVE_LLEFT  = 192;
const BYTE  WIN_INACTIVE_LRIGHT = 217;

BYTE WIN_DEFAULT_COLORS = (MakeBG(VID_BLUE)+VID_YELLOW);

void Window::SetDefaultColors(BYTE newcolors)
    {   
    WIN_DEFAULT_COLORS = newcolors; 
    }

    // ****************************************** Class Window
Window::Window(char *title, DWORD position,
    BYTE attrib, BYTE fc, BYTE clr)
    {
    SetDefaults(title, position,
        attrib,fc,clr);
    clientwidth = width-2;
    clientheight = height-3;
    }

void Window::SetDefaults(char *ttl, DWORD position,
        BYTE attrib, BYTE fc, BYTE clr)
    {
    if(title = (char far *)farmalloc(strlen(ttl)+1))
        _fstrcpy(title,ttl);
    attributes = attrib;
    GetPosition(position,top,left,height,width);
    fillchar = fc;
    color = clr;

    curRow = curCol = 0;
    isOpen = FALSE;
    }

// ADD INITIALIZATION CODE HERE!
void Window::Init(void)
    {

    }


void Window::Open(void)
    {
    int bottom = top+height;

    Screen::GotoXY(top,left);
    ClearEntireWindow();
    int i,j;
    WORD far *temp = params.curpos;
    WORD bar = ScreenChar(WIN_ACTIVE_HORZ);

    isOpen = TRUE;
    for(i = top; i < bottom-1; )
        {
        if(i == top)
            SetTitle();
        else if(i == bottom-2)
            {
            *temp = ScreenChar(WIN_ACTIVE_LLEFT);
            SetWords(&temp[1],bar,width-1);
            temp[width-1] = ScreenChar(WIN_ACTIVE_LRIGHT);
            }
        else
            temp[(width-1)] = *temp = ScreenChar(WIN_ACTIVE_VERT);
        i++;
        temp = Screen::GotoXY(i,left);
        }

    clientwidth = width-2;
    clientheight = height-3;
    GotoXY(0,0);
    }

void Window::GetTitle(char *buf)
    {
    _fstrcpy(buf,title);
    }

void Window::SetTitle(char *newtitle)
    {
    if(newtitle)
        {
        if(title)
            farfree(title);
        if(title = (char far *)farmalloc(strlen(newtitle)+1))
            _fstrcpy(title,newtitle);
        }

    if(isOpen)
        {
        Screen::GotoXY(top,left);
        WORD far *temp = params.curpos;
        WORD bar = ScreenChar(WIN_ACTIVE_HORZ);

        *temp = ScreenChar(WIN_ACTIVE_ULEFT);
        SetWords(&temp[1],bar,width-1);
        temp[width-1] = ScreenChar(WIN_ACTIVE_URIGHT);

        int pos, len = _fstrlen(title);

        char buf[80];

        *buf = ' ';

        if(width < (_fstrlen(title)+4))
            {
            _fstrncpy(&buf[1],title,width-4);
            strcpy(&buf[width-4]," ");
            Screen::AtSay(top,left+1,buf);
            }
        else
            {
            _fstrcpy(&buf[1],title);
            strcat(buf," ");
            Screen::AtSay(top,left+(width-(len+2))/2,buf);
            }
        }
    }

WORD far *Window::GotoXY(int row, int col)
    {
// ********************************** add range checking here
    curRow = row;
    curCol = col;
    return Screen::GotoXY(row+top+1,col+left+1);
    }

void Window::ClearEntireWindow(void)
    {
    Screen::Clear(top,left,top+height,left+width,color);
    }

void Window::Clear(void)
    {
    Screen::Clear(top+1,left+1,top+clientheight+2,left+clientwidth+1,color);
    }

void Window::Paint(void)
    {
    }

Window::~Window(void)
    {
    if(title)
        farfree(title);
    }

void cdecl Window::AtSay(int row, int col, char *fmt, ...)
    {
    if(!workbuffer)
        return;
    va_list argptr;

    va_start(argptr,fmt);
    vsprintf(workbuffer,fmt,argptr);
    va_end(arg_ptr);
    AtSay(row,col,workbuffer,color);
    }

void Window::AtSay(int row, int col, char *buffer, BYTE color)
    {
    GotoXY(row,col);
    strcpy(workbuffer,buffer);
    if(strlen(workbuffer) > clientwidth-col)
        workbuffer[clientwidth-col] = '\0';
    Write(workbuffer,color);
    }

void Window::Scroll(int direction,int numlines)
    {
    _DL = left+clientwidth;
    _DH = top+clientheight;
    _CL = left+1;
    _CH = top+1;
    _BH = color;
    _AH = (direction == WIN_SCROLLUP ? 6 : 7);
    _AL = numlines;
    asm int 10h
    }


void cdecl Window::Printf(char *fmt, ...)
    {
    char temp[DEFAULTLINELEN];

    va_list argptr;

    va_start(argptr,fmt);
    vsprintf(temp,fmt,argptr);
    va_end(arg_ptr);

    int len = strlen(temp);
    char *q = temp, *p = strchr(temp,'\n');
    if(!p)
        {
        Puts(temp);
        return;
        }

    while(TRUE)
        {
        if(p)
            *p = '\0';
        Puts(q);
        if(!p)
            break;
        q = p+1;
        if(q >= temp+len)
            break;
        p = strchr(q,'\n');
        }
    }

void Window::Puts(char *str)
    {
    if(curRow == clientheight-1)
        Scroll(WIN_SCROLLUP,1);
    AtSay(curRow,curCol,str,color);
    if(curRow < clientheight-1)
        curRow++;
    curCol = 0;
    }

    // ************************************* Class PopWin 
PopWin::~PopWin(void)
    {
    if(isOpen)
        Close();
    farfree(saved_screen);
    }

void PopWin::Close(void)
    {
    // restore screen
    BYTE far *temp;
    for(int i = 0; i < height-1; i++)
        {
        temp = (BYTE far *)Screen::GotoXY(top+i,left);
        CpyWords(temp,&saved_screen[i*width*2],width);
        }
    isOpen = FALSE;
    }

void PopWin::Open(void)
    {
    saved_screen = (BYTE far *)farmalloc((width+1)*(height+1)*2);

    if(!saved_screen)
        return;

    BYTE far *temp;
    for(int i = 0; i < height-1; i++)
        {
        temp = (BYTE far *)Screen::GotoXY(top+i,left);
        CpyWords(&saved_screen[i*width*2],temp,width);
        }

    Window::Open();
    }
