// screen.h RHS 7/28/91

#if !defined(SCREEN_H)
#define SCREEN_H

#include<malloc.h>
#include"stddefs.h"

inline BYTE MakeBG(BYTE byte)    
    {
    return (byte << 4);
    }

inline WORD MakeCell(BYTE c, BYTE color)
    {
    return (WORD)((color << 8)+c);
    }

inline DWORD MakePosition(BYTE top, BYTE left, BYTE height, BYTE width)
    {
    WORD hi = MAKEWORD(top,left);
    WORD lo = MAKEWORD(height,width);
    return MAKEDWORD(hi,lo);
    }

inline void GetPosition(DWORD position, BYTE& top, BYTE& left, 
        BYTE& height, BYTE& width)
    {
    WORD w = HIWORD(position);
    top = HIBYTE(w);
    left = LOBYTE(w);
    w = LOWORD(position);
    height = HIBYTE(w);
    width = LOBYTE(w);
    }

const VIDSETMODE = 0; 
const VIDSETCURSIZE = 1; 
const VIDSETCURPOS = 2; 
const VIDGETCURPOS = 3;
    
const VIDGETLIGHTPEN = 4; 
const VIDSETPAGE = 5; 
const VIDSCROLLUP = 6; 
const VIDSCROLLDN = 7; 
const VIDGETCHARATT = 8;
    
const VIDPUTCHARATT = 9; 
const VIDPUTCHARS = 10; 
const VIDSETCOLOR = 11; 
const VIDSETPIXEL = 12; 
const VIDGETPIXEL = 13;
    
const VIDPUTCHARTTY = 14; 
const VIDGETMODE = 15; 
const VIDSETPAL = 16; 
const VIDCHARTBL = 17; 
const VIDSYSCFG = 18; 
const VIDPUTSTR = 19;
    
const VIDDISPCOMBO = 0x1a; 
const VIDBIOS = 0x1b; 
const VIDSTATE = 0x1c;

const SCRMONO = 0;
const SCRCGA = 1;
const SCREGA = 2;
const SCRVGA = 3;

const VID_BLACK = 0;
const VID_BLUE = 1;
const VID_GREEN = 2;
const VID_CYAN = 3;
const VID_RED = 4;
const VID_MAGENTA = 5;
const VID_BROWN = 6;
const VID_LIGHTGRAY = 7;
const VID_DARKGRAY = 8;
const VID_LIGHTBLUE = 9;
const VID_LIGHTGREEN = 10;
const VID_LIGHTCYAN = 11;
const VID_LIGHTRED = 12;
const VID_LIGHTMAGENTA = 13;
const VID_YELLOW = 14;
const VID_WHITE = 15;

const VIDMODE_DEFAULT = -1;
const VIDMODE_BW40 = 0;
const VIDMODE_C40 = 1;
const VIDMODE_BW80 = 2;
const VIDMODE_C80 = 3;
const VIDMODE_MONO = 7;
const VIDMODE_EGAVGA = 64;

const SCR_CURSOR_ON = 1;
const SCR_CURSOR_OFF = 0;

const BYTE SCR_DEFAULT_FILLCHAR = 176;
const BYTE SCR_DEFAULT_DESKTOPCOLORS = (MakeBG(VID_LIGHTGRAY)+VID_BLUE);
const BYTE SCR_DEFAULT_COLORS = (MakeBG(VID_BLUE)+VID_WHITE);

const BYTE SCR_MENU_BAR     = 0x01;
const BYTE SCR_STATUS_BAR   = 0x02;
const BYTE SCR_SYSTEM_ICON  = 0x04;
const BYTE SCR_ABOUT_BOX    = 0x08;
const BYTE SCR_DEFAULT_ATTRIBUTES = (SCR_MENU_BAR | SCR_STATUS_BAR);

class ScrDeskTop
    {
    friend class Screen;

    BYTE    color;
    BYTE    attributes;
    BYTE    clientheight;
    BYTE    clientwidth;
    BYTE    fillchar;

public:
    ScrDeskTop( 
        BYTE color = SCR_DEFAULT_DESKTOPCOLORS, 
        BYTE attribute = SCR_DEFAULT_ATTRIBUTES, 
        BYTE fillchar = SCR_DEFAULT_FILLCHAR);
    BOOL pascal Paint(void);
    };

typedef struct _screenparams
    {
    int numlines;
    int numcols;
    char far *screenBuf;
    WORD far *curpos;
    WORD cursorSize;
    unsigned char currAttr;
    BYTE mode;
    BYTE currow;
    BYTE curcol;
    } SCRPARAMS;


class OrgScreen
    {
    friend class Screen;

#ifdef OLD
    int numlines;
    int numcols;
    char far *screenBuf;
    unsigned far *curpos;
    unsigned char currAttr;
    BYTE mode;
#else
    SCRPARAMS params;
#endif
public:
    OrgScreen(void)
        {
        }
    };

class Screen
    {
    static OrgScreen orgScreen;
    static ScrDeskTop *DeskTop;
protected:
#ifdef OLD
    static int numlines;
    static int numcols;
    static char far *screenBuf;
    static unsigned far *curpos;
    static BYTE currAttr;
    static BYTE mode;
#else
    static SCRPARAMS params;
#endif
    static BOOL wait_for_retrace;
    static BOOL buffered;
    static unsigned bufsize;
    static char far *buffer;
    static char *workbuffer;
private:
    static char *workbuf2;
    static void far *org_screen_image;
    static WORD org_screen_size;
    static WORD org_screen_curpos;
protected:

    void near pascal VidRamAccess(void far *dst, void far *src, int len);
    BOOL near pascal CheckSysCopyRight(char far *ROMaddress, char *Copyright);
    SCRPARAMS GetVidModeParams(BYTE *cols);

public:
    Screen(void);
    void Init(int newmode = VIDMODE_DEFAULT, 
        BYTE desktop_colors = SCR_DEFAULT_DESKTOPCOLORS, 
        BYTE screen_colors = SCR_DEFAULT_COLORS);
    ~Screen(void);
    void Paint(void);
    void SetTextMode(int newmode);
    void Write(char *str,WORD clr = params.currAttr);
    void Write(unsigned char *str, WORD clr, int len);
    void Read(char *str);
    void Read(char *str, int len);
    WORD far *Cursor(int x, int y);
    void Cursor(BOOL on_off);
    void Buffering(BOOL on_off);
    void FlushBuffer(void);
    void cdecl Printf(char *fmt, ...);
    void SetForeGround(unsigned char c);
    void SetBackGround(unsigned char c);
    void Clear(void) { Clear(0,0,params.numlines,params.numcols); }
    void Clear(int row, int col, int erow, int ecol, BYTE colors = params.currAttr);
    void cdecl AtSay(int x, int y, char *fmt, ...);
    int Lines(void) { return params.numlines;  }
    int Columns(void) { return params.numcols; }
    void SetAttribute(unsigned char c) { params.currAttr = c; }
    unsigned char GetAttribute(void) { return params.currAttr; }
    void WriteRaw(void far *buf, int len);
    void ReadRaw(void far *buf, int len);
    WORD far *GotoXY(int row, int col) { return Cursor(row,col); }
    int GetMode(void) { return params.mode; };
    void Exec(char *command, char *args[], char *message = NULL);

    friend class ScrDeskTop;
    };

extern Screen *ScreenPtr;

void near pascal SetWords(void far *addr, unsigned val, unsigned len);
void near pascal CpyWords(void far *dst, void far *src, unsigned n);
BYTE near pascal VidGetMode(BYTE *cols);
void near pascal VidSetMode(BYTE mode);
BOOL near pascal IsEgaVga(void);

#endif









