// dupes.cpp RHS 8/5/91

#include<string.h>
#include"file.h"
#include"dupes.h"


void Dupes::GetData(File *d, long offset)
    {
    d->ReadAt(offset,sizeof(DataBuf),&DataBuf);
    d->ReadAt(DataBuf.dirnameoffset,sizeof(DirName),&DirName);
    DirName.dirname[DirName.dirnamelen] = '\0';
    }

void Dupes::PutData(File *d, void *data)
    {                                       // setup time,date,size 
    memcpy(&DataBuf,data,(sizeof(unsigned)*2)+sizeof(long));
    d->Write(sizeof(DATABUF),&DataBuf);   // write file entry
    }

void Dupes::PutIndex(File *i, char *name, long offset, BYTE status)
    {
    strcpy(OutBuf.buf,name);                // setup index name
    OutBuf.offset = offset;                 // setup index data pointer
    OutBuf.status = status;                 // setup index status
    i->Write(sizeof(OUTBUF),&OutBuf);       // write index entry
    }

int Dupes::GetRecord(void)
    {
    if(IndexFile.Read(sizeof(OutBuf),&OutBuf) != 0)
        {
        GetData(&DataFile,OutBuf.offset);
        return 1;
        }
    return 0;
    }

static char lastdirspec[80];
static long lastdiroffset;

BOOL Dupes::PutDirectory(File *f, char *dirspec, BOOL init)
    {
    if(init)
        {
        lastdirspec[0] = '\0';
        lastdiroffset = 0L;
        }

    if(strcmp(dirspec,lastdirspec))     // if not the same dirspec
        {
        strcpy(lastdirspec,dirspec);
        lastdiroffset = DataBuf.dirnameoffset = f->CurPosition();
        strcpy(DirName.dirname,strupr(lastdirspec));
        DirName.dirnamelen = strlen(DirName.dirname);
        f->Write((DirName.dirnamelen+sizeof(DirName.dirnamelen)),&DirName);
        return TRUE;
        }
    else
        {
        DataBuf.dirnameoffset = lastdiroffset;
        return FALSE;
        }
    }


