{$N+,E+}
PROGRAM Power;
CONST epsilon = 1E-4900;

  FUNCTION Pow(Base, Expo : Extended;
               VAR error  : Boolean) : Extended;

    FUNCTION IsInt(num : Extended) : Boolean;
    BEGIN
      IsInt := ((Abs(Frac(num)) < epsilon) OR
                (1.0 - Abs(Frac(num)) < epsilon)) AND
                (Abs(num) < MaxLongInt);
    END;

    FUNCTION SignFix(num : LongInt) : ShortInt;
    BEGIN
      IF odd(num) THEN SignFix := -1
      ELSE SignFix := 1;
    END;

  BEGIN
    Error := FALSE;
    IF Abs(Base) < epsilon THEN {BASE = 0}
      BEGIN
        Pow := 0;
        Exit;
      END;

    IF Abs(Expo) < epsilon THEN {EXPO = 0}
      BEGIN
        Pow := 1;
        Exit;
      END;

    IF Base > 0 THEN            {BASE positive}
      Pow := Exp(expo * ln(base))
    ELSE
      BEGIN                     {BASE negative}
        IF IsInt(Expo) THEN     {EXPO integer}
          BEGIN
            Pow := Exp(expo * ln(-base)) *
                      SignFix(round(Expo))
          END
        ELSE
          BEGIN                 {EXPO non-integer}
            Error := TRUE;
            Pow := 0;
          END;
      END;
  END;

VAR
  B, E, R : Extended;
  Err : Boolean;
CONST
  isErr : ARRAY[boolean] OF String[7] =
            ('OK     ','*ERROR*');
BEGIN
  WriteLn('Enter 0 for both operands to quit.');
  REPEAT
    Write('Base:'); ReadLn(B);
    Write('Expo:'); ReadLn(E);
    R := Pow(B, E, Err);
    WriteLn(IsErr[Err],'  ',R:30:10);
  UNTIL (B = 0) AND (E = 0);
END.
