/*------------------------------------------------------------------------
   COLORSSCR.C -- View colors (pure, dithered, palette) using scroll bars
                  (c) Charles Petzold, 1990
  ------------------------------------------------------------------------*/

#include <windows.h>
#include <stdlib.h>

long FAR PASCAL WndProc    (HWND, WORD, WORD, LONG) ;
long FAR PASCAL ScrollProc (HWND, WORD, WORD, LONG) ;

FARPROC lpfnOldScr[3] ;
HWND    hwndScrol[3], hwndLabel[3], hwndValue[3], hwndRect ;
short   color[3], nFocus ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     static char szAppName[] = "ColorScr" ;
     static char *szColorLabel[] = { "Red", "Green", "Blue" } ;
     FARPROC     lpfnScrollProc ;
     HWND        hwnd ;
     MSG         msg;
     short       n ;
     WNDCLASS    wndclass ;

     if (!hPrevInstance)
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = NULL ;
          wndclass.lpszMenuName  = NULL ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

     hwnd = CreateWindow (szAppName, "Color Scroll",
                          WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     hwndRect = CreateWindow ("static", NULL,
                              WS_CHILD | WS_VISIBLE | SS_WHITERECT,
                              0, 0, 0, 0,
                              hwnd, 9, hInstance, NULL) ;

     lpfnScrollProc = MakeProcInstance ((FARPROC) ScrollProc, hInstance) ;

     for (n = 0 ; n < 3 ; n++) 
          {
          hwndScrol[n] = CreateWindow ("scrollbar", NULL,
                              WS_CHILD | WS_VISIBLE | WS_TABSTOP | SBS_VERT,
                              0, 0, 0, 0,
                              hwnd, n, hInstance, NULL) ;

          hwndLabel[n] = CreateWindow ("static", szColorLabel[n],
                              WS_CHILD | WS_VISIBLE | SS_CENTER,
                              0, 0, 0, 0,
                              hwnd, n + 3, hInstance, NULL) ;

          hwndValue[n] = CreateWindow ("static", "0",
                              WS_CHILD | WS_VISIBLE | SS_CENTER,
                              0, 0, 0, 0,
                              hwnd, n + 6, hInstance, NULL) ; 

          lpfnOldScr[n] = (FARPROC) GetWindowLong (hwndScrol[n], GWL_WNDPROC) ;
          SetWindowLong (hwndScrol[n], GWL_WNDPROC, (LONG) lpfnScrollProc) ;

          SetScrollRange (hwndScrol[n], SB_CTL, 0, 255, FALSE) ;
          SetScrollPos   (hwndScrol[n], SB_CTL, 0, FALSE) ;
          }

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd);

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage  (&msg) ;
          }
     return msg.wParam ;
     }

long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
     {
     static HBRUSH     hBrushScr[3] ;
     static HPALETTE   hPal ;
     static LOGPALETTE lp ;
     static short      cxClient, cyClient ;
     char              szbuffer[10] ;
     HBRUSH            hBrush ;
     HDC               hdc ;
     PAINTSTRUCT       ps ;
     POINT             point ;
     RECT              rc ;
     short             n, cyChar ;
     TEXTMETRIC        tm ;

     switch (message)
          {
          case WM_CREATE :

                    // Initialize the fields of the LOGPALETTE structure

               lp.palVersion             = 0x300 ;
               lp.palNumEntries          = 1 ;
               lp.palPalEntry[0].peRed   = 0 ;
               lp.palPalEntry[0].peGreen = 0 ;
               lp.palPalEntry[0].peBlue  = 0 ;
               lp.palPalEntry[0].peFlags = 0 ;

                    // Create the logical palette

               hPal = CreatePalette (&lp) ;

               hBrushScr[0] = CreateSolidBrush (RGB (255, 0, 0)) ;
               hBrushScr[1] = CreateSolidBrush (RGB (0, 255, 0)) ;
               hBrushScr[2] = CreateSolidBrush (RGB (0, 0, 255)) ;
               return 0 ;

          case WM_SIZE :
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ;

               hdc = GetDC (hwnd) ;
               GetTextMetrics (hdc, &tm) ;
               cyChar = tm.tmHeight ;
               ReleaseDC (hwnd, hdc) ;

               MoveWindow (hwndRect, 0, 0, cxClient / 2, cyClient, TRUE) ;

               for (n = 0 ; n < 3 ; n++)
                    {
                    MoveWindow (hwndScrol[n],
                         (2 * n + 1) * cxClient / 14, 2 * cyChar,
                         cxClient / 14, cyClient - 4 * cyChar, TRUE) ;

                    MoveWindow (hwndLabel[n],
                         (4 * n + 1) * cxClient / 28, cyChar / 2,
                         cxClient / 7, cyChar, TRUE) ;

                    MoveWindow (hwndValue[n],
                         (4 * n + 1) * cxClient / 28, cyClient - 3 * cyChar / 2,
                         cxClient / 7, cyChar, TRUE) ;
                    }
               SetFocus (hwnd) ;
               return 0 ;

          case WM_SETFOCUS:
               SetFocus (hwndScrol[nFocus]) ;
               return 0 ;

          case WM_VSCROLL :
               n = GetWindowWord (HIWORD (lParam), GWW_ID) ;

               switch (wParam)
                    {
                    case SB_PAGEDOWN :
                         color[n] += 15 ;         // fall through
                    case SB_LINEDOWN :
                         color[n] = min (255, color[n] + 1) ;
                         break ;
                    case SB_PAGEUP :
                         color[n] -= 15 ;         // fall through
                    case SB_LINEUP :
                         color[n] = max (0, color[n] - 1) ;
                         break ;
                    case SB_TOP:
                         color[n] = 0 ;
                         break ;
                    case SB_BOTTOM :
                         color[n] = 255 ;
                         break ;
                    case SB_THUMBPOSITION :
                    case SB_THUMBTRACK :
                         color[n] = LOWORD (lParam) ;
                         break ;
                    default :
                         break ;
                    }

               SetScrollPos  (hwndScrol[n], SB_CTL, color[n], TRUE) ;
               SetWindowText (hwndValue[n], itoa (color[n], szbuffer, 16)) ;
               InvalidateRect (hwnd, NULL, TRUE) ;
               return 0 ;

          case WM_CTLCOLOR:
               if (HIWORD (lParam) == CTLCOLOR_SCROLLBAR)
                    {
                    SetBkColor (wParam, GetSysColor (COLOR_CAPTIONTEXT)) ;
                    SetTextColor (wParam, GetSysColor (COLOR_WINDOWFRAME)) ;

                    n = GetWindowWord (LOWORD (lParam), GWW_ID) ;
                    point.x = point.y = 0 ;
                    ClientToScreen (hwnd, &point) ;
                    UnrealizeObject (hBrushScr[n]) ;
                    SetBrushOrg (wParam, point.x, point.y) ;
                    return ((DWORD) hBrushScr[n]) ;
                    }
               break ;

          case WM_ERASEBKGND:
               return 1 ;

          case WM_PAINT:
               hdc = BeginPaint (hwnd, &ps) ;

               rc.left   = cxClient / 2 ;
               rc.right  = cxClient ;

                         // Display solid color

               rc.top    = 0 ;
               rc.bottom = cyClient / 3 ;

               hBrush = CreateSolidBrush (
                             GetNearestColor (hdc,
                                  RGB (color[0], color[1], color[2]))) ;

               FillRect (hdc, &rc, hBrush) ;
               DeleteObject (hBrush) ;

                         // Display dithered color

               rc.top    = rc.bottom ;
               rc.bottom = 2 * cyClient / 3 ;

               hBrush = CreateSolidBrush (
                             RGB (color[0], color[1], color[2])) ;

               FillRect (hdc, &rc, hBrush) ;
               DeleteObject (hBrush) ;

                         // Display palette color

               lp.palPalEntry[0].peRed   = color[0] ;
               lp.palPalEntry[0].peGreen = color[1] ;
               lp.palPalEntry[0].peBlue  = color[2] ;

               SetPaletteEntries (hPal, 0, 1, lp.palPalEntry) ;
               SelectPalette (hdc, hPal, FALSE) ;
               RealizePalette (hdc) ;

               rc.top    = rc.bottom ;
               rc.bottom = cyClient ;

               hBrush = CreateSolidBrush (PALETTEINDEX (0)) ;

               FillRect (hdc, &rc, hBrush) ;
               DeleteObject (hBrush) ;

               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_QUERYNEWPALETTE:
               hdc = GetDC (hwnd) ;

               SelectPalette (hdc, hPal, FALSE) ;

               if (RealizePalette (hdc) > 0)
                    {
                    ReleaseDC (hwnd, hdc) ;
                    InvalidateRect (hwnd, NULL, FALSE) ;
                    return TRUE ;
                    }
               else
                    {
                    ReleaseDC (hwnd, hdc) ;
                    return FALSE ;
                    }
               break ;

          case WM_PALETTECHANGED:
               if (wParam != hwnd)
                    {
                    hdc = GetDC (hwnd) ;

                    SelectPalette (hdc, hPal, FALSE) ;

                    if (RealizePalette (hdc) > 0)
                         {
                         InvalidateRect (hwnd, NULL, FALSE) ;
                         }

                    ReleaseDC (hwnd, hdc) ;
                    }
               return 0 ;

          case WM_DESTROY:
               DeleteObject (hPal) ;
               for (n = 0 ; n < 3 ; DeleteObject (hBrushScr [n++])) ;
               PostQuitMessage (0) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }

long FAR PASCAL ScrollProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
     {
     short n = GetWindowWord (hwnd, GWW_ID) ;

     switch (message)
          {
          case WM_KEYDOWN:
               if (wParam == VK_TAB)
                    SetFocus (hwndScrol[(n +
                         (GetKeyState (VK_SHIFT) < 0 ? 2 : 1)) % 3]) ;
               break ;

          case WM_SETFOCUS:
               nFocus = n ;
               break ;
          }
     return CallWindowProc (lpfnOldScr[n], hwnd, message, wParam, lParam) ;
     }
