
/*
    TESTDOSX.C --- illustrates use of the DPMI-based
    DOS Extender TINYDOSX to display a message in protected mode.

    Copyright (C) 1990 Ziff Davis Communications
    PC Magazine * Ray Duncan

    Build with Microsoft C 6.0 SMALL MODEL as follows:

          MASM TINYDOSX;
          CL TESTDOSX.C TINYDOSX

    Execute under Windows 3.0 in the DOS Box only!
*/

#include <stdio.h>

unsigned extern pascal InitDosX(void);

main() 
{
    unsigned saveCS, saveDS;

    _asm mov saveCS,cs          ; store real mode CS 
    _asm mov saveDS,ds          ; and DS for display

    printf("\nHello, real mode world! \tCS=%04xh DS=%04xh", 
        saveCS, saveDS);

    if(InitDosX())              // attempt mode switch
    {
        puts("\nDPMI initialization failed.");
        exit(1);
    }

    _asm mov saveCS,cs          ; store protected mode CS
    _asm mov saveDS,ds          ; and DS for display

    printf("\nHello, protected mode world! \tCS=%04xh DS=%04xh\n", 
        saveCS, saveDS);

    _asm mov ah,4ch             ; exit directly to DOS to avoid
    _asm int 21h                ; GP fault in RTL cleanup code
}

