/*
*  PolyChrds.h -- chord constant definitions in the Middle octave 
*                 (Where Middle C is lowest note of octave)
*                 for the poly() function.
*
**********************************/

#define  TEMPO_VAL   2000   /* (change this if too short) */
#define  DURATION    8      /* eigth note chords */

#define  SQ          39     /* single quote ascii value */
#define  CR          13     /* carriage return ascii value */

/* Warning: only use the chords you expect to need, as this takes up memory!
            (6 ints = 12 bytes for each chord) */

static int a_maj[] =
{  TEMPO_VAL, V1| ANAT_M, V2| CSHA_M, V3| ENAT_M, DUR| DURATION, STOP };
static int ash_maj[] =
{  TEMPO_VAL, V1| ASHA_M, V2| DNAT_M, V3| FNAT_M, DUR| DURATION, STOP };
static int b_maj[] =
{  TEMPO_VAL, V1| BNAT_M, V2| DSHA_M, V3| FSHA_M, DUR| DURATION, STOP };
static int c_maj[] =
{  TEMPO_VAL, V1| CNAT_M, V2| ENAT_M, V3| GNAT_M, DUR| DURATION, STOP };
static int csh_maj[] =
{  TEMPO_VAL, V1| CSHA_M, V2| FNAT_M, V3| GSHA_M, DUR| DURATION, STOP };
static int d_maj[] =
{  TEMPO_VAL, V1| DNAT_M, V2| FSHA_M, V3| ANAT_M, DUR| DURATION, STOP };
static int dsh_maj[] =
{  TEMPO_VAL, V1| DSHA_M, V2| GNAT_M, V3| ASHA_M, DUR| DURATION, STOP };
static int e_maj[] =
{  TEMPO_VAL, V1| ENAT_M, V2| GSHA_M, V3| BNAT_M, DUR| DURATION, STOP };
static int f_maj[] =
{  TEMPO_VAL, V1| FNAT_M, V2| ANAT_M, V3| CNAT_M, DUR| DURATION, STOP };
static int fsh_maj[] =
{  TEMPO_VAL, V1| FSHA_M, V2| ASHA_M, V3| CSHA_M, DUR| DURATION, STOP };
static int g_maj[] =
{  TEMPO_VAL, V1| GNAT_M, V2| BNAT_M, V3| DNAT_M, DUR| DURATION, STOP };
static int gsh_maj[] =
{  TEMPO_VAL, V1| GSHA_M, V2| CNAT_M, V3| DSHA_M, DUR| DURATION, STOP };

static int a_min[] =
{  TEMPO_VAL, V1| ANAT_M, V2| CNAT_M, V3| ENAT_M, DUR| DURATION, STOP };
static int ash_min[] =
{  TEMPO_VAL, V1| ASHA_M, V2| CSHA_M, V3| FNAT_M, DUR| DURATION, STOP };
static int b_min[] =
{  TEMPO_VAL, V1| BNAT_M, V2| DNAT_M, V3| FSHA_M, DUR| DURATION, STOP };
static int c_min[] =
{  TEMPO_VAL, V1| CNAT_M, V2| DSHA_M, V3| GNAT_M, DUR| DURATION, STOP };
static int csh_min[] =
{  TEMPO_VAL, V1| CSHA_M, V2| ENAT_M, V3| GSHA_M, DUR| DURATION, STOP };
static int d_min[] =
{  TEMPO_VAL, V1| DNAT_M, V2| FNAT_M, V3| ANAT_M, DUR| DURATION, STOP };
static int dsh_min[] =
{  TEMPO_VAL, V1| DSHA_M, V2| FSHA_M, V3| ASHA_M, DUR| DURATION, STOP };
static int e_min[] =
{  TEMPO_VAL, V1| ENAT_M, V2| GNAT_M, V3| BNAT_M, DUR| DURATION, STOP };
static int f_min[] =
{  TEMPO_VAL, V1| FNAT_M, V2| GSHA_M, V3| CNAT_M, DUR| DURATION, STOP };
static int fsh_min[] =
{  TEMPO_VAL, V1| FSHA_M, V2| ANAT_M, V3| CSHA_M, DUR| DURATION, STOP };
static int g_min[] =
{  TEMPO_VAL, V1| GNAT_M, V2| ASHA_M, V3| DNAT_M, DUR| DURATION, STOP };
static int gsh_min[] =
{  TEMPO_VAL, V1| GSHA_M, V2| BNAT_M, V3| DSHA_M, DUR| DURATION, STOP };

static int a_7[] =
{  TEMPO_VAL, V1| ANAT_M, V2| CSHA_M, V3| GNAT_M, DUR| DURATION, STOP };
static int ash_7[] =
{  TEMPO_VAL, V1| ASHA_M, V2| DNAT_M, V3| GSHA_M, DUR| DURATION, STOP };
static int b_7[] =
{  TEMPO_VAL, V1| BNAT_M, V2| DSHA_M, V3| ANAT_M, DUR| DURATION, STOP };
static int c_7[] =
{  TEMPO_VAL, V1| CNAT_M, V2| ENAT_M, V3| ASHA_M, DUR| DURATION, STOP };
static int csh_7[] =
{  TEMPO_VAL, V1| CSHA_M, V2| FNAT_M, V3| BNAT_M, DUR| DURATION, STOP };
static int d_7[] =
{  TEMPO_VAL, V1| DNAT_M, V2| FSHA_M, V3| CNAT_M, DUR| DURATION, STOP };
static int dsh_7[] =
{  TEMPO_VAL, V1| DSHA_M, V2| GNAT_M, V3| CSHA_M, DUR| DURATION, STOP };
static int e_7[] =
{  TEMPO_VAL, V1| ENAT_M, V2| GSHA_M, V3| DNAT_M, DUR| DURATION, STOP };
static int f_7[] =
{  TEMPO_VAL, V1| FNAT_M, V2| ANAT_M, V3| DSHA_M, DUR| DURATION, STOP };
static int fsh_7[] =
{  TEMPO_VAL, V1| FSHA_M, V2| ASHA_M, V3| ENAT_M, DUR| DURATION, STOP };
static int g_7[] =
{  TEMPO_VAL, V1| GNAT_M, V2| BNAT_M, V3| FNAT_M, DUR| DURATION, STOP };
static int gsh_7[] =
{  TEMPO_VAL, V1| GSHA_M, V2| CNAT_M, V3| FSHA_M, DUR| DURATION, STOP };

static int a_m7[] =
{  TEMPO_VAL, V1| ANAT_M, V2| CNAT_M, V3| GNAT_M, DUR| DURATION, STOP };
static int ash_m7[] =
{  TEMPO_VAL, V1| ASHA_M, V2| CSHA_M, V3| GSHA_M, DUR| DURATION, STOP };
static int b_m7[] =
{  TEMPO_VAL, V1| BNAT_M, V2| DNAT_M, V3| ANAT_M, DUR| DURATION, STOP };
static int c_m7[] =
{  TEMPO_VAL, V1| CNAT_M, V2| DSHA_M, V3| ASHA_M, DUR| DURATION, STOP };
static int csh_m7[] =
{  TEMPO_VAL, V1| CSHA_M, V2| ENAT_M, V3| BNAT_M, DUR| DURATION, STOP };
static int d_m7[] =
{  TEMPO_VAL, V1| DNAT_M, V2| FNAT_M, V3| CNAT_M, DUR| DURATION, STOP };
static int dsh_m7[] =
{  TEMPO_VAL, V1| DSHA_M, V2| FSHA_M, V3| CSHA_M, DUR| DURATION, STOP };
static int e_m7[] =
{  TEMPO_VAL, V1| ENAT_M, V2| GNAT_M, V3| DNAT_M, DUR| DURATION, STOP };
static int f_m7[] =
{  TEMPO_VAL, V1| FNAT_M, V2| GSHA_M, V3| DSHA_M, DUR| DURATION, STOP };
static int fsh_m7[] =
{  TEMPO_VAL, V1| FSHA_M, V2| ANAT_M, V3| ENAT_M, DUR| DURATION, STOP };
static int g_m7[] =
{  TEMPO_VAL, V1| GNAT_M, V2| ASHA_M, V3| FNAT_M, DUR| DURATION, STOP };
static int gsh_m7[] =
{  TEMPO_VAL, V1| GSHA_M, V2| BNAT_M, V3| FSHA_M, DUR| DURATION, STOP };

static int a_dim[] =
{  TEMPO_VAL, V1| ANAT_M, V2| CNAT_M, V3| DSHA_M, DUR| DURATION, STOP };
static int ash_dim[] =
{  TEMPO_VAL, V1| ASHA_M, V2| CSHA_M, V3| ENAT_M, DUR| DURATION, STOP };
static int b_dim[] =
{  TEMPO_VAL, V1| BNAT_M, V2| DNAT_M, V3| FNAT_M, DUR| DURATION, STOP };
static int c_dim[] =
{  TEMPO_VAL, V1| CNAT_M, V2| DSHA_M, V3| FSHA_M, DUR| DURATION, STOP };
static int csh_dim[] =
{  TEMPO_VAL, V1| CSHA_M, V2| ENAT_M, V3| GNAT_M, DUR| DURATION, STOP };
static int d_dim[] =
{  TEMPO_VAL, V1| DNAT_M, V2| FNAT_M, V3| GSHA_M, DUR| DURATION, STOP };
static int dsh_dim[] =
{  TEMPO_VAL, V1| DSHA_M, V2| FSHA_M, V3| ANAT_M, DUR| DURATION, STOP };
static int e_dim[] =
{  TEMPO_VAL, V1| ENAT_M, V2| GNAT_M, V3| ASHA_M, DUR| DURATION, STOP };
static int f_dim[] =
{  TEMPO_VAL, V1| FNAT_M, V2| GSHA_M, V3| BNAT_M, DUR| DURATION, STOP };
static int fsh_dim[] =
{  TEMPO_VAL, V1| FSHA_M, V2| ANAT_M, V3| CNAT_M, DUR| DURATION, STOP };
static int g_dim[] =
{  TEMPO_VAL, V1| GNAT_M, V2| ASHA_M, V3| CSHA_M, DUR| DURATION, STOP };
static int gsh_dim[] =
{  TEMPO_VAL, V1| GSHA_M, V2| BNAT_M, V3| DNAT_M, DUR| DURATION, STOP };

static int a_dim7[] =
{  TEMPO_VAL, V1| ANAT_M, V2| CNAT_M, V3| FSHA_M, DUR| DURATION, STOP };
static int ash_dim7[] =
{  TEMPO_VAL, V1| ASHA_M, V2| CSHA_M, V3| GNAT_M, DUR| DURATION, STOP };
static int b_dim7[] =
{  TEMPO_VAL, V1| BNAT_M, V2| DNAT_M, V3| GSHA_M, DUR| DURATION, STOP };
static int c_dim7[] =
{  TEMPO_VAL, V1| CNAT_M, V2| DSHA_M, V3| ANAT_M, DUR| DURATION, STOP };
static int csh_dim7[] =
{  TEMPO_VAL, V1| CSHA_M, V2| ENAT_M, V3| ASHA_M, DUR| DURATION, STOP };
static int d_dim7[] =
{  TEMPO_VAL, V1| DNAT_M, V2| FNAT_M, V3| BNAT_M, DUR| DURATION, STOP };
static int dsh_dim7[] =
{  TEMPO_VAL, V1| DSHA_M, V2| FSHA_M, V3| CNAT_M, DUR| DURATION, STOP };
static int e_dim7[] =
{  TEMPO_VAL, V1| ENAT_M, V2| GNAT_M, V3| CSHA_M, DUR| DURATION, STOP };
static int f_dim7[] =
{  TEMPO_VAL, V1| FNAT_M, V2| GSHA_M, V3| DNAT_M, DUR| DURATION, STOP };
static int fsh_dim7[] =
{  TEMPO_VAL, V1| FSHA_M, V2| ANAT_M, V3| DSHA_M, DUR| DURATION, STOP };
static int g_dim7[] =
{  TEMPO_VAL, V1| GNAT_M, V2| ASHA_M, V3| ENAT_M, DUR| DURATION, STOP };
static int gsh_dim7[] =
{  TEMPO_VAL, V1| GSHA_M, V2| BNAT_M, V3| FNAT_M, DUR| DURATION, STOP };

