/*
	mouse.h -
	Header file for mouse processes. Adapted from 'The C Gazette' March
	and Summer, 1988. For Microsoft C5.1.
*/

#define	NO_MOUSE		0				/*		No mouse driver found		*/
#define	SHOW			1				/*		Service to show cursor		*/
#define	HIDE			2				/*		Service to hide cursor		*/

#define	LEFT			1				/*		Left button						*/
#define	RIGHT			2				/*		Right button					*/
#define	CENTER		4				/*		Center button					*/

#define	HORIZ			1				/*		Cursor direction				*/
#define	VERT			2

/* Values to OR together for mask */
#define	MOVEMENT		0x01			/* 0000 0001 Any mouse movement	*/
#define	LEFT_DOWN	0x02			/* 0000 0010 Left button pressed	*/
#define	LEFT_UP		0x04			/* 0000 0100 Left button released */
#define	RIGHT_DOWN	0x08			/* 0000 1000 Right button pressed */
#define	RIGHT_UP		0x10			/* 0001 0000 Right button released */
#define	MIDDLE_DOWN	0x20			/* 0010 0000 Middle button pressed */
#define	MIDDLE_UP	0x40			/* 0100 0000 Middle button released */
#define	ANYTHING		0x7f			/* 0111 1111 All the above			*/

typedef struct			/* structure to hold data from mouse interrupt */
	{
	unsigned	what,			/* what happened?			*/
				buttons,		/* button status at event */
				x_pos,		/* X coordinate */
				y_pos,		/* Y coordinate */
				x_mickeys,	/* horizontal mickey count */
				y_mickeys;	/* vertical mickey count */
	} MOUSETRAP;

#define	callMDD	int86(0x33, &inregs, &inregs)

#ifndef MOUSE_LIB

extern int CheckMouse(void);
extern void CloseMouse(void);
extern void DisplayMCursor(int mode);
extern int CheckPosition(int *p_x, int *p_y);
extern int PositionMCursor(int x, int y);
extern void GetPress(int button, int *p_x, int *p_y, int *p_presses);
extern void GetRelease(int button, int *p_x, int *p_y, int *p_presses);
extern void LimitCursor(int direction, int lo, int hi);
extern void GraphicCursor(int hot_x, int hot_y, unsigned far *mask);
extern void TextCursor(int type, unsigned int b1, unsigned int b2);
extern void GetMickeys(int *p_x, int *p_y);
extern void InstallTrap(unsigned mask, unsigned trap_seg, unsigned trap_offset);

extern int far _mouseInstalled;
extern MOUSETRAP far *trap_data;

#endif

