TITLE "Update PCBoard Settings (Password)"

;-----------------------------------------------------------------------
; NOTE: It is not necessary to change your password on the Directory-BBS
;       screen after using this script.  Robocomm will do it for you.
;-----------------------------------------------------------------------

; The numbers on the next lines don't actually do anything.  They are
; only added to increase the readability of the script.  Robocomm
; always numbers parameters in the order they are encountered in
; the file.
PARAMETER 1 "Enter the new password"
PARAMETER 2 "Enter your City and State"
PARAMETER 3 "Business or Data Phone"
PARAMETER 4 "Home or Voice Phone"
PARAMETER 5 "Brand of CPU you are using"

; The following line is not necessary, but will speed up the pop-up
; display on the agenda screen because Robocomm doesn't need to look
; through the rest of the file for PARAMETER lines.
ENDPARAMS

    ; There's no need for a big timeout value here, so set it low
    ; to recover quickly in the event of an line-noise error.
    TIMEOUT 10

    MESSAGE "Changing password"

    ; Send the command to enter the "Write Settings" function.
    WAITFOR "%BBS35%"
    SEND "W|"

    WAITFOR "PASSWORD" FAILURE ERROR
    IF NOT EMPTY "%P1%" SEND "%P1%|%P1%"
    SEND "|"
    SEND "%P2%|"
    SEND "%P3%|"
    SEND "%P4%|"
    SEND "%P5%|"

    ; Send a bunch of <CR> to get through the other prompts
    ; without modifications
    SEND "||||"

    ;Keep an eye out for an error message from PCBoard.
    WHEN "DO NOT MATCH" GOTO ERROR

    ;Wait till we get back to the main board to verify the password change
    WAITFOR "%BBS35%"

    ;Update the password in the BBS database if the parameter was set.
    IF NOT EMPTY "%P1%" PASSWORD "%P1%"

EXIT 0


;------------------------------------------------------------------------------
:ERROR
;------------------------------------------------------------------------------
    MESSAGE "Line noise detected or timeout.  Password not updated!"
    SEND "|||||||"
EXIT 1
