;
TITLE   PTIMER.ASM
;
COMMENT *
        Purpose:        Times and logs external file-transfer protocols.

        Created:        15-APR-1989     V1.00   Richard B. Johnson

        Modified:       20-APR-1989     V1.01   Richard B. Johnson
        Because of numerous complaints that the timing accuracy  was
        not sufficient (it could be off 45 seconds/day). The timer code
        was changed to use the MS-DOS clock so that the timing reflects
        exactly what MS-DOS says. This should be accurate enough because
        this is the time to which the PTIMER time was being compared.
        Now it "looks" 100 percent accurate.

        Modified:       23-APR-1989     V1.02   Richard B. Johnson
        Fixed bug in timing routine (typo) when I subtracted 23 hours
        for a day rather than 24. Re-wrote time-code to make the day-
        rollover correction more obvious.

        Modified:       05-AUG-1989     V1.03   Richard B. Johnson
        Revised baud-rate search routine to properly read the WILDCAT!
        ACTIVITY.LOG because revisions were made by WC! 2.0.
-------------------------------------------------------------------------------
        Users Note:  Found this excellent program on Richards BBS and
        found it serves as a supurb timer for external protocols with
        Telix.  Will no doubt work well with other communications
        programs. Included in this archive are example batch files
        for Telix.  Modify them to meet your own needs. Line 979 of Dick's
        code may be changed to reflect "your" download directory i.e. Telix,
        QModem and so on.  The compiled PTIMER13.COM in this archive is set
        to record transfer results in C:\TELIX\PROTOCOL.LOG  - This is a fine
        utility, enjoy it and drop Dick a note!.     Best Regards,
                                                     John V.  02/18/91

*
IF1
      %OUT [PASS1]
ELSE
      %OUT [PASS2]
ENDIF

VERS    STRUC
        DB      'V1.03'                 ; Set version number here.
VERS    ENDS
;
;       Structure of the data returned from the DOS "find-first" function
;       used to obtain file characteristics.
;
FIL_BUF STRUC
RESV    DB      21 DUP (?)
ATTR    DB      ?                       ; Attribute
FTIM    DW      ?                       ; Time
FDAT    DW      ?                       ; Date
SIZL    DW      ?                       ; Size-low
SIZH    DW      ?                       ; Size-high
PNAME   DB      13 DUP (?)              ; Packed name
FIL_BUF ENDS
;
;       Structure of the BIOS segment.
;
BIOS    SEGMENT AT 40H
COM1    DW      ?                       ; Base address of 1st 8250 UART
COM2    DW      ?                       ; Base address of 2nd 8250 UART
COM3    DW      ?                       ; Base address of 3rd 8250 UART
COM4    DW      ?                       ; Base address of 4th 8250 UART
PRN1    DW      ?                       ; Base address of printer ports
PRN2    DW      ?
PRN3    DW      ?
PRN4    DW      ?
        ORG     06CH
TICKL   DW      ?                       ; Low word of timer-tick
TICKH   DW      ?                       ; High word of timer-tick
        ORG     0F0H
ICA     LABEL   BYTE                    ; Inter-process communication area
RES1    DW      ?
RES2    DW      ?
RES3    DW      ?
CX_SAV  DW      ?                       ; Saved hours/minutes
DX_SAV  DW      ?                       ; Saved seconds
BIOS    ENDS
;
;       Misc. equates.
;
CR      EQU     0DH
LF      EQU     0AH
MS_DOS  EQU     21H                     ; Operating system
FBUF    EQU     80H                     ; Default file-buffer
;
PSEG    SEGMENT PARA PUBLIC 'CODE'
        ASSUME CS:PSEG, DS:PSEG, ES:PSEG, SS:NOTHING
START   EQU     $
        ORG     100H
MAIN    PROC    NEAR
        MOV     SP,OFFSET STACK         ; Put in a safe place
;
;       Immediately get the system time, extract any old time,
;       and save the new value in the ICA.
;
        MOV     AX,2C00H                ; Get the time
        INT     MS_DOS                  ; From DOS
        MOV     WORD PTR [NEW_CX],CX    ; Save the new time locally
        MOV     WORD PTR [NEW_DX],DX    ;  seconds/hundredths

        PUSH    DS                      ; Save the segment
        MOV     AX,BIOS                 ; Pick up BIOS segment
        MOV     DS,AX                   ; Set segment
        ASSUME  DS:BIOS                 ; Tell assembler
        MOV     AX,WORD PTR [CX_SAV]    ; Pick up old time
        MOV     BX,WORD PTR [DX_SAV]    ;   seconds/hundredths
        MOV     WORD PTR [CX_SAV],CX    ; Save new values
        MOV     WORD PTR [DX_SAV],DX    ;   seconds/hundreds
        POP     DS                      ; Restore segment
        ASSUME  DS:PSEG                 ; Tell the assembler
        MOV     WORD PTR [OLD_CX],AX    ; Save old time hour/minutes
        MOV     WORD PTR [OLD_DX],BX    ; Save old time seconds/tenths
;
;       Map the required command-line to upper case and extract the
;       string length.
;
        CALL    MAP_CMD                 ; Map the command-line
        TEST    CX,CX                   ; Check for anything typed
        JNZ     CMD_OK                  ; Was okay
        MOV     DX,OFFSET USAGE         ; Point to usage prompt
        CALL    PROMPT                  ; Write to screen
        JMP     FINIS                   ; Exit
CMD_OK: PUSH    CX                      ; Save characters typed
        CALL    WHEN                    ; Get data/time
        POP     CX                      ; Restore characters typed
        CALL    CHK_CMD                 ; Check commands, extract parameters
        MOV     DI,WORD PTR [STR_ADDR]  ; Get addr. of string we are building
        MOV     SI,OFFSET PRP5          ; The baud-rate
        CALL    COPY
        MOV     AX,WORD PTR [RATE]      ; Pick up the rate
        XOR     DX,DX                   ; Zero high word
        CALL    ASCII                   ; Convert to ASCII
;
;       Calculate the time in seconds from the values contained in:
;       OLD_CX =  [hour] [minutes]              of the starting time.
;       OLD_DX =  [seconds] [hundredths]        of the starting time.
;       NEW_CX =  [hour] [minutes]              of the ending time.
;       NEW_DX =  [seconds] [hundredths]        of the ending time
;
;       To do this accurately, we will convert the ending time of
;       hh:mm:ss to seconds. Then we will convert the starting time of
;       hh:mm:ss to seconds. We will then subtract the two. If midnight
;       has occurred, we will adjust accordingly.
;
        MOV     AX,WORD PTR [NEW_DX]    ; AH = secs, AL = tenths
        MOV     AL,AH                   ; Get seconds
        XOR     AH,AH                   ; Remove tenths
        MOV     WORD PTR [SEC_LO],AX    ; Save the new seconds
        MOV     WORD PTR [SEC_HI],0     ; Zero the high word
        MOV     AX,WORD PTR [NEW_CX]    ; Get new hours/minutes
        MOV     BX,AX                   ; Save
        XOR     AH,AH                   ; Remove hours, keep minutes
        MOV     CX,60                   ; Seconds/minute
        MUL     CX                      ; AX = minutes * 60
        ADD     WORD PTR [SEC_LO],AX    ; Add to accumulator
        ADC     WORD PTR [SEC_HI],0     ; Take care of overflow
        MOV     CX,WORD PTR [OLD_CX]    ; Get old hours/minutes
        CMP     BH,CH                   ; BH = new CH = old
        JNC     DAY_OK                  ; Not a new day
        ADD     BH,24                   ; compensate for new day
;
DAY_OK: MOV     AL,BH                   ; Get hours
        XOR     AH,AH                   ; Remove high byte
        MOV     CX,3600                 ; Seconds/hour
        MUL     CX                      ; DX:AX = seconds
        ADD     WORD PTR [SEC_LO],AX    ; Add to the accumulator
        ADC     WORD PTR [SEC_HI],DX    ; Add the high word
;
        MOV     AX,WORD PTR [OLD_DX]    ; AH = secs, AL = tenths
        MOV     AL,AH                   ; Get seconds
        XOR     AH,AH                   ; Remove tenths
        SUB     WORD PTR [SEC_LO],AX    ; Subtr. the new seconds
        SBB     WORD PTR [SEC_HI],0     ; Take care of carry
        MOV     AX,WORD PTR [OLD_CX]    ; Get new hours/minutes
        MOV     BX,AX                   ; Save
;
        XOR     AH,AH                   ; Remove hours, keep minutes
        MOV     CX,60                   ; Seconds/minute
        MUL     CX                      ; AX = minutes * 60
        SUB     WORD PTR [SEC_LO],AX    ; Subtr accumulator
        SBB     WORD PTR [SEC_HI],0     ; Take care of overflow
        MOV     AL,BH                   ; Get hours
        XOR     AH,AH                   ; Remove high byte
        MOV     CX,3600                 ; Seconds/hour
        MUL     CX                      ; DX:AX = seconds
        SUB     WORD PTR [SEC_LO],AX    ; Subtr the accumulator
        SBB     WORD PTR [SEC_HI],DX    ; Subtr the high word
;
        MOV     AX,WORD PTR [SEC_LO]    ; Get the total seconds
        MOV     WORD PTR [SAV_SEC],AX   ; Save seconds
        TEST    AX,AX                   ; Check for zero
        JNZ     TIMOK                   ; Must protect against div/zero
        INC     WORD PTR [SAV_SEC]      ; Protect against div/zero
;
TIMOK:  MOV     SI,OFFSET PRP6          ; Point to "Seconds"
        CALL    COPY
        XOR     DX,DX
        MOV     AX,WORD PTR [SAV_SEC]   ; Pick up seconds count
        CALL    ASCII
        MOV     SI,OFFSET PRP7          ; Point to 'transmission rate'
        CALL    COPY                    ; Copy the string
        MOV     DX,WORD PTR [TOT_HI]    ; Pick up high word
        MOV     AX,WORD PTR [TOT_LO]    ; Get low word
        DIV     WORD PTR [SAV_SEC]      ; Div by the number of seconds
        XOR     DX,DX                   ; Zero high word
        PUSH    AX                      ; Save 'cps'
        CALL    ASCII                   ; Convert
        MOV     SI,OFFSET PRP8          ; Point to 'efficiency'
        CALL    COPY                    ; Copy the string
        MOV     AX,WORD PTR [RATE]      ; Get baud-rate
        MOV     CX,10                   ; Ten bits/character
        XOR     DX,DX
        DIV     CX                      ; AX = max CPS
        MOV     BX,AX                   ; Save
        POP     AX                      ; Restore 'cps'
        XOR     DX,DX
        MOV     CX,100                  ; For 100 percent
        MUL     CX                      ; DX:AX = 10 times the cps
        DIV     BX                      ; AX = percentage
        XOR     DX,DX                   ; Kill high word
        CALL    ASCII                   ; Write ASCII
        MOV     AL,'%'                  ; Insert percent-sign
        STOSB
        MOV     SI,OFFSET PRP9          ; Point to 'protocol' string
        CALL    COPY                    ; Copy for the record
        MOV     SI,OFFSET PRP10         ; Point to 'port'
        CALL    COPY                    ; Copy to string
        MOV     AX,WORD PTR [PORT]      ; Get comm port
        PUSH    AX                      ; Save port number
        XOR     DX,DX
        CALL    ASCII                   ; Convert
        MOV     SI,OFFSET PRP11         ; Point to 'physical rate'
        CALL    COPY                    ; Copy to destination string
;
;       Get physical baud-rate of communications adapter port.
;
        POP     BX                      ; Restore comm port number
        DEC     BX                      ; COM1 = offset zero
        SHL     BX,1                    ; Index is WORDS (mult * 2)
        PUSH    DS                      ; Save segment
        MOV     AX,BIOS                 ; BIOS address
        MOV     DS,AX                   ; Set segment
        ASSUME  DS:BIOS                 ; Tell assembler
        MOV    DX,WORD PTR DS:[COM1+BX] ; Pick up port address
        POP     DS                      ; Restore segment
        ASSUME  DS:PSEG                 ; Back to original addressing
        ADD     DX,3                    ; Line-control register
        IN      AL,DX                   ; Get UART characteristics
        PUSH    AX                      ; Save for now
        OR      AL,10000000B            ; DLAB
        OUT     DX,AL                   ; Open divisor latch
        SUB     DX,3                    ; Back to base port
        IN      AX,DX                   ; Get divisor (note WORD port)
        MOV     BX,AX                   ; Save
        ADD     DX,3                    ; Back to line-control register
        POP     AX                      ; Restore UART characteristics
        OUT     DX,AL                   ; All fixed
        MOV     AX,2304                 ; Magic number
        XOR     DX,DX
        DIV     BX                      ; The UART divisor
        MOV     BX,50                   ; Lowest baud-rate
        MUL     BX                      ; AX = baud-rate
        CALL    ASCII                   ; Write ASCII
;
        MOV     AX,0A0DH                ; CR/LF backwards
        STOSW
        MOV     WORD PTR [STR_ADDR],DI  ; Location of string-end
        MOV     BYTE PTR [DI],'$'       ; Put in a stopper
        MOV     DX,OFFSET OUT_BUF       ; Point to the buffer
        CALL    PROMPT                  ; Write to screen
        CALL    OPEN_LOG                ; Open the log-file
        CALL    FIND_END                ; Find it's end
        CALL    WRITE_LOG               ; Append new data
        CALL    CLOSE_LOG               ; Close the file
        JMP     FINIS                   ; And exit
MAIN    ENDP
;
;       Get system time and date. Build output string in OUT_BUF.
;
WHEN    PROC    NEAR
        MOV     DI,OFFSET OUT_BUF       ; Set output buffer
        MOV     SI,OFFSET TIMPRP        ; Point to time-prompt
        CALL    COPY
        CALL    GET_DAT                 ; Get the date
        MOV     SI,OFFSET DAYS          ; Point to table of days
        CALL    FINDOFF                 ; AL=day of the week
        CALL    COPY                    ; Write the day
        MOV     AX,'  '
        STOSW
        MOV     AL,DH                   ; Get month
        DEC     AL                      ; Normalize for zeroth month
        MOV     SI,OFFSET MONTHS        ; Point to 'months' table
        CALL    FINDOFF                 ; Find the offset in the table
        CALL    COPY                    ; Store the string
        MOV     AL,DL                   ; Get the day
        PUSH    AX                      ; Save day
        CALL    ASCIIB                  ; Write ASCII
        POP     AX                      ; Restore day
        CMP     AL,10
        JNC     NOTEN                   ; Was the tenth of month or later
        MOV     BYTE PTR [DI-2],' '     ; Blank leading zeros
NOTEN:  MOV     AX,' ,'                 ; Put in delimiters
        STOSW
        SUB     CX,1900                 ; Normalize
        MOV     AL,19
        ADD     AL,CH                   ; If it was year 2000
        CALL    ASCIIB                  ; Write ASCII
        MOV     AL,CL                   ; Get low part
        CALL    ASCIIB                  ; Write ASCII
        MOV     AX,'  '
        STOSW
;       STOSW
        CALL    GET_TIM                 ; Get the time
        MOV     AL,CH                   ; Get hour
        CALL    ASCIIB                  ; Write ASCII
        MOV     AL,':'
        STOSB
;
        MOV     AL,CL                   ; Get minutes
        CALL    ASCIIB                  ; Write ASCII
        MOV     AL,':'
        STOSB
        MOV     AL,DH                   ; Get seconds
        CALL    ASCIIB                  ; Convert to ASCII
        MOV     AL,'.'
        STOSB                           ; Put in the decimal
        MOV     AL,DL                   ; Get hundreds
        CALL    ASCIIB                  ; Convert to ASCII
        MOV     WORD PTR [STR_ADDR],DI  ; Save next address
        RET
WHEN    ENDP
;
FINIS   PROC    NEAR
        MOV     AX,4C00H
        INT     MS_DOS
        JMP     $                       ; Trap for fatal error
FINIS   ENDP
;
;       Map Command-line to upper case and put in buffer BUFFER.
;       CX = Bytes typed upon return.
;
MAP_CMD PROC    NEAR
        MOV     DI,OFFSET BUFFER        ; Where to put the string
        MOV     SI,80H                  ; Get command line
        LODSB                           ; Get bytes typed
        CBW
        MOV     CX,AX                   ; Use as a count
        JCXZ    MAP_EX                  ; No bytes typed
        DEC     CX                      ; Count for the space
        JNZ     MAP_DO                  ; Map command line to upper case
MAP_EX: RET
;
MAP_DO: PUSH    CX                      ; Save the count
        INC     SI                      ; Get past the space or delimiter
MAP_IN: LODSB                           ; Get byte
        CMP     AL,'z'                  ; Check range
        JA      MAP_ST                  ; Not a lower case letter
        CMP     AL,'a'                  ; Check low range
        JB      MAP_ST                  ; Not a lower case letter
        AND     AL,95                   ; Reset lower-case bits
MAP_ST: STOSB
        LOOP    MAP_IN
        MOV     BYTE PTR [DI],CR        ; Terminator
        POP     CX                      ; Restore byte count
        RET
MAP_CMD ENDP
;
;       Search for a substring within a string.
;       Upon entry:
;                    DS:SI = String location
;                       CX = String length
;                       DX = Sub-string location
;                       BX = Sub-string length
;       Upon exit:
;                       ZR if string found
;                    ES:SI =  End of the substring within the string.
SCANS   PROC    NEAR
        PUSH    CX                      ; Save string length
        MOV     DI,DX                   ; Substring location
        MOV     CX,BX                   ; Substring length
        REPZ    CMPSB                   ; Compare strings
        POP     CX                      ; Restore string length
        JZ      SCANSF                  ; Substring was found.
        LOOP    SCANS                   ; Continue for string length
        INC     CX                      ; Make NZ
SCANSF: RET
SCANS   ENDP
;
;       Check the command-line for input parameters.
;
CHK_CMD PROC    NEAR
        MOV     SI,OFFSET BUFFER        ; Point to the buffer
        PUSH    CX                      ; Save string length
        MOV     DX,OFFSET CMD0          ; Check for mode
        MOV     BX,CMD0_LEN
        CALL    SCANS                   ; Scan the string
        POP     CX                      ; Restore the string length
        JNZ     NOCMD4
        CALL    SET_MOD                 ; Set the mode
;
        MOV     SI,OFFSET BUFFER        ; Point to the buffer
        PUSH    CX                      ; Save string length
        MOV     DX,OFFSET CMD1          ; Check for port
        MOV     BX,CMD1_LEN
        CALL    SCANS                   ; Scan the string
        POP     CX                      ; Restore the string length
        JNZ     NOCMD4
        CALL    SET_PRT                 ; Set the port
;
        MOV     SI,OFFSET BUFFER        ; Point to the buffer
        PUSH    CX                      ; Save string length
        MOV     DX,OFFSET CMD2          ; Check for rate
        MOV     BX,CMD2_LEN
        CALL    SCANS                   ; Scan the string
        POP     CX                      ; Restore the string length
        JNZ     NOCMD4
        CALL    SET_RAT                 ; Set the rate
;
        MOV     SI,OFFSET BUFFER        ; Point to the buffer
        PUSH    CX                      ; Save string length
        MOV     DX,OFFSET CMD3          ; Check for filename
        MOV     BX,CMD3_LEN
        CALL    SCANS                   ; Scan the string
        POP     CX                      ; Restore the string length
        JNZ     NOCMD4
        CALL    SET_FIL                 ; Set the files
;
        MOV     SI,OFFSET BUFFER        ; Point to the buffer
        PUSH    CX                      ; Save string length
        MOV     DX,OFFSET CMD4          ; Check for protocol
        MOV     BX,CMD4_LEN
        CALL    SCANS                   ; Scan the string
        POP     CX                      ; Restore the string length
        JNZ     NOCMD4
        CALL    SET_PRO                 ; Set the protocol

        MOV     SI,OFFSET BUFFER        ; Point to the buffer
        PUSH    CX                      ; Save string length
        MOV     DX,OFFSET CMD5          ; Check for filename
        MOV     BX,CMD5_LEN
        CALL    SCANS                   ; Scan the string
        POP     CX                      ; Restore the string length
        JNZ     NOCMD5
        CALL    SET_LOG                 ; Set the log filename
NOCMD5: RET
;
NOCMD4: MOV     DX,OFFSET USAGE
        CALL    PROMPT
        POP     AX                      ; Level stack (not necessary)
        MOV     AX,4C01H                ; ERRORLEVEL=1
        INT     MS_DOS
CHK_CMD ENDP
;
;       Set the timer MODE. The mode is REceive, SEnd, or STart
;       [STR_ADDR] points to the string we are building. Registers are
;       volatile. Register CX is saved.
;
SET_MOD PROC    NEAR
        LODSW                           ; Get parameter
        CMP     AX,'TS'                 ; Start 'ST' backwards
        JNZ     NOSTRT
        POP     AX                      ; Level stack
        POP     AX
        MOV     AX,4C00H                ; Exit to DOS
        INT     MS_DOS                  ; Timer has been set, exit
NOSTRT: CMP     AX,'ES'                 ; Send 'SE' backwards
        JNZ     NOSND
        MOV     DI,WORD PTR [STR_ADDR]  ; Get beginning of string
        MOV     SI,OFFSET PRP0          ; Point to "sending.."
        CALL    COPY                    ; Copy to destination
        MOV     WORD PTR [STR_ADDR],DI  ; Update string end
        RET
;
NOSND:  CMP     AX,'ER'                 ; Receive 'RE' backwards
        JNZ     NOREC
        MOV     DI,WORD PTR [STR_ADDR]  ; Get beginning of string
        MOV     SI,OFFSET PRP1          ; Point to "receiving.."
        CALL    COPY                    ; Copy to destination
        MOV     WORD PTR [STR_ADDR],DI  ; Update string end
        RET
;
NOREC:  MOV     DX,OFFSET USAGE
        CALL    PROMPT
        POP     AX                      ; Level stack
        POP     AX
        MOV     AX,4C01H                ; Exit to DOS, ERRORLEVEL=1
        INT     MS_DOS                  ; Timer has been set, exit
SET_MOD ENDP
;
;       Set the baud-rate.
;       [STR_ADDR] points to the string we are building. Registers are
;       volatile. Register CX is saved.
;
SET_RAT PROC    NEAR
        PUSH    CX                      ; Save counter
        MOV     DI,OFFSET RATE          ; Point to the baud-rate
        CALL    BININ                   ; Convert to binary
        CMP     WORD PTR [RATE],0       ; Is it zero?
        JZ      GET_WC                  ; Yes, must be a WC! board
        POP     CX                      ; Restore counter
        RET                             ; No, okay
;
;       Must be a WC! board, extract the baud-rate from the last record
;       in the file. This should be the current user.
;
GET_WC: MOV     WORD PTR [RATE],2400    ; Set default
        MOV     AX,3D00H                ; Open for reading
        XOR     CX,CX                   ; Normal attributes
        MOV     DX,OFFSET ACTVY         ; Point to activity log
        INT     MS_DOS                  ; Open the file
        JNC     OPN_WC                  ; Open was okay
        POP     CX                      ; Restore count
        RET                             ; And exit
;
;       The file was found okay.
;
OPN_WC: MOV     BX,AX                   ; Save the file handle
        MOV     AX,4202H                ; Move file-pointer to the end
        XOR     DX,DX
        MOV     CX,DX                   ; Offset zero
        INT     MS_DOS                  ; Move the pointer DX:AX is file size
;
        MOV     CX,DX                   ; Get high word (really)
        MOV     DX,AX                   ; Get low word
        MOV     AX,4200H                ; Move file-pointer to beginning +
        SUB     DX,2048                 ;  this offset
        SBB     CX,0                    ; Take care of any overflow
        INT     MS_DOS                  ; Move the pointer CX:DX is file size
;
        MOV     AX,3F00H                ; Read from file
        MOV     CX,2048                 ; Bytes to read
        MOV     DX,OFFSET WC_BUF        ; Point to wildcat buffer
        INT     MS_DOS                  ; Read the file
;
        MOV     AX,3E00H                ; Close the file
        INT     MS_DOS                  ; Close now
;
        MOV     DI,OFFSET WC_BUF + 2048 ; Point to the buffer end
        MOV     CX,2048                 ; Bytes to check
        STD                             ; Backwards!!!
;
SCANF0: PUSH    CX                      ; Save count
        MOV     SI,OFFSET BAUD          ; <<end>> of string to find
        MOV     CX,B_LEN                ; Length of the string
        REPZ    CMPSB                   ; Try to find it
        POP     CX                      ; Restore count
;
        JZ      FOUND                   ; String was found
        LOOP    SCANF0                  ; Continue
        CLD                             ; Forwards
        JMP     SHORT ERROR             ; Bad string
FOUND:  DEC     DI                      ; Back over space
        MOV     AL,' '                  ; Look for next space
        REPNZ   SCASB                   ; Find space
        CLD                             ; Fix direction flag
        JNZ     ERROR                   ; Space was not found
        MOV     SI,DI                   ; One character ahead of the space
        INC     SI                      ; Point to space
        INC     SI                      ; Point to number
        MOV     DI,OFFSET RATE          ; Point to the rate
        CALL    BININ                   ; Convert
ERROR:  POP     CX                      ; Restore count
        RET
SET_RAT ENDP
;
;       Set the comminications adapter port.
;       [STR_ADDR] points to the string we are building. Registers are
;       volatile. Register CX is saved.
;
SET_PRT PROC    NEAR
        MOV     DI,OFFSET PORT          ; Point to  port word
        CALL    BININ                   ; Convert to binary
        CMP     WORD PTR [PORT],0       ; Check lower limit
        JZ      POOR                    ; Poor choice
        CMP     WORD PTR [PORT],4       ; Check upper limit
        JA      POOR                    ; Poor choice
        RET                             ; Its okay
POOR:   MOV     WORD PTR [PORT],1       ; Set default
        RET
SET_PRT ENDP
;
;       Set the protocol.
;       [STR_ADDR] points to the string we are building. Registers are
;       volatile. Register CX is saved.
;
SET_PRO PROC    NEAR
        MOV     DI,OFFSET PROTO         ; Point to the destination string
PRO0:   LODSB                           ; Get the byte
        CMP     AL,'/'                  ; Check for delimiters
        JZ      PRO1
        CMP     AL,' '
        JBE     PRO1
        STOSB                           ; Save byte in string
        JMP     SHORT PRO0
PRO1:   RET
SET_PRO ENDP
;
;       Set the log-file
;       [STR_ADDR] points to the string we are building. Registers are
;       volatile. Register CX is saved.
;
SET_LOG PROC    NEAR
        MOV     DI,OFFSET LOGF          ; Point to the destination string
LOG0:   LODSB                           ; Get the byte
        CMP     AL,'/'                  ; Check for delimiters
        JZ      LOG1
        CMP     AL,' '
        JBE     LOG1
        STOSB                           ; Save byte in string
        JMP     SHORT LOG0
LOG1:   MOV     BYTE PTR [DI],0         ; Convert to ASCIIZ
        RET
SET_LOG ENDP
;
;       Set the file-names and sizes.
;       [STR_ADDR] points to the string we are building. Registers are
;       volatile. Register CX is saved.
;
SET_FIL PROC    NEAR
        PUSH    CX                      ; Save any count
NEWFIL: MOV     DI,OFFSET FNAME         ; Where to put the file-name
NAME0:  LODSB                           ; Get byte
        CMP     AL,' '                  ; End of the name?
        JBE     ENDN
        CMP     AL,'/'
        JZ      ENDN
        STOSB
        JMP     SHORT NAME0
;
ENDN:   MOV     BYTE PTR [DI],0         ; ASCIIZ
        CMP     DI,OFFSET FNAME         ; Did we create another string?
        MOV     DI,WORD PTR [STR_ADDR]  ; Get string address
        JZ      NAME2                   ; No, all done
;
        MOV     DX,OFFSET FNAME         ; Point to the filename
        MOV     AX,4E00H                ; Find filename
        XOR     CX,CX                   ; Normal attributes
        INT     MS_DOS                  ; Get the filename
        JC      NEWFIL                  ; File was not found
;
        PUSH    SI                      ; Save index
        MOV     SI,FBUF.PNAME           ; Point to packed name
        CALL    COPY
;
        MOV     AX,DI                   ; Get present location
        SUB     AX,WORD PTR [STR_ADDR]  ; Calculate present string length
        MOV     CX,15                   ; Length I want
        SUB     CX,AX                   ; CX = bytes to fill
        MOV     AL,' '                  ; Fill byte
        REP     STOSB                   ; File with spaces
;
        MOV     SI,OFFSET PRP3          ; Point to 'bytes'
        CALL    COPY                    ; Copy to string
        MOV     DX,WORD PTR DS:[FBUF.SIZH]
        MOV     AX,WORD PTR DS:[FBUF.SIZL]
        ADD     WORD PTR [TOT_LO],AX    ; Calculate the total bytes
        ADC     WORD PTR [TOT_HI],DX    ; High word also
        CALL    ASCII
        POP     SI
;
;       Nothing is 'clean' when parsing strings!
;
        CMP     BYTE PTR [SI-1],'/'     ; Was the last a delimiter?
        JZ      NAME2                   ; Yes, we are done
        CMP     BYTE PTR [SI-1],CR      ; Was the last a delimiter?
        JZ      NAME2                   ; Yes, we are done
        CMP     BYTE PTR [SI],'/'       ; Is the next a delimiter?
        JZ      NAME2                   ; Yes, we are done
        CMP     BYTE PTR [SI],CR        ; Is the next a delimiter?
        JZ      NAME2                   ; Yes, we are done
        CMP     WORD PTR [SI],'/ '      ; Is the next a delimiter?
        JZ      NAME2                   ; Yes, we are done
;
        PUSH    SI                      ; Save pointer to file-names
        MOV     SI,OFFSET PRP2
        CALL    COPY                    ; Copy the string
        POP     SI                      ; Restore pointer to file-names
;
        MOV     WORD PTR [STR_ADDR],DI  ; Save the address
        JMP     NEWFIL                  ; Continue for more files
;
NAME2:  MOV     SI,OFFSET PRP4          ; Point to 'total'
        CALL    COPY                    ; Copy the string
        MOV     DX,WORD PTR [TOT_HI]    ; The High word
        MOV     AX,WORD PTR [TOT_LO]    ; The low word
        CALL    ASCII                   ; Convert to ASCII
        MOV     WORD PTR [STR_ADDR],DI  ; Save the address
        POP     CX                      ; Restore any count.
        RET                             ; All done
SET_FIL ENDP
;
;       Copy a string addressed by SI to location addressed by DI until
;       a nul is encountered.
;
COPY    PROC    NEAR
        LODSB                           ; Get the byte
        TEST    AL,AL                   ; Check for a nul
        JZ      COPYX                   ; All done
        STOSB                           ; Stash the byte
        JMP     SHORT COPY              ; Do all bytes
COPYX:  RET
COPY    ENDP
;
;       Write a string addressed by DX to the console until a '$'
;
PROMPT  PROC    NEAR
        MOV     AH,9
        INT     MS_DOS
        RET
PROMPT  ENDP
;
; Print double precision number in DX:AX.  All registers destroyed.
; Register DI points to the string being built. Upon exit DI points
; to the next byte in the string.
;
ASCII   PROC    NEAR
        MOV     BP,DI                   ; Save destination string addr
        MOV     SI,0000                 ; eading zero flag
        MOV     CX,3B9AH                ; Get billions
        MOV     BX,0CA00H
        CALL    SUBTR                   ; Subtract them out
        CALL    COMMA                   ; Put in a comma
        MOV     CX,05F5H                ; Get hundred-millions
        MOV     BX,0E100H
        CALL    SUBTR                   ; Subtract them out
        MOV     CX,0098H                ; Get ten-millions
        MOV     BX,9680H
        CALL    SUBTR                   ; Subtract them out
        MOV     CX,000FH                ; Get millions
        MOV     BX,4240H
        CALL    SUBTR                   ; Subtract them out
        CALL    COMMA                   ; Put in a comma
        MOV     CX,0001H                ; Get hundred-thousands
        MOV     BX,86A0H
        CALL    SUBTR                   ; Subtract them out
        MOV     CX,0000H                ; Get ten-thousands
        MOV     BX,2710H
        CALL    SUBTR                   ; Subtract them out
        MOV     CX,0000H                ; Get thousands
        MOV     BX,03E8H
        CALL    SUBTR                   ; Subtract them out
        CALL    COMMA                   ; Put in a comma
        MOV     CX,0000H                ; Get hundreds
        MOV     BX,0064H
        CALL    SUBTR                   ; Subtract them out
        MOV     CX,0000H                ; Get tens
        MOV     BX,000AH
        CALL    SUBTR                   ; Suntract them out
        ADD     AL,'0'                  ; ASCII bias to remainder
        CALL    CON_OUT
        MOV     DI,BP                   ; Restore destination string
        RET
;
SUBTR:   MOV     DI,'0'-1               ; One less than ASCII bias
SUBTR1:  INC     DI                     ; Loop counter
         SUB     AX,BX                  ; DWORD Subtraction
         SBB     DX,CX
         JNB     SUBTR1                 ; Continue
         ADD     AX,BX                  ; One too many, add back
         ADC     DX,CX
         PUSH    AX                     ; Save for now
         MOV     AX,DI                  ; Get count
         CMP     SI,0                   ; Check for bytes written
         JNZ     SUBTR2                 ; No, can't be a leading zero
         CMP     AL,'0'                 ; Is this a zero?
         JZ      SUBTR3                 ; Yes, don't write leading zeros
         INC     SI                     ; No, set flag
SUBTR2:  CALL    CON_OUT
SUBTR3:  POP     AX
         RET
;
COMMA:  CMP     SI,0                    ; Any bytes written?
        JZ      PASS                    ; No, then no commas
        PUSH    AX                      ; Yes, write a comma
        MOV     AL,','
        CALL    CON_OUT
        POP     AX
PASS:   RET
ASCII   ENDP
;
CON_OUT PROC    NEAR
        MOV     DI,BP                   ; Get destination string address
        STOSB                           ; Save the byte
        MOV     BP,DI                   ; Save destination string address
        RET
CON_OUT ENDP
;
;
; Convert ASCII in [SI] to binary word addressed by [DI]
;
BININ   PROC    NEAR
        PUSH    CX                      ; Save any count
        MOV     WORD PTR [DI],0         ; Zero accumulator
        MOV     CX,6                    ; Max byte count
CALC:   LODSB                           ; Get the byte
        XOR     AH,AH
        SUB     AL,'0'                  ; ASCII Bias
        JB      QUIT                    ; All done
        CMP     AL,9                    ; Check upper limit
        JG      QUIT                    ; All done
        PUSH    AX                      ; Save the number
        XOR     DX,DX
        MOV     AX,10                   ; The decimal multiplier
        MUL     WORD PTR [DI]           ; The accumulator
        MOV     WORD PTR [DI],AX        ; Save new accumulator
        POP     AX                      ; Restore the number
        ADD     WORD PTR [DI],AX        ; Accumulate
        LOOP    CALC
QUIT:   POP     CX                      ; Restore count.
        RET
BININ   ENDP
;
; Get system date. Upon exit CX contains years after 1900.
; DL contains the day of the month (1-31), DH contains the month (1 to 12)
; AL contains day of the week (0 to 6) 0 = Sunday.
;
GET_DAT PROC    NEAR                    ; Get system date
        MOV     AH,2AH                  ; Function
        INT     MS_DOS
        RET
GET_DAT ENDP
;
; Upon exit CH contains the hour, CL is the minute, DH is the seconds
; and DL is tenths of seconds.
;
GET_TIM PROC    NEAR                    ; Get system time
        MOV     AH,2CH                  ; Function
        INT     MS_DOS
        RET
GET_TIM ENDP
;
; Upon entry AL contains byte to be converted to ASCII (0 to 99),
; DI points to location to store the two byte ASCII string.
;
ASCIIB  PROC    NEAR
        MOV     AH,'0'-1                ; 00 TO 99 max
SUBT:   INC     AH                      ; Tens counter
        SUB     AL,10                   ; Subtract tens
        JNC     SUBT
        ADD     AL,('0'+10)             ; Too many, add back + ASCII bias
        XCHG    AH,AL                   ; Swap
        STOSW                           ; Store in output string
        RET
ASCIIB  ENDP
;
; Upon entry SI points to the top of the table to be searched.
; AL is the index (AL=0 is top of table). Upon exit SI points to
; the first byte of the string referenced by the table.
;
FINDOFF PROC    NEAR
        PUSH    AX                      ; Save register
        XOR     AH,AH                   ; Zero the high byte
        SHL     AX,1                    ; Times two
        ADD     SI,AX                   ; Add in table offset
        LODSW                           ; Get string address
        MOV     SI,AX                   ;   into index
        POP     AX                      ; Restore
        RET
FINDOFF ENDP
;
;       Open the log-file. If none exists, create one.
;
OPEN_LOG        PROC    NEAR
        MOV     DX,OFFSET LOGF          ; Point to the log-file name
        MOV     AX,3D02H                ; Open for R/W
        XOR     CX,CX                   ; Normal file
        INT     MS_DOS
        JNC     OPNGD                   ; Good open
        MOV     AX,3C00H                ; None exists, create one
        MOV     DX,OFFSET LOGF          ; Point to file-name
        XOR     CX,CX                   ; Normal file
        INT     MS_DOS
OPNGD:  MOV     WORD PTR [LOGCHAN],AX   ; Save 'handle'
        RET
OPEN_LOG        ENDP
;
;       Find the end of the log-file.
;
FIND_END        PROC    NEAR
        MOV     AX,4202H                ; Move to the end
        XOR     CX,CX
        MOV     DX,CX                   ; No offset
        MOV     BX,WORD PTR [LOGCHAN]   ; Get handle
        INT     MS_DOS                  ; Do it.
        RET
FIND_END        ENDP
;
;       Write new data to the log-file.
;
WRITE_LOG       PROC    NEAR
        MOV     AX,4000H                ; Wrint to file
        MOV     DX,OFFSET OUT_BUF       ; Point to the string to be written
        MOV     BX,WORD PTR [LOGCHAN]   ; Handle
        MOV     CX,WORD PTR [STR_ADDR]  ; Last string address + 1
        SUB     CX,DX                   ; DX = first string address
                                        ; CX = total string length
        JCXZ    NOWRT
        INT     MS_DOS
NOWRT:  RET
WRITE_LOG       ENDP
;
;       Close the log-file.
;
CLOSE_LOG       PROC    NEAR
        MOV     AX,3E00H                ; Close the file
        MOV     BX,WORD PTR [LOGCHAN]   ; File access wordd
        INT     MS_DOS
        RET
CLOSE_LOG       ENDP
;
; Variable length data list for days of the week.
;
SUN     DB      'Sunday ',0
MON     DB      'Monday ',0
TUE     DB      'Tuesday ',0
WED     DB      'Wednesday ',0
THR     DB      'Thursday ',0
FRI     DB      'Friday ',0
SAT     DB      'Saturday ',0
;
; Variable length data list for months of the year
;
JAN     DB      'January ',0
FEB     DB      'February ',0
MAR     DB      'March ',0
APR     DB      'April ',0
MAY     DB      'May ',0
JUN     DB      'June ',0
JUL     DB      'July ',0
AUG     DB      'August ',0
SEP     DB      'September ',0
OCT     DB      'October ',0
NOV     DB      'November ',0
_DEC    DB      'December ',0
;
; Lookup table to normalize variable length string locations for indexing.
;
MONTHS  DW      JAN
        DW      FEB
        DW      MAR
        DW      APR
        DW      MAY
        DW      JUN
        DW      JUL
        DW      AUG
        DW      SEP
        DW      OCT
        DW      NOV
        DW      _DEC
;
DAYS    DW      SUN
        DW      MON
        DW      TUE
        DW      WED
        DW      THR
        DW      FRI
        DW      SAT
;
TIMPRP  DB      CR,'+'   ;Was a plus sign which will send your modem to ??
        DB      CR,LF,'                   Date : ',0
PRP0    DB      CR,LF,'        Sending file(s) : ',0
PRP1    DB      CR,LF,'      Receiving file(s) : ',0
PRP2    DB      CR,LF,'                        : ',0
PRP3    DB      'Size : ',0
PRP4    DB      CR,LF,'     Total size (bytes) : ',0
PRP5    DB      CR,LF,'        Baud-rate (bps) : ',0
PRP6    DB      CR,LF,'   Total time (seconds) : ',0
PRP7    DB      CR,LF,'Transmission rate (cps) : ',0
PRP8    DB      CR,LF,'Transmission efficiency : ',0
PRP9    DB      CR,LF,'          Protocol used : '
PROTO   DB      25 DUP (0)
PRP10   DB      CR,LF,'    Communications port : ',0
PRP11   DB      CR,LF,'     Physical baud-rate : ',0
;
B_STR           DB      'baud'
B_LEN           EQU     $ - B_STR
BAUD            EQU     $ - 1
ACTVY           DB      '\WILDCAT\ACTIVITY.LOG',0
LOGF            DB      'C:\TELIX\PROTOCOL.LOG' ;Your default log name & path
                DB      53 DUP (0)              ;change as needed.
LOGCHAN         DW      ?               ; File handle
RATE            DW      ?               ; Baud-rate
PORT            DW      ?               ; Com port
SAV_SEC         DW      ?               ; Time in seconds
SEC_LO          DW      ?               ; Accumulate time in seconds
SEC_HI          DW      ?               ;   the high word
STR_ADDR        DW      OUT_BUF         ; Address of the string to build.
TOT_LO          DW      ?               ; File size totals (low word)
TOT_HI          DW      ?               ; File size totals (high word)
OLD_CX          DW      ?               ; Old hours/minutes
OLD_DX          DW      ?               ; Old seconds/tenths
NEW_CX          DW      ?               ; New hours/minutes
NEW_DX          DW      ?               ; New seconds/tenths
CMD0            DB      '/MODE='        ; Start/Send/Receive
CMD0_LEN        EQU     $ - CMD0
CMD1            DB      '/PORT='        ; Modem port
CMD1_LEN        EQU     $ - CMD1
CMD2            DB      '/RATE='        ; User's baud-rate
CMD2_LEN        EQU     $ - CMD2
CMD3            DB      '/FILE='        ; Some file names
CMD3_LEN        EQU     $ - CMD3
CMD4            DB      '/PROTOCOL='    ; Protocol used
CMD4_LEN        EQU     $ - CMD4
CMD5            DB      'LOGFILE='      ; Logfile to keep
CMD5_LEN        EQU     $ - CMD5
;
USAGE   DB      CR,LF
        DB      'PTIMER '
        VERS    <>
        DB      CR,LF,'Usage:'
        DB      CR,LF
        DB      'PTIMER /MODE={}/PORT={}/RATE={}/PROTOCOL={}/FILE={,,,}'
        DB      CR,LF
        DB      'MODE={STart,SEnd,REceive}'
        DB      CR,LF
        DB      'PORT={1,2,3,4}'
        DB      CR,LF
        DB      'RATE={300,1200,2400,4800,9600,19200}'
        DB      CR,LF
        DB      'PROTOCOL={Name of external protocol}'
        DB      CR,LF
        DB      'FILE={file1.typ file2.typ file3.typ...}'
        DB      CR,LF
        DB      'Note: Do not use "{}" or "," in the command.'
        DB      CR,LF
        DB      'Example(s):'
        DB      CR,LF
        DB      'This command is executed just before'
        DB      ' the external protocol:'
        DB      CR,LF
        DB      'PTIMER /MODE=START'
        DB      CR,LF
        DB      'This command is executed immediately after'
        DB      ' the external protocol:'
        DB      CR,LF
        DB      'PTIMER /MODE=REC/PORT=2/RATE=2400'
        DB      '/PROTOCOL=YMODEM/FILE=SEA.BAD NEW.ZIP OLD.ARC'
        DB      CR,LF
        DB      'The following command is OPTIONAL:'
        DB      CR,LF
        DB      '/LOGFILE={Complete path and file-name for the log.}'
        DB      CR,LF,'$'
;
FNAME           DB      65 DUP (0)
        ORG     (( $ - START ) + 16 ) AND 0FFF0H
                DB      32 DUP ('STACK   ')
STACK   LABEL   WORD
BUFFER  LABEL   BYTE
        ORG     $ + 255
WC_BUF  LABEL   BYTE
        ORG     $ + 2048
OUT_BUF LABEL   BYTE
PSEG    ENDS
        END     MAIN

