#ifndef	mesg_h
#define	mesg_h



/*
 *  Mutex's message code.
 *  All code are > 127.  For 7-bits communication, extra byte(s) is(are)
 *  needed (as a escape sequence).
 */
enum MesgCode {
    MESG_NIL = 128,

    /* for video */
    VIO_NIL = MESG_NIL,
    VIO_FLUSH,
    VIO_WAKE_UP,	VIO_SLEEP,
    VIO_MAX,

    /* for window */
    WIN_NIL = 10000,
    WIN_ACK,
    WIN_CHANGE,
    WIN_CLIPBOARD,
    WIN_CLOSE,
    WIN_END,
    WIN_ENTER,
    WIN_FLUSH,
    WIN_GEOM,
    WIN_HIDE,
    WIN_LEAVE,
    WIN_MOVE,
    WIN_NAK,
    WIN_NORMAL,
    WIN_OPEN,
    WIN_OPEN2,
    WIN_RESIZE,
    WIN_RX_FILE,
    WIN_SHOW,
    WIN_SHOW_COORDS,
    WIN_SHOW_SIZE,
    WIN_SCROLL_UP,
    WIN_SCROLL_DOWN,
    WIN_SCROLL_PG_UP,
    WIN_SCROLL_PG_DOWN,
    WIN_START,
    WIN_TITLE,
    WIN_TX_FILE,
    WIN_ZOOM_H,
    WIN_ZOOM_V,
    WIN_ZOOM,
    WIN_MAX,



    /* for mutex (or mostly term) */
    MX_NIL = 128,
    MX_ACK,
    MX_AT,
    MX_CHANGE,
    MX_CLOSE,
    MX_END,
    MX_END_FILE,
    MX_EOT,
    MX_GEOM,
    MX_NAK,
    MX_OPEN,
    MX_RX_FILE,
    MX_SCR_POS,
    MX_START,
    MX_SYNC,
    MX_TX_FILE,
    MX_USER,
    MX_MAX,

    /* some constants which will not be control code */
    MX_AT2,
    MX_0, MX_1, MX_2, MX_3, MX_4,

    WX_ACK      = (~MX_ACK & 0xFF),
    WX_AT       = (~MX_AT & 0xFF),
    WX_CHANGE   = (~MX_CHANGE & 0xFF),
    WX_CLOSE    = (~MX_CLOSE & 0xFF),
    WX_END      = (~MX_END & 0xFF),
    WX_END_FILE = (~MX_END_FILE & 0xFF),
    WX_EOT      = (~MX_EOT & 0xFF),
    WX_GEOM     = (~MX_GEOM & 0xFF),
    WX_NAK      = (~MX_NAK & 0xFF),
    WX_OPEN     = (~MX_OPEN & 0xFF),
    WX_RX_FILE  = (~MX_RX_FILE & 0xFF),
    WX_SCR_POS  = (~MX_SCR_POS & 0xFF),
    WX_START    = (~MX_START & 0xFF),
    WX_SYNC	= (~MX_SYNC & 0xFF),
    WX_TX_FILE  = (~MX_TX_FILE & 0xFF),
    WX_USER	= (~MX_USER & 0xFF)
};



#ifdef	MUTEX


#define	Mod(a,b)	(((a)+(b))%(b))
#define	MESG_ERR	-32768


class Mesg {
    int head, tail;
    int size;
    int *buf;
    int writable;
    void Create(int);
    //void Clear() {buf = NULL; head = tail = size = 0;}
public:
	/* constructor & destructor */
    Mesg(int);
    Mesg();
    ~Mesg();

	/* small inline functions */
    void	ReadOnly() { writable = 0; }
    int		Resize(int);
    int		Head() { return head; }
    int		Tail() { return tail; }
    int		Size() { return size; }
    int		Empty(){ return head == tail; }
    int		Full() { return Mod(head - tail, size) == 1; }
    int		Length() { return Mod(tail - head, size); }
    int		Peek() { return Empty() ? -1 : buf[head]; }
    int		Index(int);
    int		Nth(int);
    void	AdvanceHead(int n) { head = (head + n) % size; }


	/* Message operation */
    int		Add(const int);
    int		Adds(int, int, int = MESG_ERR, int = MESG_ERR,
			int = MESG_ERR);
    int		Adds(int, int, int, int, int, int, int = MESG_ERR,
			int = MESG_ERR, int = MESG_ERR, int = MESG_ERR);
    char*	AddStr(char *);
    int		Get();
    int		Unget(const int);
    int		Ungets(int, int, int = MESG_ERR, int = MESG_ERR,
			int = MESG_ERR);
    int		Ungets(int, int, int, int, int, int, int = MESG_ERR,
			int = MESG_ERR, int = MESG_ERR, int = MESG_ERR);

    void	operator=(Mesg&);

    Mesg&	operator<<(Mesg&);
    Mesg&	operator>>(Mesg&);

    Mesg&	operator<<(int word);
    Mesg&	operator>>(int& word);
};

	/* Non-member function */
int operator<<(int&, Mesg&);
int operator>>(int word, Mesg&);


#endif



#endif
