/****************************************************************************/
/*   FILE JMODEM_F.C                                                        */
/*   Created 11-JAN-1990                    Richard B. Johnson              */
/*                                          405 Broughton Drive             */
/*                                          Beverly, Massachusetts 01925    */
/*                                          BBS (508) 922-3166              */
/*                                                                          */
/*   screen();         All screen output procedures. Uses INT 10H under     */
/*                     MS-DOS.                                              */
/*                                                                          */
/*   disp();           Displays a "USAGE" message                           */
/*                                                                          */
/*   These routines are absolutely not necessary and could be replaced      */
/*   with _printf() statements. They are used to make the pretty screens    */
/*   and overlapping windows that the PC community has grown to expect.     */
/*                                                                          */
/****************************************************************************/
#define  SCREEN                                  /* For var len param list  */
#include <stdio.h>
#include <dos.h> 
#include <stdlib.h>
#include <string.h>
#include "screen.h"
#include "jmodem.h"

short sav_par[boxes * param];                     /* Save row/columns       */
short *buffer[boxes];                             /* Pointers for  boxes    */
short last_box = 0;                               /* Last box on the screen */
short start_txt;                                  /* Text starts in box     */
short start_row;                                  /* Starting row of box    */
short start_col;                                  /* Starting column of box */
short end_row;                                    /* Ending row of box      */
short end_col;                                    /* Ending column of box   */

byte abrt[]  = "Aborted!";                        /* Five status messages   */
byte okay[]  = "Okay ";
byte retry[] = "Retry";
byte done[]  = "Done!";
byte flow[]  = "Flow ";

char info[] = "Usage:\r\n"\
              "JMODEM R1 filename\r\n"\
              "       ||___ COM port (1..4)\r\n"\
              "       |____ [R]eceive, [S]end\r\n"
              " - or -\r\n"
              "JMODEM R(3F8:4) filename\r\n"
              "       |   | |___ IRQ to use (1..7)\r\n"
              "       |   |_____ absolute port address (hex) \r\n"
              "       |_________ [R]eceive, [S]end\r\n";

byte malfail[] = "Memory allocation failed!";

char *signon[] = {
                 "     J M O D E M",
                 "File transfer protocol",
                 "     "VERS
                 };

char *sta_blk[] = {
                  "   Block :" ,
                  "  Length :" ,
                  "   Bytes :" ,
                  "Rate CPS :" ,
                  "  Status :" ,
                  "Synchronizing ...", 
                  "  Receiving file ",
                  "Transmitting file"
                  };

char *fil_blk[] = {
                  "Opening file ",
                  "Can't open the file!",
                  "Open okay",
                  "File exists, renaming to ",
                  "Can't create the file!",
                  };
/****************************************************************************/
/*                                C O D E                                   */
/****************************************************************************/
void screen (short function, SYS *sys)
{
    union REGS bios;                              /* For int 10H            */
    register const ATTRIB *attr;                  /* For attribute table    */
    register const short *index;                  /* Array pointer          */
    short page;                                   /* Box number             */
    short i;

    bios.x.ax =                                   /* Initialize             */
    bios.x.bx =
    bios.x.cx =
    bios.x.dx = 0;

    attr = attribute + last_box;                  /* Default attribute      */
    switch (function)
    {
        case SCR_SGN:                             /* Sign-on message        */
        {
            page=0;                               /* Box number             */
            kill_curs(&bios);
            attr      = attribute + page;
            index     = box_loc + (page * boxes);
            start_row = *index++;
            start_col = *index++;
            end_row   = *index++;
            end_col   = *index;
            start_txt = start_row + 1;
            set_box (page     ,                   /* Page                   */
                     attr->win,                   /* Screen attribute       */
                     start_row,                   /* Start row              */
                     start_col,                   /* Start column           */
                     end_row  ,                   /* End row                */
                     end_col  ,                   /* End column             */
                     sav_par  ,
                     buffer   ,
                     &bios  );
            for (i = 0; i<3; i++)
            {
                set_curs (start_txt++,start_col + 4,&bios);
                write_str(signon[i],attr->txt,&bios);
            }
            last_box = page;
            break;
        }
    case SCR_FIL:                                 /* File screen            */
        {
            page=1;
            attr      = attribute + page;
            index     = box_loc + (page * boxes);
            start_row = *index++;
            start_col = *index++;
            end_row   = *index++;
            end_col   = *index;
            start_txt = start_row + 1;
            set_box (page     ,                   /* Page                   */
                     attr->win,                   /* Screen attribute       */
                     start_row,                   /* Start row              */
                     start_col,                   /* Start column           */
                     end_row  ,                   /* End row                */
                     end_col  ,                   /* End column             */
                     sav_par  ,
                     buffer   ,
                     &bios  );
            set_curs (start_txt++,start_col + 3,&bios);
            write_str(fil_blk[0],attr->txt,&bios);
            write_str(sys->s_txt,attr->txt,&bios);
            last_box=page;
            break;
        }
    case SCR_FNF:                                 /* File not found         */
        {
            set_curs (start_txt++ ,start_col + 3, &bios);
            write_str(fil_blk[1],attr->txt,&bios);
            break;
        }
    case SCR_FOK:                                 /* File found okay        */
        {
            set_curs (start_txt++, start_col + 3, &bios);
            write_str(fil_blk[2],attr->txt,&bios);
            if (sys)
            {
                strcpy(info,"File size = ");
                ltoa (sys->s_byt,&info[12],10);
                set_curs (start_txt-1, start_col + 38, &bios);
                write_str(info,attr->txt,&bios);
            }
            break;
        }
    case SCR_STA:                                 /* Status block           */
        {
            page      = 2;
            attr      = attribute + page;
            index     = box_loc + (page * boxes);
            start_row = *index++;
            start_col = *index++;
            end_row   = *index++;
            end_col   = *index;
            start_txt = start_row + 1;
            set_box (page     ,                   /* Page                   */
                     attr->win,                   /* Screen attribute       */
                     start_row,                   /* Start row              */
                     start_col,                   /* Start column           */
                     end_row  ,                   /* End row                */
                     end_col  ,                   /* End column             */
                     sav_par  ,
                     buffer   ,
                     &bios  );

            for (i=0; i<6; i++)
            {
                set_curs (start_txt+i,start_col + 4,&bios);
                write_str(sta_blk[i],attr->txt,&bios);
            }
            last_box = page;
            break;
        }
   case SCR_FRN:                                  /* File renamed           */
        {
            set_curs (start_txt++, start_col + 3, &bios);
            write_str(fil_blk[3],attr->txt,&bios);
            write_str(sys->s_txt,attr->txt,&bios);
            break;
        }
   case SCR_FCR:                                  /* File created           */
        {
            set_curs (start_txt++, start_col + 3, &bios);
            write_str(fil_blk[4],attr->txt,&bios);
            break;
        }
   case SCR_SYR:                                  /* Sync receive           */
        {
            start_txt = start_row + 1;
            set_curs (start_txt + 5, start_col + 4, &bios);
            write_str(sta_blk[6],attr->txt | 0x8000 ,&bios);
            break;
        }
   case SCR_SYT:                                  /* Sync transmit          */
        {
            start_txt = start_row + 1;
            set_curs (start_txt + 5, start_col + 4, &bios);
            write_str(sta_blk[7],attr->txt | 0x8000,& bios);
            break;
        }
    case SCR_SYS:
        {
            itoa(sys->s_blk,info,10);             /* Block number           */
            set_curs (start_txt, start_col + 15, &bios);
            write_str(info,attr->txt,& bios);
            memset(info,0x20,0x08);               /* Fixed length string    */
            info[0x07] = 0x00;                    /* Set a null             */
            itoa(sys->s_len,info,10);             /* Block length           */
            *(strchr(info,0x00)) = 0x20;          /* Fill in the NULL       */
            set_curs (start_txt + 1, start_col + 15, &bios);
            write_str(info,attr->txt, &bios);
            ltoa(sys->s_byt,info,10);             /* Total bytes            */
            set_curs (start_txt + 2, start_col + 15, &bios);
            write_str(info,attr->txt, &bios);
            memset(info,0x20,0x08);               /* Fixed length string    */
            info[0x07] = 0x00;                    /* Set a null             */
            itoa(sys->s_cps,info,10);             /* Speed, cps             */
            *(strchr(info,0x00)) = 0x20;          /* Fill in the NULL       */
            set_curs (start_txt + 3, start_col + 15, &bios);
            write_str(info,attr->txt, &bios);
        }                                         /* Fall through, no break */
    case SCR_FLG:
        {
            set_curs (start_txt + 4, start_col + 15, &bios);
            write_str(sys->s_sta,attr->txt, &bios);
            break;
        }
    case SCR_END:
        {
            do
            {
                end_box (last_box, sav_par, buffer, &bios);
            }   while (last_box--);
            restore_curs(&bios);
            break;
        }
    }
    return;
}
/****************************************************************************/
/*  Save screen contents in a buffer obtained from _malloc. Write a border  */
/*  and screen attributes to saved screen location.  Record the address of  */
/*  the buffer so the screen contents may be restored. Global *buffer[] is  */
/*  used to save the pointers.                                              */
/****************************************************************************/
void set_box (short page ,                        /* Box number             */
             word screen,                         /* Screen attribute       */
             short start_row,                     /* Start row of border    */
             short start_col,                     /* Start column of border */
             short end_row,                       /* End row of border      */
             short end_col,                       /* End column of border   */
             register short *sav_par,
             register short *buffer[],
             union REGS *bios)
{
    word putscr;
    short sav_col;
    short sav_row;
    short row;
    short col;
    buffer[page] = (short *)
                   allocate_memory (              /* Get pointer to memory  */
                   ((end_row - start_row)
                  * (end_col - start_col))
                  *  sizeof (short) );
    if (!buffer[page])
        return;

    get_curs(bios);                               /* Get cursor position    */
    sav_row    = (short) bios->h.dh;              /* Save cursor row        */
    sav_col    = (short) bios->h.dl;              /* Save cursor column     */
    sav_par   += (page * param);                  /* Calculate index once   */
    *sav_par++ = screen;
    *sav_par++ = start_row;
    *sav_par++ = start_col;
    *sav_par++ = end_row;
    *sav_par++ = end_col;
    *sav_par++ = sav_row;
    *sav_par   = sav_col;

    for (row = start_row; row < end_row; row++)
    {
        for (col = start_col; col < end_col; col++)
        {
            set_curs (row,col,bios);                   /* Set cursor pos    */
            *buffer[page]++ = get_char_atr(bios);      /* Save char/attr    */
            putscr = screen | 0x20;                    /* default (else)    */
            if (row == start_row || row == end_row-1)  /* Top and bottom    */
                putscr = screen | 205;
            if (col == start_col || col == end_col-1)  /* Right and left    */
                putscr = screen | 186;
            if (row == start_row && col == start_col)  /* NW corner         */
                putscr = screen | 201;
            if (row == start_row && col == end_col-1)  /* NE corner         */
                putscr = screen | 187;
            if (row == end_row-1 && col == start_col)  /* SW corner         */
                putscr = screen | 200;
            if (row == end_row -1 && col == end_col-1) /* SE corner         */
                putscr = screen | 188;
            set_char_atr (putscr,bios);                /* Write to screen   */
        }
    }
    return;
}
/****************************************************************************/
/*  Restore the screen contents saved in memory pointed to by *buffer[].    */
/****************************************************************************/
void end_box (short page,
              register short *sav_par,
              register short *buffer[],
              union REGS  *bios)
{
    short start_row;
    short start_col;
    short end_row;
    short end_col;
    short row;
    short col;
    short sav_row;
    short sav_col;

    sav_par  += (page * param);                   /* Calculate index once   */
    sav_par++;                                    /* Bypass screen entry    */
    start_row = *sav_par++;
    start_col = *sav_par++;
    end_row   = *sav_par++;
    end_col   = *sav_par++;
    sav_row   = *sav_par++;
    sav_col   = *sav_par;

    buffer[page] -= ( (end_row - start_row)       /* Get buffer start       */
               * (end_col - start_col) );

    for (row = start_row; row < end_row; row++)
    {
        for (col = start_col; col < end_col; col++)
        {
            set_curs (row,col,bios);              /* Set cursor pos         */
            set_char_atr(*buffer[page]++,bios);   /* Restore screen         */
        }
    }
    free(buffer[page]);                           /* Free allocated memory  */
    set_curs (sav_row,sav_col,bios);              /* Restore cursor         */
    return;
}
/****************************************************************************/
/*                      Set Cursor to row, column                           */
/****************************************************************************/
void set_curs (short row, short col, register union REGS *bios)
{
    bios->h.ah=(byte) 0x02;                       /* Set cursor function    */
    bios->h.dh=(byte) row;                        /* Row                    */
    bios->h.dl=(byte) col;                        /* Column                 */
    bios->h.bh=(byte) 0x00;                       /* Page 0                 */
    int86(VIDEO, bios, bios);                     /* Use for in and out     */
    return;
}
/****************************************************************************/
/*                          Get the cursor position                         */
/****************************************************************************/
void get_curs(register union REGS *bios)
{
    bios->h.ah=(byte) 0x03;                       /* Get cursor function    */
    bios->h.bh=(byte) 0x00;                       /* Page 0                 */
    int86(VIDEO, bios, bios);                     /* Use for in and out     */
    return;
}
/****************************************************************************/
/*                           Turn off the cursor                            */
/****************************************************************************/
void kill_curs(register union REGS *bios)
{
    bios->h.ah=(byte) 0x01;                       /* Set cursor function    */
    bios->h.bh=(byte) 0x00;                       /* Page 0                 */
    bios->x.cx=(word) 0xFFFF;                     /* Kill the cursor        */
    int86(VIDEO, bios, bios);                     /* Use for in and out     */
    return;
}
/****************************************************************************/
/*                         Restore the cursor type                          */
/****************************************************************************/
void restore_curs(register union REGS *bios)
{
    bios->h.ah=(byte) 0x01;                       /* Get cursor function    */
    bios->h.bh=(byte) 0x00;                       /* Page 0                 */
    bios->x.cx=(word) 0x0607;                     /* Restore the cursor     */
    int86(VIDEO, bios, bios);                     /* Use for in and out     */
    return;
}
/****************************************************************************/
/*                    Write char /attr at cursor position                   */
/****************************************************************************/
void set_char_atr(word atr_chr, register union REGS *bios)
{
    bios->h.ah=(byte) 0x09;                       /* Write char function    */
    bios->h.al=(byte) atr_chr;                    /* Character              */
    bios->h.bl=(byte) (atr_chr >> 8);             /* Attribute              */
    bios->h.bh=(byte) 0x00;                       /* Page 0                 */
    bios->x.cx=1;                                 /* One character          */
    int86(VIDEO, bios, bios);                     /* Use for in and out     */
    return;
}
/****************************************************************************/
/*                   Get char /attr at cursor position                      */
/****************************************************************************/
word get_char_atr(register union REGS *bios)
{
    bios->h.ah=(byte) 0x08;                       /* Read char function     */
    bios->h.bh=(byte) 0x00;                       /* Page 0                 */
    int86(VIDEO, bios, bios);                     /* Use for in and out     */
    return (bios->x.ax);                          /* Its in the AX regis    */
 }
/****************************************************************************/
/*         Write a string with attributes at current position               */
/****************************************************************************/
void write_str(register char *string, word atr, register union REGS *bios)
{
    short row;
    short col;
    while (*string)                               /* Until the NULL         */
    {
        set_char_atr(atr|(short)*string++, bios); /* Write char and attr    */
        get_curs(bios);                           /* Get cursor position    */
        row = (short) bios->h.dh;                 /* Get row                */
        col = (short) bios->h.dl;                 /* Get column             */
        if (col > 69)                             /* Protect window         */
            break;
        set_curs (row,++col,bios);                /* Set column             */
    }
    return;
}
/****************************************************************************/
/*    Substitutes for the enormous _puts (char *) runtime module            */
/*                                                                          */
/****************************************************************************/
int puts(register const char *string)
{
    union REGS bios;
    while (*string)
    {
        bios.h.al=(byte) *string++;               /* Character to print     */
        bios.h.ah=(byte) 0x0E;                    /* Dumb terminal function */
        bios.h.bh=(byte) 0x00;                    /* Page 0                 */
        int86(VIDEO, &bios, &bios);               /* Use for in and out     */
    }
    bios.h.al=(byte) 0x0D;                        /* Character to print     */
    bios.h.ah=(byte) 0x0E;                        /* Dumb terminal function */
    bios.h.bh=(byte) 0x00;                        /* Page 0                 */
    int86(VIDEO, &bios, &bios);                   /* Use for in and out     */

    bios.h.al=(byte) 0x0A;                        /* Character to print     */
    bios.h.ah=(byte) 0x0E;                        /* Dumb terminal function */
    bios.h.bh=(byte) 0x00;                        /* Page 0                 */
    int86(VIDEO, &bios, &bios);                   /* Use for in and out     */
    return(0);
}
/****************************************************************************/
/*                          Print the 'Usage' prompt.                       */
/*    Made complicated so we don't have to use the ENORMOUS _printf()       */
/*    library file.  This saves a lot of space!                             */
/*                                                                          */
/****************************************************************************/
void disp()
{
    puts(signon[2]);
    puts(info);
    return;
}
/****************************************************************************/
/*                       E N D  O F  M O D U L E                            */
/****************************************************************************/
