	SET TTHRU OFF
	LEGEND "Installing VT52 emulation"
;
; ----- Set an emulation, enabling both display and remap
;	commenced: 9/23/92 R.McG
; ----------------------------------------------------------------
;	Note: This script creates the file COM-AND.RMP on the default
;	subdirectory (if no COM-AND= subdir) or on the COM-AND= subdir.
;	An existing COM-AND.RMP is destroyed.
; ----------------------------------------------------------------
;
;	If COM-AND.RMP is on the current subdirectory, use it
;
	S0 = "COM-AND.RMP"		; Default to current subdir
	IF ISFILE S0 GOTO WriteRMP	; Skip if on current subdir
;
;	Construct the file name with the COM-AND= pathing (if provided)
;
	ENVIRON S1 "COM-AND="		; Look for COM-AND= environment var
	IF FOUND			; If environment variable found
	   S1 = S1&""			; Trim trailing blanks
	   LENGTH S1 N0			; Get its length
	   IF N0 GT 0			; If trimmed len > 0
	      IF NOT STRCMP S1(n0-1:n0-1) "\" S1 = S1&"\"
	   ELSE
	      S1 = ""
	      ENDIF
	   S0 = S1&S0			; Concatenate path and name
	   ENDIF
;
;	Open the output file and write the remap
;
WriteRMP:
	S0 = "COM-AND.RMP"
	FOPENO S0 text
	IF FAILED
	   MESS "Cannot open "*S0
	   EXIT
	   ENDIF
	WRITE "^@S^A^@H^C^[[A^@P^C^[[B^@K^C^[[C^@M^C"
	WRITE "^[[D^@G^C^[[H^@O^C^[[K^@v^G^[[H^[[ J^@"
	WRITE "^C^[[M^@w^C^[[L^@n^C^[Oq^@o^C^[Or^@Z^C"
	WRITE "^[Os^@l^C^[Ot^@m^C^[Ou^@X^C^[Ov^@j^C^["
	WRITE "Ow^@k^C^[Ox^@V^C^[Oy^@p^C^[Op^@q^C^[Op"
	WRITE "^@g^B^@q^@h^C^[OP^@i^C^[OQ^@T^C^[OS^@"
	WRITE "U^C^[OT^@a^C^[Om^@b^C^[Ol^@e^C^[OM^@f^C"
	WRITE "^[On"
;
;	Add a remap for F10 (help) if help script is installed
;
	IF ISSC "VT52.HLP"
	   WRITE "^@D^JVT52.HLP^M^@^@" ; The " " is char value 255
	   ENDIF
	FCLOSEO				; Close the file
;
; ----- Enable display emulation and remap
;
	EMULATE VT52			; Display emulation
	SET REMAP ON			; Load new remap file
	EXIT
