@echo off
REM EnviMenu utility to alter attributes on a file

REM CHECK INPUT
if a%1z==az GOTO ATTRMENU_HELP
if NOT a%3z==az GOTO ATTRMENU_HELP
if a%2z==az GOTO ALLFILES
if %1==/? GOTO ATTRMENU_HELP
if %1==/H GOTO ATTRMENU_HELP
if %1==/HELP GOTO ATTRMENU_HELP
if %1==/h GOTO ATTRMENU_HELP
if %1==/help GOTO ATTRMENU_HELP
set INPUT_FILESPEC=%1
set INPUT_ATTR=%2
GOTO PARSE_ATTR

:ALLFILES
set INPUT_FILESPEC=*.*
set INPUT_ATTR=%1
GOTO PARSE_ATTR

:PARSE_ATTR
if %INPUT_ATTR%==+a GOTO PLUSA
if %INPUT_ATTR%==+A GOTO PLUSA
if %INPUT_ATTR%==-a GOTO MINUSA
if %INPUT_ATTR%==-A GOTO MINUSA
if %INPUT_ATTR%==+r GOTO PLUSR
if %INPUT_ATTR%==+R GOTO PLUSR
if %INPUT_ATTR%==-r GOTO MINUSR
if %INPUT_ATTR%==-R GOTO MINUSR
if %INPUT_ATTR%==+s GOTO PLUSS
if %INPUT_ATTR%==+S GOTO PLUSS
if %INPUT_ATTR%==-s GOTO MINUSS
if %INPUT_ATTR%==-S GOTO MINUSS
if %INPUT_ATTR%==+h GOTO PLUSH
if %INPUT_ATTR%==+H GOTO PLUSH
if %INPUT_ATTR%==-h GOTO MINUSH
if %INPUT_ATTR%==-H GOTO MINUSH
echo DO NOT RECOGNIZE ATTRIBUTE; MUST BE +A, -A, +R, -R, +S, -S, +H, or -H
pause
GOTO FINISHED

:PLUSA
set ATTR_LTTR=a
GOTO PLUS
:MINUSA
set ATTR_LTTR=a
GOTO MINUS
:PLUSR
set ATTR_LTTR=r
GOTO PLUS
:MINUSR
set ATTR_LTTR=r
GOTO MINUS
:PLUSS
set ATTR_LTTR=s
GOTO PLUS
:MINUSS
set ATTR_LTTR=s
GOTO MINUS
:PLUSH
set ATTR_LTTR=h
GOTO PLUS
:MINUSH
set ATTR_LTTR=h
GOTO MINUS

:PLUS
set FIND_ATTR=-
set SET_ATTR=+
GOTO LOOPY
:MINUS
set FIND_ATTR=
set SET_ATTR=-
GOTO LOOPY


REM   FINALLY, THIS IS THE MAIN LOOP
set FILECHOICE=
:LOOPY
dir /A-d%FIND_ATTR%%ATTR_LTTR% %INPUT_FILESPEC% /b > FileList.tmp
envimenu FILECHOICE FileList.tmp /Esc /Sort /Prompt "Select file for attribute change (Esc for none)"
if ERRORLEVEL 1 GOTO FINISHED
del FileList.tmp
if %FILECHOICE%==FILELIST.TMP GOTO LOOPY
attrib %SET_ATTR%%ATTR_LTTR% %FILECHOICE%
GOTO LOOPY

:ATTRMENU_HELP
echo 
echo Use the AttrMenu command to interactively display or change a file attribute.
echo 
echo SYNTAX:  AttrMenu [filename] (+ or -)(R or A or S orH)
echo Where:
echo   [filename]      Specifies the file you want to change in current directory
echo   +               Sets an attribute.
echo   -               Cancels an attribute.
echo   R               Sets the read-only attribute.
echo   A               Sets the archive file attribute.
echo   S               Sets the system file attribute.
echo   H               Sets the hidden file attribute.
echo 
echo EXAMPLE: To Selectively set Read-only attribute in this directory
echo     ATTRMENU *.* +r   or  ATTRMENU +r
echo 
pause
GOTO FINISHED

:FINISHED
if exist FileList.tmp del FileList.tmp
set INPUT_FILESPEC=
set INPUT_ATTR=
set ATTR_LTTR=
set FIND_ATTR=
set SET_ATTR=
set FILECHOICE=
cls
