;proper.lex  16-May-91
;INCLUDE file for english.lex

;Copyright (C) 1991, Summer Institute of Linguistics, Inc.
;All rights reserved
;See ENGLEX.DOC for fair use policy.

;edit history
;18-Nov-91	version 0.9
;26-Nov-91	version 1.0

;To enable the entries placed after the END keyword,
;move them before it.

;File Contents
;LEXICON PROPER
; days of the week
; months
; holidays
; planets, stars, zodiac
; computers, programs, and languages
; famous persons, deities and related adjectives
; misc. unique entities
; nationalities, languages, religions
; places and related adjectives
;END
; colleges and universities
; names from Alice in Wonderland
; names from Moby Dick
; books of the Bible


LEXICON PROPER
;days of the week
;pernicious homonyms commented out
`sunday	PN	"PN"
;sun	End	"AB(`sunday)"
`monday	PN	"PN"
mon	End	"AB(`monday)"
`tuesday	PN	"PN"
tues	End	"AB(`tuesday)"
`wednesday	PN	"PN"
;wed	End	"AB(`wednesday)"
`thursday	PN	"PN"
thurs	End	"AB(`thursday)"
`friday	PN	"PN"
fri	End	"AB(`friday)"
`saturday	PN	"PN"
;sat	End	"AB(`saturday)"

;months
`january	PN	"PN"
jan	End	"AB(`january)"
`february	PN	"PN"
feb	End	"AB(`february)"
`march	PN	"PN"
mar	End	"AB(`march)"
`april	PN	"PN"
apr	End	"AB(`april)"
`may	PN	"PN"
`june	PN	"PN"
jun	End	"AB(`june)"
ju`ly	PN	"PN"
jul	End	"AB(ju`ly)"
`august	PN	"PN"
aug	End	"AB(`august)"
sep`tember	PN	"PN"
sept	End	"AB(sep`tember)"
sep	End	"AB(sep`tember)"
oc`tober	PN	"PN"
oct	End	"AB(oc`tober)"
no`vember	PN	"PN"
nov	End	"AB(no`vember)"
de`cember	PN	"PN"
dec	End	"AB(de`cember)"

;holidays
;`advent	PN	"PN"
`chanukah	PN	"PN"
`christmas	PN	"PN"
`christmastide	PN	"PN"
`easter	PN	"PN"
e`piphany	PN	"PN"
hallo`ween	PN	"PN"
`hanukkah	PN	"PN"
`lent	PN	"PN"
`lent	PN	"PN"
`lenten	AJ	"PN(`lent)+AJR30"
`pasch	PN	"PN"
`passover	PN	"PN"
`pentecost	PN	"PN"
`purim	PN	"PN"
`ramadan	PN	"PN"
rosh-hashanah	PN	"PN"
`shavuot	PN	"PN"
`thanksgiving	PN	"PN"
`whitsunday	PN	"PN"
`whitsuntide	PN	"PN"
xmas	PN	"PN" ;christmas
yom-kippur	PN	"PN"
`yule	PN	"PN"
`yuletide	PN	"PN"

;planets, stars, zodiac
an`dromeda	PN	"PN"
`aries	PN	"PN"
au`rora-aus`tralis	PN	"PN"
au`rora-bore`alis	PN	"PN"
a`quarius	PN	"PN"
`betelgeuse	PN	"PN"
`cancer	PN	"PN"
`capricorn	PN	"PN"
cen`taurus	PN	"PN"
`gemini	PN	"PN"
`jupiter	PN	"PN"
`leo	PN	"PN"
`libra	PN	"PN"
`mars	PN	"PN"
`martian	AJ-to-N	"PN(`mars)+AJR4"
`mercury	PN	"PN"
`neptune	PN	"PN"
o`rion	PN	"PN"
`pisces	PN	"PN"
`pluto	PN	"PN"
sagit`tarius	PN	"PN"
`saturn	PN	"PN"
`saturnine	AJ	"PN(`saturn)+AJR38"
`scorpio	PN	"PN"
`sirius	PN	"PN"
`taurus	PN	"PN"
ursa-major	PN	"PN"
ursa-minor	PN	"PN"
u`ranus	PN	"PN"
`venus	PN	"PN"
`virgo	PN	"PN"

;computers, programs, and languages
;some of these are acronyms
`algol	PN	"PN"
`basic	PN	"PN"
`bitnet	PN	"PN"
`cobol	PN	"PN"
dec	AB	"AB"	;digital equipment corp
`emacs	PN	"PN"
`englex	PN	"PN"
`fortran	PN	"PN"
ibm	AB	"AB"	;int'l business machines
`icon	PN	"PN"
`internet	PN	"PN"
ktext	PN	"PN"
`lisp	PN	"PN"
`logo	PN	"PN"
`macintosh	PN	"PN"
pas`cal	PN	"PN"
pc-kimmo	PN	"PN"
`prolog	PN	"PN"
`smalltalk	PN	"PN"
`snobol	PN	"PN"
unix	PN	"PN"
`vax	PN	"PN"
`vaxen	Number	"PN(`vax).PL"

;famous persons, deities and related adjectives
a`chilles	PN	"PN"
`allah	PN	"PN"
`aristotle	PN	"PN"
aristo`telean	AJ-to-N	"PN(`aristotle)+AJR4"
aristo`telian	AJ-to-N	"PN(`aristotle)+AJR4"
au`gustan	AJ	"PN(au`gustus)+AJR4"
`augustine	PN	"PN"
be`elzebub	PN	"PN"
bene`dictine	AJ-to-N	"PN(`benedict)+AJR38"
`bloomfield	PN	"PN"
`brahma	PN	"PN"
`brahman	PN	"PN"
`brahmin	PN	"PN"
`buddha	PN	"PN"
`buddhism	N	"PN(`buddha)+NR8"
`buddhist	N	"PN(`buddha)+NR31"
`calvin	PN	"PN"
`chomsky	PN	"PN"
`christ	PN	"PN"
`christendom	N_Suffix1a	"PN(`christ)+NR2"
co`lumbus	PN	"PN"
co`lumbian	AJ	"PN(co`lumbus)+AJR4"
con`fucius	PN	"PN"
con`fucian	AJ-to-N	"PN(con`fucius)+AJR4"
co`pernicus	PN	"PN"
co`pernican	AJ	"PN(co`pernicus)+AJR4"
`darwin	PN	"PN"
dio`nysus	PN	"PN"
dio`nysian	AJ-to-N	"PN(dio`nysus)+AJR4"
ed`wardian	AJ-to-N	"PN(`edward)+AJR4"
`einstein	PN	"PN"
eliza`bethan	AJ-to-N	"PN(e`lizabeth)+AJR4"
eu`clidean	AJ	"PN(`euclid)+AJR4"
fran`ciscan	AJ-to-N	"PN(`francis)+AJR4"
`freud	PN	"PN"
`hercules	PN	"PN"
hercu`lean	AJ	"PN(`hercules)+AJR4"
je`hovah	PN	"PN"
`jesus	PN	"PN"
`jung	PN	"PN"
`krishna	PN	"PN"
`lenin	PN	"PN"
`lucifer	PN	"PN"
`luther	PN	"PN"
`marx	PN	"PN"
mo`hammed	PN	"PN"
m`hammad	PN	"PN"
na`poleon	PN	"PN"
`newton	PN	"PN"
`plato	PN	"PN"
pla`tonic	AJ_ic	"PN(`plato)+AJR20"
`platonism	N	"PN(`plato)+NR8"
`platonist	N	"PN(`plato)+NR31"
pythago`rean	AJ	"PN(py`thagoras)+AJR4"
`santa-claus	PN	"PN"
`satan	PN	"PN"
`shakespeare	PN	"PN"
`siva	PN	"PN"
`shiva	PN	"PN"
`socrates	PN	"PN"
soc`ratic	AJ-to-N	"PN(`socrates)+AJR20"
vic`torian	AJ-to-N	"PN(vic`toria)+AJR4"
`vishnu	PN	"PN"
zoro`astrian	AJ-to-N	"PN(`zoroaster)+AJR4"

;misc. unique entities
ko`ran	N	"N"
qur'an	N	"N"
ku-klux-klan	N	"N"
`talmud	N	"N"
to`rah	N	"N"
`veda	N	"N"
`vedic	AJ	"N(`veda)+AJR20"

;nationalities, languages, religions
`afghan	PN	"PN"
al`gonquian	PN	"PN"
al`gonquin	PN	"PN"
`anabaptist	PN	"PN"
`anglo	PN	"N"
`arab	PN	"PN"
;`arabic	AJ-to-N	"PN+AJR20"
`aryan	AJ-to-N	"AJ"
atha`bascan	PN	"PN"
`aztec	PN	"PN"
a`pache	PN	"PN"
ba`ha'i	PN	"PN"
`baptist	PN	"PN"
`basque	PN	"PN"
`bedouin	PN	"PN"
`beduin	PN	"PN"
`british	AJ	"AJ"
`briton	PN	"PN"
`cajun	PN	"PN"
`celt	PN	"PN"
`cherokee	PN	"PN"
cheyenne	PN	"PN"
chi`cano	PN	"PN"
choctaw	PN	"PN"
co`manche	PN	"PN"
`creole	PN	"PN"
`croat	PN	"PN"
`czech	PN	"PN"
czecho`slovak	AJ	"AJ"
`dane	PN	"PN"
`danish	AJ-to-N	"AJ"
`dutch	AJ-to-N	"AJ"
`english	AJ-to-N	"AJ"
`eskimo	PN	"PN"
fili`pina	PN	"PN"
fili`pino	AJ-to-N	"AJ"
`finn	PN	"PN"
;`finnish	PN	"PN"
finno-`ugric	AJ-to-N	"AJ"
`frank	PN	"PN"
`french	AJ-to-N	"AJ"
`german	AJ-to-N	"AJ"
`greek	AJ-to-N	"AJ"
`hebrew	AJ-to-N	"AJ"
he`braic	AJ	"AJ"
`hellene	PN	"PN"
`hindu	PN	"PN"
his`panic	AJ-to-N	"PN"
`inca	PN	"PN"
indo-euro`pean	AJ-to-N	"AJ"
`irish	AJ-to-N	"AJ"
`iroquois	PN	"PN"
`islam	PN	"PN"
`jain	PN	"PN"
`jew	PN	"PN"
`jewry	PN	"PN(`jew)+NR3"
ju`daic	AJ_ic	"AJ"
`judaism	PN	"PN"
`kiowa	PN	"PN"
`kurd	PN	"PN"
`latin	AJ-to-N	"AJ"
`latinate	AJ	"PN(`latin)+AJR24"
la`tino	PN	"PN"
`maori	PN	"PN"
ma`lay	PN	"PN"
`manx	AJ-to-N	"AJ" ;isle of man
`maya	PN	"PN"
`mennonite	PN	"PN"
;`methodism	PN	"PN"
;`methodist	PN	"PN"
`mohawk	PN	"PN"
`mongol	PN	"PN"
`mongoloid	AJ-to-N	"PN(`mongol)+NR53"
`moslem	PN	"PN"
`muslim	PN	"PN"
`navajo	PN	"PN"
naza`rene	PN	"PN"
`nazi	PN	"PN"
;nazism	PN	"PN"
`norman	AJ-to-N	"AJ"
`norse	PN	"PN.SG/PL"
`philistine	N-to-AJ	"PN"
pili`pino	PN	"PN"
`pole	PN	"PN"
`sanskrit	PN	"PN"
`saxon	PN	"PN"
`scot	PN	"PN"
`scots	AJ	"AJ"
`scotch	AJ	"AJ"
`serb	PN	"PN"
`shinto	PN	"PN"
`sioux	PN	"PN"
`slav	PN	"PN"
;`slavic	PN	"PN"
`spaniard	PN	"PN"
`spanish	AJ-to-N	"AJ"
swa`hili	PN	"PN"
`swede	PN	"PN"
;`swedish	PN	"PN"
`swiss	AJ-to-N	"AJ"
ta`galog	PN	"PN"
`tao	PN	"PN"
;`taoist	PN	"PN"
`teuton	PN	"PN"
`welsh	AJ-to-N	"AJ"
`yiddish	AJ-to-N	"AJ"

;places and related adjectives
;these first entries assume preprocessing e.g. to convert
;"baton rouge" to "baton-rouge"
baton-rouge	PN	"PN"
corpus-christi	PN	"PN" ;also a holy day
des-moines	PN	"PN"
el-paso	PN	"PN"
el-salvadore	PN	"PN"
san-salvadore	PN	"PN"
las-vegas	PN	"PN"
los-angeles	PN	"PN"
nova-scotia	PN	"PN"
puerto-rico	PN	"PN"
san-antonio	PN	"PN"
san-diego	PN	"PN"
san-francisco	PN	"PN"
san-jose	PN	"PN"
santa-ana	PN	"PN"
burkina-faso	PN	"PN"
costa-rica	PN	"PN"
cote-d'ivoire	PN	"PN"
sierra-leone	PN	"PN"
sri-lanka	PN	"PN"
cape-verde	PN	"PN"

`abidjan	PN	"PN"
adi`rondack	PN	"PN"
adri`atic	PN	"PN"
ae`gean	PN	"PN"
af`ghanistan	PN	"PN"
`africa	PN	"PN"
`african	AJ-to-N	"PN(`africa)+AJR4"
ala`bama	PN	"PN"
ala`baman	AJ-to-N	"PN(ala`bama)+AJR4"
ala`bamian	AJ-to-N	"PN(ala`bama)+AJR4"
a`laska	PN	"PN"
a`laskan	AJ-to-N	"PN(a`laska)+AJR4"
al`bania	PN	"PN"
al`banian	AJ-to-N	"PN(al`bania)+AJR4"
`albany	PN	"PN"
al`berta	PN	"PN"
`albuquerque	PN	"PN"
alex`andria	PN	"PN"
al`geria	PN	"PN"
al`gerian	AJ-to-N	"PN(al`geria)+AJR4"
al`giers	PN	"PN"
`allegheny	PN	"PN"
`alps	PN	"PN.PL"
al`sace	PN	"PN"
al`satian	AJ-to-N	"PN(al`sace)+AJR4"
`amazon	PN	"PN"
a`merica	PN	"PN"
a`merican	AJ-to-N	"PN(a`merica)+AJR4"
ameri`cana	PN	"PN(a`merica)+NR36"
am`man	PN	"PN"
`amsterdam	PN	"PN"
`andean	AJ	"PN(`andes)+AJR4"
`andes	PN	"PN"
an`gola	PN	"PN"
`ankara	PN	"PN"
an`napolis	PN	"PN"
ant`arctic	AJ	"AJ"
ant`arctica	PN	"PN"
an`tietam	PN	"PN"
an`tigua	PN	"PN"
an`tilles	PN	"PN"
appa`lachia	PN	"PN"
appa`lachian	AJ-to-N	"PN(appa`lachia)+AJR4"
a`rabia	PN	"PN"
a`rabian	AJ-to-N	"PN(a`rabia)+AJR4"
argen`tina	PN	"PN"
argen`tinian	AJ-to-N	"PN(argen`tina)+AJR4"
ari`zona	PN	"PN"
ari`zonan	AJ-to-N	"PN(ari`zona)+AJR4"
ar`kansan	AJ-to-N	"PN(`arkansas)+AJR4"
`arkansas	PN	"PN"
arma`geddon	PN	"PN"
ar`menia	PN	"PN"
ar`menian	AJ-to-N	"PN(ar`menia)+AJR4"
`asia	PN	"PN"
`asian	AJ-to-N	"PN(`asia)+AJR4"
asi`atic	AJ	"PN(`asia)+AJR20"
as`syria	PN	"PN"
as`syrian	AJ-to-N	"PN(as`syria)+AJR4"
a`thenian	AJ-to-N	"PN(`athens)+AJR4"
`athens	PN	"PN"
at`lanta	PN	"PN"
at`lantic	AJ-to-N	"AJ"
at`lantis	PN	"PN"
au`gusta	PN	"PN"
`auschwitz	PN	"PN"
`austin	PN	"PN"
aus`tralia	PN	"PN"
aus`tralian	AJ-to-N	"PN(aus`tralia)+AJR4"
`austria	PN	"PN"
`austrian	AJ-to-N	"PN(`austria)+AJR4"
`azerbaijan	PN	"PN"
`azore	PN	"PN"
`babel	PN	"PN"
`babylon	PN	"PN"
`baghdad	PN	"PN"
ba`hamas	PN	"PN"
ba`hamian	AJ-to-N	"PN(ba`hama)+AJR4"
bah`rain	PN	"PN"
`bali	PN	"PN"
bali`nese	AJ-to-N	"PN(`bali)+AJR3"
`balkan	PN	"PN"
`baltic	PN	"PN"
`baltimore	PN	"PN"
`bangkok	PN	"PN"
bangla`desh	PN	"PN"
`barbados	PN	"PN"
barce`lona	PN	"PN"
ba`varia	PN	"PN"
ba`varian	AJ-to-N	"PN(ba`varia)+AJR4"
bei`jing	PN	"PN"
bei`rut	PN	"PN"
`belfast	PN	"PN"
`belgian	AJ-to-N	"PN(`belgium)+AJR4"
`belgium	PN	"PN"
`belgrade	PN	"PN"
be`lize	PN	"PN"
`bengal	PN	"PN"
be`nin	PN	"PN"
`berkeley	PN	"PN"
`berkshire	PN	"PN"
ber`lin	PN	"PN"
ber`liner	PN	"PN(ber`lin)+NR11"
ber`muda	PN	"PN"
`bern	PN	"PN"
beth`esda	PN	"PN"
`bethlehem	PN	"PN"
`birmingham	PN	"PN"
`bismarck	PN	"PN"
bhu`tan	PN	"PN"
bogo`ta	PN	"PN"
bo`hemia	PN	"PN"
bo`hemian	AJ-to-N	"PN(bo`hemia)+AJR4"
`boise	PN	"PN"
bo`livia	PN	"PN"
bo`livian	AJ-to-N	"PN(bo`livia)+AJR4"
bo`logna	PN	"PN"
bom`bay	PN	"PN"
`bonn	PN	"PN"
`borneo	PN	"PN"
`boston	PN	"PN"
bots`wana	PN	"PN"
bra`silia	PN	"PN"
bra`zil	PN	"PN"
bra`zilian	AJ-to-N	"PN(bra`zil)+AJR4"
`brazzaville	PN	"PN"
`brisbane	PN	"PN"
`britain	PN	"PN"
bri`tannic	AJ	"PN(`britain)+AJR20"
`brittany	PN	"PN"
`broadway	PN	"PN"
`bronx	PN	"PN"
`brooklyn	PN	"PN"
bru`nei	PN	"PN"
`brunswick	PN	"PN"
`brussels	PN	"PN"
`bucharest	PN	"PN"
`budapest	PN	"PN"
bul`garia	PN	"PN"
bul`garian	AJ-to-N	"PN(bul`garian)+AJR4"
`burlington	PN	"PN"
`burma	PN	"PN"
bur`mese	AJ-to-N	"PN(`burma)+AJR3"
bu`rundi	PN	"PN"
byelo`russia	PN	"PN"
`byzantine	AJ	"PN(by`zantium)+AJR38"
by`zantium	PN	"PN"
`cairo	PN	"PN"
cal`cutta	PN	"PN"
`calgary	PN	"PN"
cali`fornia	PN	"PN"
cali`fornian	AJ-to-N	"PN(cali`fornia)+AJR4"
`cameroon	PN	"PN"
cam`bodia	PN	"PN"
cam`bodian	AJ-to-N	"PN(cam`bodia)+AJR4"
`cambridge	PN	"PN"
`camelot	PN	"PN"
`canaan	PN	"PN"
`canada	PN	"PN"
ca`nadian	AJ-to-N	"PN(`canada)+AJR4"
`canberra	PN	"PN"
`canterbury	PN	"PN"
`canton	PN	"PN"
`capetown	PN	"PN"
capis`trano	PN	"PN"
ca`racas	PN	"PN"
ca`ribbean	PN	"PN"
caro`lina	PN	"PN"
`carthage	PN	"PN"
cartha`ginian	AJ-to-N	"PN(`carthage)+AJR4"
`caspian	PN	"PN"
`catskill	PN	"PN"
cau`casian	AJ-to-N	"PN(`caucasus)+AJR4"
cey`lon	PN	"PN"
`chad	PN	"PN"
`charleston	PN	"PN"
`charlotte	PN	"PN"
`chesapeake	PN	"PN"
chi`cago	PN	"PN"
`chile	PN	"PN"
;chilean	AJ-to-N	"PN+AJR4"
`china	PN	"PN"
chi`nese	AJ-to-N	"PN(`china)+AJR3"
cincin`nati	PN	"PN"
`cleveland	PN	"PN"
co`lombia	PN	"PN"
co`lombian	AJ-to-N	"PN(co`lombia)+AJR4"
colo`rado	PN	"PN"
co`lumbia	PN	"PN"
`congo	PN	"PN"
congo`lese	AJ-to-N	"PN(`congo)+AJR3"
con`necticut	PN	"PN"
constanti`nople	PN	"PN"
`copenhagen	PN	"PN"
`corinth	PN	"PN"
;corinthian	AJ-to-N	"PN+AJR4"
`crete	PN	"PN"
cro`atia	PN	"PN"
cro`atian	AJ-to-N	"PN(cro`atia)+AJR4"
`cuba	PN	"PN"
`cuban	AJ-to-N	"PN(`cuba)+AJR4"
`cyprian	AJ-to-N	"PN(`cyprus)+AJR4"
`cypriot	PN	"PN"
`cyprus	PN	"PN"
`czech	PN	"PN"
czechoslo`vakia	PN	"PN"
czechoslo`vakian	AJ-to-N	"PN(czechoslo`vakia)+AJR4"
da`kota	PN	"PN"
`dallas	PN	"PN"
da`mascus	PN	"PN"
`danube	PN	"PN"
;danubian	AJ	"PN+AJR4"
`delaware	PN	"PN"
`delhi	PN	"PN"
`delphi	PN	"PN"
`delphic	AJ_ic	"PN(`delphi)+AJR20"
`denmark	PN	"PN"
`denver	PN	"PN"
de`troit	PN	"PN"
`dixie	PN	"PN"
`dixieland	PN	"PN"
dja`karta	PN	"PN"
dji`bouti	PN	"PN"
do`minica	PN	"PN"
`dover	PN	"PN"
`dublin	PN	"PN"
`dubliner	PN	"PN(`dublin)+NR11"
`ecuador	PN	"PN"
`eden	PN	"PN"
`edinburgh	PN	"PN"
`egypt	PN	"PN"
;egyptian	AJ-to-N	"PN+AJR4"
`england	PN	"PN"
e`phesian	AJ-to-N	"PN(`ephesus)+AJR4"
`ephesus	PN	"PN"
`essex	PN	"PN"
es`tonia	PN	"PN"
es`tonian	AJ-to-N	"PN(es`tonia)+AJR4"
ethi`opia	PN	"PN"
ethi`opian	AJ-to-N	"PN(ethi`opia)+AJR4"
eu`phrates	PN	"PN"
eu`rasia	PN	"PN"
`europe	PN	"PN"
`everglades	PN	"PN"
`fargo	PN	"PN"
`fiji	PN	"PN"
`finland	PN	"PN"
`flemish	AJ	"AJ"
`florence	PN	"PN"
`florentine	AJ	"PN(`florence)+AJR38"
`florida	PN	"PN"
flo`ridian	AJ-to-N	"PN(`florida)+AJR4"
for`mosa	PN	"PN"
for`mosan	AJ-to-N	"PN(for`mosa)+AJR4"
`france	PN	"PN"
fran`cisco	PN	"PN"
`frankfurt	PN	"PN"
`fuji	PN	"PN"
ga`bon	PN	"PN"
`gael	PN	"PN"
ga`lapagos	PN	"PN"
`galilee	PN	"PN"
gali`laean	AJ-to-N	"PN(`galilee)+AJR4"
`galveston	PN	"PN"
`gambia	PN	"PN"
`gambian	AJ-to-N	"PN(`gambia)+AJR4"
`ganges	PN	"PN"
`gaza	PN	"PN"
ge`neva	PN	"PN"
`georgia	PN	"PN"
`georgian	AJ-to-N	"PN(`georgia)+AJR4"
`germany	PN	"PN"
`gettysburg	PN	"PN"
`ghana	PN	"PN"
`ghanian	AJ-to-N	"PN(`ghana)+AJR4"
gib`raltar	PN	"PN"
`golan	PN	"PN"
`grecian	AJ-to-N	"PN(`greece)+AJR4"
gre`nada	PN	"PN"
`greece	PN	"PN"
`greenland	PN	"PN"
`greenwich	PN	"PN"
`guam	PN	"PN"
guade`lupe	PN	"PN"
guan`tanamo	PN	"PN"
guate`mala	PN	"PN"
`guinea	PN	"PN"
guy`ana	PN	"PN"
`hague	PN	"PN"
`haifa	PN	"PN"
`haiti	PN	"PN"
`haitian	AJ-to-N	"PN(`haiti)+AJR4"
`halifax	PN	"PN"
`hamburg	PN	"PN"
`hampshire	PN	"PN"
ha`noi	PN	"PN"
`harrisburg	PN	"PN"
`hartford	PN	"PN"
`hatteras	PN	"PN"
ha`vana	PN	"PN"
ha`waii	PN	"PN"
;hawaiian	PN	"PN"
he`lena	PN	"PN"
`helsinki	PN	"PN"
hima`laya	PN	"PN"
hi`roshima	PN	"PN"
`holland	PN	"PN"
`hollywood	PN	"PN"
hon`duras	PN	"PN"
hono`lulu	PN	"PN"
`houston	PN	"PN"
`hungary	PN	"PN"
i`beria	PN	"PN"
i`berian	AJ-to-N	"PN(i`beria)+AJR4"
`iceland	PN	"PN"
;icelandic	PN	"PN"
`idaho	PN	"PN"
illi`nois	PN	"PN"
`india	PN	"PN"
`indian	AJ-to-N	"PN(`india)+AJR4"
indi`ana	PN	"PN"
indian`apolis	PN	"PN"
`indies	PN	"PN"
indo`china	PN	"PN"
indochi`nese	AJ-to-N	"PN(indo`china)+AJR3"
indo`nesia	PN	"PN"
indo`nesian	AJ-to-N	"PN(indo`nesia)+AJR4"
`iowa	PN	"PN"
`iowan	AJ-to-N	"PN(`iowa)+AJR4"
i`ran	PN	"PN"
;iranian	PN	"PN"
i`raq	PN	"PN"
;i`raqi	PN	"PN"
`ireland	PN	"PN"
is`lamabad	PN	"PN"
`israel	PN	"PN"
`israelite	PN	"PN"
`istanbul	PN	"PN"
`italy	PN	"PN"
`jackson	PN	"PN"
ja`karta	PN	"PN"
ja`maica	PN	"PN"
ja`maican	AJ-to-N	"PN(ja`maica)+AJR4"
ja`pan	PN	"PN"
japan`ese	AJ-to-N	"PN(ja`pan)+AJR3"
`java	PN	"PN"
`jericho	PN	"PN"
`jersey	PN	"PN"
je`rusalem	PN	"PN"
jo`hannesburg	PN	"PN"
`jordan	PN	"PN"
ju`dea	PN	"PN"
`juneau	PN	"PN"
`kabul	PN	"PN"
`kansas	PN	"PN"
ka`rachi	PN	"PN"
ken`tucky	PN	"PN"
`kenya	PN	"PN"
`kenyan	AJ-to-N	"PN(`kenya)+AJR4"
kalama`zoo	PN	"PN"
kam`pala	PN	"PN"
kathman`du	PN	"PN"
katman`du	PN	"PN"
khar`toum	PN	"PN"
ki`ev	PN	"PN"
`kingston	PN	"PN"
kin`shasha	PN	"PN"
`kodiak	PN	"PN"
ko`rea	PN	"PN"
ko`rean	AJ-to-N	"PN(ko`rea)+AJR4"
kraka`toa	PN	"PN"
`krakow	PN	"PN"
ku`wait	PN	"PN"
`kyoto	PN	"PN"
`labrador	PN	"PN"
`lagos	PN	"PN"
`lancaster	PN	"PN"
`lansing	PN	"PN"
`laos	PN	"PN"
la`otian	AJ-to-N	"PN(`laos)+AJR4"
`laramie	PN	"PN"
la`redo	PN	"PN"
`latvia	PN	"PN"
`latvian	AJ-to-N	"PN(`latvia)+AJR4"
`lauderdale	PN	"PN"
lau`sanne	PN	"PN"
leban`ese	AJ-to-N	"PN(`lebanon)+AJR3"
`lebanon	PN	"PN"
`leningrad	PN	"PN"
le`sotho	PN	"PN"
li`beria	PN	"PN"
li`berian	AJ-to-N	"PN(li`beria)+AJR4"
`libya	PN	"PN"
`libyan	AJ-to-N	"PN(`libyan)+AJR4"
`liechtenstein	PN	"PN"
`lima	PN	"PN"
`lisbon	PN	"PN"
lithu`ania	PN	"PN"
lithu`anian	AJ-to-N	"PN(lithu`ania)+AJR4"
`liverpool	PN	"PN"
`london	PN	"PN"
louisi`ana	PN	"PN"
`louisville	PN	"PN"
`lourdes	PN	"PN"
lu`cerne	PN	"PN"
`luxembourg	PN	"PN"
lu`zon	PN	"PN"
ly`on	PN	"PN"
ma`cao	PN	"PN"
mace`donia	PN	"PN"
mada`gascar	PN	"PN"
`madison	PN	"PN"
ma`drid	PN	"PN"
`maine	PN	"PN"
ma`lawi	PN	"PN"
ma`laysia	PN	"PN"
ma`laysian	AJ-to-N	"PN(ma`laysia)+AJR4"
`maldives	PN	"PN"
`mali	PN	"PN"
`malta	PN	"PN"
mal`tese	AJ-to-N	"PN(`malta)+AJR3"
ma`nagua	PN	"PN"
`manchester	PN	"PN"
man`hattan	PN	"PN"
ma`nila	PN	"PN"
mani`toba	PN	"PN"
mar`seilles	PN	"PN"
`maryland	PN	"PN"
massa`chusetts	PN	"PN"
mauri`tania	PN	"PN"
maur`itius	PN	"PN"
`mecca	PN	"PN"
`mekong	PN	"PN"
mediter`ranean	AJ-to-N	"AJ"
mela`nesia	PN	"PN"
`melbourne	PN	"PN"
`memphis	PN	"PN"
mesopo`tamia	PN	"PN"
mesopo`tamian	AJ-to-N	"PN(mesopo`tamia)+AJR4"
`mexican	AJ-to-N	"PN(`mexico)+AJR4"
`mexico	PN	"PN"
mi`ami	PN	"PN"
`michigan	PN	"PN"
micro`nesia	PN	"PN"
mi`lan	PN	"PN"
mil`waukee	PN	"PN"
minda`nao	PN	"PN"
minne`apolis	PN	"PN"
minne`sota	PN	"PN"
missis`sippi	PN	"PN"
;mississippian	PN	"PN"
mis`soula	PN	"PN"
mis`souri	PN	"PN"
mo`luccas	PN	"PN"
`monaco	PN	"PN"
mon`golia	PN	"PN"
mon`golian	AJ-to-N	"PN(mon`golia)+AJR4"
mon`rovia	PN	"PN"
mon`tana	PN	"PN"
monte`negro	PN	"PN"
monti`cello	PN	"PN"
mont`pelier	PN	"PN"
montre`al	PN	"PN"
mo`ravia	PN	"PN"
mo`ravian	AJ-to-N	"PN(mo`ravia)+AJR4"
mo`rocco	PN	"PN"
mo`roccan	AJ-to-N	"PN(mo`rocco)+AJR4"
`moscow	PN	"PN"
mozam`bique	PN	"PN"
`muscovite	PN	"PN"
`munich	PN	"PN"
naga`saki	PN	"PN"
nai`robi	PN	"PN"
nan`tucket	PN	"PN"
`naples	PN	"PN"
narra`gansett	PN	"PN"
`nashville	PN	"PN"
`nazareth	PN	"PN"
ne`braska	PN	"PN"
ne`braskan	AJ-to-N	"PN(ne`braska)+AJR4"
ne`pal	PN	"PN"
`netherlands	PN	"PN"
ne`vada	PN	"PN"
`newark	PN	"PN"
`newfoundland	PN	"PN"
`newport	PN	"PN"
ni`agara	PN	"PN"
nica`ragua	PN	"PN"
nica`raguan	AJ-to-N	"PN(nica`ragua)+AJR4"
nico`sia	PN	"PN"
`niger	PN	"PN"
ni`geria	PN	"PN"
ni`gerian	AJ-to-N	"PN(ni`geria)+AJR4"
`nile	PN	"PN"
`norfolk	PN	"PN"
`normandy	PN	"PN"
`norway	PN	"PN"
nor`wegian	AJ-to-N	"PN(`norway)+AJR4"
`oakland	PN	"PN"
oce`ania	PN	"PN"
o`hio	PN	"PN"
oki`nawa	PN	"PN"
okla`homa	PN	"PN"
`omaha	PN	"PN"
o`man	PN	"PN"
on`tario	PN	"PN"
`oregon	PN	"PN"
or`lando	PN	"PN"
`orleans	PN	"PN"
o`saka	PN	"PN"
`oslo	PN	"PN"
`ottawa	PN	"PN"
ouaga`dougou	PN	"PN"
`oxford	PN	"PN"
`ozark	PN	"PN"
`pakistan	PN	"PN"
;pakis`tani	PN	"PN"
`palestine	PN	"PN"
;palestinian	PN	"PN"
`panama	PN	"PN"
pana`manian	AJ-to-N	"PN(`panama)+AJR4"
`papua	PN	"PN"
`paraguay	PN	"PN"
`paris	PN	"PN"
;parisian	PN	"PN"
pasa`dena	PN	"PN"
pata`gonia	PN	"PN"
paw`tucket	PN	"PN"
pe`king	PN	"PN"
pe`kinese	AJ-to-N	"PN(pe`king)+AJR3"
pennsyl`vania	PN	"PN"
pennsyl`vanian	AJ-to-N	"PN(pennsyl`vania)+AJR4"
pensa`cola	PN	"PN"
pe`oria	PN	"PN"
`persia	PN	"PN"
`persian	AJ-to-N	"PN(`persia)+AJR4"
`perth	PN	"PN"
pe`ru	PN	"PN"
pe`ruvian	AJ-to-N	"PN(pe`ru)+AJR4"
phila`delphia	PN	"PN"
phila`delphian	AJ-to-N	"PN(phila`delphia)+AJR4"
`philippine	AJ	"AJ"
`philippines	PN	"PN"
phoe`nicia	PN	"PN"
`pierre	PN	"PN"
`pittsburgh	PN	"PN"
`pocono	PN	"PN"
`poland	PN	"PN"
poly`nesia	PN	"PN"
poly`nesian	AJ-to-N	"PN(poly`nesia)+AJR4"
pom`peii	PN	"PN"
port-au-prince	PN	"PN"
`portland	PN	"PN"
`portsmouth	PN	"PN"
`portugal	PN	"PN"
`portuguese	AJ-to-N	"PN(`portugal)+AJR3"
po`tomac	PN	"PN"
pough`keepsie	PN	"PN"
`prague	PN	"PN"
pre`toria	PN	"PN"
`prussia	PN	"PN"
`prussian	AJ-to-N	"PN(`prussia)+AJR3"
pyong`yang	PN	"PN"
qa`tar	PN	"PN"
que`bec	PN	"PN"
`quito	PN	"PN"
`raleigh	PN	"PN"
ran`goon	PN	"PN"
`reykjavik	PN	"PN"
`rhine	PN	"PN"
`rhode	PN	"PN"
rho`desia	PN	"PN"
`richmond	PN	"PN"
ri`yadh	PN	"PN"
`rochester	PN	"PN"
`rome	PN	"PN"
ro`mania	PN	"PN"
ro`manian	AJ-to-N	"PN(ro`mania)+AJR4"
ru`mania	PN	"PN"
ru`manian	AJ-to-N	"PN(ru`mania)+AJR4"
`russia	PN	"PN"
`russian	AJ-to-N	"PN(`russia)+AJR4"
`rwanda	PN	"PN"
sacra`mento	PN	"PN"
sa`hara	PN	"PN"
sai`gon	PN	"PN"
`salem	PN	"PN"
`salisbury	PN	"PN"
`salvador	PN	"PN"
sa`moa	PN	"PN"
sa`moan	AJ-to-N	"PN(sa`moa)+AJR4"
santi`ago	PN	"PN"
sas`katchewan	PN	"PN"
sa`udi	PN	"PN"
sa`vannah	PN	"PN"
`saxony	PN	"PN"
scandi`navia	PN	"PN"
scandi`navian	AJ-to-N	"PN(scandi`navia)+AJR4"
`scarborough	PN	"PN"
sche`nectady	PN	"PN"
`scotland	PN	"PN"
`scranton	PN	"PN"
se`attle	PN	"PN"
`seine	PN	"PN"
`selma	PN	"PN"
`senegal	PN	"PN"
`seoul	PN	"PN"
`serbia	PN	"PN"
`serbian	AJ-to-N	"PN(`serbia)+AJR4"
sey`chelles	PN	"PN"
`shanghai	PN	"PN"
shenan`doah	PN	"PN"
`shreveport	PN	"PN"
si`am	PN	"PN"
si`beria	PN	"PN"
;sicilian	PN	"PN"
`sicily	PN	"PN"
`sidney	PN	"PN"
`sinai	PN	"PN"
`singapore	PN	"PN"
so`fia	PN	"PN"
`solomon	PN	"PN" ;islands
so`malia	PN	"PN"
`spain	PN	"PN"
`sparta	PN	"PN"
`spartan	AJ-to-N	"PN(`sparta)+AJR4"
spo`kane	PN	"PN"
stockholm	PN	"PN"
`stonehenge	PN	"PN"
`stuttgart	PN	"PN"
`stygian	AJ	"PN(`styx)+AJR4"
`styx	PN	"PN"
su`dan	PN	"PN"
sudan`ese	AJ-to-N	"PN(su`dan)+AJR3"
su`ez	PN	"PN"
`suffolk	PN	"PN"
su`matra	PN	"PN"
`sumer	PN	"PN"
;sumerian	PN	"PN"
`suriname	PN	"PN"
`sussex	PN	"PN"
`swaziland	PN	"PN"
`sweden	PN	"PN"
`switzerland	PN	"PN"
`sydney	PN	"PN"
`syracuse	PN	"PN"
`syria	PN	"PN"
`syrian	AJ-to-N	"PN(`syria)+AJR4"
ta`coma	PN	"PN"
ta`hiti	PN	"PN"
`tahoe	PN	"PN"
tai`pei	PN	"PN"
tai`wan	PN	"PN"
taiwan`ese	AJ-to-N	"PN(tai`wan)+AJR3"
talla`hassee	PN	"PN"
`tampa	PN	"PN"
tan`zania	PN	"PN"
tas`mania	PN	"PN"
teguci`galpa	PN	"PN"
tehe`ran	PN	"PN"
teh`ran	PN	"PN"
tennes`see	PN	"PN"
`texan	AJ-to-N	"PN(`texas)+AJR4"
`texas	PN	"PN"
`thai	PN	"PN"
`thailand	PN	"PN"
`thames	PN	"PN"
ti`bet	PN	"PN"
ti`betan	AJ-to-N	"PN(ti`bet)+AJR4"
`tigris	PN	"PN"
to`bago	PN	"PN"
`togo	PN	"PN"
`tokyo	PN	"PN"
to`ledo	PN	"PN"
to`peka	PN	"PN"
to`ronto	PN	"PN"
`trinidad	PN	"PN"
`trojan	AJ-to-N	"PN(`troy)+AJR4"
`troy	PN	"PN"
`tucson	PN	"PN"
`tulsa	PN	"PN"
`tunis	PN	"PN"
tu`nisia	PN	"PN"
`turkey	PN	"PN"
`turkish	PN	"PN"
u`ganda	PN	"PN"
u`gandan	AJ-to-N	"PN(u`ganda)+AJR4"
uk`raine	PN	"PN"
;ukrainian	PN	"PN"
`ulster	PN	"PN"
`uruguay	PN	"PN"
`utah	PN	"PN"
van`couver	PN	"PN"
vanu`atu	PN	"PN"
`vatican	PN	"PN"
ve`netian	AJ-to-N	"PN(`venice)+AJR4"
vene`zuela	PN	"PN"
vene`zuelan	AJ-to-N	"PN(vene`zuela)+AJR4"
`venice	PN	"PN"
ven`etian	AJ-to-N	"PN(`venice)+AJR4"
ver`mont	PN	"PN"
ver`sailles	PN	"PN"
vi`enna	PN	"PN"
vien`nese	AJ-to-N	"PN(vi`enna)+AJR3"
`vietnam	PN	"PN"
vir`ginia	PN	"PN"
vir`ginian	AJ-to-N	"PN(vir`ginia)+AJR4"
`volga	PN	"PN"
`warsaw	PN	"PN"
`washington	PN	"PN"
`westminster	PN	"PN"
`wichita	PN	"PN"
`williamsburg	PN	"PN"
`wilmington	PN	"PN"
`winnipeg	PN	"PN"
wis`consin	PN	"PN"
`worcester	PN	"PN"
wy`oming	PN	"PN"
`yakima	PN	"PN"
`yarmouth	PN	"PN"
`yemen	PN	"PN"
`york	PN	"PN"
`yorkshire	PN	"PN"
yo`semite	PN	"PN"
`yucatan	PN	"PN"
`yugoslav	PN	"PN"
yugo`slavia	PN	"PN"
`yukon	PN	"PN"
`zagreb	PN	"PN"
za`ire	PN	"PN"
zam`bezi	PN	"PN"
`zambia	PN	"PN"
`zambian	AJ-to-N	"PN(`zambia)+AJR4"
`zanzibar	PN	"PN"
`zealand	PN	"PN"
zim`babwe	PN	"PN"
`zion	PN	"PN"
`zurich	PN	"PN"

END

;To enable any of the following entries, move them before
;the END keyword.

;colleges and universities (excluding place names)
`auburn	PN	"PN"
`bates	PN	"PN"
`baylor	PN	"PN"
`bowdoin	PN	"PN"
`brown	PN	"PN"
carnegie-mellon	PN	"PN"
`colby	PN	"PN"
co`lumbia	PN	"PN"
cor`nell	PN	"PN"
`dartmouth	PN	"PN"
`duke	PN	"PN"
`harvard	PN	"PN"
mit	PN	"PN" ;mass. inst. of technology
`princeton	PN	"PN"
pur`due	PN	"PN"
`rice	PN	"PN"
`stanford	PN	"PN"
`tufts	PN	"PN"
`vanderbilt	PN	"PN"
`vassar	PN	"PN"
`yale	PN	"PN"

;names from Alice in Wonderland
ada	PN	"PN"
lewis	PN	"PN"
carroll	PN	"PN"
alice	PN	"PN"
dinah	PN	"PN"
mabel	PN	"PN"
william	PN	"PN"
edwin	PN	"PN"
morcar	PN	"PN"
mercia	PN	"PN"
northumbria	PN	"PN"
stigand	PN	"PN"
edgar	PN	"PN"
atheling	PN	"PN"
mary	PN	"PN"
ann	PN	"PN"
cheshire	PN	"PN"
elsie	PN	"PN"
lacie	PN	"PN"
tillie	PN	"PN"

;names from Moby Dick
ahab	PN	"PN"
bedford	PN	"PN"
bildad	PN	"PN"
dick	PN	"PN"
ishmael	PN	"PN"
moby	PN	"PN"
peleg	PN	"PN"
pequod	PN	"PN"
queequeg	PN	"PN"
starbuck	PN	"PN"
stubb	PN	"PN"
steelkilt	PN	"PN"

;books of the Bible
genesis	PN	"PN"
exodus	PN	"PN"
leviticus	PN	"PN"
numbers	PN	"PN"
deuteronomy	PN	"PN"
joshua	PN	"PN"
josue	PN	"PN"
judges	PN	"PN"
ruth	PN	"PN"
samuel	PN	"PN"
kings	PN	"PN"
chronicles	PN	"PN"
paralipomenon	PN	"PN"
ezra	PN	"PN"
nehemiah	PN	"PN"
esther	PN	"PN"
job	PN	"PN"
psalms	PN	"PN"
proverbs	PN	"PN"
ecclesiastes	PN	"PN"
;song-of-solomon	PN	"PN"
;song-of-songs	PN	"PN"
;canticle-of-canticles	PN	"PN"
isaiah	PN	"PN"
isaias	PN	"PN"
jeremiah	PN	"PN"
jeremias	PN	"PN"
lamentations	PN	"PN"
baruch	PN	"PN"
ezekiel	PN	"PN"
daniel	PN	"PN"
hosea	PN	"PN"
osee	PN	"PN"
joel	PN	"PN"
amos	PN	"PN"
obadiah	PN	"PN"
abdias	PN	"PN"
jonah	PN	"PN"
jonas	PN	"PN"
micah	PN	"PN"
micheas	PN	"PN"
nahum	PN	"PN"
habakkuk	PN	"PN"
habacuc	PN	"PN"
zephaniah	PN	"PN"
sophonias	PN	"PN"
haggai	PN	"PN"
aggeus	PN	"PN"
zechariah	PN	"PN"
malachi	PN	"PN"
malachias	PN	"PN"
esdras	PN	"PN"
tobit	PN	"PN"
judith	PN	"PN"
wisdom	PN	"PN"
ecclesiasticus	PN	"PN"
baruch	PN	"PN"
azariah	PN	"PN"
susanna	PN	"PN"
bel	PN	"PN" ;and the dragon
manasses	PN	"PN"
maccabees	PN	"PN"
machabees	PN	"PN"
matthew	PN	"PN"
mark	PN	"PN"
luke	PN	"PN"
john	PN	"PN"
;acts	PN	"PN"
romans	PN	"PN"
corinthians	PN	"PN"
galatians	PN	"PN"
ephesians	PN	"PN"
philippians	PN	"PN"
colossians	PN	"PN"
thessalonians	PN	"PN"
timothy	PN	"PN"
titus	PN	"PN"
philemon	PN	"PN"
hebrews	PN	"PN"
james	PN	"PN"
peter	PN	"PN"
john	PN	"PN"
jude	PN	"PN"
;revelation	PN	"PN"
;apocalypse	PN	"PN"
