#include <conio.h>
#include <stdio.h>
#include <dir.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>
#include <sys\stat.h>

FILE	*nextfile(char *file);

main(int argc, char *argv[])
  {
  short noquotes=0;
  int	i,handle;
  char	file[100],drive[3],path[80],name[9],ext[5],inchar;
  FILE	*instream,*outstream;

  if (argc<2)
    {
    cprintf("\n\rUsage: PAGIFILE <input file> [/d].\n\r");
    exit(1);
    }

  if ((instream=fopen(argv[1],"rb"))==NULL)
    {
    cprintf("\n\rCan't open file %s\n\r",argv[1]);
    exit(2);
    }

  fnsplit(argv[1],drive,path,name,ext);

  for(i=strlen(name);i<7;i++)
    name[i]='0';
  name[7]='0';
  name[8]=0;

  fnmerge(file,drive,path,name,ext);

  outstream=nextfile(file);
  for(;(inchar=getc(instream))!=EOF;)
    {
    if (noquotes && inchar=='"')
      {
      noquotes=0;
      inchar=getc(instream);
      }

    if (inchar==0x0C)
      {
      fclose(outstream);
      outstream=nextfile(file);
      do
	{
	inchar=getc(instream);
	}
      while (inchar<0x20 || inchar>0x7E);
      }

    if (inchar=='I' || inchar=='i')
      {
      fputc(inchar,outstream);
      inchar=getc(instream);
      if (inchar=='N' || inchar=='n')
	{
	fputc(inchar,outstream);
	inchar=getc(instream);
	if (inchar=='%')
	  {
	  fputc(inchar,outstream);
	  inchar=getc(instream);
	  if (inchar=='"')
	    {
	    fseek(outstream,-3,SEEK_CUR);
	    inchar=getc(instream);
	    noquotes=1;
	    }
	  }
	}
      }

    if (inchar!=EOF && fputc(inchar,outstream)==EOF)
      {
      cprintf("Can't write to output file");
      exit(2);
      }
    }

  fclose(outstream);

  if (argc>2 && argv[2][0]=='/' && argv[2][1]=='d')
    remove(argv[1]);
  }


FILE	*nextfile(char *file)
  {
  FILE	*outstream;
  char	drive[3],path[80],name[9],ext[5];
  int	i,handle;

  for (;;)
    {
    if ((handle=open(file,O_CREAT|O_BINARY|O_EXCL|O_RDWR,S_IREAD|S_IWRITE))==-1)
      if (errno==EEXIST)
	{
	fnsplit(file,drive,path,name,ext);
	for (i=7;i>=0;i--)
	  {
	  if (!isdigit(name[i])) name[i]='0';
	  if (name[i]<'9')
	    {
	    name[i]++;
	    break;
	    }
	  else
	    name[i]='0';
	  }
	fnmerge(file,drive,path,name,ext);
	if (i<0)
	  {
	  cprintf("\n\rOut of file names at %s\n\r",file);
	  exit(2);
	  }
	}
      else
	{
	cprintf("\n\rCan't open output file %s.\n\r",file);
	exit(2);
	}
    else
      {
      if ((outstream=fdopen(handle,"wb"))==NULL)
	{
	cprintf("\n\rCan't open output stream %s.\n\r");
	exit(2);
	}
      return outstream;
      }
    }
  }
