/*
 * Data interface with a QTSO vocoder selector card
 */
#include "global.h"
#include "mbuf.h"
#include "proc.h"
#include "iface.h"
#include "internet.h"
#include "ip.h"
#include "slhc.h"
#include "n8250.h"
#include "asy.h"
#include "pktdrvr.h"
#include "socket.h"
#include "devparam.h"
#include "qtso.h"
#include "trace.h"

struct qtso *Qtso;

/* Routines local to this file */

/*
 * FCS lookup table as generated by fcsgen.c
 */
static int16 fcstab[256] = {
    0x0000, 0x1189, 0x2312, 0x329b, 0x4624, 0x57ad, 0x6536, 0x74bf,
    0x8c48, 0x9dc1, 0xaf5a, 0xbed3, 0xca6c, 0xdbe5, 0xe97e, 0xf8f7,
    0x1081, 0x0108, 0x3393, 0x221a, 0x56a5, 0x472c, 0x75b7, 0x643e,
    0x9cc9, 0x8d40, 0xbfdb, 0xae52, 0xdaed, 0xcb64, 0xf9ff, 0xe876,
    0x2102, 0x308b, 0x0210, 0x1399, 0x6726, 0x76af, 0x4434, 0x55bd,
    0xad4a, 0xbcc3, 0x8e58, 0x9fd1, 0xeb6e, 0xfae7, 0xc87c, 0xd9f5,
    0x3183, 0x200a, 0x1291, 0x0318, 0x77a7, 0x662e, 0x54b5, 0x453c,
    0xbdcb, 0xac42, 0x9ed9, 0x8f50, 0xfbef, 0xea66, 0xd8fd, 0xc974,
    0x4204, 0x538d, 0x6116, 0x709f, 0x0420, 0x15a9, 0x2732, 0x36bb,
    0xce4c, 0xdfc5, 0xed5e, 0xfcd7, 0x8868, 0x99e1, 0xab7a, 0xbaf3,
    0x5285, 0x430c, 0x7197, 0x601e, 0x14a1, 0x0528, 0x37b3, 0x263a,
    0xdecd, 0xcf44, 0xfddf, 0xec56, 0x98e9, 0x8960, 0xbbfb, 0xaa72,
    0x6306, 0x728f, 0x4014, 0x519d, 0x2522, 0x34ab, 0x0630, 0x17b9,
    0xef4e, 0xfec7, 0xcc5c, 0xddd5, 0xa96a, 0xb8e3, 0x8a78, 0x9bf1,
    0x7387, 0x620e, 0x5095, 0x411c, 0x35a3, 0x242a, 0x16b1, 0x0738,
    0xffcf, 0xee46, 0xdcdd, 0xcd54, 0xb9eb, 0xa862, 0x9af9, 0x8b70,
    0x8408, 0x9581, 0xa71a, 0xb693, 0xc22c, 0xd3a5, 0xe13e, 0xf0b7,
    0x0840, 0x19c9, 0x2b52, 0x3adb, 0x4e64, 0x5fed, 0x6d76, 0x7cff,
    0x9489, 0x8500, 0xb79b, 0xa612, 0xd2ad, 0xc324, 0xf1bf, 0xe036,
    0x18c1, 0x0948, 0x3bd3, 0x2a5a, 0x5ee5, 0x4f6c, 0x7df7, 0x6c7e,
    0xa50a, 0xb483, 0x8618, 0x9791, 0xe32e, 0xf2a7, 0xc03c, 0xd1b5,
    0x2942, 0x38cb, 0x0a50, 0x1bd9, 0x6f66, 0x7eef, 0x4c74, 0x5dfd,
    0xb58b, 0xa402, 0x9699, 0x8710, 0xf3af, 0xe226, 0xd0bd, 0xc134,
    0x39c3, 0x284a, 0x1ad1, 0x0b58, 0x7fe7, 0x6e6e, 0x5cf5, 0x4d7c,
    0xc60c, 0xd785, 0xe51e, 0xf497, 0x8028, 0x91a1, 0xa33a, 0xb2b3,
    0x4a44, 0x5bcd, 0x6956, 0x78df, 0x0c60, 0x1de9, 0x2f72, 0x3efb,
    0xd68d, 0xc704, 0xf59f, 0xe416, 0x90a9, 0x8120, 0xb3bb, 0xa232,
    0x5ac5, 0x4b4c, 0x79d7, 0x685e, 0x1ce1, 0x0d68, 0x3ff3, 0x2e7a,
    0xe70e, 0xf687, 0xc41c, 0xd595, 0xa12a, 0xb0a3, 0x8238, 0x93b1,
    0x6b46, 0x7acf, 0x4854, 0x59dd, 0x2d62, 0x3ceb, 0x0e70, 0x1ff9,
    0xf78f, 0xe606, 0xd49d, 0xc514, 0xb1ab, 0xa022, 0x92b9, 0x8330,
    0x7bc7, 0x6a4e, 0x58d5, 0x495c, 0x3de3, 0x2c6a, 0x1ef1, 0x0f78
};

#define pppfcs(fcs, c)		((fcs >> 8) ^ fcstab[(fcs ^ c) & 0x00ff])
#define SP_CHAR			0x20


/* Send IP datagram to QTSO */
int
qtso_send(bp,ifp,gateway,tos)
struct mbuf *bp;	/* Buffer to send */
struct iface *ifp;	/* Pointer to interface control block */
int32 gateway;		/* Ignored (PPP is point-to-point) */
int tos;
{
	return (*ifp->output)(ifp,NULLCHAR,NULLCHAR,0,bp);
}


/* Send a packet to QTSO */
int
qtso_output(ifp,dest,source,protocol,data)
struct iface *ifp;	/* Pointer to interface control block */
char *dest;		/* Dest addr (ignored; point-to-point) */
char *source;		/* Source addr (ignored; point-to-point) */
int16 protocol;		/* Protocol Type field */
struct mbuf *data;	/* Actual data to be sent */
{
	return (*ifp->raw)(ifp,data);
}


/* Encode a raw packet in PPP framing, put on link output queue */
static int
qtso_raw(ifp,bp)
struct iface *ifp;
struct mbuf *bp;
{
	int16 calc_fcs = HDLC_FCS_START;
	struct mbuf *vbp;
	register char *cp;
	register int c;
	int accm = 0;
	struct qtso *qp;

	qp = ifp->edv;
	qp->sendframes++;

	dump(ifp,IF_TRACE_OUT,bp);
	ifp->rawsndcnt++;
	ifp->lastsent = secclock();

	/* Allocate output mbuf that's twice as long as the packet.
	 * This is a worst-case guess (consider a packet full of HDLC_FLAGs!)
	 */
	if ((vbp = alloc_mbuf((int16)(2*len_p(bp)))) == NULLBUF) {
		return -1;
	}
	cp = vbp->data;

	/* Flush out any line garbage */
	*cp++ = HDLC_FLAG;

	/* Copy input to output, escaping special characters */
	while ((c = PULLCHAR(&bp)) != -1) {
		/* Fold char value into FCS calculated so far */
		calc_fcs = pppfcs(calc_fcs, c);

		if ( ((c < SP_CHAR) && (accm & (1L << c)))
		    || (c == HDLC_ESC_ASYNC)
		    || (c == HDLC_FLAG)) {
			*cp++ = HDLC_ESC_ASYNC;
			*cp++ = (c ^ HDLC_ESC_COMPL);
		} else {
			*cp++ = c;
		}
	}

	/* Final FCS calculation */
	calc_fcs ^= 0xffff;
	c = (calc_fcs & 0x00ff);	/* Least significant byte first */
	if ( ((c < SP_CHAR) && (accm & (1L << c)))
	     ||(c == HDLC_ESC_ASYNC)
	     ||(c == HDLC_FLAG)) {
		*cp++ = HDLC_ESC_ASYNC;
		*cp++ = (c ^ HDLC_ESC_COMPL);
	} else {
		*cp++ = c;
	}
	c = (calc_fcs >> 8);		/* Most significant byte next */
	if ( ((c < SP_CHAR) && (accm & (1L << c)))
	     ||(c == HDLC_ESC_ASYNC)
	     ||(c == HDLC_FLAG)) {
		*cp++ = HDLC_ESC_ASYNC;
		*cp++ = (c ^ HDLC_ESC_COMPL);
	} else {
		*cp++ = c;
	}

	/* Tie off the packet */
	*cp++ = HDLC_FLAG;
	vbp->cnt = cp - vbp->data;

	if (ifp->trace & IF_TRACE_RAW)
		raw_dump(ifp,IF_TRACE_OUT,vbp);
	return asy_send(ifp->dev,vbp);
}

/* Packetize QTSO input from device */
void
qtso_recv(dev,p1,p2)
int dev;
void *p1;
void *p2;
{
	struct iface *ifp = p1;
	int16 calc_fcs = HDLC_FCS_START;
	struct mbuf *raw_bp = NULLBUF;
	struct mbuf *head_bp = NULLBUF;
	register struct mbuf *tail_bp = NULLBUF;
	char *cp;			/* next byte in tail mbuf */
	register int mode = FALSE;
	register int c;
	int accm = 0;
	struct qtso *qp;

	qp = ifp->edv;
	while((c = get_asy(dev)) != -1){
#ifdef	notdef
		if (ifp->trace & IF_TRACE_RAW) {
			if ( raw_bp != NULLBUF
			  || (raw_bp = alloc_mbuf( LCP_MRU_HI * 2 )) != NULLBUF ) {
				*raw_bp->data++ = c;
				raw_bp->cnt++;
				if ( raw_bp->cnt != 1 && c == HDLC_FLAG ) {
					raw_bp->data = (char *)(raw_bp + 1);
					raw_dump( ifp, IF_TRACE_IN, raw_bp );
					raw_bp->cnt = 0;
				}
			}
		}
#endif
		if(c == HDLC_FLAG){
			if(mode & PPP_ESCAPED){
				/* Frame abort */
				qp->aborts++;
			} else if(mode & PPP_TOSS){
				/* We're ignoring this frame */
				free_p(head_bp);
			} else if(head_bp != NULLBUF) {
				if(calc_fcs != HDLC_FCS_FINAL){
					/* CRC error */
					qp->crcerrs++;
				} else {
					/* trim off FCS bytes */
					trim_mbuf(&head_bp, len_p(head_bp)-2);

					net_route(ifp,head_bp);
					qp->goodframes++;
					/* Especially on slow machines, serial I/O can be quite
					 * compute intensive, so release the machine before we
					 * do the next packet.  This will allow this packet to
					 * go on toward its ultimate destination. [Karn]
					 */
					pwait(NULL);
				}
			} else {
				/* Flag on idle link */
			}
			/* setup for next buffer */
			mode = FALSE;
			head_bp = tail_bp = NULLBUF;
			calc_fcs = HDLC_FCS_START;
			accm = 0;

			if(!(ifp->trace & IF_TRACE_RAW)){
				if(raw_bp != NULLBUF){
					free_p(raw_bp);
					raw_bp = NULLBUF;
				}
			}
			continue;
		}
		/* We reach here for every byte inside a frame.
		 * (The order of the following tests is important.)
		 * Discard spurious control characters.
		 * Check for escape sequence.
		 * (Allow escaped escape.)
		 */
		if(c < SP_CHAR && (accm & (1L << c))){
			continue;
		} else if(mode & PPP_ESCAPED){
			mode &= ~PPP_ESCAPED;
			c ^= HDLC_ESC_COMPL;
		} else if(c == HDLC_ESC_ASYNC){
			mode |= PPP_ESCAPED;
			continue;
		}
		/* We reach here with a byte for the buffer.
		 * Make sure there is room for it.
		 */
		if(tail_bp == NULLBUF){
			if ((tail_bp = alloc_mbuf(PPP_ALLOC)) == NULLBUF) {
				mode |= PPP_TOSS;
				continue;
			}
			head_bp = tail_bp;
			cp = tail_bp->data;
		} else if(tail_bp->cnt >= tail_bp->size){
			/* Current mbuf is full */
			if((tail_bp->next = alloc_mbuf(PPP_ALLOC)) == NULLBUF){
				/* No memory, drop the whole packet */
				head_bp = NULLBUF;
				mode |= PPP_TOSS;
				continue;
			}
			tail_bp = tail_bp->next;
			cp = tail_bp->data;
		}

		/* Store the byte, increment counts */
		*cp++ = c;
		tail_bp->cnt++;
		calc_fcs = pppfcs(calc_fcs, c);
	}
	/* clean up afterward */
	free_p(raw_bp);
	free_p(head_bp);
	ifp->rxproc = NULLPROC;
}

#pragma option -G-

/* Process incoming QTSO packets */
/* (called from network task) */
void
qtso_proc(ifp,bp)
struct iface *ifp;
struct mbuf *bp;
{
	if ( ifp == NULLIF ) {
		return;
	}
	if ( bp == NULLBUF ) {
		return;
	}
/*	ip_route(ifp,bp,0); */
	qtso_raw(ifp,bp);	
/*	tputc('.'); */
}

#pragma option -G

/* Initialize QTSO control structures for a Point-to-Point interface */
int
qtso_init(ifp,vj)
struct iface *ifp;
int vj;
{
	char *ifn;
	struct qtso *qp;
	struct mbuf *bp;
	char imsg[] = { 0x01, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0 };

	qp = (struct qtso *)calloc(1,sizeof(struct qtso));
	ifp->edv = qp;
	qp->iface = ifp;
	setencap(ifp,"QTSO");
	ifp->ioctl = asy_ioctl;
	ifp->flags = FALSE;
	ifp->raw = qtso_raw;

	ifp->rxproc = newproc( ifn = if_name( ifp, " receive" ),
			320, qtso_recv, ifp->dev, ifp, NULL, 0);
	free(ifn);
	bp = qdata(imsg,sizeof(imsg));
	qtso_raw(ifp,bp);

	return 0;
}
int
qtso_free(ifp)
struct iface *ifp;
{
	struct qtso *qp,*qp1;
	
	qp = (struct qtso *)ifp->edv;
	if(qp == Qtso){
		Qtso = qp->next;
	} else {
		for(qp1 = Qtso;qp1 != NULLQTSO;qp1 = qp1->next)
			if(qp1->next == qp)
				break;
		if(qp1->next == qp){
			qp1->next = qp->next;
		}
	}
	return 0;
}
int
doqtso(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp;
	struct qtso *qp;

	if((ifp = if_lookup(argv[1])) == NULLIF){
		printf("Interface %s unknown\n",argv[1]);
		return 1;
	}
	qp = ifp->edv;
	printf("TX Frames %lu, Good rx frames %lu, CRC errs %lu, aborts %lu\n",
		qp->sendframes,qp->goodframes,qp->crcerrs,qp->aborts);
	return 0;
}

