/* A collection of stuff heavily dependent on the configuration info
 * in config.h. The idea is that configuration-dependent tables should
 * be located here to avoid having to pepper lots of .c files with #ifdefs,
 * requiring them to include config.h and be recompiled each time config.h
 * is modified.
 *
 * Copyright 1991 Phil Karn, KA9Q
 */

#include <stdio.h>
#include <dos.h>
#include "global.h"
#include "config.h"
#include "mbuf.h"
#include "timer.h"
#include "proc.h"
#include "iface.h"
#include "ip.h"
#include "tcp.h"
#include "udp.h"
#ifdef	ARCNET
#include "arcnet.h"
#endif
#include "lapb.h"
#include "ax25.h"
#include "enet.h"
#include "kiss.h"
#include "nr4.h"
#include "nrs.h"
#include "netrom.h"
#include "pktdrvr.h"
#include "ppp.h"
#include "slip.h"
#include "arp.h"
#include "icmp.h"
#include "hardware.h"	/***/
#include "usock.h"
#include "cmdparse.h"
#include "commands.h"
#include "mailbox.h"
#include "ax25mail.h"
#include "nr4mail.h"
#include "tipmail.h"
#include "daemon.h"
#include "bootp.h"
#include "asy.h"
#include "trace.h"
#ifdef	QTSO
#include "qtso.h"
#endif

int dotest __ARGS((int argc,char *argv[],void *p));	/**/
static int dostart __ARGS((int argc,char *argv[],void *p));
static int dostop __ARGS((int argc,char *argv[],void *p));

#ifdef	AX25
static void axip __ARGS((struct iface *iface,struct ax25_cb *axp,char *src,
	char *dest,struct mbuf *bp,int mcast));
static void axarp __ARGS((struct iface *iface,struct ax25_cb *axp,char *src,
	char *dest,struct mbuf *bp,int mcast));
static void axnr __ARGS((struct iface *iface,struct ax25_cb *axp,char *src,
	char *dest,struct mbuf *bp,int mcast));
#endif	/* AX25 */

struct mbuf *Hopper;		/* Queue of incoming packets */
unsigned Nsessions = NSESSIONS;
unsigned Nsock = DEFNSOCK;		/* Number of socket entries */

/* Free memory threshold, below which things start to happen to conserve
 * memory, like garbage collection, source quenching and refusing connects
 */
int32 Memthresh = MTHRESH;

int Nibufs = NIBUFS;		/* Number of interrupt buffers */
unsigned Ibufsize = IBUFSIZE;	/* Size of each interrupt buffer */
unsigned Nfiles = DEFNFILES;

/* Command lookup and branch tables */
struct cmds Cmds[] = {
	/* The "go" command must be first */
	"",		go,		0, 0, NULLCHAR,
#ifndef	AMIGA
	"!",		doshell,	0, 0, NULLCHAR,
#endif
	"abort",	doabort,	0, 0, NULLCHAR,
#ifdef	AMIGA
	"amiga",	doamiga,	0, 0, NULLCHAR,
#endif
#if	(defined(MAC) && defined(APPLETALK))
	"applestat",	doatstat,	0,	0, NULLCHAR,
#endif
#if	(defined(AX25) || defined(ETHER) || defined(APPLETALK))
	"arp",		doarp,		0, 0, NULLCHAR,
#endif
#ifdef	ASY
	"asystat",	doasystat,	0, 0, NULLCHAR,
#endif
	"attach",	doattach,	0, 2,
		"attach <hardware> <hw specific options>",
#ifdef	AX25
	"ax25",		doax25,		0, 0, NULLCHAR,
#endif
#ifdef	BOOTP
	"bootp",	dobootp,	0, 0, NULLCHAR,
	"bootpd",	bootpdcmd,	0, 0, NULLCHAR,
#endif
/* This one is out of alpabetical order to allow abbreviation to "c" */
#ifdef	AX25
	"connect",	doconnect,	1024, 3,
	"connect <interface> <callsign>",
#endif
#if	!defined(UNIX) && !defined(AMIGA)
	"cd",		docd,		0, 0, NULLCHAR,
#endif
	"close",	doclose,	0, 0, NULLCHAR,
/* This one is out of alpabetical order to allow abbreviation to "d" */
	"disconnect",	doclose,	0, 0, NULLCHAR,
	"delete",	dodelete,	0, 2, "delete <file>",
	"detach",	dodetach,	0, 2, "detach <interface>",
#ifdef	DIALER
	"dialer",	dodialer,	0, 2,
	"dialer <iface> <timeout> [<raise script> <lower script>]",
#endif
#ifndef	AMIGA
	"dir",		dodir,		512, 0, NULLCHAR, /* note sequence */
#endif
	"domain",	dodomain,	0, 0, NULLCHAR,
#ifdef	DRSI
	"drsistat",	dodrstat,	0, 0, NULLCHAR,
#endif
#ifdef	EAGLE
	"eaglestat",	doegstat,	0, 0, NULLCHAR,
#endif
	"echo",		doecho,		0, 0, NULLCHAR,
	"eol",		doeol,		0, 0, NULLCHAR,
#if	!defined(MSDOS)
	"escape",	doescape,	0, 0, NULLCHAR,
#endif
	"exit",		doexit,		0, 0, NULLCHAR,
	"files",	dofiles,	0, 0, NULLCHAR,
	"finger",	dofinger,	1024, 2, "finger name@host",
	"ftp",		doftp,		2048, 2, "ftp <address>",
#ifdef HAPN
	"hapnstat",	dohapnstat,	0, 0, NULLCHAR,
#endif
	"help",		dohelp,		0, 0, NULLCHAR,
#ifdef	HOPCHECK
	"hop",		dohop,		0, 0, NULLCHAR,
#endif
	"hostname",	dohostname,	0, 0, NULLCHAR,
#ifdef	HS
	"hs",		dohs,		0, 0, NULLCHAR,
#endif
	"icmp",		doicmp,		0, 0, NULLCHAR,
	"ifconfig",	doifconfig,	0, 0, NULLCHAR,
	"ip",		doip,		0, 0, NULLCHAR,
#ifdef	MSDOS
	"isat",		doisat,		0, 0, NULLCHAR,
#endif
	"kick",		dokick,		0, 0, NULLCHAR,
	"log",		dolog,		0, 0, NULLCHAR,
#ifdef	MAILBOX
	"mbox",		dombox,		0, 0, NULLCHAR,
#endif
#ifndef	UNIX
	"memory",	domem,		0, 0, NULLCHAR,
#endif
	"mkdir",	domkd,		0, 2, "mkdir <directory>",
#ifdef	AX25
	"mode",		domode,		0, 2, "mode <interface>",
#endif
	"more",		doview,		0, 2, "more <filename>",
#ifdef	NETROM
	"netrom",	donetrom,	0, 0, NULLCHAR,
#endif	/* NETROM */
#ifdef	NNTP
	"nntp",		donntp,		0, 0, NULLCHAR,
#endif	/* NNTP */
#ifdef	NRS
	"nrstat",	donrstat,	0, 0, NULLCHAR,
#endif	/* NRS */
	"param",	doparam,	0, 2, "param <interface>",
	"ping",		doping,		512, 2,
	"ping <hostid> [<length> [<interval> [incflag]]]",
#ifdef	PI
	"pistatus",	dopistat,	0, 0, NULLCHAR,
#endif
#ifdef POP
	"pop",		dopop,		0, 0, NULLCHAR,
#endif
#ifdef PPP
	"ppp",		doppp_commands,	0, 0, NULLCHAR,
#endif
	"ps",		ps,		0, 0, NULLCHAR,
#if	!defined(UNIX) && !defined(AMIGA)
	"pwd",		docd,		0, 0, NULLCHAR,
#endif
	"record",	dorecord,	0, 0, NULLCHAR,
	"remote",	doremote,	0, 3, "remote [-p port] [-k key] [-a kickaddr] <address> exit|reset|kick",
	"rename",	dorename,	0, 3, "rename <oldfile> <newfile>",
	"reset",	doreset,	0, 0, NULLCHAR,
#ifdef	RIP
	"rip",		dorip,		0, 0, NULLCHAR,
#endif
	"rmdir",	dormd,		0, 2, "rmdir <directory>",
	"route",	doroute,	0, 0, NULLCHAR,
	"session",	dosession,	0, 0, NULLCHAR,
#ifdef	SCC
	"sccstat",	dosccstat,	0, 0, NULLCHAR,
#endif
#if	!defined(AMIGA)
	"shell",	doshell,	0, 0, NULLCHAR,
#endif
	"smtp",		dosmtp,		0, 0, NULLCHAR,
	"socket",	dosock,		0, 0, NULLCHAR,
#ifdef	SERVERS
	"start",	dostart,	0, 2, "start <servername>",
	"stop",		dostop,		0, 2, "stop <servername>",
#endif
	"tcp",		dotcp,		0, 0, NULLCHAR,
	"telnet",	dotelnet,	1024, 2, "telnet <address>",
	"test",		dotest,		1024, 0, NULLCHAR,
	"tip",		dotip,		256, 2, "tip <iface>",
#ifdef	TRACE
	"trace",	dotrace,	512, 0, NULLCHAR,
#endif
	"udp",		doudp,		0, 0, NULLCHAR,
	"upload",	doupload,	0, 0, NULLCHAR,
	"view",		doview,		0, 2, "view <filename>",
#ifdef	MSDOS
	"watch",	doswatch,	0, 0, NULLCHAR,
#endif
	"?",		dohelp,		0, 0, NULLCHAR,
	NULLCHAR,	NULLFP,		0, 0,
		"Unknown command; type \"?\" for list",
};

/* List of supported hardware devices */
struct cmds Attab[] = {
#ifdef	ASY
	/* Ordinary PC asynchronous adaptor */
	"asy", asy_attach, 0, 8,
#ifndef	AMIGA
	"attach asy <address> <vector> slip|ax25|nrs|ppp <label> <buffers> <mtu> <speed> [ip_addr]",
#else
	"attach asy <driver> <unit> slip|ax25|nrs|ppp <label> <buffers> <mtu> <speed> [ip_addr]",
#endif	/* AMIGA */
#endif	/* ASY */
#ifdef	PC100
	/* PACCOMM PC-100 8530 HDLC adaptor */
	"pc100", pc_attach, 0, 8,
	"attach pc100 <address> <vector> ax25 <label> <buffers>\
 <mtu> <speed> [ip_addra] [ip_addrb]",
#endif
#ifdef	DRSI
	/* DRSI PCPA card in low speed mode */
	"drsi", dr_attach, 0, 8,
	"attach drsi <address> <vector> ax25 <label> <bufsize> <mtu>\
<chan a speed> <chan b speed> [ip addr a] [ip addr b]",
#endif
#ifdef	EAGLE
	/* EAGLE RS-232C 8530 HDLC adaptor */
	"eagle", eg_attach, 0, 8,
	"attach eagle <address> <vector> ax25 <label> <buffers>\
 <mtu> <speed> [ip_addra] [ip_addrb]",
#endif
#ifdef	PI
	/* PI 8530 HDLC adaptor */
	"pi", pi_attach, 0, 8,
	"attach pi <address> <vector> <dmachannel> ax25 <label> <buffers>\
 <mtu> <speed> [ip_addra] [ip_addrb]",
#endif
#ifdef	HAPN
	/* Hamilton Area Packet Radio (HAPN) 8273 HDLC adaptor */
	"hapn", hapn_attach, 0, 8,
	"attach hapn <address> <vector> ax25 <label> <rx bufsize>\
 <mtu> csma|full [ip_addr]",
#endif
#ifdef	APPLETALK
	/* Macintosh AppleTalk */
	"0", at_attach, 0, 7,
	"attach 0 <protocol type> <device> arpa <label> <rx bufsize> <mtu> [ip_addr]",
#endif
#ifdef NETROM
	/* fake netrom interface */
	"netrom", nr_attach, 0, 1,
	"attach netrom [ip_addr]",
#endif
#ifdef	PACKET
	/* FTP Software's packet driver spec */
	"packet", pk_attach, 0, 4,
	"attach packet <int#> <label> <buffers> <mtu> [ip_addr]",
#endif
#ifdef	HS
	/* Special high speed driver for DRSI PCPA or Eagle cards */
	"hs", hs_attach, 0, 7,
	"attach hs <address> <vector> ax25 <label> <buffers> <mtu>\
 <txdelay> <persistence> [ip_addra] [ip_addrb]",
#endif
#ifdef SCC
	"scc", scc_attach, 0, 7,
	"attach scc <devices> init <addr> <spacing> <Aoff> <Boff> <Dataoff>\n"
	"   <intack> <vec> [p]<clock> [hdwe] [param]\n"
	"attach scc <chan> slip|kiss|nrs|ax25 <label> <mtu> <speed> <bufsize> [call] ",
#endif
	NULLCHAR,
};

#ifdef	SERVERS
/* "start" and "stop" subcommands */
static struct cmds Startcmds[] = {
#if	defined(AX25) && defined(MAILBOX)
	"ax25",		ax25start,	256, 0, NULLCHAR,
#endif
	"discard",	dis1,		256, 0, NULLCHAR,
	"echo",		echo1,		256, 0, NULLCHAR,
	"finger",	finstart,	256, 0, NULLCHAR,
	"ftp",		ftpstart,	256, 0, NULLCHAR,
#if	defined(NETROM) && defined(MAILBOX)
	"netrom",	nr4start,	256, 0, NULLCHAR,
#endif
#ifdef POP
	"pop",		pop1,		256, 0, NULLCHAR,
#endif
#ifdef	RIP
	"rip",		doripinit,	0,   0, NULLCHAR,
#endif
	"smtp",		smtp1,		256, 0, NULLCHAR,
#if	defined(MAILBOX)
	"telnet",	telnet1,	256, 0, NULLCHAR,
	"tip",		tipstart,	256, 2, "start tip <interface>",
#endif
	"ttylink",	ttylstart,	256, 0, NULLCHAR,
	"remote",	rem1,		768, 0, NULLCHAR,
	NULLCHAR,
};

static struct cmds Stopcmds[] = {
#if	defined(AX25) && defined(MAILBOX)
	"ax25",		ax250,		0, 0, NULLCHAR,
#endif
	"discard",	dis0,		0, 0, NULLCHAR,
	"echo",		echo0,		0, 0, NULLCHAR,
	"finger",	fin0,		0, 0, NULLCHAR,
	"ftp",		ftp0,		0, 0, NULLCHAR,
#if	defined(NETROM) && defined(MAILBOX)
	"netrom",	nr40,		0, 0, NULLCHAR,
#endif
#ifdef	POP
	"pop",		pop0,		0, 0, NULLCHAR,
#endif
#ifdef	RIP
	"rip",		doripstop,	0, 0, NULLCHAR,
#endif
	"smtp",		smtp0,		0, 0, NULLCHAR,
#ifdef	MAILBOX
	"telnet",	telnet0,	0, 0, NULLCHAR,
	"tip",		tip0,		0, 2, "stop tip <interface>",
#endif
	"ttylink",	ttyl0,		0, 0, NULLCHAR,
	"remote",	rem0,		0, 0, NULLCHAR,
	NULLCHAR,
};
#endif	/* SERVERS */

/* Socket-protocol interface table */
struct socklink Socklink[] = {
	/* type,
	 * socket,	bind,		listen,		connect,
	 * accept,	recv,		send,		qlen,
	 * kick,	shut,		close,		check,
	 * error,	state,		status,		eol_seq
	 */
	TYPE_TCP,
	so_tcp,		NULLFP,		so_tcp_listen,	so_tcp_conn,
	TRUE,		so_tcp_recv,	so_tcp_send,	so_tcp_qlen,
	so_tcp_kick,	so_tcp_shut,	so_tcp_close,	checkipaddr,
	Tcpreasons,	tcpstate,	so_tcp_stat,	Inet_eol,

	TYPE_UDP,
	so_udp,		so_udp_bind,	NULLFP,		so_udp_conn,
	FALSE,		so_udp_recv,	so_udp_send,	so_udp_qlen,
	NULLFP,		NULLFP,		so_udp_close,	checkipaddr,
	NULL,		NULLFP,		so_udp_stat,	Inet_eol,

#ifdef	AX25
	TYPE_AX25I,
	so_ax_sock,	NULLFP,		so_ax_listen,	so_ax_conn,
	TRUE,		so_ax_recv,	so_ax_send,	so_ax_qlen,
	so_ax_kick,	so_ax_shut,	so_ax_close,	checkaxaddr,
	Axreasons,	axstate,	so_ax_stat,	Ax25_eol,

	TYPE_AX25UI,
	so_axui_sock,	so_axui_bind,	NULLFP,		so_axui_conn,
	FALSE,		so_axui_recv,	so_axui_send,	so_axui_qlen,
	NULLFP,		NULLFP,		so_axui_close,	checkaxaddr,
	NULL,		NULLFP,		NULLFP,		Ax25_eol,
#endif	/* AX25 */

	TYPE_RAW,
	so_ip_sock,	NULLFP,		NULLFP,		so_ip_conn,
	FALSE,		so_ip_recv,	so_ip_send,	so_ip_qlen,
	NULLFP,		NULLFP,		so_ip_close,	checkipaddr,
	NULL,		NULLFP,		NULLFP,		Inet_eol,

#ifdef	NETROM
	TYPE_NETROML3,
	so_n3_sock,	NULLFP,		NULLFP,		so_n3_conn,
	FALSE,		so_n3_recv,	so_n3_send,	so_n3_qlen,
	NULLFP,		NULLFP,		so_n3_close,	checknraddr,
	NULL,		NULLFP,		NULLFP,		Ax25_eol,

	TYPE_NETROML4,
	so_n4_sock,	NULLFP,		so_n4_listen,	so_n4_conn,
	TRUE,		so_n4_recv,	so_n4_send,	so_n4_qlen,
	so_n4_kick,	so_n4_shut,	so_n4_close,	checknraddr,
	Nr4reasons,	nrstate,	so_n4_stat,	Ax25_eol,
#endif	/* NETROM */

#ifdef	LOCSOCK
	TYPE_LOCAL_STREAM,
	so_los,		NULLFP,		NULLFP,		NULLFP,
	TRUE,		so_lo_recv,	so_los_send,	so_los_qlen,
	NULLFP,		so_loc_shut,	so_loc_close,	NULLFP,
	NULL,		NULLFP,		so_loc_stat,	Eol,

	TYPE_LOCAL_DGRAM,
	so_lod,		NULLFP,		NULLFP,		NULLFP,
	FALSE,		so_lo_recv,	so_lod_send,	so_lod_qlen,
	NULLFP,		so_loc_shut,	so_loc_close,	NULLFP,
	NULL,		NULLFP,		so_loc_stat,	Eol,
#endif

	-1
};

/* Table of functions for printing socket addresses */
char * (*Psock[]) () = {
	ippsocket,
#ifdef	AX25
	axpsocket,
#else
	NULLFP,
#endif
#ifdef	NETROM
	nrpsocket,
#else
	NULLFP,
#endif
	lopsocket,
};

/* TCP port numbers to be considered "interactive" by the IP routing
 * code and given priority in queueing
 */
int Tcp_interact[] = {
	IPPORT_FTP,	/* FTP control (not data!) */
	IPPORT_TELNET,	/* Telnet */
	IPPORT_LOGIN,	/* BSD rlogin */
	IPPORT_MTP,	/* Secondary telnet */
	-1
};

/* Transport protocols atop IP */
struct iplink Iplink[] = {
	TCP_PTCL,	tcp_input,
	UDP_PTCL,	udp_input,
	ICMP_PTCL,	icmp_input,
	IP_PTCL,	ipip_recv,
	0,		0
};

/* Transport protocols atop ICMP */
struct icmplink Icmplink[] = {
	TCP_PTCL,	tcp_icmp,
	0,		0
};

#ifdef	AX25
/* Linkage to network protocols atop ax25 */
struct axlink Axlink[] = {
	PID_IP,		axip,
	PID_ARP,	axarp,
#ifdef	NETROM
	PID_NETROM,	axnr,
#endif
	PID_NO_L3,	axnl3,
	0,		NULL,
};
#endif	/* AX25 */

/* ARP protocol linkages, indexed by arp's hardware type */
struct arp_type Arp_type[NHWTYPES] = {
#ifdef	NETROM
	AXALEN, 0, 0, 0, NULLCHAR, pax25, setcall,	/* ARP_NETROM */
#else
	0, 0, 0, 0, NULLCHAR,NULL,NULL,
#endif

#ifdef	ETHER
	EADDR_LEN,IP_TYPE,ARP_TYPE,1,Ether_bdcst,pether,gether, /* ARP_ETHER */
#else
	0, 0, 0, 0, NULLCHAR,NULL,NULL,
#endif

	0, 0, 0, 0, NULLCHAR,NULL,NULL,			/* ARP_EETHER */

#ifdef	AX25
	AXALEN, PID_IP, PID_ARP, 10, Ax25multi[0], pax25, setcall,
#else
	0, 0, 0, 0, NULLCHAR,NULL,NULL,			/* ARP_AX25 */
#endif

	0, 0, 0, 0, NULLCHAR,NULL,NULL,			/* ARP_PRONET */

	0, 0, 0, 0, NULLCHAR,NULL,NULL,			/* ARP_CHAOS */

	0, 0, 0, 0, NULLCHAR,NULL,NULL,			/* ARP_IEEE802 */

#ifdef	ARCNET
	AADDR_LEN, ARC_IP, ARC_ARP, 1, ARC_bdcst, parc, garc, /* ARP_ARCNET */
#else
	0, 0, 0, 0, NULLCHAR,NULL,NULL,
#endif

	0, 0, 0, 0, NULLCHAR,NULL,NULL,			/* ARP_APPLETALK */
};
/* Get rid of trace references in Iftypes[] if TRACE is turned off */
#ifndef	TRACE
#define	ip_dump		NULLVFP
#define	ax25_dump	NULLVFP
#define	ki_dump		NULLVFP
#define	sl_dump		NULLVFP
#define	ether_dump	NULLVFP
#define	ppp_dump	NULLVFP
#define	arc_dump	NULLVFP
#endif	/* TRACE */

/* Table of interface types. Contains most device- and encapsulation-
 * dependent info
 */
struct iftype Iftypes[] = {
	/* This entry must be first, since Loopback refers to it */
	"None",		NULL,		NULL,		NULL,
	NULL,		CL_NONE,	0,		ip_proc,
	NULLFP,		ip_dump,

#ifdef	AX25
	"AX25",		ax_send,	ax_output,	pax25,
	setcall,	CL_AX25,	AXALEN,		ax_recv,
	ax_forus,	ax25_dump,
#endif	/* AX25 */

#ifdef	KISS
	"KISS",		ax_send,	ax_output,	pax25,
	setcall,	CL_AX25,	AXALEN,		kiss_recv,
	ki_forus,	ki_dump,
#endif	/* KISS */

#ifdef	SLIP
	"SLIP",		slip_send,	NULL,		NULL,
	NULL,		CL_NONE,	0,		ip_proc,
	NULLFP,		ip_dump,
#endif	/* SLIP */

#ifdef	VJCOMPRESS
	"VJSLIP",	slip_send,	NULL,		NULL,
	NULL,		CL_NONE,	0,		ip_proc,
	NULLFP,		sl_dump,
#endif	/* VJCOMPRESS */

#ifdef	ETHER
	/* Note: NULL is specified for the scan function even though
	 * gether() exists because the packet drivers don't support
	 * address setting.
	 */
	"Ethernet",	enet_send,	enet_output,	pether,
	NULL,		CL_ETHERNET,	EADDR_LEN,	eproc,
	ether_forus,	ether_dump,
#endif	/* ETHER */

#ifdef	NETROM
	"NETROM",	nr_send,	NULL,		pax25,
	setcall,	CL_NETROM,	AXALEN,		NULLVFP,
	NULLFP,		NULLVFP,
#endif	/* NETROM */

#ifdef	SLFP
	"SLFP",		pk_send,	NULL,		NULL,
	NULL,		CL_NONE,	0,		ip_proc,
	NULLFP,		ip_dump,
#endif	/* SLFP */

#ifdef	PPP
	"PPP",		ppp_send,	ppp_output,	NULL,
	NULL,		CL_PPP,		0,		ppp_proc,
	NULLFP,		ppp_dump,
#endif	/* PPP */

#ifdef	ARCNET
	"Arcnet",	anet_send,	anet_output,	parc,
	garc,		CL_ARCNET,	1,		aproc,
	arc_forus,	arc_dump,
#endif	/* ARCNET */

#ifdef	QTSO
	"QTSO",		qtso_send,	qtso_output,	NULL,
	NULL,		CL_NONE,	0,		qtso_proc,
	NULLFP,		NULLVFP,
#endif	/* QTSO */

	NULLCHAR,	NULLFP,		NULLFP,		NULL,
	NULL,		-1,		0,		NULLFP,
	NULLFP,		NULLVFP,
};

/* Asynchronous interface mode table */
#ifdef	ASY
struct asymode Asymode[] = {
#ifdef	SLIP
	"SLIP",	FR_END,		slip_init,	slip_free,
#endif
#ifdef	KISS
	"AX25",	FR_END,		kiss_init,	kiss_free,
	"KISS",	FR_END,		kiss_init,	kiss_free,
#endif
#ifdef	NRS
	"NRS",	ETX,		nrs_init,	nrs_free,
#endif
#ifdef	PPP
	"PPP",	HDLC_FLAG,	ppp_init,	ppp_free,
#endif
#ifdef	QTSO
	"QTSO",	HDLC_FLAG,	qtso_init,	qtso_free,
#endif
	NULLCHAR
};
#endif	/* ASY */


/* daemons to be run at startup time */
struct daemon Daemons[] = {
	"killer",	512,	killer,
	"gcollect",	256,	gcollect,
	"timer",	1024,	timerproc,
	"network",	1536,	network,
	"keyboard",	250,	keyboard,
	NULLCHAR,	0,	NULLVFP
};

/* Functions to be called on each clock tick */
void (*Cfunc[])() = {
	pctick,	/* Call PC-specific stuff to keep time */
	kbint,	/* Necessary because there's no hardware keyboard interrupt */
	refiq,	/* Replenish interrupt pool */
	sesflush,	/* Flush current session output */
#ifdef	ASY
	asytimer,
#endif
#ifdef	SCC
	scctimer,
#endif
	NULL,
};

/* Entry points for garbage collection */
void (*Gcollect[])() = {
	tcp_garbage,
	ip_garbage,
	udp_garbage,
	st_garbage,
#ifdef	AX25
	lapb_garbage,
#endif
#ifdef	NETROM
	nr_garbage,
#endif
	NULL
};

/* Functions to be called at shutdown */
void (*Shutdown[])() = {
#ifdef	SCC
	sccstop,
#endif
	uchtimer,	/* Unlink timer handler from timer chain */
	NULLVFP,
};

#ifdef	MAILBOX
void (*Listusers) __ARGS((FILE *network)) = listusers;
#else
void (*Listusers) __ARGS((FILE *network)) = NULL;
#endif	/* MAILBOX */

#ifndef	BOOTP
int WantBootp = 0;

int
bootp_validPacket(ip,bpp)
struct ip *ip;
struct mbuf **bpp;
{
	return 0;
}
#endif	/* BOOTP */

/* Packet tracing stuff */
#ifdef	TRACE
#include "trace.h"

#else	/* TRACE */

/* Stub for packet dump function */
void
dump(iface,direction,type,bp)
struct iface *iface;
int direction;
unsigned type;
struct mbuf *bp;
{
}
void
raw_dump(iface,direction,bp)
struct iface *iface;
int direction;
struct mbuf *bp;
{
}
#endif	/* TRACE */

#ifndef	TRACEBACK
void
stktrace()
{
}
#endif

#ifndef	LZW
void
lzwfree(up)
struct usock *up;
{
}
#endif

#ifdef	AX25
/* Hooks for passing incoming AX.25 data frames to network protocols */
static void
axip(iface,axp,src,dest,bp,mcast)
struct iface *iface;
struct ax25_cb *axp;
char *src;
char *dest;
struct mbuf *bp;
int mcast;
{
	(void)ip_route(iface,bp,mcast);
}

static void
axarp(iface,axp,src,dest,bp,mcast)
struct iface *iface;
struct ax25_cb *axp;
char *src;
char *dest;
struct mbuf *bp;
int mcast;
{
	(void)arp_input(iface,bp);
}

#ifdef	NETROM
static void
axnr(iface,axp,src,dest,bp,mcast)
struct iface *iface;
struct ax25_cb *axp;
char *src;
char *dest;
struct mbuf *bp;
int mcast;
{
	if(!mcast)
		nr_route(bp,axp);
	else
		nr_nodercv(iface,src,bp);
}

#endif	/* NETROM */
#endif	/* AX25 */

#ifndef	RIP
/* Stub for routing timeout when RIP is not configured -- just remove entry */
void
rt_timeout(s)
void *s;
{
	struct route *stale = (struct route *)s;

	rt_drop(stale->target,stale->bits);
}
#endif

/* Stubs for demand dialer */
#ifndef	DIALER
void
dialer_kick(asyp)
struct asy *asyp;
{
}
#endif

/* Stubs for Van Jacobsen header compression */
#if !defined(VJCOMPRESS) && defined(ASY)
struct slcompress *
slhc_init(rslots,tslots)
int rslots;
int tslots;
{
	return NULLSLCOMPR;
}
int
slhc_compress(comp, bpp, compress_cid)
struct slcompress *comp;
struct mbuf **bpp;
int compress_cid;
{
	return SL_TYPE_IP;
}
int
slhc_uncompress(comp, bpp)
struct slcompress *comp;
struct mbuf **bpp;
{
	return -1;	/* Can't decompress */
}
void
shlc_i_status(comp)
struct slcompress *comp;
{
}
void
shlc_o_status(comp)
struct slcompress *comp;
{
}
int
slhc_remember(comp, bpp)
struct slcompress *comp;
struct mbuf **bpp;
{
	return -1;
}
#endif /* !defined(VJCOMPRESS) && defined(ASY) */

#ifdef	SERVERS
static int
dostart(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return subcmd(Startcmds,argc,argv,p);
}
static int
dostop(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return subcmd(Stopcmds,argc,argv,p);
}
#endif	/* SERVERS */

#ifdef	notdef
int
dotest(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	long i;
	int32 oldtime = 0;
	int32 newtime;

	Current->flowmode = 1;
	for(i=0;i<40000;i++){
		newtime = msclock();
		if(newtime < oldtime){
			printf("Clock slip %ld: %ld - %ld = %ld\n",i,
				newtime,oldtime,newtime-oldtime);
		} else
			oldtime = newtime;
	}
	pwait(NULL);
	Current->flowmode = 0;
	return 0;
}

#endif
#ifdef	notdef
int
dotest(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct sockaddr_in fsocket;
	FILE *fp,*fp1;
	int s;
	int c;
	char buf[128];
	struct mbuf *bp;

#ifdef	notdef
	fsocket.sin_family = AF_INET;
	if(argc < 3)
		fsocket.sin_port = IPPORT_FINGER;
	else
		fsocket.sin_port = atoi(argv[2]);

	printf("Resolving %s... ",argv[1]);
	if((fsocket.sin_addr.s_addr = resolve(argv[1])) == 0){
		printf(Badhost,argv[1]);
		keywait(NULLCHAR,1);
		return 1;
	}
	if((s = socket(AF_INET,SOCK_STREAM,0)) == -1){
		printf("Can't create socket\n");
		keywait(NULLCHAR,1);
		return 1;
	}
	if(connect(s,(char *)&fsocket,sizeof(fsocket)) == -1){
		perror("connect failed");
		return 1;
	}
	printf("connected\n");
	fp = fdopen(s,"r+t");
	fprintf(fp,"karn\n");
	fflush(fp);
	while((c = getc(fp)) != EOF){
		fputc(c,stdout);
	}
	fclose(fp);
#endif

	fp = fopen("net.map","rt");
	fp1 = fopen("net.foo","wt");
	while((c = fgetc(fp)) != EOF){
		fputc(c,fp1);
	}
	printf("eof reached\r\n");
	fclose(fp);
	fclose(fp1);
	return 0;
}
#endif
#ifdef	notdef
char imsg[] = { 0x01, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0 };

int
dotest(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct mbuf *bp;
	struct iface *ifp;
	extern qtso_raw();

	bp = qdata(imsg,sizeof(imsg));
	ifp = if_lookup("com3");
	(*ifp->raw)(ifp,bp);
	return 0;
}

int
dotest(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	void sigsender();
	struct proc *child;

	if(SETSIG(666)){
		printf("parent received signal, exiting...\n");
		return;
	}

	printf("Hello from parent, my proc is %lx. Spawning sigsender.\n",
		ptol(Curproc));
	child = newproc("sigsender",512,sigsender,0,(void *)Curproc,NULL,0);
	printf("child spawned, proc = %lx\n",ptol(child));
	printf("parent looping.\n");
	for(;;){
		pwait((void *)0x12345678);	/* Not likely to occur */
		printf("parent returned from pwait!!\n");
	}

}
void
sigsender(a,b,c)
int a;
void *b,*c;
{
	struct proc *parent;

	parent = (struct proc *)b;
	printf("hello, sigsender here. procid is %lx. Parent is %lx. Pausing...\n",
		ptol(Curproc),ptol(parent));
	pause(10000L);
	printf("sigsender: alerting parent\n");
	alert(parent,666);
	printf("sigsender: returning\n");
}
#endif
dotest(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	int c;
	struct session *sp;

	sp = newsession("test",TIP,1);
	fmode(stdin,STREAM_BINARY);
	fmode(stdout,STREAM_BINARY);
	sp->ttystate.edit = 0;
	sp->ttystate.echo = 0;

	printf("hello from test\n");
	while((c = getchar()) != 0x1a)
		putchar(c);
	printf("text exiting\n");
	keywait(NULLCHAR,1);
	freesession(sp);
	return 0;
}
